/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.rc.common.util;

import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.oro.text.GlobCompiler;
import org.apache.oro.text.regex.MalformedPatternException;
import org.apache.oro.text.regex.MatchResult;
import org.apache.oro.text.regex.Pattern;
import org.apache.oro.text.regex.Perl5Compiler;
import org.apache.oro.text.regex.Perl5Matcher;
import org.eclipse.jubula.rc.common.exception.StepExecutionException;
import org.eclipse.jubula.tools.objects.event.EventFactory;
import org.eclipse.jubula.tools.objects.event.TestErrorEvent;

public class MatchUtil {
    public static final String EQUALS = "equals";
    public static final String NOT_EQUALS = "not equals";
    public static final String MATCHES_REGEXP = "matches";
    public static final String MATCHES_GLOB = "simple match";
    public static final String DEFAULT_OPERATOR = "equals";
    private static MatchUtil instance = new MatchUtil();
    private Map<String, MatchOperation> m_operationMap = new HashMap<String, MatchOperation>();
    private Map<String, FindOperation> m_findOperationMap = new HashMap<String, FindOperation>();

    private MatchUtil() {
        this.m_operationMap.put("equals", new MatchOperation(){

            public boolean matches(String text, String pattern) {
                return MatchUtil.this.isEqual(text, pattern);
            }
        });
        this.m_operationMap.put(NOT_EQUALS, new MatchOperation(){

            public boolean matches(String text, String pattern) {
                return !MatchUtil.this.isEqual(text, pattern);
            }
        });
        this.m_operationMap.put(MATCHES_REGEXP, new MatchOperation(){

            public boolean matches(String text, String pattern) {
                return MatchUtil.this.matchesRegExp(text, pattern);
            }
        });
        this.m_operationMap.put(MATCHES_GLOB, new MatchOperation(){

            public boolean matches(String text, String pattern) {
                return MatchUtil.this.matchesGlob(text, pattern);
            }
        });
        this.m_findOperationMap.put("equals", new FindOperation(){

            public FindResult find(String text, String pattern) {
                int index = text.indexOf(pattern);
                return new FindResult(index != -1 ? pattern : null, index);
            }
        });
        this.m_findOperationMap.put(NOT_EQUALS, new FindOperation(){

            public FindResult find(String text, String pattern) {
                int index = text.indexOf(pattern);
                return new FindResult(index != -1 ? pattern : null, index);
            }
        });
        this.m_findOperationMap.put(MATCHES_REGEXP, new FindOperation(){

            public FindResult find(String text, String pattern) {
                return MatchUtil.this.findRegExp(text, pattern);
            }
        });
        this.m_findOperationMap.put(MATCHES_GLOB, new FindOperation(){

            public FindResult find(String text, String pattern) {
                return MatchUtil.this.findGlob(text, pattern);
            }
        });
    }

    public static MatchUtil getInstance() {
        return instance;
    }

    public FindResult find(String text, String pattern, String operator) throws StepExecutionException {
        if (!this.m_findOperationMap.containsKey(operator)) {
            TestErrorEvent event = EventFactory.createActionError((String)"TestErrorEvent.UnknownOperator", (Object[])new Object[]{operator});
            throw new StepExecutionException("unknown operator", event);
        }
        if (pattern == null) {
            TestErrorEvent event = EventFactory.createActionError((String)"TestErrorEvent.MalformedRegexp", (Object[])new Object[]{pattern});
            throw new StepExecutionException("null pattern", event);
        }
        FindOperation op = this.m_findOperationMap.get(operator);
        return op.find(text == null ? "" : text, pattern);
    }

    public boolean match(String text, String pattern, String operator) throws StepExecutionException {
        if (!this.m_operationMap.containsKey(operator)) {
            TestErrorEvent event = EventFactory.createActionError((String)"TestErrorEvent.UnknownOperator", (Object[])new Object[]{operator});
            throw new StepExecutionException("unknown operator", event);
        }
        MatchOperation op = this.m_operationMap.get(operator);
        return op.matches(text == null ? "" : text, pattern);
    }

    public boolean match(String text, String[] patterns, String operator) throws StepExecutionException {
        boolean result = true;
        int i = 0;
        while (i < patterns.length) {
            if (operator.startsWith("not")) {
                if (!this.match(text, patterns[i], operator)) {
                    result = false;
                    break;
                }
            } else {
                if (this.match(text, patterns[i], operator)) {
                    result = true;
                    break;
                }
                result = false;
            }
            ++i;
        }
        return result;
    }

    private boolean isEqual(String text, String pattern) {
        return StringUtils.equals((String)text, (String)pattern);
    }

    private boolean matchesRegExp(String text, String pattern) {
        Perl5Compiler pc = new Perl5Compiler();
        Perl5Matcher matcher = new Perl5Matcher();
        try {
            Pattern p = pc.compile(pattern, 16);
            return matcher.matches(text, p);
        }
        catch (MalformedPatternException malformedPatternException) {
            TestErrorEvent event = EventFactory.createActionError((String)"TestErrorEvent.MalformedRegexp", (Object[])new Object[]{pattern});
            throw new StepExecutionException("malformed regular expression", event);
        }
    }

    private boolean matchesGlob(String text, String pattern) {
        return this.matchesRegExp(text, GlobCompiler.globToPerl5((char[])pattern.toCharArray(), (int)0));
    }

    private FindResult findRegExp(String text, String pattern) {
        Perl5Compiler pc = new Perl5Compiler();
        Perl5Matcher matcher = new Perl5Matcher();
        try {
            Pattern p = pc.compile(pattern, 16);
            matcher.contains(text, p);
            MatchResult match = matcher.getMatch();
            if (match != null) {
                return new FindResult(match.toString(), match.beginOffset(0));
            }
            return null;
        }
        catch (MalformedPatternException malformedPatternException) {
            TestErrorEvent event = EventFactory.createActionError((String)"TestErrorEvent.MalformedRegexp", (Object[])new Object[]{pattern});
            throw new StepExecutionException("malformed regular expression", event);
        }
    }

    private FindResult findGlob(String text, String pattern) {
        return this.findRegExp(text, GlobCompiler.globToPerl5((char[])pattern.toCharArray(), (int)0));
    }

    private static interface FindOperation {
        public FindResult find(String var1, String var2);
    }

    public static class FindResult {
        private int m_pos;
        private String m_str;

        public FindResult(String str, int pos) {
            this.m_str = str;
            this.m_pos = pos;
        }

        public int getPos() {
            return this.m_pos;
        }

        public String getStr() {
            return this.m_str;
        }
    }

    private static interface MatchOperation {
        public boolean matches(String var1, String var2);
    }
}

