/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.rc.common.util;

import java.beans.PropertyDescriptor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Map;
import java.util.TreeMap;
import org.apache.commons.beanutils.PropertyUtils;
import org.apache.commons.lang.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PropertyUtil {
    private PropertyUtil() {
    }

    public static Map<String, String> getMapOfComponentProperties(Object currComp) {
        PropertyDescriptor[] propertyDescriptors = PropertyUtils.getPropertyDescriptors((Object)currComp);
        TreeMap<String, String> componentProperties = new TreeMap<String, String>();
        int i = 0;
        while (i < propertyDescriptors.length) {
            PropertyDescriptor pd = propertyDescriptors[i];
            try {
                Method readMethod = pd.getReadMethod();
                if (readMethod != null) {
                    Character c;
                    Object obj = readMethod.invoke(currComp, new Object[0]);
                    String value = String.valueOf(obj);
                    if (value.length() > 200) {
                        value = StringUtils.substring((String)value, (int)0, (int)200);
                    }
                    if (obj instanceof Character && (c = (Character)obj).charValue() == '\u0000') {
                        value = "";
                    }
                    componentProperties.put(pd.getName(), value);
                } else {
                    componentProperties.put(pd.getName(), "This property is not readable");
                }
            }
            catch (IllegalArgumentException illegalArgumentException) {
                componentProperties.put(pd.getName(), "Error");
            }
            catch (IllegalAccessException illegalAccessException) {
                componentProperties.put(pd.getName(), "Error accessing this property");
            }
            catch (InvocationTargetException invocationTargetException) {
                componentProperties.put(pd.getName(), "Error reading this property");
            }
            ++i;
        }
        return componentProperties;
    }
}

