/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.rc.swt.driver;

import java.util.LinkedList;
import java.util.List;
import org.eclipse.jubula.rc.common.AUTServer;
import org.eclipse.jubula.rc.common.driver.IEventMatcher;
import org.eclipse.jubula.rc.common.driver.IRobotEventConfirmer;
import org.eclipse.jubula.rc.common.driver.IRunnable;
import org.eclipse.jubula.rc.common.driver.InterceptorOptions;
import org.eclipse.jubula.rc.common.driver.RobotTiming;
import org.eclipse.jubula.rc.common.exception.RobotException;
import org.eclipse.jubula.rc.common.logger.AutServerLogger;
import org.eclipse.jubula.rc.common.util.WorkaroundUtil;
import org.eclipse.jubula.rc.swt.SwtAUTServer;
import org.eclipse.jubula.rc.swt.driver.EventThreadQueuerSwtImpl;
import org.eclipse.jubula.rc.swt.utils.SwtUtils;
import org.eclipse.jubula.tools.objects.event.EventFactory;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Widget;

class RobotEventConfirmerSwtImpl
implements IRobotEventConfirmer,
Listener {
    private static AutServerLogger log = new AutServerLogger(RobotEventConfirmerSwtImpl.class);
    private boolean m_enabled = false;
    private boolean m_waiting = false;
    private InterceptorOptions m_options;
    private Object m_eventTarget;
    private IEventMatcher m_eventMatcher;
    private List m_eventList = new LinkedList();

    RobotEventConfirmerSwtImpl(InterceptorOptions options) {
        this.m_options = options;
    }

    private void logList(List list) {
        log.debug((Object)"Stored SWTEvents[");
        List copy = (List)((LinkedList)list).clone();
        for (Object element : copy) {
            log.debug(element);
        }
        log.debug((Object)"]");
    }

    private boolean isEventMatching(Event event) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("SWTEvent matching?: " + event));
            log.debug((Object)("Matching ID?      : " + (event.type == this.m_eventMatcher.getEventId())));
            log.debug((Object)("Matching source?  : " + (this.m_eventTarget == null || event.widget == this.m_eventTarget)));
            log.debug((Object)("*Source: " + event.widget));
            log.debug((Object)("*Target: " + this.m_eventTarget));
        }
        return (this.m_eventTarget == null || this.matchComponent(this.m_eventTarget, event.widget) || this.isInBounds(this.m_eventTarget, event.widget)) && this.m_eventMatcher.isMatching((Object)event);
    }

    private boolean isInBounds(Object eventTarget, Widget eventWidget) {
        return SwtUtils.isInBounds((Widget)eventTarget, eventWidget);
    }

    private boolean matchComponent(Object evTarget, Object evSource) {
        return this.isComponentMatching(evTarget, evSource) || this.isComponentMatching(evSource, evTarget);
    }

    private boolean isComponentMatching(Object expComp, Object currComp) {
        return this.isComponentMatching(expComp, currComp, true);
    }

    protected boolean isNoConfirmComponent(Object eventTarget) {
        return eventTarget instanceof Menu || eventTarget instanceof MenuItem || eventTarget instanceof Shell;
    }

    private boolean isComponentMatching(Object expComp, Object currComp, boolean checkChildren) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Matching source? : " + (expComp == currComp)));
        }
        if (expComp == currComp) {
            return true;
        }
        boolean match = false;
        Widget curr = (Widget)currComp;
        Widget[] widgetChildren = SwtUtils.getWidgetChildren(curr, true);
        if (checkChildren && widgetChildren.length > 0) {
            Widget[] children = widgetChildren;
            int i = 0;
            while (i < children.length) {
                match = this.isComponentMatching(expComp, children[i]);
                if (match) {
                    return match;
                }
                ++i;
            }
        }
        if (currComp instanceof Control) {
            Control controlComp = (Control)currComp;
            Control parentControl = SwtUtils.checkControlParent(controlComp);
            if (controlComp != parentControl) {
                match = this.isComponentMatching(expComp, parentControl, false);
            }
            if (match) {
                return match;
            }
        }
        return match;
    }

    private boolean isEventMatching(List eventList) {
        for (Event event : eventList) {
            if (!this.isEventMatching(event)) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addEventToList(Event event) {
        List list = this.m_eventList;
        synchronized (list) {
            ((LinkedList)this.m_eventList).addFirst(event);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void stopWaiting() {
        RobotEventConfirmerSwtImpl robotEventConfirmerSwtImpl = this;
        synchronized (robotEventConfirmerSwtImpl) {
            this.m_waiting = false;
            this.notify();
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)"Notified waiting thread");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setEnabled(final boolean enabled) {
        this.m_enabled = enabled;
        List list = this.m_eventList;
        synchronized (list) {
            this.m_eventList.clear();
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("Enabled?    : " + enabled));
            if (enabled) {
                log.debug((Object)("Storing SWTEvents with: " + this.m_options));
            }
        }
        final long[] eventMask = this.m_options.getEventMask();
        EventThreadQueuerSwtImpl evThreadQueuer = new EventThreadQueuerSwtImpl();
        evThreadQueuer.invokeAndWait("add-/removeDisplayFilters", new IRunnable(){

            public Object run() {
                Display autDisplay = ((SwtAUTServer)AUTServer.getInstance()).getAutDisplay();
                int maskLength = eventMask.length;
                int i = 0;
                while (i < maskLength) {
                    if (enabled) {
                        autDisplay.addFilter((int)eventMask[i], (Listener)RobotEventConfirmerSwtImpl.this);
                    } else {
                        autDisplay.removeFilter((int)eventMask[i], (Listener)RobotEventConfirmerSwtImpl.this);
                    }
                    ++i;
                }
                return null;
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void waitToConfirm(Object eventTarget, IEventMatcher matcher, long timeout) throws RobotException {
        this.m_eventTarget = eventTarget;
        this.m_eventMatcher = matcher;
        try {
            if (this.isNoConfirmComponent(eventTarget)) {
                return;
            }
            List list = this.m_eventList;
            synchronized (list) {
                if (this.isEventMatching(this.m_eventList)) {
                    return;
                }
            }
            this.m_waiting = true;
            this.waitFor(timeout);
            if (this.m_waiting) {
                boolean fallBackMatching;
                List list2 = this.m_eventList;
                synchronized (list2) {
                    fallBackMatching = this.m_eventMatcher.isFallBackEventMatching(this.m_eventList, this.m_eventTarget);
                }
                if (log.isDebugEnabled()) {
                    if (!fallBackMatching) {
                        log.debug((Object)"Received timeout");
                        log.debug((Object)this.m_options);
                        list2 = this.m_eventList;
                        synchronized (list2) {
                            this.logList(this.m_eventList);
                        }
                    } else {
                        log.debug((Object)"-> Fall back event has matched!");
                    }
                }
                if (!fallBackMatching && !WorkaroundUtil.isIgnoreTimeout()) {
                    throw new RobotException("Timeout received before confirming the posted event: " + this.m_eventMatcher.getEventId(), EventFactory.createActionError((String)"TestErrorEvent.ConfirmationTimeout"));
                }
            }
            if (!log.isDebugEnabled()) return;
            log.debug((Object)"Got notification");
            return;
        }
        finally {
            this.setEnabled(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void waitFor(long pTimeout) {
        RobotEventConfirmerSwtImpl robotEventConfirmerSwtImpl = this;
        synchronized (robotEventConfirmerSwtImpl) {
            long timeout = pTimeout;
            long done = System.currentTimeMillis() + timeout;
            do {
                try {
                    this.wait(timeout);
                }
                catch (InterruptedException interruptedException) {}
                long now = System.currentTimeMillis();
                timeout = done - now;
            } while (this.m_waiting && timeout > 0L);
        }
    }

    public void handleEvent(final Event event) {
        if (!this.m_enabled) {
            return;
        }
        new Thread(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                try {
                    RobotEventConfirmerSwtImpl.this.addEventToList(event);
                    List list = RobotEventConfirmerSwtImpl.this.m_eventList;
                    synchronized (list) {
                        if (log.isDebugEnabled()) {
                            log.debug((Object)("SWTEvent    : " + event));
                            log.debug((Object)("Event target: " + RobotEventConfirmerSwtImpl.this.m_eventTarget));
                            log.debug((Object)("Waiting?    : " + RobotEventConfirmerSwtImpl.this.m_waiting));
                            RobotEventConfirmerSwtImpl.this.logList(RobotEventConfirmerSwtImpl.this.m_eventList);
                        }
                        if (RobotEventConfirmerSwtImpl.this.m_waiting && RobotEventConfirmerSwtImpl.this.isEventMatching(RobotEventConfirmerSwtImpl.this.m_eventList)) {
                            RobotEventConfirmerSwtImpl.this.stopWaiting();
                        }
                    }
                }
                catch (Throwable t) {
                    log.error((Object)"exception in handleEvent", t);
                }
            }
        }).start();
    }

    public void waitToConfirm(Object eventTarget, IEventMatcher matcher) throws RobotException {
        this.waitToConfirm(eventTarget, matcher, RobotTiming.getEventConfirmTimeout());
    }
}

