/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.client.core.commands;

import org.eclipse.jubula.client.core.ClientTest;
import org.eclipse.jubula.client.core.IClientTest;
import org.eclipse.jubula.client.core.events.AUTServerEvent;
import org.eclipse.jubula.client.core.i18n.Messages;
import org.eclipse.jubula.communication.internal.APICommand;
import org.eclipse.jubula.communication.internal.message.Message;
import org.eclipse.jubula.communication.internal.message.StartAUTServerStateMessage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StartAUTServerStateCommand
implements APICommand {
    private static Logger log = LoggerFactory.getLogger(StartAUTServerStateCommand.class);
    private StartAUTServerStateMessage m_message;

    public Message getMessage() {
        return this.m_message;
    }

    public void setMessage(Message message) {
        this.m_message = (StartAUTServerStateMessage)message;
    }

    public Message execute() {
        int state = this.m_message.getReason();
        IClientTest clientTest = ClientTest.instance();
        switch (state) {
            case 0: {
                log.info(Messages.AUTServerIsStarting);
                break;
            }
            case 3: {
                log.error(String.valueOf(Messages.NoJavaFound) + ":" + " " + this.m_message.getDescription());
                clientTest.fireAUTServerStateChanged(new AUTServerEvent(7));
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 5: 
            case 10: 
            case 11: {
                log.error(String.valueOf(Messages.AUTServerCouldNotStart) + ":" + " " + this.m_message.getDescription());
                clientTest.fireAUTServerStateChanged(new AUTServerEvent(4));
                break;
            }
            case 6: 
            case 7: {
                log.info(String.valueOf(Messages.AUTServerCouldNotStart) + ":" + " " + this.m_message.getDescription());
                clientTest.fireAUTServerStateChanged(new AUTServerEvent(5));
                break;
            }
            case 8: 
            case 9: {
                log.info(String.valueOf(Messages.AUTServerCouldNotStart) + ":" + " " + this.m_message.getDescription());
                clientTest.fireAUTServerStateChanged(new AUTServerEvent(6));
                break;
            }
            case 12: {
                log.error(String.valueOf(Messages.AUTServerCouldNotStart) + ":" + " " + this.m_message.getDescription());
                clientTest.fireAUTServerStateChanged(new AUTServerEvent(11));
                break;
            }
            case 13: {
                log.error(String.valueOf(Messages.AUTServerCouldNotStart) + ":" + " " + this.m_message.getDescription());
                clientTest.fireAUTServerStateChanged(new AUTServerEvent(12));
                break;
            }
            case 14: {
                log.error(String.valueOf(Messages.AUTServerCouldNotStart) + ":" + " " + this.m_message.getDescription());
                clientTest.fireAUTServerStateChanged(new AUTServerEvent(13));
                break;
            }
            default: {
                log.error(String.valueOf(Messages.UnknownState) + " " + String.valueOf(state) + ":" + this.m_message.getDescription());
            }
        }
        return null;
    }

    public void timeout() {
        log.error(String.valueOf(this.getClass().getName()) + "." + Messages.TimeoutCalled);
    }
}

