/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.client.core.persistence;

import java.util.Date;
import java.util.List;
import java.util.Set;
import javax.persistence.EntityManager;
import javax.persistence.EntityTransaction;
import javax.persistence.Query;
import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.criteria.CriteriaQuery;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.Order;
import javax.persistence.criteria.Path;
import javax.persistence.criteria.Root;
import javax.persistence.criteria.Selection;
import org.apache.commons.lang.time.DateUtils;
import org.eclipse.jubula.client.core.events.DataEventDispatcher;
import org.eclipse.jubula.client.core.i18n.Messages;
import org.eclipse.jubula.client.core.model.ITestResultPO;
import org.eclipse.jubula.client.core.model.ITestResultSummaryPO;
import org.eclipse.jubula.client.core.model.PoMaker;
import org.eclipse.jubula.client.core.persistence.PMException;
import org.eclipse.jubula.client.core.persistence.Persistor;
import org.eclipse.jubula.client.core.persistence.TestResultSummaryPM;
import org.eclipse.jubula.tools.internal.exception.JBException;
import org.eclipse.jubula.tools.internal.exception.JBFatalException;
import org.eclipse.jubula.tools.internal.exception.ProjectDeletedException;
import org.eclipse.jubula.tools.internal.messagehandling.MessageIDs;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestResultPM {
    private static Logger log = LoggerFactory.getLogger(TestResultPM.class);

    private TestResultPM() {
    }

    public static final void storeTestResult(EntityManager session) {
        Persistor persistor = Persistor.instance();
        try {
            try {
                EntityTransaction tx = persistor.getTransaction(session);
                persistor.commitTransaction(session, tx);
            }
            catch (PMException e) {
                log.error(Messages.StoringOfTestResultsFailed, (Throwable)((Object)e));
                throw new JBFatalException(Messages.StoringOfTestResultsFailed, (Throwable)((Object)e), MessageIDs.E_DATABASE_GENERAL);
            }
            catch (ProjectDeletedException e) {
                throw new JBFatalException(Messages.StoringOfTestResultsFailed, (Throwable)e, MessageIDs.E_PROJECT_NOT_FOUND);
            }
        }
        finally {
            persistor.dropSession(session);
        }
    }

    private static final void deleteTestresultOfSummary(Long resultId) {
        Persistor persistor = Persistor.instance();
        if (persistor == null) {
            return;
        }
        EntityManager session = persistor.openSession();
        try {
            try {
                EntityTransaction tx = persistor.getTransaction(session);
                persistor.lockDB();
                TestResultPM.executeDeleteTestresultOfSummary(session, resultId);
                TestResultPM.deleteMonitoringReports(session, resultId);
                persistor.commitTransaction(session, tx);
            }
            catch (PMException e) {
                log.error(Messages.DeleteTestresultElementFailed, (Throwable)((Object)e));
                throw new JBFatalException(Messages.DeleteTestresultElementFailed, (Throwable)((Object)e), MessageIDs.E_DATABASE_GENERAL);
            }
            catch (ProjectDeletedException e) {
                throw new JBFatalException(Messages.DeleteTestresultElementFailed, (Throwable)e, MessageIDs.E_PROJECT_NOT_FOUND);
            }
        }
        finally {
            persistor.dropSessionWithoutLockRelease(session);
            persistor.unlockDB();
        }
    }

    private static void deleteMonitoringReports(EntityManager session, Long summaryId) {
        ITestResultSummaryPO summaryPo = null;
        if (summaryId != null) {
            summaryPo = (ITestResultSummaryPO)session.find(PoMaker.getTestResultSummaryClass(), (Object)summaryId);
            if (summaryPo != null) {
                summaryPo.setMonitoringReport(null);
                summaryPo.setReportWritten(false);
            }
        } else {
            Query deleteMonitoringReportsQuery = session.createQuery("UPDATE " + PoMaker.getMonitoringReportClass().getSimpleName() + " SET report = null");
            deleteMonitoringReportsQuery.executeUpdate();
            session.flush();
            StringBuilder queryBuilder = new StringBuilder();
            queryBuilder.append("SELECT summary FROM ").append(PoMaker.getTestResultSummaryClass().getSimpleName()).append(" AS summary where summary.reportWritten = :isReportWritten");
            Query q = session.createQuery(queryBuilder.toString());
            q.setParameter("isReportWritten", (Object)true);
            List reportList = q.getResultList();
            for (ITestResultSummaryPO summary : reportList) {
                summary.setMonitoringReport(null);
                summary.setReportWritten(false);
            }
        }
    }

    public static final void executeDeleteTestresultOfSummary(EntityManager session, Long resultId) {
        boolean isDeleteAll = resultId == null;
        String paramQueryBaseString = "delete from PARAMETER_DETAILS";
        if (isDeleteAll) {
            session.createNativeQuery(paramQueryBaseString).executeUpdate();
        } else {
            Query paramQuery = session.createNativeQuery(String.valueOf(paramQueryBaseString) + " where FK_TESTRESULT in (select ID from TESTRESULT where INTERNAL_TESTRUN_ID = #summaryId)");
            paramQuery.setParameter("summaryId", (Object)resultId);
            paramQuery.executeUpdate();
        }
        StringBuilder resultQueryBuilder = new StringBuilder();
        resultQueryBuilder.append("delete from TestResultPO testResult");
        if (!isDeleteAll) {
            resultQueryBuilder.append(" where testResult.internalTestResultSummaryID = :id");
        }
        Query resultQuery = session.createQuery(resultQueryBuilder.toString());
        if (!isDeleteAll) {
            resultQuery.setParameter("id", (Object)resultId);
        }
        resultQuery.executeUpdate();
        StringBuilder deleteReportingRulesQueryBuilder = new StringBuilder();
        deleteReportingRulesQueryBuilder.append("delete from ALM_REPORTING_RULE where FK_TESTRESULT_SUM is not null");
        if (!isDeleteAll) {
            deleteReportingRulesQueryBuilder.append(" and FK_TESTRESULT_SUM = #id");
        }
        Query reportingRulesResultQuery = session.createNativeQuery(deleteReportingRulesQueryBuilder.toString());
        if (!isDeleteAll) {
            reportingRulesResultQuery.setParameter("id", (Object)resultId);
        }
        reportingRulesResultQuery.executeUpdate();
    }

    public static final void deleteAllTestresultDetails() {
        TestResultPM.deleteTestresultOfSummary(null);
    }

    public static final void cleanTestresultDetails(int days, String projGUID, Integer majorVersion, Integer minorVersion, Integer microVersion, String versionQualifier) {
        Date cleanDate = DateUtils.addDays((Date)new Date(), (int)(days * -1));
        try {
            Set<Long> summaries = TestResultSummaryPM.findTestResultSummariesByDate(cleanDate, projGUID, majorVersion, minorVersion, microVersion, versionQualifier);
            for (Long summaryId : summaries) {
                TestResultPM.deleteTestresultOfSummary(summaryId);
            }
            DataEventDispatcher.getInstance().fireTestresultChanged(DataEventDispatcher.TestresultState.Refresh);
        }
        catch (JBException e) {
            throw new JBFatalException(Messages.DeletingTestresultsFailed, (Throwable)e, MessageIDs.E_DELETE_TESTRESULT);
        }
    }

    public static List<ITestResultPO> computeTestResultListForSummary(EntityManager session, Long summaryId) {
        CriteriaBuilder builder = session.getCriteriaBuilder();
        CriteriaQuery query = builder.createQuery();
        Root from = query.from(PoMaker.getTestResultClass());
        query.orderBy(new Order[]{builder.asc((Expression)from.get("keywordSequence"))}).select((Selection)from).where((Expression)builder.equal((Expression)from.get("internalTestResultSummaryID"), (Object)summaryId));
        return session.createQuery(query).getResultList();
    }

    public static boolean hasTestResultDetails(EntityManager session, Long summaryId) {
        boolean hasDetails = false;
        if (session == null) {
            return hasDetails;
        }
        CriteriaBuilder builder = session.getCriteriaBuilder();
        CriteriaQuery query = builder.createQuery();
        Root from = query.from(PoMaker.getTestResultClass());
        query.select((Selection)builder.count((Expression)from)).where((Expression)builder.equal((Expression)from.get("internalTestResultSummaryID"), (Object)summaryId));
        Number result = (Number)session.createQuery(query).getSingleResult();
        if (result.longValue() > 0L) {
            hasDetails = true;
        }
        return hasDetails;
    }

    public static ITestResultSummaryPO getTestResultSummary(EntityManager session, Long summaryId) {
        if (session == null) {
            return null;
        }
        CriteriaBuilder builder = session.getCriteriaBuilder();
        CriteriaQuery query = builder.createQuery();
        Root from = query.from(PoMaker.getTestResultSummaryClass());
        query.where((Expression)builder.equal((Expression)from.get("id"), (Object)summaryId));
        return (ITestResultSummaryPO)session.createQuery(query).getSingleResult();
    }

    public static List<Number> computeTestresultIdsWithDetails(EntityManager session) {
        CriteriaBuilder builder = session.getCriteriaBuilder();
        CriteriaQuery query = builder.createQuery();
        Path from = query.from(PoMaker.getTestResultClass()).get("internalTestResultSummaryID");
        query.select((Selection)from).distinct(true);
        return session.createQuery(query).getResultList();
    }
}

