/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.client.core.utils;

import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.eclipse.core.runtime.URIUtil;
import org.eclipse.jubula.client.core.Activator;
import org.eclipse.jubula.client.core.utils.LocaleUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Languages {
    public static final String KEYBOARD_MAPPING_FILE_PREFIX = "resources/keyboard_mapping/";
    public static final String KEYBOARD_MAPPING_FILE_POSTFIX = ".properties";
    private static final Logger LOG = LoggerFactory.getLogger(Languages.class);
    private static Languages instance = null;
    private Map<Locale, String> m_localeToDisplayMap;
    private Map<String, Locale> m_displayToLocaleMap;
    private List<Locale> m_suppLangList = new ArrayList<Locale>();

    private Languages() {
        this.initMap();
    }

    public static Languages getInstance() {
        if (instance == null) {
            instance = Languages.createInstance();
        }
        return instance;
    }

    private static synchronized Languages createInstance() {
        if (instance == null) {
            instance = new Languages();
        }
        return instance;
    }

    private void initMap() {
        this.m_localeToDisplayMap = new HashMap<Locale, String>();
        this.m_displayToLocaleMap = new HashMap<String, Locale>();
        Locale[] localeArray = Locale.getAvailableLocales();
        int n = localeArray.length;
        int n2 = 0;
        while (n2 < n) {
            Locale l = localeArray[n2];
            if (!"".equals(l.getCountry())) {
                this.m_suppLangList.add(l);
                String displayName = l.getDisplayName(Locale.getDefault());
                this.m_localeToDisplayMap.put(l, displayName);
                this.m_displayToLocaleMap.put(displayName, l);
            }
            ++n2;
        }
    }

    public Locale getLocale(String displayString) {
        if (!this.m_displayToLocaleMap.containsKey(displayString)) {
            Locale locale = LocaleUtil.convertStrToLocale(displayString);
            this.m_localeToDisplayMap.put(locale, displayString);
            this.m_displayToLocaleMap.put(displayString, locale);
        }
        return this.m_displayToLocaleMap.get(displayString);
    }

    public String getDisplayString(Locale locale) {
        if (!this.m_localeToDisplayMap.containsKey(locale)) {
            String displayString = locale.getDisplayName();
            this.m_localeToDisplayMap.put(locale, displayString);
            this.m_displayToLocaleMap.put(displayString, locale);
        }
        return this.m_localeToDisplayMap.get(locale);
    }

    public List<Locale> getSuppLangList() {
        return this.m_suppLangList;
    }

    public String[] getKeyboardLayouts() {
        ArrayList<String> keyboardLayouts = new ArrayList<String>();
        Enumeration layoutUrls = Activator.getDefault().getBundle().findEntries(KEYBOARD_MAPPING_FILE_PREFIX, "*.properties", false);
        while (layoutUrls.hasMoreElements()) {
            URL layoutUrl = (URL)layoutUrls.nextElement();
            try {
                keyboardLayouts.add(URIUtil.lastSegment((URI)URIUtil.removeFileExtension((URI)URIUtil.toURI((URL)layoutUrl))));
            }
            catch (URISyntaxException e) {
                LOG.error("Error occurred while reading Keyboard Mappings.", (Throwable)e);
            }
        }
        return keyboardLayouts.toArray(new String[keyboardLayouts.size()]);
    }
}

