/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.client.core.utils;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import org.apache.commons.lang.Validate;
import org.eclipse.jubula.client.core.gen.parser.parameter.lexer.LexerException;
import org.eclipse.jubula.client.core.gen.parser.parameter.node.EOF;
import org.eclipse.jubula.client.core.gen.parser.parameter.parser.ParserException;
import org.eclipse.jubula.client.core.i18n.Messages;
import org.eclipse.jubula.client.core.model.IParamDescriptionPO;
import org.eclipse.jubula.client.core.model.IParamNodePO;
import org.eclipse.jubula.client.core.model.IParameterInterfacePO;
import org.eclipse.jubula.client.core.utils.ExecObject;
import org.eclipse.jubula.client.core.utils.INestableParamValueToken;
import org.eclipse.jubula.client.core.utils.IParamValueToken;
import org.eclipse.jubula.client.core.utils.IParamValueValidator;
import org.eclipse.jubula.client.core.utils.RefToken;
import org.eclipse.jubula.client.core.utils.SemanticParsingException;
import org.eclipse.jubula.client.core.utils.SimpleValueToken;
import org.eclipse.jubula.client.core.utils.TokenError;
import org.eclipse.jubula.client.core.utils.VariableToken;
import org.eclipse.jubula.tools.internal.exception.InvalidDataException;
import org.eclipse.jubula.tools.internal.messagehandling.MessageIDs;

public abstract class ParamValueConverter {
    private static final Set<Integer> RECOVERABLE_PARSE_ERROR_CODES = new HashSet<Integer>();
    private String m_guiString = null;
    private String m_modelString = null;
    private List<IParamValueToken> m_tokens = new ArrayList<IParamValueToken>();
    private List<TokenError> m_errors = new ArrayList<TokenError>(1);
    private IParameterInterfacePO m_currentNode;
    private Locale m_locale;
    private IParamDescriptionPO m_desc;
    private IParamValueValidator m_validator;

    static {
        RECOVERABLE_PARSE_ERROR_CODES.add(MessageIDs.E_ONE_CHAR_PARSE_ERROR);
        RECOVERABLE_PARSE_ERROR_CODES.add(MessageIDs.E_MISSING_CLOSING_BRACE);
    }

    public ParamValueConverter(IParameterInterfacePO currentNode, Locale locale, IParamDescriptionPO desc, IParamValueValidator validator) {
        Validate.notNull((Object)currentNode, (String)Messages.NodeForGivenParameterValueMustNotBeNull);
        this.m_currentNode = currentNode;
        this.m_locale = locale;
        this.m_desc = desc;
        this.m_validator = validator;
    }

    protected ParamValueConverter() {
    }

    public List<String> getNamesForReferences() {
        ArrayList<String> paramNames = new ArrayList<String>();
        for (IParamValueToken token : this.getAllTokens()) {
            if (!(token instanceof RefToken)) continue;
            RefToken refToken = (RefToken)token;
            paramNames.add(RefToken.extractCore(refToken.getGuiString()));
        }
        return paramNames;
    }

    public List<String> getVariables() {
        ArrayList<String> variables = new ArrayList<String>();
        for (IParamValueToken token : this.getAllTokens()) {
            if (!(token instanceof VariableToken)) continue;
            variables.add(((VariableToken)token).getGuiString());
        }
        return variables;
    }

    public boolean containsReferences() {
        for (IParamValueToken token : this.getAllTokens()) {
            if (!(token instanceof RefToken)) continue;
            return true;
        }
        return false;
    }

    public boolean containsOnlySimpleValues() {
        for (IParamValueToken token : this.getTokens()) {
            if (token instanceof SimpleValueToken) continue;
            return false;
        }
        return true;
    }

    public String getExecutionString(List<ExecObject> stack, Locale locale) throws InvalidDataException {
        StringBuilder builder = new StringBuilder();
        for (IParamValueToken token : this.getTokens()) {
            builder.append(token.getExecutionString(new ArrayList<ExecObject>(stack), locale));
        }
        return builder.toString();
    }

    abstract void createTokens();

    abstract void validateSingleTokens();

    protected List<IParamValueToken> getTokens() {
        return this.m_tokens;
    }

    protected List<IParamValueToken> getAllTokens() {
        ArrayList<IParamValueToken> tokens = new ArrayList<IParamValueToken>(this.getTokens());
        for (IParamValueToken token : this.getTokens()) {
            if (!(token instanceof INestableParamValueToken)) continue;
            this.addAllSubTokens((INestableParamValueToken)token, tokens);
        }
        return tokens;
    }

    private void addAllSubTokens(INestableParamValueToken token, List<IParamValueToken> tokenList) {
        IParamValueToken[] nestedTokens = token.getNestedTokens();
        tokenList.addAll(Arrays.asList(nestedTokens));
        IParamValueToken[] iParamValueTokenArray = nestedTokens;
        int n = nestedTokens.length;
        int n2 = 0;
        while (n2 < n) {
            IParamValueToken subToken = iParamValueTokenArray[n2];
            if (subToken instanceof INestableParamValueToken) {
                this.addAllSubTokens((INestableParamValueToken)subToken, tokenList);
            }
            ++n2;
        }
    }

    protected void setTokens(List<IParamValueToken> tokens) {
        this.m_tokens = tokens;
    }

    public IParameterInterfacePO getCurrentNode() {
        return this.m_currentNode;
    }

    public String getGuiString() {
        return this.m_guiString;
    }

    protected void setGuiString(String guiString) {
        this.m_guiString = guiString;
    }

    public String getModelString() {
        return this.m_modelString;
    }

    public List<RefToken> getRefTokens() {
        ArrayList<RefToken> refTokens = new ArrayList<RefToken>();
        for (IParamValueToken token : this.getAllTokens()) {
            if (!(token instanceof RefToken)) continue;
            refTokens.add((RefToken)token);
        }
        return Collections.unmodifiableList(refTokens);
    }

    protected void setModelString(String modelString) {
        this.m_modelString = modelString;
    }

    Locale getLocale() {
        return this.m_locale;
    }

    public IParamDescriptionPO getDesc() {
        return this.m_desc;
    }

    protected void setDesc(IParamDescriptionPO desc) {
        this.m_desc = desc;
    }

    public List<TokenError> getErrors() {
        this.validateSingleTokens();
        return this.m_errors;
    }

    public boolean containsErrors() {
        return !this.m_errors.isEmpty();
    }

    protected void addError(TokenError error) {
        this.m_errors.add(error);
    }

    protected void setErrors(List<TokenError> errors) {
        this.m_errors = errors;
    }

    protected void setLocale(Locale locale) {
        this.m_locale = locale;
    }

    void setCurrentNode(IParamNodePO currentNode) {
        this.m_currentNode = currentNode;
    }

    protected void createErrors(IOException e, String input) {
        this.addError(new TokenError(input, MessageIDs.E_GENERAL_PARSE_ERROR, ConvValidationState.invalid));
    }

    protected void createErrors(LexerException e, String input) {
        this.addError(new TokenError(input, MessageIDs.E_GENERAL_PARSE_ERROR, ConvValidationState.invalid));
    }

    protected void createErrors(ParserException e, String input) {
        ConvValidationState state = ConvValidationState.invalid;
        if (e.getToken() instanceof EOF) {
            state = ConvValidationState.undecided;
        }
        this.addError(new TokenError(input, MessageIDs.E_GENERAL_PARSE_ERROR, state));
    }

    protected void createErrors(SemanticParsingException e, String input) {
        if (RECOVERABLE_PARSE_ERROR_CODES.contains(e.getErrorId())) {
            this.addError(new TokenError(input, e.getErrorId(), ConvValidationState.undecided));
        } else {
            this.addError(new TokenError(input, e.getErrorId(), ConvValidationState.invalid));
        }
    }

    IParamValueValidator getValidator() {
        return this.m_validator;
    }

    protected void createTokenError(ConvValidationState state, IParamValueToken token) {
        if (state == ConvValidationState.invalid || state == ConvValidationState.undecided) {
            TokenError tokenError = new TokenError(this.getGuiString(), token.getErrorKey(), state);
            this.addError(tokenError);
        }
    }

    public static enum ConvValidationState {
        invalid,
        notSet,
        undecided,
        valid;

    }
}

