/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.client.core.utils;

import java.util.HashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.Locale;
import java.util.regex.Pattern;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.eclipse.jubula.client.core.businessprocess.TestCaseParamBP;
import org.eclipse.jubula.client.core.i18n.Messages;
import org.eclipse.jubula.client.core.model.INodePO;
import org.eclipse.jubula.client.core.model.IParamDescriptionPO;
import org.eclipse.jubula.client.core.model.IParamNodePO;
import org.eclipse.jubula.client.core.model.IParameterInterfacePO;
import org.eclipse.jubula.client.core.model.ISpecTestCasePO;
import org.eclipse.jubula.client.core.model.ITestDataCubePO;
import org.eclipse.jubula.client.core.model.ITestSuitePO;
import org.eclipse.jubula.client.core.utils.AbstractParamValueToken;
import org.eclipse.jubula.client.core.utils.ExecObject;
import org.eclipse.jubula.client.core.utils.ParamValueConverter;
import org.eclipse.jubula.tools.internal.exception.Assert;
import org.eclipse.jubula.tools.internal.exception.InvalidDataException;
import org.eclipse.jubula.tools.internal.messagehandling.MessageIDs;

public class RefToken
extends AbstractParamValueToken {
    private static final String PREFIX = "={";
    private String m_guiString = null;
    private String m_modelString = null;
    private boolean m_isTokenGuiBased;
    private IParameterInterfacePO m_currentNode;

    public RefToken(String string, boolean isGuiString, int startPos, IParameterInterfacePO node, IParamDescriptionPO desc) {
        super(string, startPos, desc);
        if (!this.isValid(string, isGuiString)) {
            throw new IllegalArgumentException(String.valueOf(Messages.SyntaxErrorInReference) + " " + string);
        }
        this.m_isTokenGuiBased = isGuiString;
        if (isGuiString) {
            this.m_guiString = string;
        } else {
            this.m_modelString = string;
        }
        this.m_currentNode = node;
    }

    @Override
    public String getModelString() {
        String guid;
        if (this.m_modelString == null && this.m_guiString != null && (guid = this.computeGuid()) != null) {
            this.m_modelString = RefToken.replaceCore(this.computeGuid(), this.m_guiString);
        }
        return this.m_modelString;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private String computeGuid() {
        String guid = "";
        if (this.m_modelString != null) {
            return RefToken.extractCore(this.m_modelString);
        }
        if (this.m_guiString == null) return guid;
        if (!(this.m_currentNode instanceof INodePO)) return guid;
        INodePO parent = ((INodePO)((Object)this.m_currentNode)).getParentNode();
        String refName = RefToken.extractCore(this.m_guiString);
        if (parent instanceof IParamNodePO) {
            IParamNodePO parentNode = (IParamNodePO)parent;
            IParamDescriptionPO desc = parentNode.getParameterForName(refName);
            if (desc == null) return null;
            return desc.getUniqueId();
        }
        StringBuilder msg = new StringBuilder();
        msg.append(Messages.Node);
        msg.append(" ");
        msg.append(this.m_currentNode.getName());
        msg.append(" ");
        msg.append(Messages.WithReferenceIsNotChildOfParamNode);
        Assert.notReached((String)msg.toString());
        return guid;
    }

    public static String replaceCore(String repl, String str) {
        int start = -1;
        int end = -1;
        StringBuilder builder = new StringBuilder(str);
        if (str.startsWith(PREFIX)) {
            start = 2;
            end = str.length() - 1;
        } else {
            start = 1;
            end = str.length();
        }
        if (start < end) {
            builder.replace(start, end, repl);
            return builder.toString();
        }
        Assert.notReached((String)Messages.UnexpectedProblemWithStringReplacement);
        return str;
    }

    private boolean isValid(String s, boolean isGuiString) {
        if (!isGuiString) {
            String string = RefToken.extractCore(s);
            return Pattern.matches("[0-9a-fA-F]{32}", string);
        }
        return true;
    }

    public static String extractCore(String s) {
        StringBuilder builder = new StringBuilder(s);
        if (s != null && s.length() != 0) {
            if (s.startsWith(PREFIX) && s.endsWith("}")) {
                builder.delete(0, 2);
                builder.deleteCharAt(builder.length() - 1);
            } else if (s.startsWith("=")) {
                builder.deleteCharAt(0);
            }
        }
        return builder.toString();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public ParamValueConverter.ConvValidationState validate() {
        ParamValueConverter.ConvValidationState state = ParamValueConverter.ConvValidationState.notSet;
        if (this.m_currentNode instanceof ISpecTestCasePO) {
            this.setErrorKey(MessageIDs.E_NO_REF_FOR_SPEC_TC);
            return ParamValueConverter.ConvValidationState.invalid;
        }
        if (this.m_currentNode instanceof INodePO && ((INodePO)((Object)this.m_currentNode)).getParentNode() instanceof ITestSuitePO) {
            this.setErrorKey(MessageIDs.E_REF_IN_TS);
            return ParamValueConverter.ConvValidationState.invalid;
        }
        if (this.m_currentNode instanceof ITestDataCubePO) {
            this.setErrorKey(MessageIDs.E_REF_IN_TDC);
            return ParamValueConverter.ConvValidationState.invalid;
        }
        boolean isModifiable = TestCaseParamBP.isReferenceValueAllowed(this.m_currentNode);
        if (!this.m_isTokenGuiBased) return ParamValueConverter.ConvValidationState.valid;
        INodePO parent = this.m_currentNode.getSpecificationUser();
        String refName = RefToken.extractCore(this.m_guiString);
        if (!(parent instanceof ISpecTestCasePO)) throw new UnsupportedOperationException(Messages.NotAllowedToAddReferenceToNodeASpecTestCase);
        ISpecTestCasePO specTc = (ISpecTestCasePO)parent;
        List<IParamDescriptionPO> descs = specTc.getParameterList();
        HashMap<String, IParamDescriptionPO> paramNames = new HashMap<String, IParamDescriptionPO>();
        for (IParamDescriptionPO desc : descs) {
            paramNames.put(desc.getName(), desc);
        }
        if (paramNames.keySet().contains(refName)) {
            IParamDescriptionPO desc;
            desc = (IParamDescriptionPO)paramNames.get(refName);
            if (desc.getType().equals(this.getParamDescription().getType())) {
                return ParamValueConverter.ConvValidationState.valid;
            }
            state = ParamValueConverter.ConvValidationState.invalid;
            this.setErrorKey(MessageIDs.E_INVALID_REF_TYPE);
            return state;
        } else {
            if (isModifiable) {
                return ParamValueConverter.ConvValidationState.valid;
            }
            state = ParamValueConverter.ConvValidationState.invalid;
            this.setErrorKey(MessageIDs.E_INVALID_REF);
            for (String paramName : paramNames.keySet()) {
                IParamDescriptionPO desc;
                if (!paramName.startsWith(refName) || !(desc = (IParamDescriptionPO)paramNames.get(paramName)).getType().equals(this.getParamDescription().getType())) continue;
                return ParamValueConverter.ConvValidationState.undecided;
            }
        }
        return state;
    }

    @Override
    public String getExecutionString(List<ExecObject> stack, Locale locale) throws InvalidDataException {
        String refGuid = RefToken.extractCore(this.getModelString());
        ListIterator<ExecObject> it = stack.listIterator(stack.size());
        while (it.hasPrevious()) {
            ExecObject obj = it.previous();
            String parameterValue = obj.getParameterValue(refGuid);
            if (parameterValue == null) continue;
            return parameterValue;
        }
        this.throwInvalidDataException(RefToken.extractCore(this.getGuiString()));
        return null;
    }

    private void throwInvalidDataException(String reference) throws InvalidDataException {
        throw new InvalidDataException(String.valueOf(Messages.Reference) + reference + " " + Messages.NotResolvable, MessageIDs.E_NO_REFERENCE);
    }

    @Override
    public String getGuiString() {
        if (this.m_modelString != null && this.m_guiString == null) {
            this.m_guiString = RefToken.replaceCore(this.computeReferenceName(), this.m_modelString);
        }
        return this.m_guiString;
    }

    private String computeReferenceName() {
        String refName = "";
        if (this.m_guiString != null) {
            refName = RefToken.extractCore(this.m_guiString);
        } else if (this.m_modelString != null) {
            String guid = RefToken.extractCore(this.m_modelString);
            INodePO parent = this.m_currentNode.getSpecificationUser();
            if (parent instanceof IParamNodePO) {
                IParamNodePO parentNode = (IParamNodePO)parent;
                IParamDescriptionPO desc = parentNode.getParameterForUniqueId(guid);
                if (desc != null) {
                    refName = desc.getName();
                } else {
                    String id = guid != null ? guid : "";
                    Assert.notReached((String)(String.valueOf(Messages.InvalidGuid) + " " + id + " " + Messages.InReferenceNoAppropriateParameter));
                }
            } else {
                Assert.notReached((String)Messages.NodeWithReferenceIsNotChildOfParamNode);
            }
        }
        return refName;
    }

    void setModelString(String modelString) {
        this.m_modelString = modelString;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        RefToken otherObj = (RefToken)obj;
        return new EqualsBuilder().append((Object)this.getModelString(), (Object)otherObj.getModelString()).isEquals();
    }

    public int hashCode() {
        return new HashCodeBuilder().append((Object)this.getModelString()).toHashCode();
    }
}

