/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.rc.swt.tester;

import java.awt.Rectangle;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.Set;
import org.eclipse.jubula.rc.common.AUTServer;
import org.eclipse.jubula.rc.common.driver.IRobot;
import org.eclipse.jubula.rc.common.driver.IRobotFactory;
import org.eclipse.jubula.rc.common.driver.IRunnable;
import org.eclipse.jubula.rc.common.exception.StepExecutionException;
import org.eclipse.jubula.rc.common.listener.EventLock;
import org.eclipse.jubula.rc.common.logger.AutServerLogger;
import org.eclipse.jubula.rc.common.tester.AbstractApplicationTester;
import org.eclipse.jubula.rc.common.util.KeyStrokeUtil;
import org.eclipse.jubula.rc.common.util.MatchUtil;
import org.eclipse.jubula.rc.common.util.Verifier;
import org.eclipse.jubula.rc.swt.SwtAUTServer;
import org.eclipse.jubula.rc.swt.components.SwtComponent;
import org.eclipse.jubula.rc.swt.driver.EventThreadQueuerSwtImpl;
import org.eclipse.jubula.rc.swt.driver.RobotFactoryConfig;
import org.eclipse.jubula.rc.swt.listener.ComponentHandler;
import org.eclipse.jubula.rc.swt.listener.FocusTracker;
import org.eclipse.jubula.rc.swt.tester.CAPUtil;
import org.eclipse.jubula.rc.swt.tester.util.EventListener;
import org.eclipse.jubula.rc.swt.utils.SwtPointUtil;
import org.eclipse.jubula.tools.internal.objects.event.EventFactory;
import org.eclipse.jubula.tools.internal.utils.EnvironmentUtils;
import org.eclipse.jubula.tools.internal.utils.TimeUtil;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Widget;

public class SwtApplicationTester
extends AbstractApplicationTester {
    private static AutServerLogger log = new AutServerLogger(SwtApplicationTester.class);
    private IRobotFactory m_robotFactory;

    private IRobotFactory getRobotFactory() {
        if (this.m_robotFactory == null) {
            this.m_robotFactory = new RobotFactoryConfig().getRobotFactory();
        }
        return this.m_robotFactory;
    }

    public String[] getTextArrayFromComponent() {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void rcWaitForWindow(final String title, final String operator, int timeout, int delay) {
        WindowEventCondition cond = new WindowEventCondition(title, operator, false);
        final EventLock lock = new EventLock();
        final EventListener listener = new EventListener(lock, cond);
        final Display display = ((SwtAUTServer)AUTServer.getInstance()).getAutDisplay();
        EventThreadQueuerSwtImpl queuer = new EventThreadQueuerSwtImpl();
        queuer.invokeAndWait("addWindowOpenedListeners", new IRunnable(){

            public Object run() {
                display.addFilter(26, listener);
                display.addFilter(22, listener);
                if (SwtApplicationTester.this.isWindowOpen(title, operator)) {
                    lock.release();
                }
                return null;
            }
        });
        try {
            EventLock eventLock = lock;
            synchronized (eventLock) {
                long currentTimeout = timeout;
                long done = System.currentTimeMillis() + (long)timeout;
                while (!lock.isReleased() && currentTimeout > 0L) {
                    try {
                        lock.wait(currentTimeout);
                        long now = System.currentTimeMillis();
                        currentTimeout = done - now;
                    }
                    catch (InterruptedException interruptedException) {}
                }
            }
        }
        catch (Throwable throwable) {
            queuer.invokeAndWait("removeWindowOpenedListeners", new IRunnable(display, listener){
                private final /* synthetic */ Display val$display;
                private final /* synthetic */ Listener val$listener;
                {
                    this.val$display = display;
                    this.val$listener = listener;
                }

                public Object run() {
                    this.val$display.removeFilter(26, this.val$listener);
                    this.val$display.removeFilter(22, this.val$listener);
                    return null;
                }
            });
            throw throwable;
        }
        queuer.invokeAndWait("removeWindowOpenedListeners", new /* invalid duplicate definition of identical inner class */);
        if (!lock.isReleased()) {
            throw new StepExecutionException("window did not open", EventFactory.createActionError((String)"TestErrorEvent.TimeoutExpired"));
        }
        TimeUtil.delay((long)delay);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void rcWaitForWindowActivation(final String title, final String operator, int timeout, int delay) {
        WindowEventCondition cond = new WindowEventCondition(title, operator, false);
        final EventLock lock = new EventLock();
        final EventListener listener = new EventListener(lock, cond);
        final Display display = ((SwtAUTServer)AUTServer.getInstance()).getAutDisplay();
        EventThreadQueuerSwtImpl queuer = new EventThreadQueuerSwtImpl();
        queuer.invokeAndWait("addWindowActiveListeners", new IRunnable(){

            public Object run() {
                display.addFilter(26, listener);
                if (SwtApplicationTester.this.isWindowActive(title, operator)) {
                    lock.release();
                }
                return null;
            }
        });
        try {
            EventLock eventLock = lock;
            synchronized (eventLock) {
                long currentTimeout = timeout;
                long done = System.currentTimeMillis() + (long)timeout;
                while (!lock.isReleased() && currentTimeout > 0L) {
                    try {
                        lock.wait(currentTimeout);
                        long now = System.currentTimeMillis();
                        currentTimeout = done - now;
                    }
                    catch (InterruptedException interruptedException) {}
                }
            }
        }
        catch (Throwable throwable) {
            queuer.invokeAndWait("removeWindowActiveListeners", new IRunnable(display, listener){
                private final /* synthetic */ Display val$display;
                private final /* synthetic */ Listener val$listener;
                {
                    this.val$display = display;
                    this.val$listener = listener;
                }

                public Object run() {
                    this.val$display.removeFilter(26, this.val$listener);
                    return null;
                }
            });
            throw throwable;
        }
        queuer.invokeAndWait("removeWindowActiveListeners", new /* invalid duplicate definition of identical inner class */);
        if (!lock.isReleased()) {
            throw new StepExecutionException("window was not activated", EventFactory.createActionError((String)"TestErrorEvent.TimeoutExpired"));
        }
        TimeUtil.delay((long)delay);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void rcWaitForWindowToClose(final String title, final String operator, int timeout, int delay) {
        WindowEventCondition cond = new WindowEventCondition(title, operator, true);
        final EventLock lock = new EventLock();
        final EventListener listener = new EventListener(lock, cond);
        final Display display = ((SwtAUTServer)AUTServer.getInstance()).getAutDisplay();
        EventThreadQueuerSwtImpl queuer = new EventThreadQueuerSwtImpl();
        queuer.invokeAndWait("addWindowClosedListeners", new IRunnable(){

            public Object run() {
                display.addFilter(21, listener);
                display.addFilter(23, listener);
                display.addFilter(12, listener);
                if (!SwtApplicationTester.this.isWindowOpen(title, operator)) {
                    lock.release();
                }
                return null;
            }
        });
        try {
            EventLock eventLock = lock;
            synchronized (eventLock) {
                long currentTimeout = timeout;
                long done = System.currentTimeMillis() + (long)timeout;
                while (!lock.isReleased() && currentTimeout > 0L) {
                    try {
                        lock.wait(currentTimeout);
                        long now = System.currentTimeMillis();
                        currentTimeout = done - now;
                    }
                    catch (InterruptedException interruptedException) {}
                }
            }
        }
        catch (Throwable throwable) {
            queuer.invokeAndWait("removeWindowClosedListeners", new IRunnable(display, listener){
                private final /* synthetic */ Display val$display;
                private final /* synthetic */ Listener val$listener;
                {
                    this.val$display = display;
                    this.val$listener = listener;
                }

                public Object run() {
                    this.val$display.removeFilter(21, this.val$listener);
                    this.val$display.removeFilter(23, this.val$listener);
                    this.val$display.removeFilter(12, this.val$listener);
                    return null;
                }
            });
            throw throwable;
        }
        queuer.invokeAndWait("removeWindowClosedListeners", new /* invalid duplicate definition of identical inner class */);
        if (!lock.isReleased()) {
            throw new StepExecutionException("window did not close", EventFactory.createActionError((String)"TestErrorEvent.TimeoutExpired"));
        }
        TimeUtil.delay((long)delay);
    }

    private boolean isWindowOpen(String title, String operator) {
        boolean wasInterrupted = false;
        boolean equal = false;
        block2: do {
            try {
                wasInterrupted = false;
                Set components = ComponentHandler.getAutHierarchy().getHierarchyMap().keySet();
                Iterator it = components.iterator();
                while (it.hasNext()) {
                    Widget comp = ((SwtComponent)((Object)it.next())).getRealComponent();
                    if (!(comp instanceof Shell) || comp.isDisposed() || !((Shell)comp).isVisible()) continue;
                    Shell frame = (Shell)comp;
                    if (!MatchUtil.getInstance().match(CAPUtil.getWidgetText((Widget)frame, frame.getText()), title, operator)) continue;
                    equal = true;
                    continue block2;
                }
            }
            catch (ConcurrentModificationException e) {
                log.debug((Object)"hierarchy modified while traversing", (Throwable)e);
                wasInterrupted = true;
            }
        } while (wasInterrupted);
        return equal;
    }

    public void rcCheckExistenceOfWindow(final String title, final String operator, boolean exists) {
        EventThreadQueuerSwtImpl queuer = new EventThreadQueuerSwtImpl();
        Boolean windowExists = (Boolean)queuer.invokeAndWait("isWindowOpen", new IRunnable(){

            public Object run() throws StepExecutionException {
                return new Boolean(SwtApplicationTester.this.isWindowOpen(title, operator));
            }
        });
        Verifier.equals((boolean)exists, (boolean)windowExists);
    }

    public Rectangle getActiveWindowBounds() {
        org.eclipse.swt.graphics.Rectangle activeWindowSize = (org.eclipse.swt.graphics.Rectangle)this.getRobotFactory().getEventThreadQueuer().invokeAndWait(String.valueOf(((Object)((Object)this)).getClass().getName()) + ".getActiveWindowBounds", new IRunnable(){

            public Object run() {
                Display d = ((SwtAUTServer)AUTServer.getInstance()).getAutDisplay();
                if (d != null && d.getActiveShell() != null) {
                    return d.getActiveShell().getBounds();
                }
                return null;
            }
        });
        if (activeWindowSize != null) {
            return SwtPointUtil.toAwtRectangle(activeWindowSize);
        }
        return null;
    }

    protected IRobot getRobot() {
        return AUTServer.getInstance().getRobot();
    }

    public void rcKeyStroke(String modifierSpec, String keySpec) {
        if (keySpec == null || keySpec.trim().length() == 0) {
            throw new StepExecutionException("The base key of the key stroke must not be null or empty", EventFactory.createActionError((String)"TestErrorEvent.InvalidParameterValue"));
        }
        String keyStrokeSpec = keySpec.trim();
        String mod = KeyStrokeUtil.getModifierString((String)modifierSpec);
        if (mod.length() > 0) {
            keyStrokeSpec = String.valueOf(mod) + " " + keyStrokeSpec;
        }
        String keySpecification = keySpec.trim().toLowerCase();
        if (EnvironmentUtils.isMacOS() && keySpecification.length() == 1 && keySpecification.charAt(0) == 'b') {
            this.rcNativeKeyStroke(modifierSpec, keySpec);
        } else {
            this.getRobot().keyStroke(keyStrokeSpec);
        }
    }

    protected Object getFocusOwner() {
        return FocusTracker.getFocusOwner();
    }

    protected int getEventCode(int key) {
        int event = 0;
        switch (key) {
            case 1: {
                event = 16777299;
                break;
            }
            case 2: {
                event = 16777298;
                break;
            }
            case 3: {
                event = 16777300;
                break;
            }
        }
        return event;
    }

    protected Object getActiveWindow() {
        Shell activeWindow = (Shell)this.getRobotFactory().getEventThreadQueuer().invokeAndWait(String.valueOf(((Object)((Object)this)).getClass().getName()) + ".getActiveWindow", new IRunnable(){

            public Object run() {
                Display d = ((SwtAUTServer)AUTServer.getInstance()).getAutDisplay();
                return d.getActiveShell();
            }
        });
        return activeWindow;
    }

    private boolean isWindowActive(String title, String operator) {
        Shell activeWindow = (Shell)this.getActiveWindow();
        if (activeWindow == null) {
            if (log.isWarnEnabled()) {
                log.warn((Object)("No active Window found while searching for Window with title: '" + String.valueOf(title) + "'! " + "(SwtApplicationImplClass#isWindowActive(String, String))"));
            }
            return false;
        }
        String windowTitle = CAPUtil.getWidgetText((Widget)activeWindow, activeWindow.getText());
        return MatchUtil.getInstance().match(windowTitle, title, operator);
    }

    private static class WindowEventCondition
    implements EventListener.Condition {
        private String m_windowTitle;
        private String m_matchingOperator;
        private boolean m_valForDisposed;

        public WindowEventCondition(String windowTitle, String matchingOperator, boolean valForDisposed) {
            this.m_windowTitle = windowTitle;
            this.m_matchingOperator = matchingOperator;
            this.m_valForDisposed = valForDisposed;
        }

        public boolean isTrue(Event event) {
            if (event.widget instanceof Shell) {
                Shell window = (Shell)event.widget;
                if (window.isDisposed()) {
                    return this.m_valForDisposed;
                }
                String windowText = CAPUtil.getWidgetText((Widget)window, window.getText());
                return MatchUtil.getInstance().match(windowText, this.m_windowTitle, this.m_matchingOperator);
            }
            return false;
        }
    }
}

