/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.rc.javafx.listener;

import javafx.scene.input.InputEvent;
import javafx.scene.input.KeyCode;
import javafx.scene.input.KeyEvent;
import javafx.scene.input.MouseButton;
import javafx.scene.input.MouseEvent;
import org.eclipse.jubula.rc.common.AUTServerConfiguration;

public class KeyAcceptor {
    public static final int MAPPING_KEY_COMB = 1;
    public static final int CHECKMODE_KEY_COMB = 2;
    public static final int CHECKCOMP_KEY_COMB = 3;

    private KeyAcceptor() {
    }

    public static int accept(InputEvent event) {
        int keyMod = 0;
        int inputCode = 0;
        if (event instanceof KeyEvent) {
            KeyEvent kEvent = (KeyEvent)event;
            inputCode = KeyAcceptor.getAWTKeyCode(kEvent);
            if (kEvent.isAltDown()) {
                keyMod |= 0x200;
            }
            if (kEvent.isShiftDown()) {
                keyMod |= 0x40;
            }
            if (kEvent.isControlDown()) {
                keyMod |= 0x80;
            }
        } else if (event instanceof MouseEvent) {
            MouseEvent mEvent = (MouseEvent)event;
            MouseButton button = mEvent.getButton();
            switch (button) {
                case PRIMARY: {
                    inputCode = 1;
                    break;
                }
                case MIDDLE: {
                    inputCode = 2;
                    break;
                }
                case SECONDARY: {
                    inputCode = 3;
                    break;
                }
            }
        }
        if (inputCode == AUTServerConfiguration.getInstance().getKey() || inputCode == AUTServerConfiguration.getInstance().getMouseButton() && keyMod == AUTServerConfiguration.getInstance().getKeyMod()) {
            return 1;
        }
        if (inputCode == AUTServerConfiguration.getInstance().getCheckModeKey() && keyMod == AUTServerConfiguration.getInstance().getCheckModeKeyMod()) {
            return 2;
        }
        if (inputCode == AUTServerConfiguration.getInstance().getCheckCompKey() && keyMod == AUTServerConfiguration.getInstance().getCheckCompKeyMod()) {
            return 3;
        }
        return 0;
    }

    public static int getAWTKeyCode(KeyEvent event) {
        KeyCode code = event.getCode();
        if (code.isLetterKey()) {
            return java.awt.event.KeyEvent.getExtendedKeyCodeForChar(code.getName().charAt(0));
        }
        if (code.isFunctionKey()) {
            switch (code) {
                case F1: {
                    return 112;
                }
                case F2: {
                    return 113;
                }
                case F3: {
                    return 114;
                }
                case F4: {
                    return 115;
                }
                case F5: {
                    return 116;
                }
                case F6: {
                    return 117;
                }
                case F7: {
                    return 118;
                }
                case F8: {
                    return 119;
                }
                case F9: {
                    return 120;
                }
                case F10: {
                    return 121;
                }
                case F11: {
                    return 112;
                }
                case F12: {
                    return 123;
                }
            }
        }
        return 0;
    }
}

