/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.rc.javafx.tester.adapter;

import java.awt.Rectangle;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Callable;
import javafx.scene.Node;
import javafx.scene.control.Skin;
import javafx.scene.control.SkinBase;
import javafx.scene.control.Tab;
import javafx.scene.control.TabPane;
import org.eclipse.jubula.rc.common.exception.StepExecutionException;
import org.eclipse.jubula.rc.common.tester.adapter.interfaces.ITabbedComponent;
import org.eclipse.jubula.rc.javafx.driver.EventThreadQueuerJavaFXImpl;
import org.eclipse.jubula.rc.javafx.tester.adapter.IContainerAdapter;
import org.eclipse.jubula.rc.javafx.tester.adapter.JavaFXComponentAdapter;
import org.eclipse.jubula.rc.javafx.util.NodeBounds;
import org.eclipse.jubula.tools.internal.objects.event.EventFactory;

public class TabPaneAdapter
extends JavaFXComponentAdapter<TabPane>
implements ITabbedComponent,
IContainerAdapter {
    private static final Class<?>[] GET_TAB_HEADER_SKIN_PARAMETER_TYPES = new Class[]{Tab.class};
    private static final String GET_TAB_HEADER_SKIN_METHOD_NAME = "getTabHeaderSkin";
    private static final String TAB_HEADER_AREA_CLASSNAME = "com.sun.javafx.scene.control.skin.TabPaneSkin$TabHeaderArea";

    public TabPaneAdapter(TabPane objectToAdapt) {
        super(objectToAdapt);
    }

    public int getTabCount() {
        return EventThreadQueuerJavaFXImpl.invokeAndWait("getTabCount", new Callable<Integer>(){

            @Override
            public Integer call() {
                return ((TabPane)TabPaneAdapter.this.getRealComponent()).getTabs().size();
            }
        });
    }

    public String getTitleofTab(final int index) {
        return EventThreadQueuerJavaFXImpl.invokeAndWait("getTitleOfTab", new Callable<String>(){

            @Override
            public String call() {
                return TabPaneAdapter.this.getTabAt(index).getText();
            }
        });
    }

    public Rectangle getBoundsAt(final int index) {
        return EventThreadQueuerJavaFXImpl.invokeAndWait("getBoundsAt", new Callable<Rectangle>(){

            @Override
            public Rectangle call() {
                Tab targetTab = TabPaneAdapter.this.getTabAt(index);
                Node targetNode = TabPaneAdapter.this.getNodeFor(targetTab);
                return NodeBounds.getRelativeBounds(targetNode, (Node)TabPaneAdapter.this.getRealComponent());
            }
        });
    }

    public boolean isEnabledAt(final int index) {
        return EventThreadQueuerJavaFXImpl.invokeAndWait("isEnabledAt", new Callable<Boolean>(){

            @Override
            public Boolean call() {
                return !TabPaneAdapter.this.getTabAt(index).isDisabled();
            }
        });
    }

    public int getSelectedIndex() {
        return EventThreadQueuerJavaFXImpl.invokeAndWait("getSelectedIndex", new Callable<Integer>(){

            @Override
            public Integer call() throws Exception {
                return ((TabPane)TabPaneAdapter.this.getRealComponent()).getSelectionModel().getSelectedIndex();
            }
        });
    }

    private Tab getTabAt(int index) {
        EventThreadQueuerJavaFXImpl.checkEventThread();
        return (Tab)((TabPane)this.getRealComponent()).getTabs().get(index);
    }

    private Node getNodeFor(Tab targetTab) throws StepExecutionException {
        EventThreadQueuerJavaFXImpl.checkEventThread();
        Skin tabPaneSkin = ((TabPane)this.getRealComponent()).getSkin();
        if (!(tabPaneSkin instanceof SkinBase)) {
            throw new StepExecutionException("Skin not supported: " + tabPaneSkin.getClass(), EventFactory.createActionError((String)"TestErrorEvent.RendererNotSupported"));
        }
        ClassLoader skinClassLoader = targetTab.getClass().getClassLoader();
        try {
            Class<?> tabHeaderAreaClass = skinClassLoader.loadClass(TAB_HEADER_AREA_CLASSNAME);
            for (Node tabPaneSkinChild : ((SkinBase)tabPaneSkin).getChildren()) {
                if (!tabHeaderAreaClass.isInstance(tabPaneSkinChild)) continue;
                Method method = tabHeaderAreaClass.getDeclaredMethod(GET_TAB_HEADER_SKIN_METHOD_NAME, GET_TAB_HEADER_SKIN_PARAMETER_TYPES);
                method.setAccessible(true);
                Object tabHeaderSkin = method.invoke((Object)tabPaneSkinChild, targetTab);
                if (tabHeaderSkin == null || tabHeaderSkin instanceof Node) {
                    return (Node)tabHeaderSkin;
                }
                throw new StepExecutionException("Skin not supported: " + tabHeaderSkin.getClass(), EventFactory.createActionError((String)"TestErrorEvent.RendererNotSupported"));
            }
        }
        catch (ClassNotFoundException | NoSuchMethodException reflectiveOperationException) {
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            throw new StepExecutionException((Throwable)e);
        }
        throw new StepExecutionException("Skin / structure not supported: " + tabPaneSkin.getClass(), EventFactory.createActionError((String)"TestErrorEvent.RendererNotSupported"));
    }

    @Override
    public List<Node> getContent() {
        return EventThreadQueuerJavaFXImpl.invokeAndWait("getContent", new Callable<List<Node>>(){

            @Override
            public List<Node> call() throws Exception {
                ArrayList<Node> list = new ArrayList<Node>();
                list.add(((Tab)((TabPane)TabPaneAdapter.this.getRealComponent()).getSelectionModel().getSelectedItem()).getContent());
                return list;
            }
        });
    }
}

