/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.client.ui.rcp.dialogs;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.jface.layout.RowLayoutFactory;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jubula.client.core.model.IProjectPO;
import org.eclipse.jubula.client.ui.rcp.Plugin;
import org.eclipse.jubula.client.ui.rcp.businessprocess.ProjectUIBP;
import org.eclipse.jubula.client.ui.rcp.i18n.Messages;
import org.eclipse.jubula.client.ui.rcp.provider.ControlDecorator;
import org.eclipse.jubula.client.ui.utils.DialogUtils;
import org.eclipse.jubula.client.ui.utils.LayoutUtil;
import org.eclipse.jubula.client.ui.widgets.DirectCombo;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProjectDialog
extends TitleAreaDialog {
    private static Logger log = LoggerFactory.getLogger(TitleAreaDialog.class);
    private static final int NUM_COLUMNS_1 = 1;
    private static final int NUM_COLUMNS_4 = 4;
    private static final int VERTICAL_SPACING = 2;
    private static final int MARGIN_WIDTH = 10;
    private static final int MARGIN_HEIGHT = 10;
    private static final int WIDTH_HINT = 300;
    private static final int HORIZONTAL_SPAN = 3;
    private String m_message;
    private DirectCombo<String> m_nameComboBox;
    private DirectCombo<String> m_versionComboBox;
    private Map<String, List<String>> m_guidToVersionMap = new HashMap<String, List<String>>();
    private Map<ProjectData, IProjectPO> m_projectMap = new HashMap<ProjectData, IProjectPO>();
    private List<String> m_guidList = new ArrayList<String>();
    private List<String> m_nameList = new ArrayList<String>();
    private List<String> m_versionList = new ArrayList<String>();
    private ProjectData m_selection;
    private String m_title;
    private Image m_image;
    private String m_shellTitle;
    private Button m_defaultProject;
    private boolean m_isDeleteOperation = false;
    private Button m_keepTestresultSummaryButton;
    private boolean m_keepTestresultSummary = false;

    public ProjectDialog(Shell parentShell, List<IProjectPO> projectList, String message, String title, Image image, String shellTitle, boolean isDeleteAction) {
        super(parentShell);
        for (IProjectPO proj : projectList) {
            String projGUID = proj.getGuid();
            String projVersion = proj.getVersionString();
            if (projGUID != null && projVersion != null) {
                if (!this.m_guidToVersionMap.containsKey(projGUID)) {
                    this.m_nameList.add(proj.getName());
                    this.m_guidList.add(projGUID);
                    this.m_guidToVersionMap.put(projGUID, new ArrayList());
                }
                this.m_guidToVersionMap.get(projGUID).add(projVersion);
                this.m_projectMap.put(new ProjectData(projGUID, projVersion), proj);
                continue;
            }
            log.warn(String.valueOf(Messages.ProjectWithGUID) + " " + proj.getGuid() + " " + Messages.HasNoName + ".");
        }
        this.m_message = message;
        this.m_title = title;
        this.m_image = image;
        this.m_shellTitle = shellTitle;
        this.m_isDeleteOperation = isDeleteAction;
    }

    protected Control createDialogArea(Composite parent) {
        this.setMessage(this.m_message);
        this.setTitle(this.m_title);
        this.setTitleImage(this.m_image);
        this.getShell().setText(this.m_shellTitle);
        GridLayout gridLayoutParent = new GridLayout();
        gridLayoutParent.numColumns = 1;
        gridLayoutParent.verticalSpacing = 2;
        gridLayoutParent.marginWidth = 10;
        gridLayoutParent.marginHeight = 10;
        parent.setLayout((Layout)gridLayoutParent);
        LayoutUtil.createSeparator((Composite)parent);
        Composite area = new Composite(parent, 0);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 4;
        area.setLayout((Layout)gridLayout);
        GridData gridData = new GridData();
        gridData.grabExcessHorizontalSpace = true;
        gridData.grabExcessVerticalSpace = true;
        gridData.horizontalAlignment = 4;
        gridData.verticalAlignment = 4;
        gridData.widthHint = 300;
        area.setLayoutData((Object)gridData);
        this.createComboBoxes(area);
        this.createDefaultProjectCheckbox(area);
        if (this.m_isDeleteOperation) {
            this.createDeleteTestresultsCheckbox(area);
        }
        LayoutUtil.createSeparator((Composite)parent);
        return area;
    }

    private void createDeleteTestresultsCheckbox(Composite composite) {
        this.m_keepTestresultSummaryButton = new Button(composite, 32);
        this.m_keepTestresultSummaryButton.setText(Messages.DeleteProjectActionKeepTestresultSummaryCheckbox);
        this.m_keepTestresultSummaryButton.setSelection(false);
        GridData data = new GridData();
        data.horizontalSpan = 3;
        this.m_keepTestresultSummaryButton.setLayoutData((Object)data);
        ControlDecorator.decorateInfo((Control)this.m_keepTestresultSummaryButton, "ControlDecorator.KeepTestresultSummary", false);
    }

    private void createComboBoxes(Composite parent) {
        this.createEmptyLabel(parent);
        new Label(parent, 0).setText(Messages.OpenProjectActionLabel);
        this.m_nameComboBox = new DirectCombo(parent, 2060, this.m_guidList, this.m_nameList, false, true);
        GridData gridData = this.newGridData();
        LayoutUtil.addToolTipAndMaxWidth((GridData)gridData, this.m_nameComboBox);
        this.m_nameComboBox.setLayoutData((Object)gridData);
        this.m_nameComboBox.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                ProjectDialog.this.m_versionList = (List)ProjectDialog.this.m_guidToVersionMap.get(ProjectDialog.this.m_nameComboBox.getSelectedObject());
                ProjectDialog.this.m_versionComboBox.setItems(ProjectDialog.this.m_versionList, ProjectDialog.this.m_versionList);
                ProjectDialog.this.m_versionComboBox.select(ProjectDialog.this.m_versionComboBox.getItemCount() - 1);
                ProjectDialog.this.enableOKButton();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        if (this.m_nameComboBox.getItemCount() > 0) {
            this.m_nameComboBox.select(0);
        }
        this.m_versionList = this.m_guidToVersionMap.get(this.m_nameComboBox.getSelectedObject());
        this.createEmptyLabel(parent);
        new Label(parent, 0).setText(Messages.OpenProjectActionLabel2);
        this.m_versionComboBox = new DirectCombo(parent, 2060, this.m_versionList, this.m_versionList, false, (Comparator)new Comparator<String>(){

            @Override
            public int compare(String s1, String s2) {
                return s1.compareTo(s2);
            }
        });
        gridData = new GridData();
        gridData.grabExcessHorizontalSpace = false;
        gridData.horizontalAlignment = 1;
        gridData.horizontalSpan = 3;
        this.m_versionComboBox.setLayoutData((Object)gridData);
        this.m_versionComboBox.select(this.m_versionComboBox.getItemCount() - 1);
        this.m_versionComboBox.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                ProjectDialog.this.enableOKButton();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
    }

    private void createDefaultProjectCheckbox(Composite composite) {
        if (!this.m_isDeleteOperation) {
            this.createEmptyLabel(composite);
            new Label(composite, 0).setLayoutData((Object)new GridData(4, 2, false, false, 3, 1));
            IPreferenceStore prefs = Plugin.getDefault().getPreferenceStore();
            Composite checkLinkComposite = new Composite(composite, 0);
            checkLinkComposite.setLayout((Layout)RowLayoutFactory.fillDefaults().spacing(0).create());
            this.m_defaultProject = new Button(checkLinkComposite, 32);
            this.m_defaultProject.setSelection(prefs.getBoolean("PERFORM_AUTO_PROJECT_LOAD_KEY"));
            DialogUtils.createLinkToSecureStoragePreferencePage((Composite)checkLinkComposite, (String)Messages.OpenProjectDialogDefaultProjectCheckbox);
        }
    }

    private void createEmptyLabel(Composite composite) {
        new Label(composite, 0).setLayoutData((Object)new GridData(4, 2, false, false, 4, 1));
    }

    public void enableOKButton() {
        if (this.getButton(0) != null) {
            this.getButton(0).setEnabled(true);
        }
        this.setMessage(this.m_message);
    }

    protected void okPressed() {
        this.m_selection = new ProjectData((String)this.m_nameComboBox.getSelectedObject(), (String)this.m_versionComboBox.getSelectedObject());
        ProjectUIBP defaultProject = ProjectUIBP.getInstance();
        if (this.m_isDeleteOperation) {
            this.m_keepTestresultSummary = this.m_keepTestresultSummaryButton.getSelection();
        } else if (this.m_defaultProject.getSelection()) {
            defaultProject.saveMostRecentProjectData(this.m_selection);
        }
        this.setReturnCode(0);
        this.close();
    }

    private GridData newGridData() {
        GridData gridData = new GridData();
        gridData.grabExcessHorizontalSpace = true;
        gridData.horizontalAlignment = 4;
        gridData.horizontalSpan = 3;
        return gridData;
    }

    public ProjectData getSelection() {
        return this.m_selection;
    }

    public boolean keepTestresultSummary() {
        return this.m_keepTestresultSummary;
    }

    public static class ProjectData {
        private String m_guid;
        private String m_versionString;

        public ProjectData(String guid, String versionString) {
            this.m_guid = guid;
            this.m_versionString = versionString;
        }

        public String getVersionString() {
            return this.m_versionString;
        }

        public void setVersionString(String version) {
            this.m_versionString = version;
        }

        public String getGUID() {
            return this.m_guid;
        }

        public void setGUID(String guid) {
            this.m_guid = guid;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof ProjectData)) {
                return false;
            }
            ProjectData otherData = (ProjectData)obj;
            return new EqualsBuilder().append((Object)this.getGUID(), (Object)otherData.getGUID()).append((Object)this.getVersionString(), (Object)otherData.getVersionString()).isEquals();
        }

        public int hashCode() {
            return new HashCodeBuilder().append((Object)this.getGUID()).append((Object)this.getVersionString()).toHashCode();
        }
    }
}

