/*******************************************************************************
 * Copyright (c) 2014 BREDEX GmbH.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     BREDEX GmbH - initial API and implementation and/or initial documentation
 *******************************************************************************/
package org.eclipse.jubula.toolkit.base.widgets;

import org.eclipse.jubula.toolkit.internal.annotations.RealizedType;
import org.eclipse.jubula.toolkit.internal.annotations.TesterClass;

@RealizedType(realizedType="null")
@TesterClass(testerClass="")
public interface GraphicsComponent
	
	 {
	
	
	
		
		public void showText(
		
			java.lang.String text,
		
			java.lang.Integer textSizeInPoints,
		
			java.lang.Integer timePerWordInMilliseconds,
		
			java.lang.Integer windowWidthInPixels
		
		) ;
	
		
		public void checkExistence(
		
			java.lang.Boolean exists
		
		) ;
	
		
		public void checkEnablement(
		
			java.lang.Boolean enabled
		
		) ;
	
		
		public void checkProperty(
		
			java.lang.String propertyName,
		
			java.lang.String propertyValue,
		
			org.eclipse.jubula.toolkit.enums.ValueSets.Operator operator
		
		) ;
	
		
		public void storeProperty(
		
			org.eclipse.jubula.toolkit.datatype.Variable variableName,
		
			java.lang.String propertyName
		
		) ;
	
		
		public void checkFocus(
		
			java.lang.Boolean hasFocus
		
		) ;
	
		
		public void waitForComponent(
		
			java.lang.Integer timeoutInMs,
		
			java.lang.Integer delayAfterVisibility
		
		) ;
	
		
		public void click(
		
			java.lang.Integer numberOfClicks,
		
			java.lang.Integer mouseButton
		
		) ;
	
		
		public void clickInComponent(
		
			java.lang.Integer numberOfClicks,
		
			java.lang.Integer mouseButton,
		
			java.lang.Integer xPosition,
		
			org.eclipse.jubula.toolkit.enums.ValueSets.Unit xUnits,
		
			java.lang.Integer yPosition,
		
			org.eclipse.jubula.toolkit.enums.ValueSets.Unit yUnits
		
		) ;
	
		
		public void selectContextMenuEntryByTextpathSpecifyPosition(
		
			java.lang.Integer xPosition,
		
			org.eclipse.jubula.toolkit.enums.ValueSets.Unit xUnits,
		
			java.lang.Integer yPosition,
		
			org.eclipse.jubula.toolkit.enums.ValueSets.Unit yUnits,
		
			java.lang.String menupath,
		
			org.eclipse.jubula.toolkit.enums.ValueSets.Operator operator,
		
			java.lang.Integer mouseButton
		
		) ;
	
		
		public void selectContextMenuEntryByIndexpath(
		
			java.lang.String indexpath,
		
			java.lang.Integer mouseButton
		
		) ;
	
		
		public void selectContextMenuEntryByTextpath(
		
			java.lang.String textpath,
		
			org.eclipse.jubula.toolkit.enums.ValueSets.Operator operator,
		
			java.lang.Integer mouseButton
		
		) ;
	
		
		public void selectContextMenuEntryByIndexpathSpecifyPosition(
		
			java.lang.Integer xPosition,
		
			org.eclipse.jubula.toolkit.enums.ValueSets.Unit xUnits,
		
			java.lang.Integer yPosition,
		
			org.eclipse.jubula.toolkit.enums.ValueSets.Unit yUnits,
		
			java.lang.String indexpath,
		
			java.lang.Integer mouseButton
		
		) ;
	
		
		public void checkEnablementOfContextMenuEntryByIndexpath(
		
			java.lang.String indexpath,
		
			java.lang.Boolean enabled,
		
			java.lang.Integer mouseButton
		
		) ;
	
		
		public void checkEnablementOfContextMenuEntryByIndexpathSpecifyPosition(
		
			java.lang.Integer xPosition,
		
			org.eclipse.jubula.toolkit.enums.ValueSets.Unit xUnits,
		
			java.lang.Integer yPosition,
		
			org.eclipse.jubula.toolkit.enums.ValueSets.Unit yUnits,
		
			java.lang.String indexpath,
		
			java.lang.Boolean enabled,
		
			java.lang.Integer mouseButton
		
		) ;
	
		
		public void checkEnablementOfContextMenuEntryByTextpath(
		
			java.lang.String textpath,
		
			org.eclipse.jubula.toolkit.enums.ValueSets.Operator operator,
		
			java.lang.Boolean enabled,
		
			java.lang.Integer mouseButton
		
		) ;
	
		
		public void checkEnablementOfContextMenuEntryByTextpathSpecifyPosition(
		
			java.lang.Integer xPosition,
		
			org.eclipse.jubula.toolkit.enums.ValueSets.Unit xUnits,
		
			java.lang.Integer yPosition,
		
			org.eclipse.jubula.toolkit.enums.ValueSets.Unit yUnits,
		
			java.lang.String textpath,
		
			org.eclipse.jubula.toolkit.enums.ValueSets.Operator operator,
		
			java.lang.Boolean enabled,
		
			java.lang.Integer mouseButton
		
		) ;
	
		
		public void checkExistenceOfContextMenuEntryByIndexpath(
		
			java.lang.String indexpath,
		
			java.lang.Boolean exists,
		
			java.lang.Integer mouseButton
		
		) ;
	
		
		public void checkExistenceOfContextMenuEntryByIndexpathSpecifyPosition(
		
			java.lang.Integer xPosition,
		
			org.eclipse.jubula.toolkit.enums.ValueSets.Unit xUnits,
		
			java.lang.Integer yPosition,
		
			org.eclipse.jubula.toolkit.enums.ValueSets.Unit yUnits,
		
			java.lang.String indexpath,
		
			java.lang.Boolean exists,
		
			java.lang.Integer mouseButton
		
		) ;
	
		
		public void checkExistenceOfContextMenuEntryByTextpath(
		
			java.lang.String textpath,
		
			org.eclipse.jubula.toolkit.enums.ValueSets.Operator operator,
		
			java.lang.Boolean exists,
		
			java.lang.Integer mouseButton
		
		) ;
	
		
		public void checkExistenceOfContextMenuEntryByTextpathSpecifyPosition(
		
			java.lang.Integer xPosition,
		
			org.eclipse.jubula.toolkit.enums.ValueSets.Unit xUnits,
		
			java.lang.Integer yPosition,
		
			org.eclipse.jubula.toolkit.enums.ValueSets.Unit yUnits,
		
			java.lang.String textpath,
		
			org.eclipse.jubula.toolkit.enums.ValueSets.Operator operator,
		
			java.lang.Boolean exists,
		
			java.lang.Integer mouseButton
		
		) ;
	
		
		public void checkSelectionOfContextMenuEntryByIndexpath(
		
			java.lang.String indexpath,
		
			java.lang.Boolean selected,
		
			java.lang.Integer mouseButton
		
		) ;
	
		
		public void checkSelectionOfContextMenuEntryByIndexpathSpecifyPosition(
		
			java.lang.Integer xPosition,
		
			org.eclipse.jubula.toolkit.enums.ValueSets.Unit xUnits,
		
			java.lang.Integer yPosition,
		
			org.eclipse.jubula.toolkit.enums.ValueSets.Unit yUnits,
		
			java.lang.String indexpath,
		
			java.lang.Boolean selected,
		
			java.lang.Integer mouseButton
		
		) ;
	
		
		public void checkSelectionOfContextMenuEntryByTextpath(
		
			java.lang.String textpath,
		
			org.eclipse.jubula.toolkit.enums.ValueSets.Operator operator,
		
			java.lang.Boolean selected,
		
			java.lang.Integer mouseButton
		
		) ;
	
		
		public void checkSelectionOfContextMenuEntryByTextpathSpecifyPosition(
		
			java.lang.Integer xPosition,
		
			org.eclipse.jubula.toolkit.enums.ValueSets.Unit xUnits,
		
			java.lang.Integer yPosition,
		
			org.eclipse.jubula.toolkit.enums.ValueSets.Unit yUnits,
		
			java.lang.String textpath,
		
			org.eclipse.jubula.toolkit.enums.ValueSets.Operator operator,
		
			java.lang.Boolean selected,
		
			java.lang.Integer mouseButton
		
		) ;
	
		
		public void drag(
		
			java.lang.Integer mouseButton,
		
			org.eclipse.jubula.toolkit.enums.ValueSets.Modifier modifierKeys,
		
			java.lang.Integer xPosition,
		
			org.eclipse.jubula.toolkit.enums.ValueSets.Unit xUnits,
		
			java.lang.Integer yPosition,
		
			org.eclipse.jubula.toolkit.enums.ValueSets.Unit yUnits
		
		) ;
	
		
		public void drop(
		
			java.lang.Integer xPosition,
		
			org.eclipse.jubula.toolkit.enums.ValueSets.Unit xUnits,
		
			java.lang.Integer yPosition,
		
			org.eclipse.jubula.toolkit.enums.ValueSets.Unit yUnits,
		
			java.lang.Integer delayBeforeDropMilliseconds
		
		) ;
	 
}