/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.client.internal.impl;

import java.util.Map;
import org.eclipse.jubula.client.AUTAgent;
import org.eclipse.jubula.client.internal.AutAgentConnection;
import org.eclipse.jubula.client.internal.Synchronizer;
import org.eclipse.jubula.client.launch.AUTConfiguration;
import org.eclipse.jubula.communication.internal.Communicator;
import org.eclipse.jubula.communication.internal.message.Message;
import org.eclipse.jubula.communication.internal.message.StartAUTServerMessage;
import org.eclipse.jubula.communication.internal.message.StopAUTServerMessage;
import org.eclipse.jubula.tools.internal.registration.AutIdentifier;

public class AUTAgentImpl
implements AUTAgent {
    private String m_hostname;
    private int m_port;
    private AutAgentConnection m_agent;

    public AUTAgentImpl(String hostname, int port) {
        this.m_hostname = hostname;
        this.m_port = port;
    }

    @Override
    public void connect() throws Exception {
        AutAgentConnection.createInstance(this.m_hostname, String.valueOf(this.m_port));
        this.m_agent = AutAgentConnection.getInstance();
        this.m_agent.run();
    }

    @Override
    public void disconnect() {
        if (this.m_agent != null) {
            this.m_agent.close();
        }
    }

    @Override
    public boolean isConnected() {
        return this.m_agent != null ? this.m_agent.isConnected() : false;
    }

    @Override
    public AutIdentifier startAUT(AUTConfiguration configuration) throws Exception {
        Map<String, String> autConfigMap = configuration.getLaunchInformation();
        Communicator communicator = this.m_agent.getCommunicator();
        autConfigMap.put("com.bredexsw.guidancer.aut.register.autAgentPort", String.valueOf(communicator.getPort()));
        autConfigMap.put("com.bredexsw.guidancer.aut.register.autAgentHost", communicator.getHostName());
        autConfigMap.put("com.bredexsw.guidancer.aut.register.autName", autConfigMap.get("AUT_ID"));
        String toolkitID = autConfigMap.get("toolkitID");
        StartAUTServerMessage startAUTMessage = new StartAUTServerMessage(autConfigMap, toolkitID);
        this.m_agent.send((Message)startAUTMessage);
        int startResponse = Synchronizer.instance().exchange(null);
        return this.handleResponse(startResponse);
    }

    private AutIdentifier handleResponse(int startResponse) throws Exception {
        if (startResponse != 0) {
            return null;
        }
        return Synchronizer.instance().exchange(null);
    }

    @Override
    public void stopAUT(AutIdentifier aut) throws Exception {
        this.m_agent.send((Message)new StopAUTServerMessage(aut));
    }
}

