/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.client.core.commands;

import org.eclipse.jubula.client.core.agent.AutRegistrationEvent;
import org.eclipse.jubula.client.core.agent.IAutRegistrationListener;
import org.eclipse.jubula.client.core.i18n.Messages;
import org.eclipse.jubula.communication.internal.ICommand;
import org.eclipse.jubula.communication.internal.message.Message;
import org.eclipse.jubula.communication.internal.message.RegisteredAutListMessage;
import org.eclipse.jubula.tools.internal.registration.AutIdentifier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RegisteredAutListCommand
implements ICommand {
    private static final Logger LOG = LoggerFactory.getLogger(RegisteredAutListCommand.class);
    private IAutRegistrationListener m_listener;
    private RegisteredAutListMessage m_message;

    public RegisteredAutListCommand(IAutRegistrationListener l) {
        this.m_listener = l;
    }

    public Message execute() {
        AutIdentifier[] autIdentifierArray = this.m_message.getAutIds();
        int n = autIdentifierArray.length;
        int n2 = 0;
        while (n2 < n) {
            AutIdentifier id = autIdentifierArray[n2];
            this.m_listener.handleAutRegistration(new AutRegistrationEvent(id, AutRegistrationEvent.RegistrationStatus.Register));
            ++n2;
        }
        return null;
    }

    public RegisteredAutListMessage getMessage() {
        return this.m_message;
    }

    public void setMessage(Message message) {
        this.m_message = (RegisteredAutListMessage)message;
    }

    public void timeout() {
        LOG.error(String.valueOf(this.getClass().getName()) + "." + Messages.TimeoutCalled);
    }
}

