/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.client.core.model;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Locale;
import javax.persistence.CascadeType;
import javax.persistence.DiscriminatorValue;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.Transient;
import org.apache.commons.lang.StringUtils;
import org.eclipse.jubula.client.core.businessprocess.TestDataBP;
import org.eclipse.jubula.client.core.model.IDataSetPO;
import org.eclipse.jubula.client.core.model.INodePO;
import org.eclipse.jubula.client.core.model.IParamDescriptionPO;
import org.eclipse.jubula.client.core.model.IParamNodePO;
import org.eclipse.jubula.client.core.model.IParameterInterfacePO;
import org.eclipse.jubula.client.core.model.ITDManager;
import org.eclipse.jubula.client.core.model.ITestDataPO;
import org.eclipse.jubula.client.core.model.NodePO;
import org.eclipse.jubula.client.core.model.TDCell;
import org.eclipse.jubula.client.core.model.TestDataCubePO;
import org.eclipse.jubula.client.core.utils.ModelParamValueConverter;
import org.eclipse.persistence.internal.descriptors.PersistenceObject;
import org.eclipse.persistence.internal.weaving.PersistenceWeaved;

@Entity
@DiscriminatorValue(value="A")
abstract class ParamNodePO
extends NodePO
implements IParamNodePO,
PersistenceWeaved,
PersistenceObject {
    private TestDataCubePO m_parameterInterface;
    static final long serialVersionUID = 4332688069435438538L;

    public ParamNodePO(String name, boolean isGenerated) {
        super(name, isGenerated);
        this.setParameterInterface(new TestDataCubePO(null));
    }

    public ParamNodePO(String name, String guid, boolean isGenerated) {
        super(name, guid, isGenerated);
        this.setParameterInterface(new TestDataCubePO(null));
    }

    ParamNodePO() {
    }

    @ManyToOne(cascade={CascadeType.ALL}, targetEntity=TestDataCubePO.class, fetch=FetchType.EAGER)
    @JoinColumn(name="FK_PARAM_INTERFACE", unique=true)
    private TestDataCubePO getParameterInterface() {
        return this.m_parameterInterface;
    }

    private void setParameterInterface(TestDataCubePO parameterInterface) {
        this.m_parameterInterface = parameterInterface;
    }

    @Override
    @Transient
    public String getDataFile() {
        return this.getParameterInterface().getDataFile();
    }

    @Override
    @Transient
    public ITDManager getDataManager() {
        return this.getParameterInterface().getDataManager();
    }

    @Transient
    protected ITDManager getHbmDataManager() {
        return this.getParameterInterface().getHbmDataManager();
    }

    protected final void clearParameterList() {
        this.getParameterInterface().clearParameterList();
    }

    protected void addParameter(IParamDescriptionPO p) {
        this.getParameterInterface().addParameter(p);
    }

    @Transient
    protected List<IParamDescriptionPO> getHbmParameterList() {
        return this.getParameterInterface().getHbmParameterList();
    }

    protected void removeParameter(IParamDescriptionPO p) {
        this.getParameterInterface().removeParameter(p);
    }

    @Override
    public IParamDescriptionPO getParameterForName(String paramName) {
        return this.getParameterInterface().getParameterForName(paramName);
    }

    @Override
    public IParamDescriptionPO getParameterForUniqueId(String uniqueId) {
        return this.getParameterInterface().getParameterForUniqueId(uniqueId);
    }

    @Override
    @Transient
    public List<IParamDescriptionPO> getParameterList() {
        return this.getParameterInterface().getParameterList();
    }

    @Override
    @Transient
    public ListIterator<IParamDescriptionPO> getParameterListIter() {
        return this.getParameterInterface().getParameterListIter();
    }

    @Override
    @Transient
    public int getParameterListSize() {
        return this.getParameterInterface().getParameterListSize();
    }

    @Override
    @Transient
    public List<String> getParamNames() {
        return this.getParameterInterface().getParamNames();
    }

    @Override
    @Transient
    public IParameterInterfacePO getReferencedDataCube() {
        return this.getParameterInterface().getReferencedDataCube();
    }

    @Override
    public void setDataFile(String pathToExternalDataFile) {
        this.getParameterInterface().setDataFile(pathToExternalDataFile);
    }

    @Override
    public void setDataManager(ITDManager dataManager) {
        this.getParameterInterface().setDataManager(dataManager);
    }

    @Override
    public void setReferencedDataCube(IParameterInterfacePO dataCube) {
        this.getParameterInterface().setReferencedDataCube(dataCube);
    }

    @Override
    public boolean isTestDataComplete(Locale locale) {
        if (StringUtils.isEmpty((String)this.getDataFile())) {
            int paramListSize = this.getParameterListSize();
            ITDManager testDataManager = this.getDataManager();
            if (testDataManager.getDataSetCount() == 0 && paramListSize > 0) {
                return false;
            }
            if (this.getParameterListSize() > testDataManager.getColumnCount()) {
                return false;
            }
            ArrayList<IParamDescriptionPO> requiredParameters = new ArrayList<IParamDescriptionPO>(this.getParameterList());
            IParameterInterfacePO refDataCube = this.getReferencedDataCube();
            int i = 0;
            while (i < testDataManager.getDataSetCount()) {
                for (IParamDescriptionPO paramDesc : requiredParameters) {
                    IParamDescriptionPO dataCubeParam;
                    int column = testDataManager.findColumnForParam(paramDesc.getUniqueId());
                    if (refDataCube != null && (dataCubeParam = refDataCube.getParameterForName(paramDesc.getName())) != null) {
                        column = testDataManager.findColumnForParam(dataCubeParam.getUniqueId());
                    }
                    if (column == -1) {
                        return false;
                    }
                    ITestDataPO testData = TestDataBP.instance().getTestData(this, testDataManager, paramDesc, i);
                    if (testData != null && testData.getValue(locale) != null) continue;
                    return false;
                }
                ++i;
            }
        }
        return true;
    }

    @Override
    public Iterator<TDCell> getParamReferencesIterator(Locale locale) {
        ArrayList<TDCell> references = new ArrayList<TDCell>();
        int row = 0;
        for (IDataSetPO dataSet : this.getDataManager().getDataSets()) {
            this.addParamReferences(references, dataSet, row, locale);
            ++row;
        }
        return references.iterator();
    }

    @Override
    public Iterator<TDCell> getParamReferencesIterator(int dataSetRow, Locale locale) {
        IDataSetPO row = this.getDataManager().getDataSet(dataSetRow);
        ArrayList<TDCell> references = new ArrayList<TDCell>();
        this.addParamReferences(references, row, dataSetRow, locale);
        return references.iterator();
    }

    private void addParamReferences(List<TDCell> references, IDataSetPO row, int dataSetRow, Locale locale) {
        int col = 0;
        for (ITestDataPO testData : row.getList()) {
            String uniqueId;
            IParamDescriptionPO desc;
            ModelParamValueConverter conv = new ModelParamValueConverter(testData, (IParameterInterfacePO)this, locale, desc = this.getParameterForUniqueId(uniqueId = this.getDataManager().getUniqueIds().get(col)));
            if (conv.containsReferences()) {
                references.add(new TDCell(testData, dataSetRow, col));
            }
            ++col;
        }
    }

    @Override
    public void setParentProjectId(Long projectId) {
        super.setParentProjectId(projectId);
        if (this.getParameterInterface() != null) {
            this.getParameterInterface().setParentProjectId(projectId);
        }
    }

    @Override
    @Transient
    public INodePO getSpecificationUser() {
        return this.getParentNode();
    }

    @Override
    public void clearTestData() {
        if (!this.hasReferencedTestData()) {
            this.getDataManager().clear();
        }
    }

    public boolean hasReferencedTestData() {
        return this.getReferencedDataCube() != null;
    }

    @Override
    public Object _persistence_post_clone() {
        Object object = super._persistence_post_clone();
        this._persistence_primaryKey = null;
        return this;
    }

    @Override
    public Object _persistence_new(PersistenceObject persistenceObject) {
        return new ParamNodePO();
    }

    @Override
    public Object _persistence_get(String string) {
        if (string == "parameterInterface") {
            return this.parameterInterface;
        }
        return super._persistence_get(string);
    }

    @Override
    public void _persistence_set(String string, Object object) {
        if (string == "parameterInterface") {
            this.parameterInterface = (TestDataCubePO)object;
            return;
        }
        super._persistence_set(string, object);
    }
}

