/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.client.ui.rcp.dialogs;

import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.jubula.client.core.model.ProjectVersion;
import org.eclipse.jubula.client.ui.constants.IconConstants;
import org.eclipse.jubula.client.ui.rcp.dialogs.VersionComposite;
import org.eclipse.jubula.client.ui.utils.LayoutUtil;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;

public class VersionDialog
extends TitleAreaDialog {
    private static final int NUM_COLUMNS_1 = 1;
    private static final int VERTICAL_SPACING = 2;
    private static final int MARGIN_WIDTH = 10;
    private static final int MARGIN_HEIGHT = 10;
    private String m_projectName;
    private Integer m_majorVersionNumber = null;
    private Integer m_minorVersionNumber = null;
    private Integer m_microVersionNumber = null;
    private String m_versionQualifier = null;
    private VersionComposite m_versionComposite;
    private String m_message = "";
    private String m_image = "";
    private String m_shell = "";
    private String m_title = "";
    private Integer m_greatestMajor = null;
    private Integer m_greatestMinor = null;
    private Integer m_greatestMicro = null;
    private boolean m_withProjectNameLabel = false;
    private ProjectVersion m_projectVersion = null;
    private String m_greatestQualifier = null;

    public VersionDialog(Shell parentShell, String title, ProjectVersion version, String message, String wrongNameError, String doubleNameError, String image, String shell) {
        super(parentShell);
        this.setNewVersion(version);
        this.m_message = message;
        this.m_image = image;
        this.m_shell = shell;
        this.m_title = title;
    }

    public VersionDialog(Shell parentShell, String title, String message, String wrongNameError, String doubleNameError, String image, String shell, boolean withProjectNameLabel) {
        super(parentShell);
        this.m_withProjectNameLabel = withProjectNameLabel;
        this.m_greatestMajor = 1;
        this.m_greatestMinor = 0;
        this.m_projectVersion = new ProjectVersion(Integer.valueOf(1), Integer.valueOf(0), null);
        this.m_message = message;
        this.m_image = image;
        this.m_shell = shell;
        this.m_title = title;
    }

    private void setNewVersion(ProjectVersion greatestVersion) {
        this.m_greatestMajor = greatestVersion.getMajorNumber();
        this.m_greatestMinor = greatestVersion.getMinorNumber();
        this.m_greatestMicro = greatestVersion.getMicroNumber();
        this.m_greatestQualifier = greatestVersion.getVersionQualifier();
        if (this.m_greatestMajor != null && this.m_greatestMinor == null) {
            this.m_greatestMajor = this.m_greatestMajor + 1;
        }
        if (this.m_greatestMinor != null && this.m_greatestMicro == null) {
            this.m_greatestMinor = this.m_greatestMinor + 1;
        }
        if (this.m_greatestMicro != null) {
            this.m_greatestMicro = this.m_greatestMicro + 1;
        }
        this.m_projectVersion = new ProjectVersion(this.m_greatestMajor, this.m_greatestMinor, this.m_greatestMicro, this.m_greatestQualifier);
    }

    protected Control createDialogArea(Composite parent) {
        this.setMessage(this.m_message);
        this.setTitle(this.m_title);
        this.setTitleImage(IconConstants.getImage((String)this.m_image));
        this.getShell().setText(this.m_shell);
        GridLayout gridLayoutParent = new GridLayout();
        gridLayoutParent.numColumns = 1;
        gridLayoutParent.verticalSpacing = 2;
        gridLayoutParent.marginWidth = 10;
        gridLayoutParent.marginHeight = 10;
        parent.setLayout((Layout)gridLayoutParent);
        LayoutUtil.createSeparator((Composite)parent);
        Composite area = new Composite(parent, 0);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 1;
        area.setLayout((Layout)gridLayout);
        GridData gridData = new GridData();
        gridData.grabExcessHorizontalSpace = true;
        gridData.grabExcessVerticalSpace = true;
        gridData.verticalAlignment = 1;
        area.setLayoutData((Object)gridData);
        this.createVersionFields(area);
        this.createAdditionalComponents(area);
        LayoutUtil.createSeparator((Composite)parent);
        return area;
    }

    public void setStyle(int style) {
        this.setShellStyle(style);
    }

    protected void initializeBounds() {
        super.initializeBounds();
        this.setMessage(this.m_message);
    }

    private void createVersionFields(Composite area) {
        this.m_versionComposite = new VersionComposite(area, 0, this.m_projectVersion, this.m_withProjectNameLabel){

            @Override
            public Boolean isChangeAllowed() {
                return VersionDialog.this.isInputAllowed();
            }

            @Override
            public void setMessage(String string) {
                VersionDialog.this.setErrorMessage(string);
            }

            @Override
            public void modifiedAction() {
                if (VersionDialog.this.getButton(0) != null && this.isOKAllowed()) {
                    VersionDialog.this.getButton(0).setEnabled(true);
                    VersionDialog.this.setErrorMessage(null);
                } else if (VersionDialog.this.getButton(0) != null && !this.isOKAllowed()) {
                    VersionDialog.this.getButton(0).setEnabled(false);
                }
            }
        };
    }

    protected boolean isInputAllowed() {
        return true;
    }

    protected void okPressed() {
        if (!this.m_versionComposite.modifyVersionFieldAction()) {
            return;
        }
        ProjectVersion version = this.m_versionComposite.getVersion();
        this.m_majorVersionNumber = version.getMajorNumber();
        this.m_minorVersionNumber = version.getMinorNumber();
        this.m_microVersionNumber = version.getMicroNumber();
        this.m_versionQualifier = version.getVersionQualifier();
        this.m_projectName = this.m_versionComposite.getProjectNameFieldValue();
        this.setReturnCode(0);
        this.close();
    }

    public ProjectVersion getProjectVersion() {
        return new ProjectVersion(this.m_majorVersionNumber, this.m_minorVersionNumber, this.m_microVersionNumber, this.m_versionQualifier);
    }

    protected void createAdditionalComponents(Composite parent) {
        parent.setEnabled(true);
    }

    public ProjectVersion getFieldVersion() {
        return this.m_versionComposite.getVersion();
    }

    public String getProjectNameFieldValue() {
        return this.m_versionComposite.getProjectNameFieldValue();
    }

    public String getProjectName() {
        return this.m_projectName;
    }
}

