/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.rc.javafx.tester;

import java.awt.Point;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.Callable;
import javafx.collections.ObservableList;
import javafx.geometry.Bounds;
import javafx.geometry.Point2D;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.control.CheckBox;
import javafx.scene.control.TableCell;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableColumnBase;
import javafx.scene.control.TablePosition;
import javafx.scene.control.TableView;
import javafx.scene.control.cell.CheckBoxTableCell;
import org.eclipse.jubula.rc.common.driver.ClickOptions;
import org.eclipse.jubula.rc.common.exception.StepExecutionException;
import org.eclipse.jubula.rc.common.implclasses.table.Cell;
import org.eclipse.jubula.rc.common.logger.AutServerLogger;
import org.eclipse.jubula.rc.common.tester.AbstractTableTester;
import org.eclipse.jubula.rc.common.tester.adapter.interfaces.ITableComponent;
import org.eclipse.jubula.rc.common.util.MatchUtil;
import org.eclipse.jubula.rc.common.util.Verifier;
import org.eclipse.jubula.rc.javafx.driver.EventThreadQueuerJavaFXImpl;
import org.eclipse.jubula.rc.javafx.listener.ComponentHandler;
import org.eclipse.jubula.rc.javafx.util.AbstractTraverser;
import org.eclipse.jubula.rc.javafx.util.GenericTraverseHelper;
import org.eclipse.jubula.rc.javafx.util.NodeBounds;
import org.eclipse.jubula.rc.javafx.util.Rounding;
import org.eclipse.jubula.toolkit.enums.ValueSets;
import org.eclipse.jubula.tools.internal.objects.event.EventFactory;

public class TableTester
extends AbstractTableTester {
    private static AutServerLogger log = new AutServerLogger(TableTester.class);

    protected Object setEditorToReplaceMode(Object editor, boolean replace) {
        Object returnvalue = editor;
        if (replace) {
            this.getRobot().clickAtCurrentPosition(editor, 3, 1);
        } else {
            returnvalue = this.getComponent().getRealComponent();
        }
        return returnvalue;
    }

    protected Object activateEditor(Cell cell, Rectangle rectangle) {
        Object table = this.getComponent().getRealComponent();
        this.getRobot().click(table, (Object)rectangle);
        TableCell<?, ?> realCell = this.getCellAt(cell.getRow(), cell.getCol());
        if (realCell.isEditing()) {
            ClickOptions co = ClickOptions.create().setClickCount(2);
            this.getRobot().click(table, (Object)rectangle, co);
        }
        return realCell;
    }

    private TableCell<?, ?> getCellAt(final int row, final int column) {
        TableCell result = (TableCell)EventThreadQueuerJavaFXImpl.invokeAndWait("getCellText", new Callable<TableCell<?, ?>>(){

            @Override
            public TableCell<?, ?> call() throws Exception {
                TableView table = (TableView)TableTester.this.getRealComponent();
                table.scrollTo(row);
                table.scrollToColumnIndex(column);
                table.layout();
                TableColumn col = table.getVisibleLeafColumn(column);
                List<TableCell> tCells = ComponentHandler.getAssignableFrom(TableCell.class);
                for (TableCell cell : tCells) {
                    if (cell.getIndex() != row || cell.getTableColumn() != col) continue;
                    return cell;
                }
                return null;
            }
        });
        return result;
    }

    protected int getExtendSelectionModifier() {
        return 17;
    }

    protected Cell getCellAtMousePosition() throws StepExecutionException {
        final Point p = this.getRobot().getCurrentMousePosition();
        Cell result = EventThreadQueuerJavaFXImpl.invokeAndWait("getCellAtMousePosition", new Callable<Cell>(){

            @Override
            public Cell call() throws Exception {
                TableView table = (TableView)TableTester.this.getRealComponent();
                table.layout();
                List<TableCell> tCells = ComponentHandler.getAssignableFrom(TableCell.class);
                for (TableCell cell : tCells) {
                    Rectangle rec = TableTester.this.getCellRect(cell);
                    Point2D tablePos = table.localToScreen(0.0, 0.0);
                    rec.x += Rounding.round(tablePos.getX());
                    rec.y += Rounding.round(tablePos.getY());
                    if (!rec.contains(p) || !cell.getTableView().equals(table)) continue;
                    TableColumn cellColumn = cell.getTableColumn();
                    int col = table.getVisibleLeafIndex(cellColumn);
                    return new Cell(cell.getIndex(), col);
                }
                return null;
            }
        });
        return result;
    }

    private String getColumnPath(TableColumnBase column, TableView table) {
        String colPath = "";
        TableColumnBase nxtColumn = column;
        while (nxtColumn.getParentColumn() != null) {
            colPath = String.valueOf('/').concat(String.valueOf(String.valueOf(nxtColumn.getParentColumn().getColumns().indexOf((Object)nxtColumn) + 1) + colPath));
            nxtColumn = nxtColumn.getParentColumn();
        }
        colPath = String.valueOf(table.getColumns().indexOf((Object)nxtColumn) + 1) + colPath;
        return colPath;
    }

    private Rectangle getCellRect(final TableCell<?, ?> cell) {
        Rectangle result = EventThreadQueuerJavaFXImpl.invokeAndWait("getCellRect", new Callable<Rectangle>(){

            @Override
            public Rectangle call() throws Exception {
                TableView table = (TableView)TableTester.this.getRealComponent();
                table.layout();
                Bounds b = cell.getBoundsInParent();
                Point2D pos = cell.localToScreen(0.0, 0.0);
                Point2D parentPos = table.localToScreen(0.0, 0.0);
                return new Rectangle(Rounding.round(pos.getX() - parentPos.getX()), Rounding.round(pos.getY() - parentPos.getY()), Rounding.round(b.getWidth()), Rounding.round(b.getHeight()));
            }
        });
        return result;
    }

    protected boolean isMouseOnHeader() {
        Point p = this.getRobot().getCurrentMousePosition();
        final Point2D pos = new Point2D((double)p.x, (double)p.y);
        boolean result = EventThreadQueuerJavaFXImpl.invokeAndWait("getTableHeader", new Callable<Boolean>(){

            @Override
            public Boolean call() throws Exception {
                TableView table = (TableView)TableTester.this.getRealComponent();
                table.layout();
                Parent header = (Parent)table.lookup("TableHeaderRow");
                return NodeBounds.checkIfContains(pos, (Node)header);
            }
        });
        return result;
    }

    public void rcToggleCheckboxInSelectedRow() {
        int row = EventThreadQueuerJavaFXImpl.invokeAndWait("rcToggleCheckboxInSelectedRow", new Callable<Integer>(){

            @Override
            public Integer call() throws StepExecutionException {
                TableView table = (TableView)TableTester.this.getRealComponent();
                return new Integer(table.getSelectionModel().getSelectedIndex());
            }
        });
        this.clickCheckBoxFirstColumn(row);
    }

    public void rcToggleCheckboxInRowAtMousePosition() {
        this.clickCheckBoxFirstColumn(this.getCellAtMousePosition().getRow());
    }

    public void rcVerifyCheckboxInSelectedRow(boolean checked) throws StepExecutionException {
        int row = ((ITableComponent)this.getComponent()).getSelectedCell().getRow();
        this.verifyCheckboxInRow(checked, row);
    }

    public void rcVerifyCheckboxInRowAtMousePosition(boolean checked) {
        Cell cell = this.getCellAtMousePosition();
        if (cell != null) {
            int row = cell.getRow();
            this.verifyCheckboxInRow(checked, row);
        } else {
            log.error((Object)("No Ceckbox found at Mouseposition: " + this.getRobot().getCurrentMousePosition()));
        }
    }

    private void clickCheckBoxFirstColumn(int row) {
        Node box = this.getCheckBoxFirstColumn(row);
        if (box != null) {
            this.getRobot().click((Object)box, null, ClickOptions.create().setClickCount(1).setMouseButton(1));
        }
    }

    private void verifyCheckboxInRow(boolean checked, int row) {
        final CheckBox box = (CheckBox)this.getCheckBoxFirstColumn(row);
        Boolean checkIndex = EventThreadQueuerJavaFXImpl.invokeAndWait("verifyCheckboxInRow", new Callable<Boolean>(){

            @Override
            public Boolean call() throws StepExecutionException {
                return box.isSelected();
            }
        });
        Verifier.equals((boolean)checked, (boolean)checkIndex);
    }

    private Node getCheckBoxFirstColumn(final int row) {
        return EventThreadQueuerJavaFXImpl.invokeAndWait("clickCheckBoxFirstColumn", new Callable<Node>(){

            @Override
            public Node call() throws Exception {
                TableView table = (TableView)TableTester.this.getRealComponent();
                table.layout();
                TableColumn col = table.getVisibleLeafColumn(0);
                List<CheckBoxTableCell> checkboxCells = ComponentHandler.getAssignableFrom(CheckBoxTableCell.class);
                for (CheckBoxTableCell cell : checkboxCells) {
                    if (!cell.getTableColumn().equals(col) || cell.getIndex() != row) continue;
                    return cell.lookup("CheckBox");
                }
                List<TableCell> cells = ComponentHandler.getAssignableFrom(TableCell.class);
                for (TableCell cell : cells) {
                    if (!cell.getTableColumn().equals(col) || cell.getIndex() != row) continue;
                    return cell.lookup("CheckBox");
                }
                return null;
            }
        });
    }

    public void rcVerifyValueInRow(String row, String rowOperator, final String value, final String operator, final String searchType, boolean exists) throws StepExecutionException {
        final ITableComponent adapter = (ITableComponent)this.getComponent();
        final int implRow = adapter.getRowFromString(row, rowOperator);
        boolean result = EventThreadQueuerJavaFXImpl.invokeAndWait("rcVerifyValueInRow", new Callable<Boolean>(){

            @Override
            public Boolean call() throws Exception {
                boolean valueIsExisting = false;
                valueIsExisting = implRow == -1 ? TableTester.this.getColumnByName(value, operator, searchType, adapter, implRow) != null : TableTester.this.getColumnByValue(value, operator, searchType, adapter, implRow) != null;
                return valueIsExisting;
            }
        });
        Verifier.equals((boolean)exists, (boolean)result);
    }

    private String getColumnByName(final String name, final String operator, final String searchType, final ITableComponent adapter, int implRow) {
        return EventThreadQueuerJavaFXImpl.invokeAndWait("getColumnByName", new Callable<String>(){

            @Override
            public String call() throws Exception {
                int columnCount = adapter.getColumnCount();
                if (columnCount > 0) {
                    List columns = TableTester.this.getColumnsFromTable(searchType, adapter);
                    for (TableColumn column : columns) {
                        if (!MatchUtil.getInstance().match(column.getText(), name, operator)) continue;
                        return TableTester.this.getColumnPath((TableColumnBase)column, (TableView)TableTester.this.getRealComponent());
                    }
                }
                return null;
            }
        });
    }

    private List<TableColumn> getColumnsFromTable(String searchType, ITableComponent adapter) {
        ArrayList<TableColumn> columns = new ArrayList<TableColumn>();
        if (searchType.equalsIgnoreCase(ValueSets.SearchType.relative.rcValue())) {
            TableView table = (TableView)adapter.getRealComponent();
            TableColumn selColumn = ((TablePosition)table.getSelectionModel().getSelectedCells().get(0)).getTableColumn();
            TableColumnBase parCol = selColumn.getParentColumn();
            while (parCol != null) {
                selColumn = (TableColumn)parCol;
                parCol = parCol.getParentColumn();
            }
            columns.addAll(new GenericTraverseHelper<TableColumn, TableColumn>().getInstancesOf(new AbstractTraverser<TableColumn, TableColumn>(selColumn){

                @Override
                public Iterable<TableColumn> getTraversableData() {
                    return ((TableColumn)this.getObject()).getColumns();
                }
            }, TableColumn.class));
        } else {
            for (TableColumn column : ((TableView)this.getRealComponent()).getColumns()) {
                columns.addAll(new GenericTraverseHelper<TableColumn, TableColumn>().getInstancesOf(new AbstractTraverser<TableColumn, TableColumn>(column){

                    @Override
                    public Iterable<TableColumn> getTraversableData() {
                        return ((TableColumn)this.getObject()).getColumns();
                    }
                }, TableColumn.class));
            }
            columns.addAll((Collection<TableColumn>)((TableView)adapter.getRealComponent()).getColumns());
        }
        return columns;
    }

    private String getColumnByValue(final String value, final String operator, final String searchType, final ITableComponent adapter, final int implRow) {
        return EventThreadQueuerJavaFXImpl.invokeAndWait("getColumnByValue", new Callable<String>(){

            @Override
            public String call() {
                int columnCount = adapter.getColumnCount();
                if (columnCount > 0) {
                    int startIndex = TableTester.this.getStartingColIndex(searchType) - 1;
                    ObservableList columns = ((TableView)TableTester.this.getRealComponent()).getVisibleLeafColumns();
                    int i = startIndex;
                    while (i < columns.size()) {
                        TableColumn column = (TableColumn)columns.get(i);
                        int index = adapter.getColumnFromString(TableTester.this.getColumnPath((TableColumnBase)column, (TableView)TableTester.this.getRealComponent()), "equals");
                        String cellValue = adapter.getCellText(implRow, index);
                        if (MatchUtil.getInstance().match(cellValue, value, operator)) {
                            return TableTester.this.getColumnPath((TableColumnBase)column, (TableView)TableTester.this.getRealComponent());
                        }
                        ++i;
                    }
                }
                return null;
            }
        });
    }

    public void rcSelectCellByColValue(String row, String rowOperator, final String value, final String operator, int clickCount, String extendSelection, final String searchType, int button) {
        final ITableComponent adapter = (ITableComponent)this.getComponent();
        final int implRow = adapter.getRowFromString(row, rowOperator);
        String result = EventThreadQueuerJavaFXImpl.invokeAndWait("rcSelectCellByColValue", new Callable<String>(){

            @Override
            public String call() throws Exception {
                if (implRow == -1) {
                    return TableTester.this.getColumnByName(value, operator, searchType, adapter, implRow);
                }
                return TableTester.this.getColumnByValue(value, operator, searchType, adapter, implRow);
            }
        });
        if (result == null) {
            throw new StepExecutionException("no such cell found", EventFactory.createActionError((String)"TestErrorEvent.NotFound"));
        }
        this.rcSelectCell(row, rowOperator, result, operator, clickCount, 50, ValueSets.Unit.percent.rcValue(), 50, ValueSets.Unit.percent.rcValue(), extendSelection, button);
    }

    private int getStartingColIndex(String searchType) {
        int startingIndex = 0;
        if (searchType.equalsIgnoreCase(ValueSets.SearchType.relative.rcValue())) {
            Cell c = ((ITableComponent)this.getComponent()).getSelectedCell();
            if (c == null) {
                throw new StepExecutionException("No selection found", EventFactory.createActionError((String)"TestErrorEvent.NoSelection"));
            }
            startingIndex = c.getCol();
        }
        return startingIndex + 1;
    }
}

