/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.rc.javafx.tester.adapter;

import com.sun.javafx.scene.control.skin.TableColumnHeader;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.concurrent.Callable;
import javafx.collections.ObservableList;
import javafx.geometry.Bounds;
import javafx.geometry.Point2D;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.control.TableCell;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TablePosition;
import javafx.scene.control.TableView;
import javafx.scene.control.TextField;
import javafx.scene.control.cell.TextFieldTableCell;
import javafx.scene.layout.Pane;
import org.eclipse.jubula.rc.common.exception.StepExecutionException;
import org.eclipse.jubula.rc.common.implclasses.table.Cell;
import org.eclipse.jubula.rc.common.tester.adapter.interfaces.ITableComponent;
import org.eclipse.jubula.rc.common.util.IndexConverter;
import org.eclipse.jubula.rc.common.util.MatchUtil;
import org.eclipse.jubula.rc.javafx.driver.EventThreadQueuerJavaFXImpl;
import org.eclipse.jubula.rc.javafx.listener.ComponentHandler;
import org.eclipse.jubula.rc.javafx.tester.adapter.JavaFXComponentAdapter;
import org.eclipse.jubula.rc.javafx.util.AbstractTraverser;
import org.eclipse.jubula.rc.javafx.util.GenericTraverseHelper;
import org.eclipse.jubula.rc.javafx.util.Rounding;
import org.eclipse.jubula.tools.internal.objects.event.EventFactory;
import org.eclipse.jubula.tools.internal.utils.StringParsing;

public class TableAdapter
extends JavaFXComponentAdapter<TableView<?>>
implements ITableComponent {
    private List<TableColumn> m_columns = new ArrayList<TableColumn>();

    public TableAdapter(TableView objectToAdapt) {
        super(objectToAdapt);
    }

    public String getText() {
        String result = EventThreadQueuerJavaFXImpl.invokeAndWait("getText", new Callable<String>(){

            @Override
            public String call() throws Exception {
                ObservableList sCells = ((TableView)TableAdapter.this.getRealComponent()).getSelectionModel().getSelectedCells();
                if (!sCells.isEmpty()) {
                    TablePosition pos = (TablePosition)sCells.get(0);
                    return TableAdapter.this.getCellText(pos.getRow(), pos.getColumn());
                }
                throw new StepExecutionException("No selection found", EventFactory.createActionError((String)"TestErrorEvent.NoSelection"));
            }
        });
        return result;
    }

    public int getColumnCount() {
        int result = EventThreadQueuerJavaFXImpl.invokeAndWait("getColumnCount", new Callable<Integer>(){

            @Override
            public Integer call() throws Exception {
                int counter = 0;
                for (TableColumn column : ((TableView)TableAdapter.this.getRealComponent()).getColumns()) {
                    counter += new GenericTraverseHelper<TableColumn, TableColumn>().getInstancesOf(new AbstractTraverser<TableColumn, TableColumn>(column){

                        @Override
                        public Iterable<TableColumn> getTraversableData() {
                            return ((TableColumn)this.getObject()).getColumns();
                        }
                    }, TableColumn.class).size();
                }
                return counter + ((TableView)TableAdapter.this.getRealComponent()).getColumns().size();
            }
        });
        return result;
    }

    public int getRowCount() {
        int result = EventThreadQueuerJavaFXImpl.invokeAndWait("getRowCount", new Callable<Integer>(){

            @Override
            public Integer call() throws Exception {
                return ((TableView)TableAdapter.this.getRealComponent()).getItems().size();
            }
        });
        return result;
    }

    public String getCellText(final int row, final int column) {
        String result = EventThreadQueuerJavaFXImpl.invokeAndWait("getCellText", new Callable<String>(){

            @Override
            public String call() throws Exception {
                TableView table = (TableView)TableAdapter.this.getRealComponent();
                TableColumn col = null;
                col = TableAdapter.this.m_columns.size() == 0 ? table.getVisibleLeafColumn(column) : (TableColumn)TableAdapter.this.m_columns.get(column);
                table.scrollTo(row);
                table.scrollToColumn(col);
                table.layout();
                List<TableCell> tCells = ComponentHandler.getAssignableFrom(TableCell.class);
                for (TableCell cell : tCells) {
                    if (cell.getIndex() != row || cell.getTableColumn() != col || cell.getTableView() != table) continue;
                    String txt = cell.getText();
                    if (txt == null && cell instanceof TextFieldTableCell && cell.isEditing()) {
                        TextField f = (TextField)cell.getGraphic();
                        txt = f.getText();
                    }
                    return txt;
                }
                return null;
            }
        });
        return result;
    }

    public String getColumnHeaderText(final int column) {
        String result = EventThreadQueuerJavaFXImpl.invokeAndWait("getColumnHeaderText", new Callable<String>(){

            @Override
            public String call() throws Exception {
                if (TableAdapter.this.m_columns.size() > 0) {
                    TableColumn tCol = (TableColumn)TableAdapter.this.m_columns.get(column);
                    return tCol.getText();
                }
                TableColumn tCol = ((TableView)TableAdapter.this.getRealComponent()).getVisibleLeafColumn(column);
                return tCol.getText();
            }
        });
        return result;
    }

    public int getColumnFromString(final String colPath, final String op) {
        Integer result = EventThreadQueuerJavaFXImpl.invokeAndWait("getColumnFromString", new Callable<Integer>(){

            @Override
            public Integer call() throws Exception {
                TableView table = (TableView)TableAdapter.this.getRealComponent();
                TableColumn column = null;
                List path = StringParsing.splitToList((String)colPath, (char)'/', (char)'\\', (boolean)false);
                ObservableList columns = colPath.contains("/") ? table.getColumns() : table.getVisibleLeafColumns();
                Iterator pathIterator = path.iterator();
                String currCol = null;
                block4: while (pathIterator.hasNext()) {
                    try {
                        currCol = (String)pathIterator.next();
                        int usrIdxCol = Integer.parseInt(currCol);
                        if (usrIdxCol == 0) {
                            ++usrIdxCol;
                        }
                        int i = IndexConverter.toImplementationIndex((int)usrIdxCol);
                        if (pathIterator.hasNext()) {
                            columns = ((TableColumn)columns.get(i)).getColumns();
                            continue;
                        }
                        column = (TableColumn)columns.get(i);
                    }
                    catch (NumberFormatException numberFormatException) {
                        try {
                            if (path.size() <= 1) {
                                columns = table.getColumns();
                            }
                            if (columns.size() <= 0) {
                                throw new StepExecutionException("No Columns", EventFactory.createActionError((String)"TestErrorEvent.NoHeader"));
                            }
                            for (TableColumn c : columns) {
                                String header = c.getText();
                                if (!MatchUtil.getInstance().match(header, currCol, op)) continue;
                                column = c;
                                if (!pathIterator.hasNext()) continue block4;
                                columns = c.getColumns();
                                continue block4;
                            }
                        }
                        catch (IllegalArgumentException illegalArgumentException) {}
                    }
                }
                if (column == null) {
                    throw new StepExecutionException("Column not found", EventFactory.createActionError((String)"TestErrorEvent.NotFound"));
                }
                if (table.getVisibleLeafColumns().contains(column)) {
                    return table.getVisibleLeafColumns().indexOf(column);
                }
                TableAdapter.this.m_columns.add(column);
                return TableAdapter.this.m_columns.indexOf(column);
            }
        });
        return result;
    }

    public String getRowText(int row) {
        return null;
    }

    public int getRowFromString(final String row, final String operator) {
        Integer result = EventThreadQueuerJavaFXImpl.invokeAndWait("getRowFromString", new Callable<Integer>(){

            /*
             * Unable to fully structure code
             */
            @Override
            public Integer call() throws Exception {
                block5: {
                    rowInt = -2;
                    table = (TableView)TableAdapter.this.getRealComponent();
                    try {
                        rowInt = IndexConverter.toImplementationIndex((int)Integer.parseInt(row));
                        if (rowInt == -1 && table.getColumns().size() <= 0) {
                            throw new StepExecutionException("No Header", EventFactory.createActionError((String)"TestErrorEvent.NoHeader"));
                        }
                        break block5;
                    }
                    catch (NumberFormatException v0) {
                        i = 0;
                        ** while (i < table.getItems().size())
                    }
lbl-1000:
                    // 1 sources

                    {
                        cellTxt = TableAdapter.this.getCellText(i, 0);
                        if (MatchUtil.getInstance().match(cellTxt, row, operator)) {
                            return new Integer(i);
                        }
                        ++i;
                        continue;
                    }
                }
                return new Integer(rowInt);
            }
        });
        return result;
    }

    public Rectangle getHeaderBounds(final int column) {
        Rectangle result = EventThreadQueuerJavaFXImpl.invokeAndWait("getHeaderBounds", new Callable<Rectangle>(){

            @Override
            public Rectangle call() throws Exception {
                TableView table = (TableView)TableAdapter.this.getRealComponent();
                TableColumn col = TableAdapter.this.m_columns.size() > 0 ? (TableColumn)TableAdapter.this.m_columns.get(column) : ((TableView)TableAdapter.this.getRealComponent()).getVisibleLeafColumn(column);
                table.scrollToColumn(col);
                table.layout();
                Parent headerRow = (Parent)table.lookup("TableHeaderRow");
                Set columnHeaders = headerRow.lookupAll("column-header");
                Point2D parentPos = table.localToScreen(0.0, 0.0);
                for (Node n : columnHeaders) {
                    TableColumnHeader colH = (TableColumnHeader)n;
                    if (!colH.getTableColumn().equals(col)) continue;
                    Bounds b = n.getBoundsInParent();
                    Point2D pos = n.localToScreen(0.0, 0.0);
                    return new Rectangle(Rounding.round(pos.getX() - parentPos.getX()), Rounding.round(pos.getY() - parentPos.getY()), Rounding.round(b.getWidth()), Rounding.round(b.getHeight()));
                }
                return null;
            }
        });
        return result;
    }

    public Cell getSelectedCell() throws StepExecutionException {
        Cell result = EventThreadQueuerJavaFXImpl.invokeAndWait("getSelectedCell", new Callable<Cell>(){

            @Override
            public Cell call() throws StepExecutionException {
                TableView table = (TableView)TableAdapter.this.getRealComponent();
                ObservableList list = table.getSelectionModel().getSelectedCells();
                if (list.size() > 0) {
                    TablePosition pos = null;
                    for (Object object : list) {
                        TablePosition curr = (TablePosition)object;
                        if (curr.getRow() != table.getSelectionModel().getSelectedIndex()) continue;
                        pos = curr;
                        break;
                    }
                    if (pos != null) {
                        return new Cell(pos.getRow(), pos.getColumn());
                    }
                }
                throw new StepExecutionException("No selection found", EventFactory.createActionError((String)"TestErrorEvent.NoSelection"));
            }
        });
        return result;
    }

    public boolean isHeaderVisible() {
        boolean result = EventThreadQueuerJavaFXImpl.invokeAndWait("isHeaderVisible", new Callable<Boolean>(){

            @Override
            public Boolean call() throws Exception {
                Pane header = (Pane)((TableView)TableAdapter.this.getRealComponent()).lookup("TableHeaderRow");
                if (header != null) {
                    return header.isVisible();
                }
                return false;
            }
        });
        return result;
    }

    public boolean isCellEditable(final int row, final int column) {
        boolean result = EventThreadQueuerJavaFXImpl.invokeAndWait("isCellEditable", new Callable<Boolean>(){

            @Override
            public Boolean call() throws Exception {
                TableView table = (TableView)TableAdapter.this.getRealComponent();
                if (table.isEditable()) {
                    TableColumn col = null;
                    col = TableAdapter.this.m_columns.size() == 0 ? table.getVisibleLeafColumn(column) : (TableColumn)TableAdapter.this.m_columns.get(column);
                    if (col.isEditable()) {
                        table.scrollTo(row);
                        table.scrollToColumn(col);
                        table.layout();
                        List<TableCell> tCells = ComponentHandler.getAssignableFrom(TableCell.class);
                        for (TableCell cell : tCells) {
                            if (cell.getIndex() != row || cell.getTableColumn() != col || cell.getTableView() != table) continue;
                            return cell.isEditable();
                        }
                    }
                }
                return false;
            }
        });
        return result;
    }

    public boolean hasCellSelection() {
        boolean result = EventThreadQueuerJavaFXImpl.invokeAndWait("hasCellSelection", new Callable<Boolean>(){

            @Override
            public Boolean call() throws Exception {
                TableView table = (TableView)TableAdapter.this.getRealComponent();
                if (table.getSelectionModel().getSelectedCells().size() > 0) {
                    return true;
                }
                return false;
            }
        });
        return result;
    }

    public Rectangle scrollCellToVisible(final int row, final int column) throws StepExecutionException {
        Rectangle result = EventThreadQueuerJavaFXImpl.invokeAndWait("scrollCellToVisible", new Callable<Rectangle>(){

            @Override
            public Rectangle call() throws Exception {
                TableView table = (TableView)TableAdapter.this.getRealComponent();
                TableColumn col = null;
                col = TableAdapter.this.m_columns.size() == 0 ? table.getVisibleLeafColumn(column) : (TableColumn)TableAdapter.this.m_columns.get(column);
                table.scrollTo(row);
                table.scrollToColumn(col);
                table.layout();
                List<TableCell> tCells = ComponentHandler.getAssignableFrom(TableCell.class);
                for (TableCell cell : tCells) {
                    if (cell.getIndex() != row || cell.getTableColumn() != col || cell.getTableView() != table) continue;
                    Bounds b = cell.getBoundsInParent();
                    Point2D pos = cell.localToScreen(0.0, 0.0);
                    Point2D parentPos = table.localToScreen(0.0, 0.0);
                    return new Rectangle(Rounding.round(pos.getX() - parentPos.getX()), Rounding.round(pos.getY() - parentPos.getY()), Rounding.round(b.getWidth()), Rounding.round(b.getHeight()));
                }
                return null;
            }
        });
        return result;
    }

    public Object getTableHeader() {
        Object result = EventThreadQueuerJavaFXImpl.invokeAndWait("getTableHeader", new Callable<Object>(){

            @Override
            public Object call() throws Exception {
                return ((TableView)TableAdapter.this.getRealComponent()).lookup("TableHeaderRow");
            }
        });
        return result;
    }
}

