/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.rc.swing.driver;

import java.awt.Point;
import java.awt.Robot;
import java.awt.Window;
import org.eclipse.jubula.rc.common.driver.IEventThreadQueuer;
import org.eclipse.jubula.rc.common.driver.IRunnable;
import org.eclipse.jubula.rc.common.driver.RobotConfiguration;
import org.eclipse.jubula.rc.common.driver.RobotTiming;
import org.eclipse.jubula.rc.common.exception.StepExecutionException;
import org.eclipse.jubula.toolkit.enums.ValueSets;

public abstract class WindowActivationMethod {
    private static final int ACTIVATE_BTN = 16;
    private final Robot m_robot;
    private final IEventThreadQueuer m_queuer;

    protected WindowActivationMethod(Robot robot, IEventThreadQueuer queuer) {
        this.m_robot = robot;
        this.m_queuer = queuer;
    }

    protected abstract Point getClickPoint(Window var1);

    public void activate(final Window window) {
        this.m_queuer.invokeAndWait("window activate", new IRunnable(){

            public Object run() throws StepExecutionException {
                Point pos = window.getLocationOnScreen();
                Point cp = WindowActivationMethod.this.getClickPoint(window);
                WindowActivationMethod.this.m_robot.mouseMove(pos.x + cp.x, pos.y + cp.y);
                WindowActivationMethod.this.m_robot.mousePress(16);
                WindowActivationMethod.this.m_robot.mouseRelease(16);
                RobotTiming.sleepPostWindowActivationDelay();
                return null;
            }
        });
    }

    public static WindowActivationMethod createWindowActivationMethod(String method, Robot robot, IEventThreadQueuer queuer) {
        if (ValueSets.AUTActivationMethod.autDefault.rcValue().equals(method)) {
            return WindowActivationMethod.createWindowActivationMethod(RobotConfiguration.getInstance().getDefaultActivationMethod(), robot, queuer);
        }
        if (ValueSets.AUTActivationMethod.none.rcValue().equals(method)) {
            return new NoneMethod(robot, queuer);
        }
        if (ValueSets.AUTActivationMethod.titlebar.rcValue().equals(method)) {
            return new TitleMethod(robot, queuer);
        }
        if (ValueSets.AUTActivationMethod.northwest.rcValue().equals(method)) {
            return new NorthWestMethod(robot, queuer);
        }
        if (ValueSets.AUTActivationMethod.northeast.rcValue().equals(method)) {
            return new NorthEastMethod(robot, queuer);
        }
        if (ValueSets.AUTActivationMethod.southwest.rcValue().equals(method)) {
            return new SouthWestMethod(robot, queuer);
        }
        if (ValueSets.AUTActivationMethod.southeast.rcValue().equals(method)) {
            return new SouthEastMethod(robot, queuer);
        }
        if (ValueSets.AUTActivationMethod.center.rcValue().equals(method)) {
            return new CenterMethod(robot, queuer);
        }
        return new NoneMethod(robot, queuer);
    }

    private static class CenterMethod
    extends WindowActivationMethod {
        public CenterMethod(Robot robot, IEventThreadQueuer queuer) {
            super(robot, queuer);
        }

        protected Point getClickPoint(Window window) {
            return new Point(window.getWidth() / 2, window.getHeight() / 2);
        }
    }

    private static class NoneMethod
    extends WindowActivationMethod {
        public NoneMethod(Robot robot, IEventThreadQueuer queuer) {
            super(robot, queuer);
        }

        protected Point getClickPoint(Window window) {
            return null;
        }

        public void activate(Window window) {
        }
    }

    private static class NorthEastMethod
    extends WindowActivationMethod {
        public NorthEastMethod(Robot robot, IEventThreadQueuer queuer) {
            super(robot, queuer);
        }

        protected Point getClickPoint(Window window) {
            return new Point(window.getWidth() - 1, 0);
        }
    }

    private static class NorthWestMethod
    extends WindowActivationMethod {
        public NorthWestMethod(Robot robot, IEventThreadQueuer queuer) {
            super(robot, queuer);
        }

        protected Point getClickPoint(Window window) {
            return new Point(0, 0);
        }
    }

    private static class SouthEastMethod
    extends WindowActivationMethod {
        public SouthEastMethod(Robot robot, IEventThreadQueuer queuer) {
            super(robot, queuer);
        }

        protected Point getClickPoint(Window window) {
            return new Point(window.getWidth() - 1, window.getHeight() - 1);
        }
    }

    private static class SouthWestMethod
    extends WindowActivationMethod {
        public SouthWestMethod(Robot robot, IEventThreadQueuer queuer) {
            super(robot, queuer);
        }

        protected Point getClickPoint(Window window) {
            return new Point(0, window.getHeight() - 1);
        }
    }

    private static class TitleMethod
    extends WindowActivationMethod {
        public TitleMethod(Robot robot, IEventThreadQueuer queuer) {
            super(robot, queuer);
        }

        protected Point getClickPoint(Window window) {
            return new Point(window.getWidth() / 2, 3);
        }
    }
}

