/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.rc.swt.tester.adapter;

import org.eclipse.jubula.rc.common.driver.ClickOptions;
import org.eclipse.jubula.rc.common.driver.IEventMatcher;
import org.eclipse.jubula.rc.common.driver.IRobot;
import org.eclipse.jubula.rc.common.driver.IRobotEventConfirmer;
import org.eclipse.jubula.rc.common.driver.IRobotEventInterceptor;
import org.eclipse.jubula.rc.common.driver.IRunnable;
import org.eclipse.jubula.rc.common.driver.InterceptorOptions;
import org.eclipse.jubula.rc.common.exception.RobotException;
import org.eclipse.jubula.rc.common.exception.StepExecutionException;
import org.eclipse.jubula.rc.common.listener.EventLock;
import org.eclipse.jubula.rc.common.logger.AutServerLogger;
import org.eclipse.jubula.rc.common.tester.adapter.interfaces.IMenuComponent;
import org.eclipse.jubula.rc.common.tester.adapter.interfaces.IMenuItemComponent;
import org.eclipse.jubula.rc.swt.driver.EventThreadQueuerSwtImpl;
import org.eclipse.jubula.rc.swt.driver.RobotFactorySwtImpl;
import org.eclipse.jubula.rc.swt.driver.SelectionSwtEventMatcher;
import org.eclipse.jubula.rc.swt.driver.ShowSwtEventMatcher;
import org.eclipse.jubula.rc.swt.tester.CAPUtil;
import org.eclipse.jubula.rc.swt.tester.adapter.AbstractComponentAdapter;
import org.eclipse.jubula.rc.swt.tester.adapter.MenuAdapter;
import org.eclipse.jubula.rc.swt.tester.util.EventListener;
import org.eclipse.jubula.rc.swt.utils.SwtUtils;
import org.eclipse.jubula.tools.internal.i18n.I18n;
import org.eclipse.jubula.tools.internal.objects.event.EventFactory;
import org.eclipse.jubula.tools.internal.utils.EnvironmentUtils;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Widget;

public class MenuItemAdapter
extends AbstractComponentAdapter
implements IMenuItemComponent {
    private static AutServerLogger log = new AutServerLogger(MenuItemAdapter.class);
    private MenuItem m_menuItem;

    public MenuItemAdapter(Object component) {
        this.m_menuItem = (MenuItem)component;
    }

    protected IRobot getRobot() throws RobotException {
        return this.getRobotFactory().getRobot();
    }

    public Object getRealComponent() {
        return this.m_menuItem;
    }

    public void setComponent(Object element) {
        this.m_menuItem = (MenuItem)element;
    }

    public String getText() {
        return (String)this.getEventThreadQueuer().invokeAndWait("getText", new IRunnable(){

            public Object run() {
                return CAPUtil.getWidgetText((Widget)MenuItemAdapter.this.m_menuItem, SwtUtils.removeMnemonics(MenuItemAdapter.this.m_menuItem.getText()));
            }
        });
    }

    public boolean isEnabled() {
        Boolean isEnabled = (Boolean)this.getEventThreadQueuer().invokeAndWait("isEnabled", new IRunnable(){

            public Object run() throws StepExecutionException {
                return MenuItemAdapter.this.m_menuItem.isEnabled() ? Boolean.TRUE : Boolean.FALSE;
            }
        });
        return isEnabled;
    }

    public boolean isExisting() {
        return this.m_menuItem != null;
    }

    public boolean isSelected() {
        Boolean isSelected = (Boolean)this.getEventThreadQueuer().invokeAndWait("isSelected", new IRunnable(){

            public Object run() throws StepExecutionException {
                return MenuItemAdapter.this.m_menuItem.getSelection() ? Boolean.TRUE : Boolean.FALSE;
            }
        });
        return isSelected;
    }

    public boolean isShowing() {
        return this.m_menuItem != null;
    }

    public IMenuComponent getMenu() {
        Menu menu = (Menu)this.getEventThreadQueuer().invokeAndWait("getItems", new IRunnable(){

            public Object run() {
                return MenuItemAdapter.this.m_menuItem.getMenu();
            }
        });
        return new MenuAdapter(menu);
    }

    public boolean hasSubMenu() {
        return this.getMenu() != null;
    }

    public boolean isSeparator() {
        Boolean isSeparator = (Boolean)this.getEventThreadQueuer().invokeAndWait(".isSeparator", new IRunnable(){

            public Object run() throws StepExecutionException {
                return (MenuItemAdapter.this.m_menuItem.getStyle() & 2) != 0 ? Boolean.TRUE : Boolean.FALSE;
            }
        });
        return isSeparator;
    }

    public void selectMenuItem() {
        Rectangle nullBounds;
        Rectangle bounds = this.getMenuItemBounds();
        if (bounds.equals((Object)(nullBounds = new Rectangle(0, 0, 0, 0)))) {
            this.selectProgramatically();
        } else {
            this.clickMenuItem(this.getRobot(), this.m_menuItem, 1);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IMenuComponent openSubMenu() {
        EventLock lock;
        MenuShownCondition cond;
        MenuItem menuItem;
        block12: {
            menuItem = this.m_menuItem;
            cond = new MenuShownCondition(menuItem);
            lock = new EventLock();
            final EventListener listener = new EventListener(lock, cond);
            final Display d = menuItem.getDisplay();
            EventThreadQueuerSwtImpl queuer = new EventThreadQueuerSwtImpl();
            queuer.invokeAndWait("addMenuShownListeners", new IRunnable(){

                public Object run() {
                    d.addFilter(22, (Listener)listener);
                    return null;
                }
            });
            try {
                try {
                    int clickCount = this.isMenuBarItem(menuItem) ? 1 : 0;
                    Menu menu = (Menu)this.getEventThreadQueuer().invokeAndWait("openSubMenu", new IRunnable(){

                        public Object run() {
                            return menuItem.getMenu();
                        }
                    });
                    Rectangle bounds = this.getMenuItemBounds();
                    Rectangle nullBounds = new Rectangle(0, 0, 0, 0);
                    if (bounds.equals((Object)nullBounds)) {
                        this.openSubMenuProgramatically(menu);
                    } else {
                        this.clickMenuItem(this.getRobot(), menuItem, clickCount);
                    }
                    EventLock eventLock = lock;
                    synchronized (eventLock) {
                        long timeout = 10000L;
                        long done = System.currentTimeMillis() + timeout;
                        while (!lock.isReleased() && timeout > 0L) {
                            lock.wait(timeout);
                            long now = System.currentTimeMillis();
                            timeout = done - now;
                        }
                    }
                }
                catch (InterruptedException interruptedException) {
                    queuer.invokeAndWait("removeMenuShownListeners", new IRunnable(d, listener){
                        private final /* synthetic */ Display val$d;
                        private final /* synthetic */ EventListener val$listener;
                        {
                            this.val$d = display;
                            this.val$listener = eventListener;
                        }

                        public Object run() {
                            this.val$d.removeFilter(22, (Listener)this.val$listener);
                            return null;
                        }
                    });
                    break block12;
                }
            }
            catch (Throwable throwable) {
                queuer.invokeAndWait("removeMenuShownListeners", new /* invalid duplicate definition of identical inner class */);
                throw throwable;
            }
            queuer.invokeAndWait("removeMenuShownListeners", new /* invalid duplicate definition of identical inner class */);
        }
        if (!lock.isReleased()) {
            String itemText = (String)this.getEventThreadQueuer().invokeAndWait("getItemText", new IRunnable(){

                public Object run() throws StepExecutionException {
                    if (menuItem != null && !menuItem.isDisposed()) {
                        return CAPUtil.getWidgetText((Widget)menuItem, SwtUtils.removeMnemonics(menuItem.getText()));
                    }
                    return "unknown menu item";
                }
            });
            itemText = SwtUtils.removeMnemonics(itemText);
            throw new StepExecutionException(I18n.getString((String)"TestErrorEvent.MenuDidNotAppear", (Object[])new String[]{itemText}), EventFactory.createActionError((String)"TestErrorEvent.MenuDidNotAppear", (Object[])new String[]{itemText}));
        }
        return new MenuAdapter(cond.getMenu());
    }

    private boolean isMenuBarItem(final MenuItem menuItem) {
        return (Boolean)this.getEventThreadQueuer().invokeAndWait("isMenuBarItem", new IRunnable(){

            public Object run() throws StepExecutionException {
                Menu parent;
                if (menuItem != null && !menuItem.isDisposed() && (parent = menuItem.getParent()) != null && !parent.isDisposed()) {
                    return (parent.getStyle() & 2) != 0 ? Boolean.TRUE : Boolean.FALSE;
                }
                return Boolean.FALSE;
            }
        });
    }

    private void clickMenuItem(IRobot robot, final MenuItem item, int clickCount) {
        boolean isSecondInMenu = (Boolean)this.getEventThreadQueuer().invokeAndWait("isMenuBar", new IRunnable(){

            public Object run() throws StepExecutionException {
                try {
                    Menu preparent;
                    if ((item.getParent().getParentMenu().getStyle() & 2) != 0) {
                        return Boolean.TRUE;
                    }
                    Menu parent = item.getMenu().getParentMenu();
                    if (parent != null && (preparent = parent.getParentMenu()) != null) {
                        return (preparent.getStyle() & 2) != 0 ? Boolean.TRUE : Boolean.FALSE;
                    }
                }
                catch (NullPointerException nullPointerException) {}
                return Boolean.FALSE;
            }
        });
        if (isSecondInMenu) {
            robot.click((Object)item, null, ClickOptions.create().setClickType(ClickOptions.ClickType.RELEASED).setStepMovement(true).setClickCount(clickCount).setFirstHorizontal(false));
        } else {
            robot.click((Object)item, null, ClickOptions.create().setClickType(ClickOptions.ClickType.RELEASED).setStepMovement(true).setClickCount(clickCount));
        }
    }

    public Rectangle getMenuItemBounds() {
        Rectangle bounds = (Rectangle)this.getEventThreadQueuer().invokeAndWait("getMenuItemBounds", new IRunnable(){

            public Object run() {
                return SwtUtils.getBounds(MenuItemAdapter.this.m_menuItem);
            }
        });
        return bounds;
    }

    public void openSubMenuProgramatically(final Menu menu) {
        if (!this.isMenuEnabled(menu)) {
            throw new StepExecutionException("menu item not enabled", EventFactory.createActionError((String)"TestErrorEvent.MenuItemNotEnabled"));
        }
        InterceptorOptions options = new InterceptorOptions(new long[]{22L});
        ShowSwtEventMatcher matcher = new ShowSwtEventMatcher();
        RobotFactorySwtImpl robotSwt = new RobotFactorySwtImpl();
        IRobotEventInterceptor interceptor = robotSwt.getRobotEventInterceptor();
        IRobotEventConfirmer confirmer = interceptor.intercept(options);
        final Event event = new Event();
        event.time = (int)System.currentTimeMillis();
        event.widget = menu;
        event.display = menu.getDisplay();
        event.type = 22;
        this.getEventThreadQueuer().invokeAndWait("openSubMenuProgramatically", new IRunnable(){

            public Object run() {
                menu.notifyListeners(22, event);
                return null;
            }
        });
        try {
            confirmer.waitToConfirm((Object)menu, (IEventMatcher)matcher);
        }
        catch (RobotException re) {
            final StringBuffer sb = new StringBuffer("Robot exception occurred while clicking...\n");
            sb.append("Component: ");
            this.getEventThreadQueuer().invokeAndWait("getBounds", new IRunnable(){

                public Object run() throws StepExecutionException {
                    sb.append(menu);
                    return null;
                }
            });
            log.error((Object)sb.toString(), (Throwable)re);
            throw re;
        }
    }

    public void selectProgramatically() {
        if (!this.isMenuItemEnabled(this.m_menuItem)) {
            throw new StepExecutionException("menu item not enabled", EventFactory.createActionError((String)"TestErrorEvent.MenuItemNotEnabled"));
        }
        final MenuItem menuItem = this.m_menuItem;
        InterceptorOptions options = new InterceptorOptions(new long[]{13L});
        SelectionSwtEventMatcher matcher = new SelectionSwtEventMatcher();
        RobotFactorySwtImpl robotSwt = new RobotFactorySwtImpl();
        IRobotEventInterceptor interceptor = robotSwt.getRobotEventInterceptor();
        IRobotEventConfirmer confirmer = interceptor.intercept(options);
        final Event event = new Event();
        event.time = (int)System.currentTimeMillis();
        event.widget = menuItem;
        event.display = menuItem.getDisplay();
        event.type = 13;
        this.closeUnderMac();
        this.getEventThreadQueuer().invokeLater("selectProgramatically", new Runnable(){

            public void run() {
                if ((menuItem.getStyle() & 0x20) == 0 || (menuItem.getStyle() & 0x10) == 0) {
                    if (menuItem.getSelection()) {
                        menuItem.setSelection(false);
                    } else {
                        menuItem.setSelection(true);
                    }
                }
                menuItem.notifyListeners(13, event);
            }
        });
        try {
            confirmer.waitToConfirm((Object)menuItem, (IEventMatcher)matcher);
        }
        catch (RobotException re) {
            final StringBuffer sb = new StringBuffer("Robot exception occurred while clicking...\n");
            sb.append("Component: ");
            this.getEventThreadQueuer().invokeAndWait("getBounds", new IRunnable(){

                public Object run() throws StepExecutionException {
                    sb.append(menuItem);
                    return null;
                }
            });
            log.error((Object)sb.toString(), (Throwable)re);
            throw re;
        }
    }

    private void closeUnderMac() {
        if (EnvironmentUtils.isMacOS()) {
            this.m_menuItem.getDisplay().syncExec(new Runnable(){

                public void run() {
                    Menu parentMenu = MenuItemAdapter.this.m_menuItem.getParent();
                    while (parentMenu.getParentMenu() != null) {
                        parentMenu = parentMenu.getParentMenu();
                    }
                    parentMenu.setVisible(false);
                }
            });
        }
    }

    private boolean isMenuItemEnabled(final MenuItem menuItem) {
        Boolean isEnabled = (Boolean)this.getEventThreadQueuer().invokeAndWait(MenuItemAdapter.class + ".isMenuItemEnabled", new IRunnable(){

            public Object run() throws StepExecutionException {
                return menuItem.isEnabled() ? Boolean.TRUE : Boolean.FALSE;
            }
        });
        return isEnabled;
    }

    private boolean isMenuEnabled(final Menu menu) {
        Boolean isEnabled = (Boolean)this.getEventThreadQueuer().invokeAndWait(MenuItemAdapter.class + ".isMenuEnabled", new IRunnable(){

            public Object run() throws StepExecutionException {
                return menu.isEnabled() ? Boolean.TRUE : Boolean.FALSE;
            }
        });
        return isEnabled;
    }

    public static class MenuShownCondition
    implements EventListener.Condition {
        private Menu m_shownMenu = null;
        private MenuItem m_parentItem;

        MenuShownCondition(MenuItem parentItem) {
            this.m_parentItem = parentItem;
        }

        public Menu getMenu() {
            return this.m_shownMenu;
        }

        public boolean isTrue(Event event) {
            if (event.type == 22 && event.widget instanceof Menu && ((Menu)event.widget).getParentItem() == this.m_parentItem) {
                this.m_shownMenu = (Menu)event.widget;
                return true;
            }
            return false;
        }
    }
}

