/*******************************************************************************
 * Copyright (c) 2014 BREDEX GmbH.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     BREDEX GmbH - initial API and implementation and/or initial documentation
 *******************************************************************************/
package org.eclipse.jubula.toolkit.concrete.widgets;

import org.eclipse.jubula.toolkit.internal.annotations.RealizedType;
import org.eclipse.jubula.toolkit.internal.annotations.TesterClass;

@RealizedType(realizedType="guidancer.abstract.Widget")
@TesterClass(testerClass="null")
public interface Tree
	extends org.eclipse.jubula.toolkit.base.widgets.GraphicsComponent
	 {
	
	
	
		
		public void collapseNodeByTextpath(
		
			org.eclipse.jubula.toolkit.enums.ValueSets.SearchType pathType,
		
			java.lang.Integer preAscend,
		
			java.lang.String textpath,
		
			org.eclipse.jubula.toolkit.enums.ValueSets.Operator operator
		
		) ;
	
		
		public void collapseNodeByIndexpath(
		
			org.eclipse.jubula.toolkit.enums.ValueSets.SearchType pathType,
		
			java.lang.Integer preAscend,
		
			java.lang.String indexpath
		
		) ;
	
		
		public void expandNodeByTextpath(
		
			org.eclipse.jubula.toolkit.enums.ValueSets.SearchType pathType,
		
			java.lang.Integer preAscend,
		
			java.lang.String textpath,
		
			org.eclipse.jubula.toolkit.enums.ValueSets.Operator operator
		
		) ;
	
		
		public void expandNodeByIndexpath(
		
			org.eclipse.jubula.toolkit.enums.ValueSets.SearchType pathType,
		
			java.lang.Integer preAscend,
		
			java.lang.String indexpath
		
		) ;
	
		
		public void selectNodeByTextpath(
		
			org.eclipse.jubula.toolkit.enums.ValueSets.SearchType pathType,
		
			java.lang.Integer preAscend,
		
			java.lang.String textpath,
		
			org.eclipse.jubula.toolkit.enums.ValueSets.Operator operator,
		
			java.lang.Integer numberOfClicks,
		
			java.lang.Integer mouseButton,
		
			org.eclipse.jubula.toolkit.enums.ValueSets.BinaryChoice extendSelection
		
		) ;
	
		
		public void selectNodeByIndexpath(
		
			org.eclipse.jubula.toolkit.enums.ValueSets.SearchType pathType,
		
			java.lang.Integer preAscend,
		
			java.lang.String indexpath,
		
			java.lang.Integer numberOfClicks,
		
			java.lang.Integer mouseButton,
		
			org.eclipse.jubula.toolkit.enums.ValueSets.BinaryChoice extendSelection
		
		) ;
	
		
		public void move(
		
			org.eclipse.jubula.toolkit.enums.ValueSets.TreeDirection direction,
		
			java.lang.Integer numberOfNodes,
		
			java.lang.Integer numberOfClicks
		
		) ;
	
		
		public void checkExistenceOfNodeByTextpath(
		
			org.eclipse.jubula.toolkit.enums.ValueSets.SearchType pathType,
		
			java.lang.Integer preAscend,
		
			java.lang.String textpath,
		
			org.eclipse.jubula.toolkit.enums.ValueSets.Operator operator,
		
			java.lang.Boolean exists
		
		) ;
	
		
		public void checkExistenceOfNodeByIndexpath(
		
			org.eclipse.jubula.toolkit.enums.ValueSets.SearchType pathType,
		
			java.lang.Integer preAscend,
		
			java.lang.String indexpath,
		
			java.lang.Boolean exists
		
		) ;
	
		
		public void checkTextOfSelectedNodeS(
		
			java.lang.String text,
		
			org.eclipse.jubula.toolkit.enums.ValueSets.Operator operator
		
		) ;
	
		
		public void checkTextMousePosition(
		
			java.lang.String text,
		
			org.eclipse.jubula.toolkit.enums.ValueSets.Operator operator
		
		) ;
	
		
		public void dragNodeByTextpath(
		
			java.lang.Integer mouseButton,
		
			org.eclipse.jubula.toolkit.enums.ValueSets.Modifier modifierKeys,
		
			org.eclipse.jubula.toolkit.enums.ValueSets.SearchType pathType,
		
			java.lang.Integer preAscend,
		
			java.lang.String treeTextpath,
		
			org.eclipse.jubula.toolkit.enums.ValueSets.Operator operator
		
		) ;
	
		
		public void dropOnNodeByTextpath(
		
			org.eclipse.jubula.toolkit.enums.ValueSets.SearchType pathType,
		
			java.lang.Integer preAscend,
		
			java.lang.String treeTextpath,
		
			org.eclipse.jubula.toolkit.enums.ValueSets.Operator operator,
		
			java.lang.Integer delayBeforeDropMilliseconds
		
		) ;
	
		
		public void dragNodeByIndexpath(
		
			java.lang.Integer mouseButton,
		
			org.eclipse.jubula.toolkit.enums.ValueSets.Modifier modifierKeys,
		
			org.eclipse.jubula.toolkit.enums.ValueSets.SearchType pathType,
		
			java.lang.Integer preAscend,
		
			java.lang.String treeIndexpath
		
		) ;
	
		
		public void dropOnNodeByIndexpath(
		
			org.eclipse.jubula.toolkit.enums.ValueSets.SearchType pathType,
		
			java.lang.Integer preAscend,
		
			java.lang.String treeIndexpath,
		
			java.lang.Integer delayBeforeDropMilliseconds
		
		) ;
	
		
		public void storeTextOfSelectedNode(
		
			org.eclipse.jubula.toolkit.datatype.Variable variableName
		
		) ;
	
		
		public void storeTextAtMousePosition(
		
			org.eclipse.jubula.toolkit.datatype.Variable variableName
		
		) ;
	 
}