/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.tools.internal.objects;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.eclipse.jubula.tools.internal.i18n.CompSystemI18n;
import org.eclipse.jubula.tools.internal.objects.IComponentIdentifier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ComponentIdentifier
implements Serializable,
IComponentIdentifier {
    static final long serialVersionUID = 1031L;
    private static Logger log = LoggerFactory.getLogger(ComponentIdentifier.class);
    private String m_supportedClassName = null;
    private List<String> m_neighbours = new ArrayList<String>();
    private String m_componentClassName = null;
    private List<String> m_hierarchyNames = new ArrayList<String>();
    private String m_alternativeDisplayName = null;
    private double m_matchPercentage = -1.0;
    private int m_numberOfOtherMatchingComponents = -1;
    private boolean m_equalOriginalFound = false;
    private Map m_componentProperties;

    @Override
    public String getComponentClassName() {
        return this.m_componentClassName;
    }

    @Override
    public void setComponentClassName(String componentClassName) {
        this.m_componentClassName = componentClassName;
    }

    @Override
    public String getComponentName() {
        try {
            if (this.m_hierarchyNames != null && this.m_hierarchyNames.size() > 0) {
                return this.m_hierarchyNames.get(this.m_hierarchyNames.size() - 1);
            }
        }
        catch (ClassCastException cce) {
            log.error("unexpected element type", (Throwable)cce);
        }
        return "";
    }

    @Override
    public void setHierarchyNames(List<String> hierarchyNames) {
        this.m_hierarchyNames = hierarchyNames == null ? new ArrayList<String>() : hierarchyNames;
    }

    @Override
    public List<String> getHierarchyNames() {
        return this.m_hierarchyNames;
    }

    @Override
    public void addHierarchyName(String hierarchyNames) {
        this.m_hierarchyNames.add(hierarchyNames);
    }

    @Override
    public String toString() {
        return new ToStringBuilder((Object)this).append("component type", (Object)this.m_componentClassName).append("alternative name", (Object)this.m_alternativeDisplayName).append("hierarchy", this.m_hierarchyNames).toString();
    }

    @Override
    public void clearHierarchyNames() {
        this.m_hierarchyNames.clear();
    }

    @Override
    public IComponentIdentifier makeClone() {
        ComponentIdentifier clone = new ComponentIdentifier();
        clone.setHierarchyNames(new ArrayList<String>(this.m_hierarchyNames));
        clone.setComponentClassName(this.m_componentClassName);
        if (this.m_supportedClassName != null) {
            clone.setSupportedClassName(this.m_supportedClassName);
        }
        if (this.m_neighbours != null) {
            clone.setNeighbours(new ArrayList<String>(this.m_neighbours));
        }
        clone.setAlternativeDisplayName(this.m_alternativeDisplayName);
        return clone;
    }

    @Override
    public String getSupportedClassName() {
        return this.m_supportedClassName;
    }

    @Override
    public void setSupportedClassName(String supportedClassName) {
        this.m_supportedClassName = supportedClassName;
    }

    @Override
    public List<String> getNeighbours() {
        return this.m_neighbours;
    }

    @Override
    public void setNeighbours(List<String> neighbours) {
        this.m_neighbours = neighbours;
    }

    @Override
    public void addNeighbour(String neighbours) {
        this.m_neighbours.add(neighbours);
    }

    @Override
    public String generateLogicalName() {
        String returnVal = null;
        String supportedClassName = this.getSupportedClassName();
        if (supportedClassName.lastIndexOf(".") > -1 && supportedClassName.length() > supportedClassName.lastIndexOf(".") + 1) {
            returnVal = this.checkDefaultMapping(supportedClassName);
            if (returnVal != null) {
                return returnVal;
            }
            returnVal = String.valueOf(supportedClassName.substring(supportedClassName.lastIndexOf(".") + 1)) + "(";
        } else {
            returnVal = String.valueOf(supportedClassName) + "(";
        }
        StringBuffer hash = new StringBuffer();
        Iterator<String> iter = this.getHierarchyNames().iterator();
        while (iter.hasNext()) {
            hash.append(iter.next());
        }
        returnVal = String.valueOf(returnVal) + hash.toString().hashCode();
        returnVal = String.valueOf(returnVal) + ")";
        return returnVal;
    }

    private String checkDefaultMapping(String supportedClassName) {
        if ("com.bredexsw.guidancer.autserver.swing.implclasses.GraphicApplication".equals(supportedClassName) || "com.bredexsw.guidancer.autswtserver.implclasses.GraphicApplication".equals(supportedClassName)) {
            return CompSystemI18n.getString("CompSystem.LogicalApplicationName");
        }
        if ("org.eclipse.swt.widgets.Menu".equals(supportedClassName) || "javax.swing.JMenuBar".equals(supportedClassName)) {
            return CompSystemI18n.getString("CompSystem.LogicalMenuName");
        }
        return null;
    }

    @Override
    public String getAlternativeDisplayName() {
        return this.m_alternativeDisplayName;
    }

    @Override
    public void setAlternativeDisplayName(String alternativeDisplayName) {
        this.m_alternativeDisplayName = alternativeDisplayName;
    }

    @Override
    public String getComponentNameToDisplay() {
        String componentNameToDisplay = this.m_alternativeDisplayName == null ? this.getComponentName() : this.m_alternativeDisplayName;
        return componentNameToDisplay;
    }

    public boolean equals(Object obj) {
        if (obj instanceof IComponentIdentifier) {
            IComponentIdentifier compId = (IComponentIdentifier)obj;
            ArrayList<String> neighbours1 = new ArrayList<String>(this.getNeighbours());
            ArrayList<String> neighbours2 = new ArrayList<String>(compId.getNeighbours());
            Collections.sort(neighbours1);
            Collections.sort(neighbours2);
            return new EqualsBuilder().append(this.getHierarchyNames(), compId.getHierarchyNames()).append(neighbours1, neighbours2).isEquals();
        }
        return super.equals(obj);
    }

    public int hashCode() {
        ArrayList<String> neighbours = new ArrayList<String>(this.getNeighbours());
        Collections.sort(neighbours);
        return new HashCodeBuilder().append(this.getHierarchyNames()).append(neighbours).toHashCode();
    }

    @Override
    public void setMatchPercentage(double matchPercentage) {
        this.m_matchPercentage = matchPercentage;
    }

    @Override
    public double getMatchPercentage() {
        return this.m_matchPercentage;
    }

    @Override
    public void setNumberOfOtherMatchingComponents(int numberOfOtherMatchingComponents) {
        this.m_numberOfOtherMatchingComponents = numberOfOtherMatchingComponents;
    }

    @Override
    public int getNumberOfOtherMatchingComponents() {
        return this.m_numberOfOtherMatchingComponents;
    }

    @Override
    public void setEqualOriginalFound(boolean equalOriginalFound) {
        this.m_equalOriginalFound = equalOriginalFound;
    }

    @Override
    public boolean isEqualOriginalFound() {
        return this.m_equalOriginalFound;
    }

    @Override
    public Map getComponentPropertiesMap() {
        return this.m_componentProperties;
    }

    @Override
    public void setComponentPropertiesMap(Map componentProperties) {
        this.m_componentProperties = componentProperties;
    }
}

