/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.client.api.converter.ui.handlers;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.reflect.InvocationTargetException;
import java.util.Iterator;
import java.util.Locale;
import java.util.NoSuchElementException;
import java.util.regex.Pattern;
import org.apache.commons.io.IOUtils;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.dialogs.IInputValidator;
import org.eclipse.jface.dialogs.InputDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jubula.client.api.converter.NodeGenerator;
import org.eclipse.jubula.client.api.converter.NodeInfo;
import org.eclipse.jubula.client.api.converter.exceptions.InvalidNodeNameException;
import org.eclipse.jubula.client.api.converter.ui.i18n.Messages;
import org.eclipse.jubula.client.core.errorhandling.ErrorMessagePresenter;
import org.eclipse.jubula.client.core.model.IAUTMainPO;
import org.eclipse.jubula.client.core.model.ICategoryPO;
import org.eclipse.jubula.client.core.model.INodePO;
import org.eclipse.jubula.client.core.model.IProjectPO;
import org.eclipse.jubula.client.core.model.IReusedProjectPO;
import org.eclipse.jubula.client.core.persistence.GeneralStorage;
import org.eclipse.jubula.client.core.persistence.IExecPersistable;
import org.eclipse.jubula.client.core.persistence.ProjectPM;
import org.eclipse.jubula.client.ui.handlers.AbstractHandler;
import org.eclipse.jubula.client.ui.rcp.Plugin;
import org.eclipse.jubula.client.ui.rcp.businessprocess.WorkingLanguageBP;
import org.eclipse.jubula.client.ui.rcp.utils.Utils;
import org.eclipse.jubula.client.ui.utils.ErrorHandlingUtil;
import org.eclipse.jubula.tools.internal.exception.JBException;
import org.eclipse.jubula.tools.internal.messagehandling.MessageIDs;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.PlatformUI;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConvertProjectHandler
extends AbstractHandler {
    private static final Logger LOG = LoggerFactory.getLogger(ConvertProjectHandler.class);
    private static String genPath;
    private static String genPackage;
    private static Locale language;

    public Object executeImpl(ExecutionEvent event) {
        language = WorkingLanguageBP.getInstance().getWorkingLanguage();
        DirectoryDialog directoryDialog = this.createDirectoryDialog();
        genPath = directoryDialog.open();
        if (genPath != null) {
            Utils.storeLastDirPath((String)directoryDialog.getFilterPath());
            File directory = new File(genPath);
            if (directory.list().length == 0) {
                InputDialog inputDialog = new InputDialog(this.getActiveShell(), Messages.InputDialogName, Messages.InputDialogMessage, "", (IInputValidator)new PackageNameValidator());
                if (inputDialog.open() == 0) {
                    genPackage = inputDialog.getValue();
                    IWorkbench workbench = PlatformUI.getWorkbench();
                    try {
                        workbench.getProgressService().run(true, true, (IRunnableWithProgress)new ConvertProjectOperation());
                    }
                    catch (InterruptedException | InvocationTargetException e) {
                        LOG.error(Messages.ErrorWhileConverting, (Throwable)e);
                    }
                }
            } else {
                ErrorHandlingUtil.createMessageDialog((Integer)MessageIDs.E_NON_EMPTY_DIRECTORY);
            }
        }
        return null;
    }

    private DirectoryDialog createDirectoryDialog() {
        DirectoryDialog directoryDialog = new DirectoryDialog(this.getActiveShell(), 8192);
        String filterPath = Utils.getLastDirPath();
        directoryDialog.setFilterPath(filterPath);
        return directoryDialog;
    }

    private static class ConvertProjectOperation
    implements IRunnableWithProgress {
        private static IProgressMonitor progressMonitor;
        private static String defaultToolkit;

        private ConvertProjectOperation() {
        }

        public void run(IProgressMonitor monitor) {
            progressMonitor = monitor;
            IProjectPO project = GeneralStorage.getInstance().getProject();
            progressMonitor.beginTask(NLS.bind((String)Messages.ConvertProjectTaskName, (Object)project.getName()), -1);
            String basePath = String.valueOf(genPath) + "/" + genPackage.replace(".", "/");
            if (project != null) {
                defaultToolkit = this.determineDefaultToolkit(project);
                for (IReusedProjectPO reusedProject : project.getUsedProjects()) {
                    try {
                        IProjectPO usedProject = ProjectPM.loadReusedProjectInMasterSession((IReusedProjectPO)reusedProject);
                        this.handleProject(usedProject, basePath);
                    }
                    catch (JBException e) {
                        ErrorHandlingUtil.createMessageDialog((JBException)new JBException(e.getMessage(), (Throwable)e, MessageIDs.E_LOAD_PROJECT));
                    }
                }
                this.handleProject(project, basePath);
            }
            progressMonitor.done();
        }

        private String determineDefaultToolkit(IProjectPO project) {
            String toolkit = null;
            IAUTMainPO firstAUT = null;
            try {
                firstAUT = (IAUTMainPO)project.getAutCont().getAutMainList().iterator().next();
            }
            catch (NoSuchElementException noSuchElementException) {
                ErrorMessagePresenter.getPresenter().showErrorMessage(new JBException(Messages.NoAutInProject, MessageIDs.E_NO_AUT_IN_PROJECT), null, null);
                progressMonitor.setCanceled(true);
            }
            if (firstAUT != null) {
                toolkit = firstAUT.getToolkit();
            }
            if (toolkit.equals("com.bredexsw.guidancer.RcpToolkitPlugin")) {
                toolkit = "com.bredexsw.guidancer.SwtToolkitPlugin";
            }
            return toolkit;
        }

        private void handleProject(IProjectPO project, String basePath) {
            String path;
            String projectName = "";
            try {
                projectName = org.eclipse.jubula.client.api.converter.utils.Utils.translateToPackageName((INodePO)project);
            }
            catch (InvalidNodeNameException invalidNodeNameException) {
                this.displayErrorForInvalidName((INodePO)project);
            }
            String projectPath = String.valueOf(basePath) + "/" + projectName;
            for (IExecPersistable node : project.getExecObjCont().getExecObjList()) {
                path = String.valueOf(projectPath) + "/" + "testsuites" + "/";
                this.handleNode(new File(path), (INodePO)node);
            }
            for (IExecPersistable node : project.getSpecObjCont().getSpecObjList()) {
                path = String.valueOf(projectPath) + "/" + "testcases" + "/";
                this.handleNode(new File(path), (INodePO)node);
            }
        }

        private void handleNode(File parentDir, INodePO node) {
            if (progressMonitor.isCanceled()) {
                return;
            }
            if (node instanceof ICategoryPO) {
                ICategoryPO category = (ICategoryPO)node;
                this.handleCategory(parentDir, category);
            } else {
                this.handleTestCaseSuiteOrJob(parentDir, node);
            }
        }

        private void handleCategory(File parentDir, ICategoryPO category) {
            File dir = this.createDir(parentDir, category);
            if (dir.exists()) {
                this.displayErrorForDuplicate((INodePO)category);
                return;
            }
            dir.mkdirs();
            Iterator iterator = category.getNodeListIterator();
            while (iterator.hasNext()) {
                INodePO child = (INodePO)iterator.next();
                this.handleNode(dir, child);
            }
        }

        private void handleTestCaseSuiteOrJob(File parentDir, INodePO node) {
            File file = this.createFile(parentDir, node);
            if (file.exists()) {
                Plugin.getDefault().writeErrorLineToConsole("Duplicate filename error:" + file.getAbsolutePath(), true);
                return;
            }
            try {
                file.createNewFile();
                NodeGenerator gen = new NodeGenerator();
                NodeInfo info = new NodeInfo(file.getName(), node, genPackage, defaultToolkit, language);
                String content = gen.generate((Object)info);
                this.writeContentToFile(file, content);
            }
            catch (IOException e) {
                ErrorHandlingUtil.createMessageDialog((JBException)new JBException(e.getMessage(), (Throwable)e, MessageIDs.E_FILE_NO_PERMISSION));
            }
        }

        private void writeContentToFile(File file, String content) throws IOException {
            FileOutputStream fop = new FileOutputStream(file);
            byte[] contentInBytes = content.getBytes();
            IOUtils.write((byte[])contentInBytes, (OutputStream)fop);
        }

        private void displayErrorForDuplicate(INodePO node) {
            String fqNodeName = org.eclipse.jubula.client.api.converter.utils.Utils.getFullyQualifiedName((INodePO)node);
            ErrorMessagePresenter.getPresenter().showErrorMessage(new JBException(NLS.bind((String)Messages.DuplicateNode, (Object[])new String[]{fqNodeName}), MessageIDs.E_DUPLICATE_NODE), (Object[])new String[]{fqNodeName}, null);
            progressMonitor.setCanceled(true);
        }

        private File createDir(File parentDir, ICategoryPO category) {
            File dir = null;
            try {
                String dirPath = String.valueOf(parentDir.getAbsolutePath()) + "/" + org.eclipse.jubula.client.api.converter.utils.Utils.translateToPackageName((INodePO)category);
                dir = new File(dirPath);
            }
            catch (InvalidNodeNameException invalidNodeNameException) {
                this.displayErrorForInvalidName((INodePO)category);
            }
            return dir;
        }

        private File createFile(File parentDir, INodePO node) {
            String extension = ".java";
            String className = "";
            try {
                className = org.eclipse.jubula.client.api.converter.utils.Utils.determineClassName((INodePO)node);
            }
            catch (InvalidNodeNameException invalidNodeNameException) {
                this.displayErrorForInvalidName(node);
            }
            String fileName = String.valueOf(parentDir.getAbsolutePath()) + "/" + className + extension;
            File file = new File(fileName);
            return file;
        }

        private void displayErrorForInvalidName(INodePO node) {
            String fqNodeName = org.eclipse.jubula.client.api.converter.utils.Utils.getFullyQualifiedName((INodePO)node);
            ErrorMessagePresenter.getPresenter().showErrorMessage(new JBException(NLS.bind((String)Messages.InvalidNodeName, (Object[])new String[]{fqNodeName}), MessageIDs.E_INVALID_NODE_NAME), (Object[])new String[]{fqNodeName}, null);
            progressMonitor.setCanceled(true);
        }
    }

    private static class PackageNameValidator
    implements IInputValidator {
        private PackageNameValidator() {
        }

        public String isValid(String newText) {
            if (newText.isEmpty()) {
                return Messages.NoPackageNameSpecified;
            }
            Pattern p = Pattern.compile("^[a-zA-Z_][\\w]*(\\.[a-zA-Z_][\\w]*)*$");
            if (!p.matcher(newText).matches()) {
                return Messages.InvalidPackageName;
            }
            return null;
        }
    }
}

