/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.client.api.converter;

import java.util.Iterator;
import java.util.ListIterator;
import java.util.Locale;
import org.apache.commons.lang.StringUtils;
import org.eclipse.jubula.client.api.converter.NodeInfo;
import org.eclipse.jubula.client.api.converter.exceptions.InvalidNodeNameException;
import org.eclipse.jubula.client.api.converter.utils.CompNameLoader;
import org.eclipse.jubula.client.api.converter.utils.ParamUtils;
import org.eclipse.jubula.client.api.converter.utils.ProjectCache;
import org.eclipse.jubula.client.api.converter.utils.Utils;
import org.eclipse.jubula.client.core.model.ICapPO;
import org.eclipse.jubula.client.core.model.IExecTestCasePO;
import org.eclipse.jubula.client.core.model.INodePO;
import org.eclipse.jubula.client.core.model.IParamDescriptionPO;
import org.eclipse.jubula.client.core.model.IParameterInterfacePO;
import org.eclipse.jubula.client.core.model.IProjectPO;
import org.eclipse.jubula.client.core.model.IRefTestSuitePO;
import org.eclipse.jubula.client.core.model.ISpecTestCasePO;
import org.eclipse.jubula.client.core.model.ITestSuitePO;
import org.eclipse.jubula.client.ui.rcp.Plugin;
import org.eclipse.jubula.toolkit.api.gen.internal.utils.NameLoader;
import org.eclipse.jubula.toolkit.common.businessprocess.ToolkitSupportBP;
import org.eclipse.jubula.toolkit.common.xml.businessprocess.ComponentBuilder;
import org.eclipse.jubula.tools.internal.exception.JBException;
import org.eclipse.jubula.tools.internal.xml.businessmodell.CompSystem;
import org.eclipse.jubula.tools.internal.xml.businessmodell.Component;
import org.eclipse.jubula.tools.internal.xml.businessmodell.ConcreteComponent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NodeGenerator {
    protected static String nl;
    public final String NL = nl == null ? System.getProperties().getProperty("line.separator") : nl;
    protected final String TEXT_1 = "package ";
    protected final String TEXT_2 = ";" + this.NL + this.NL + "import org.eclipse.jubula.client.AUT;" + this.NL + this.NL + "public class ";
    protected final String TEXT_3 = " {" + this.NL + "\t" + this.NL + "\tpublic static void execute(" + this.NL + "\t";
    protected final String TEXT_4 = String.valueOf(this.NL) + "\t\t";
    protected final String TEXT_5 = " ";
    protected final String TEXT_6 = ",";
    protected final String TEXT_7 = String.valueOf(this.NL) + "\t\t";
    protected final String TEXT_8 = String.valueOf(this.NL) + "\t";
    protected final String TEXT_9 = String.valueOf(this.NL) + "\t) {" + this.NL + "\t\tAUT aut = null;" + this.NL + "\t" + this.NL + "\t\t";
    protected final String TEXT_10 = String.valueOf(this.NL) + "\t\taut.execute(" + this.NL + "\t\t\t";
    protected final String TEXT_11 = ".create";
    protected final String TEXT_12 = "(";
    protected final String TEXT_13 = "null";
    protected final String TEXT_14 = ")" + this.NL + "\t\t\t\t.";
    protected final String TEXT_15 = "(" + this.NL + "\t\t\t\t";
    protected final String TEXT_16 = String.valueOf(this.NL) + "\t\t\t\t";
    protected final String TEXT_17 = ".valueOf(";
    protected final String TEXT_18 = ")";
    protected final String TEXT_19 = ",";
    protected final String TEXT_20 = String.valueOf(this.NL) + "\t\t\t\t";
    protected final String TEXT_21 = String.valueOf(this.NL) + "\t\t\t\t)," + this.NL + "\t\t\tnull);" + this.NL + "\t\t\t\t";
    protected final String TEXT_22 = String.valueOf(this.NL) + "\t\t// TODO: Client action ";
    protected final String TEXT_23 = "." + this.NL + "\t\t\t\t";
    protected final String TEXT_24 = String.valueOf(this.NL) + "\t\t\t";
    protected final String TEXT_25 = String.valueOf(this.NL) + "\t\t";
    protected final String TEXT_26 = ".execute(" + this.NL + "\t\t\t\t\t";
    protected final String TEXT_27 = String.valueOf(this.NL) + "\t\t\t\t";
    protected final String TEXT_28 = ",";
    protected final String TEXT_29 = String.valueOf(this.NL) + "\t\t\t\t\t";
    protected final String TEXT_30 = String.valueOf(this.NL) + "\t\t\t\t\t";
    protected final String TEXT_31 = String.valueOf(this.NL) + "\t\t\t\t);" + this.NL + "\t\t\t\t";
    protected final String TEXT_32 = String.valueOf(this.NL) + "\t\t\t";
    protected final String TEXT_33 = String.valueOf(this.NL) + "\t\t";
    protected final String TEXT_34 = ".execute();" + this.NL + "\t\t\t";
    protected final String TEXT_35 = String.valueOf(this.NL) + "\t\t";
    protected final String TEXT_36 = String.valueOf(this.NL) + "\t}" + this.NL + "}";

    public static synchronized NodeGenerator create(String lineSeparator) {
        nl = lineSeparator;
        NodeGenerator result = new NodeGenerator();
        nl = null;
        return result;
    }

    public String generate(Object argument) {
        StringBuffer stringBuffer = new StringBuffer();
        Logger log = LoggerFactory.getLogger(NodeGenerator.class);
        NodeInfo info = (NodeInfo)argument;
        String className = info.getClassName();
        INodePO node = info.getNode();
        Locale locale = info.getLanguage();
        Iterator iterator = node.getNodeListIterator();
        String packageBase = info.getPackageBasePath();
        NameLoader nameLoader = NameLoader.getInstance();
        IProjectPO project = null;
        try {
            project = ProjectCache.get(node.getParentProjectId());
        }
        catch (JBException jBException) {
            Plugin.getDefault().writeErrorLineToConsole("Error while loading project.", true);
            return "";
        }
        String projectName = null;
        try {
            projectName = Utils.translateToPackageName((INodePO)project);
        }
        catch (InvalidNodeNameException e) {
            log.error(e.getLocalizedMessage());
        }
        String fqName = Utils.getFullyQualifiedTranslatedName(node, packageBase, projectName);
        String packageName = StringUtils.substringBeforeLast((String)fqName, (String)".");
        stringBuffer.append("package ");
        stringBuffer.append(packageName);
        stringBuffer.append(this.TEXT_2);
        stringBuffer.append(className);
        stringBuffer.append(this.TEXT_3);
        if (node instanceof ISpecTestCasePO) {
            ISpecTestCasePO tc = (ISpecTestCasePO)node;
            ListIterator paramIterator = tc.getParameterListIter();
            while (paramIterator.hasNext()) {
                IParamDescriptionPO param = (IParamDescriptionPO)paramIterator.next();
                String paramType = nameLoader.findTypeForParameter(param.getType(), "");
                String paramName = param.getName();
                stringBuffer.append(this.TEXT_4);
                stringBuffer.append(paramType);
                stringBuffer.append(" ");
                stringBuffer.append(paramName);
                if (paramIterator.hasNext()) {
                    stringBuffer.append(",");
                }
                stringBuffer.append(this.TEXT_7);
            }
            stringBuffer.append(this.TEXT_8);
        }
        stringBuffer.append(this.TEXT_9);
        while (iterator.hasNext()) {
            INodePO child = (INodePO)iterator.next();
            if (child instanceof ICapPO) {
                String componentNameToCreate;
                String factoryName;
                ICapPO cap = (ICapPO)child;
                String componentFromCap = cap.getComponentType();
                CompNameLoader loader = new CompNameLoader(componentFromCap);
                String actionName = loader.get(cap.getActionName());
                boolean hasDefaultMapping = loader.get("hasDefaultMapping").equals("true");
                ConcreteComponent cc = null;
                CompSystem compSystem = ComponentBuilder.getInstance().getCompSystem();
                Component c = compSystem.getComponentForType(componentFromCap);
                if (c instanceof ConcreteComponent) {
                    cc = (ConcreteComponent)c;
                }
                if (hasDefaultMapping) {
                    String toolkitID = info.getDefaultToolkit();
                    factoryName = Utils.getFactoryName(toolkitID);
                    ConcreteComponent componentToCreate = ToolkitSupportBP.getMostAbstractRealizingComponentInToolkit((String)toolkitID, (ConcreteComponent)cc);
                    CompNameLoader newLoader = new CompNameLoader(componentToCreate.getType());
                    componentNameToCreate = newLoader.get("componentTypeName");
                } else {
                    factoryName = loader.get("factoryName");
                    componentNameToCreate = loader.get("componentTypeName");
                }
                if (actionName != null) {
                    stringBuffer.append(this.TEXT_10);
                    stringBuffer.append(factoryName);
                    stringBuffer.append(".create");
                    stringBuffer.append(componentNameToCreate);
                    stringBuffer.append("(");
                    if (!hasDefaultMapping) {
                        stringBuffer.append("null");
                    }
                    stringBuffer.append(this.TEXT_14);
                    stringBuffer.append(actionName);
                    stringBuffer.append(this.TEXT_15);
                    ListIterator childParamIterator = cap.getParameterListIter();
                    while (childParamIterator.hasNext()) {
                        IParamDescriptionPO param = (IParamDescriptionPO)childParamIterator.next();
                        String paramType = param.getUniqueId();
                        String enumType = nameLoader.getEnumForParam(paramType);
                        String paramValue = ParamUtils.getValueForParam((IParameterInterfacePO)cap, param, 0, locale);
                        Boolean isEnum = enumType != null;
                        stringBuffer.append(this.TEXT_16);
                        if (isEnum.booleanValue()) {
                            stringBuffer.append(enumType);
                            stringBuffer.append(".valueOf(");
                        }
                        stringBuffer.append(paramValue);
                        if (isEnum.booleanValue()) {
                            stringBuffer.append(")");
                        }
                        if (childParamIterator.hasNext()) {
                            stringBuffer.append(",");
                        }
                        stringBuffer.append(this.TEXT_20);
                    }
                    stringBuffer.append(this.TEXT_21);
                } else {
                    stringBuffer.append(this.TEXT_22);
                    stringBuffer.append(cap.getActionName());
                    stringBuffer.append(this.TEXT_23);
                }
                stringBuffer.append(this.TEXT_24);
            } else if (child instanceof IExecTestCasePO) {
                IExecTestCasePO exec = (IExecTestCasePO)child;
                ISpecTestCasePO spec = exec.getSpecTestCase();
                String testCaseName = "";
                try {
                    project = ProjectCache.get(spec.getParentProjectId());
                }
                catch (JBException jBException) {
                    Plugin.getDefault().writeErrorLineToConsole("Error while loading project.", true);
                    return "";
                }
                try {
                    projectName = Utils.translateToPackageName((INodePO)project);
                }
                catch (InvalidNodeNameException e) {
                    log.error(e.getLocalizedMessage());
                }
                testCaseName = Utils.getFullyQualifiedTranslatedName((INodePO)spec, packageBase, projectName);
                int rowCount = exec.getDataManager().getDataSetCount();
                int row = 0;
                do {
                    stringBuffer.append(this.TEXT_25);
                    stringBuffer.append(testCaseName);
                    stringBuffer.append(this.TEXT_26);
                    ListIterator childParamIterator = exec.getParameterListIter();
                    while (childParamIterator.hasNext()) {
                        IParamDescriptionPO param = (IParamDescriptionPO)childParamIterator.next();
                        String paramValue = ParamUtils.getValueForParam((IParameterInterfacePO)exec, param, row, locale);
                        stringBuffer.append(this.TEXT_27);
                        stringBuffer.append(paramValue);
                        if (childParamIterator.hasNext()) {
                            stringBuffer.append(",");
                        }
                        stringBuffer.append(this.TEXT_29);
                    }
                    stringBuffer.append(this.TEXT_30);
                    stringBuffer.append(this.TEXT_31);
                } while (++row < rowCount);
                stringBuffer.append(this.TEXT_32);
            } else if (child instanceof IRefTestSuitePO) {
                IRefTestSuitePO ref = (IRefTestSuitePO)child;
                ITestSuitePO testSuite = ref.getTestSuite();
                String testSuiteName = "";
                try {
                    project = ProjectCache.get(testSuite.getParentProjectId());
                }
                catch (JBException jBException) {
                    Plugin.getDefault().writeErrorLineToConsole("Error while loading project.", true);
                    return "";
                }
                try {
                    projectName = Utils.translateToPackageName((INodePO)project);
                }
                catch (InvalidNodeNameException e) {
                    log.error(e.getLocalizedMessage());
                }
                testSuiteName = Utils.getFullyQualifiedTranslatedName((INodePO)testSuite, packageBase, projectName);
                stringBuffer.append(this.TEXT_33);
                stringBuffer.append(testSuiteName);
                stringBuffer.append(this.TEXT_34);
            }
            stringBuffer.append(this.TEXT_35);
        }
        stringBuffer.append(this.TEXT_36);
        return stringBuffer.toString();
    }
}

