/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.client.api.converter.utils;

import java.util.Locale;
import java.util.regex.Pattern;
import org.apache.commons.lang.StringUtils;
import org.eclipse.jubula.client.core.model.IParamDescriptionPO;
import org.eclipse.jubula.client.core.model.IParameterInterfacePO;
import org.eclipse.jubula.client.ui.rcp.views.dataset.AbstractDataSetPage;

public class ParamUtils {
    private static Pattern parameter = Pattern.compile("^=([a-zA-Z0-9_]+)");
    private static Pattern parameterWithBrackets = Pattern.compile("^=\\{([a-zA-Z0-9_]+)\\}");
    private static Pattern multipleParameters = Pattern.compile(".*=.*=.*");
    private static Pattern variable = Pattern.compile(".*\\$.*");
    private static Pattern function = Pattern.compile(".*\\?[a-zA-Z_]+\\(.*?");

    private ParamUtils() {
    }

    public static String getValueForParam(IParameterInterfacePO node, IParamDescriptionPO param, int row, Locale locale) {
        String paramType = param.getType();
        String value = AbstractDataSetPage.getGuiStringForParamValue((IParameterInterfacePO)node, (IParamDescriptionPO)param, (int)row, (Locale)locale);
        if (value == null) {
            value = "null /*TODO: check*/";
        } else if (StringUtils.isBlank((String)(value = ParamUtils.executeEscapes(value)))) {
            value = "\"\"";
        } else {
            if (multipleParameters.matcher(value).matches()) {
                return "null // TODO: Parameter concatenation: \"" + value + "\"\n";
            }
            if (variable.matcher(value).matches()) {
                return "null /* TODO: Variable: \"" + value + "\" */";
            }
            if (function.matcher(value).matches()) {
                return "null /* TODO: Function: \"" + value + "\" */";
            }
            if (parameterWithBrackets.matcher(value).matches()) {
                value = value.replaceAll(parameterWithBrackets.pattern(), "$1");
            } else if (parameter.matcher(value).matches()) {
                value = value.replaceAll(parameter.pattern(), "$1");
            } else if (paramType.equals("java.lang.String")) {
                value = "\"" + value + "\"";
            } else if (paramType.equals("guidancer.datatype.Variable")) {
                value = "null /* TODO: Potential Variable assignment: " + value + "*/";
            }
        }
        return value;
    }

    private static String executeEscapes(String value) {
        String adjustedValue = value;
        adjustedValue = adjustedValue.replace("\\", "\\\\");
        adjustedValue = adjustedValue.replace("\"", "\\\"");
        adjustedValue = adjustedValue.replace("'", "\\'");
        return adjustedValue;
    }
}

