/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.client.api.ui.handlers;

import java.io.BufferedWriter;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Serializable;
import java.util.HashMap;
import java.util.List;
import java.util.SortedMap;
import java.util.TreeMap;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jubula.client.api.ui.utils.OMAssociation;
import org.eclipse.jubula.client.core.businessprocess.IComponentNameMapper;
import org.eclipse.jubula.client.core.model.IAUTMainPO;
import org.eclipse.jubula.client.core.model.IObjectMappingAssoziationPO;
import org.eclipse.jubula.client.core.model.IObjectMappingCategoryPO;
import org.eclipse.jubula.client.core.model.IObjectMappingPO;
import org.eclipse.jubula.client.core.model.LogicComponentNotManagedException;
import org.eclipse.jubula.client.internal.utils.SerilizationUtils;
import org.eclipse.jubula.client.ui.handlers.AbstractHandler;
import org.eclipse.jubula.client.ui.rcp.editors.ObjectMappingMultiPageEditor;
import org.eclipse.jubula.client.ui.rcp.utils.Utils;
import org.eclipse.jubula.client.ui.utils.ErrorHandlingUtil;
import org.eclipse.jubula.toolkit.client.api.ui.internal.OMClassGenerator;
import org.eclipse.jubula.tools.internal.exception.JBException;
import org.eclipse.jubula.tools.internal.messagehandling.MessageIDs;
import org.eclipse.jubula.tools.internal.objects.ComponentIdentifier;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.handlers.HandlerUtil;

public class ExportObjectMappingHandler
extends AbstractHandler {
    private SortedMap<String, String> m_map = new TreeMap<String, String>();
    private IComponentNameMapper m_compMapper;
    private OMClassGenerator m_omClassGenerator = new OMClassGenerator();

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Object executeImpl(ExecutionEvent event) {
        IWorkbenchPart activePart = HandlerUtil.getActivePart((ExecutionEvent)event);
        if (!(activePart instanceof ObjectMappingMultiPageEditor)) return null;
        ObjectMappingMultiPageEditor omEditor = (ObjectMappingMultiPageEditor)activePart;
        IAUTMainPO aut = omEditor.getAut();
        int exportType = this.determineExportType();
        if (exportType == -1) return null;
        FileDialog saveDialog = this.createSaveDialog(aut, exportType);
        String path = saveDialog.open();
        if (path == null) return null;
        Utils.storeLastDirPath((String)saveDialog.getFilterPath());
        this.fillMap(omEditor, aut);
        OMAssociation omAssociations = this.generateEncodedAssociations();
        omAssociations.setTargetClassName(saveDialog.getFileName());
        try {
            Throwable throwable = null;
            Object var10_12 = null;
            try (BufferedWriter writer = new BufferedWriter(new FileWriter(path));){
                switch (exportType) {
                    case 0: {
                        writer.append(this.m_omClassGenerator.generate(omAssociations));
                        return null;
                    }
                    case 1: {
                        writer.append(omAssociations.getEncodedAssociations());
                        return null;
                    }
                }
                return null;
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                    throw throwable;
                }
                if (throwable == throwable2) throw throwable;
                throwable.addSuppressed(throwable2);
                throw throwable;
            }
        }
        catch (IOException e) {
            ErrorHandlingUtil.createMessageDialog((JBException)new JBException(e.getMessage(), (Throwable)e, MessageIDs.E_FILE_NO_PERMISSION));
        }
        return null;
    }

    private void fillMap(ObjectMappingMultiPageEditor omEditor, IAUTMainPO aut) {
        IObjectMappingPO objMap = aut.getObjMap();
        IObjectMappingCategoryPO mappedCategory = objMap.getMappedCategory();
        this.m_compMapper = omEditor.getEditorHelper().getEditSupport().getCompMapper();
        try {
            this.writeAssociationsToMap(objMap, mappedCategory);
        }
        catch (IOException | LogicComponentNotManagedException e) {
            ErrorHandlingUtil.createMessageDialog((JBException)new JBException(e.getMessage(), e, MessageIDs.E_EXPORT_OM_ERROR));
        }
    }

    private FileDialog createSaveDialog(IAUTMainPO aut, int exportType) {
        String fileName = "";
        String fileExtension = "";
        switch (exportType) {
            case 0: {
                fileExtension = ".java";
                fileName = "OM" + fileExtension;
                break;
            }
            case 1: {
                fileExtension = ".properties";
                fileName = "objectMapping_" + aut.getName() + fileExtension;
                break;
            }
        }
        FileDialog saveDialog = new FileDialog(this.getActiveShell(), 8192);
        saveDialog.setFileName(fileName);
        saveDialog.setFilterExtensions(new String[]{"*" + fileExtension});
        saveDialog.setOverwrite(true);
        String filterPath = Utils.getLastDirPath();
        saveDialog.setFilterPath(filterPath);
        return saveDialog;
    }

    private int determineExportType() {
        String dialogTitle = "Choose Export Type";
        String dialogMessage = "What do you prefer?";
        MessageDialog dialog = new MessageDialog(this.getActiveShell(), dialogTitle, null, dialogMessage, 3, new String[]{"Java Class", "Properties File"}, 0);
        return dialog.open();
    }

    private OMAssociation generateEncodedAssociations() {
        StringBuffer encodedAssociations = new StringBuffer();
        HashMap<String, String> identifierMap = new HashMap<String, String>();
        for (String key : this.m_map.keySet()) {
            String value = (String)this.m_map.get(key);
            encodedAssociations.append(String.valueOf(key) + "=" + value + "\n");
            identifierMap.put(key, this.translateToJavaIdentifier(key));
        }
        return new OMAssociation(encodedAssociations, identifierMap);
    }

    private String translateToJavaIdentifier(String key) {
        String[] exceptions;
        String modifiedKey = key;
        String[] stringArray = exceptions = new String[]{".", " ", "\\", "/", "*", ":", "[", "]", "(", ")", "=", "+", "-", "|"};
        int n = exceptions.length;
        int n2 = 0;
        while (n2 < n) {
            String exception = stringArray[n2];
            modifiedKey = modifiedKey.replace(exception, "_");
            ++n2;
        }
        return modifiedKey;
    }

    private void writeAssociationsToMap(IObjectMappingPO objMap, IObjectMappingCategoryPO category) throws LogicComponentNotManagedException, IOException {
        List subcategoryList = category.getUnmodifiableCategoryList();
        if (!subcategoryList.isEmpty()) {
            for (IObjectMappingCategoryPO subcategory : subcategoryList) {
                this.writeAssociationsToMap(objMap, subcategory);
            }
        }
        for (IObjectMappingAssoziationPO assoziation : category.getUnmodifiableAssociationList()) {
            String compUUID = (String)assoziation.getLogicalNames().get(0);
            String compName = this.m_compMapper.getCompNameCache().getName(compUUID);
            ComponentIdentifier identifier = (ComponentIdentifier)objMap.getTechnicalName(compUUID);
            this.m_map.put(compName, SerilizationUtils.encode((Serializable)identifier));
        }
    }
}

