/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.client.toolkit.ui.view;

import java.util.Iterator;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.StringUtils;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.jubula.client.core.utils.StringHelper;
import org.eclipse.jubula.client.ui.constants.IconConstants;
import org.eclipse.jubula.client.ui.filter.JBPatternFilter;
import org.eclipse.jubula.client.ui.rcp.filter.JBFilteredTree;
import org.eclipse.jubula.client.ui.rcp.provider.contentprovider.AbstractTreeViewContentProvider;
import org.eclipse.jubula.client.ui.rcp.provider.labelprovider.GeneralLabelProvider;
import org.eclipse.jubula.toolkit.common.xml.businessprocess.ComponentBuilder;
import org.eclipse.jubula.tools.internal.i18n.CompSystemI18n;
import org.eclipse.jubula.tools.internal.xml.businessmodell.Action;
import org.eclipse.jubula.tools.internal.xml.businessmodell.CompSystem;
import org.eclipse.jubula.tools.internal.xml.businessmodell.Component;
import org.eclipse.jubula.tools.internal.xml.businessmodell.ConcreteComponent;
import org.eclipse.jubula.tools.internal.xml.businessmodell.Param;
import org.eclipse.jubula.tools.internal.xml.businessmodell.ParamValueSet;
import org.eclipse.jubula.tools.internal.xml.businessmodell.ToolkitDescriptor;
import org.eclipse.jubula.tools.internal.xml.businessmodell.ValueSetElement;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.dialogs.PatternFilter;
import org.eclipse.ui.part.ViewPart;

public class ToolkitOverView
extends ViewPart {
    private static final CompSystem COMP_SYSTEM = ComponentBuilder.getInstance().getCompSystem();
    private TreeViewer m_viewer;

    public void createPartControl(Composite parent) {
        JBFilteredTree ft = new JBFilteredTree(parent, 2818, (PatternFilter)new JBPatternFilter(), true);
        this.setTreeViewer(ft.getViewer());
        TreeViewer treeViewer = this.getTreeViewer();
        treeViewer.setContentProvider((IContentProvider)new OverViewContentProvider());
        treeViewer.setLabelProvider((IBaseLabelProvider)new OverViewLabelProvider());
        treeViewer.setSorter(new ViewerSorter());
        treeViewer.setInput((Object)COMP_SYSTEM);
        this.getSite().setSelectionProvider((ISelectionProvider)treeViewer);
    }

    private TreeViewer getTreeViewer() {
        return this.m_viewer;
    }

    private void setTreeViewer(TreeViewer viewer) {
        this.m_viewer = viewer;
    }

    public void setFocus() {
        this.getTreeViewer().getTree().setFocus();
    }

    private final class OverViewContentProvider
    extends AbstractTreeViewContentProvider {
        private OverViewContentProvider() {
        }

        public Object[] getChildren(Object parent) {
            if (parent instanceof CompSystem) {
                CompSystem compSystem = (CompSystem)parent;
                return compSystem.getAllToolkitDescriptors().toArray();
            }
            if (parent instanceof ToolkitDescriptor) {
                ToolkitDescriptor toolkitDescriptor = (ToolkitDescriptor)parent;
                return COMP_SYSTEM.getComponents(toolkitDescriptor.getToolkitID(), true).toArray();
            }
            if (parent instanceof Component) {
                Component component = (Component)parent;
                return component.getActions().toArray();
            }
            if (parent instanceof Action) {
                Action action = (Action)parent;
                return action.getParams().toArray();
            }
            return ArrayUtils.EMPTY_OBJECT_ARRAY;
        }

        public Object getParent(Object element) {
            return null;
        }
    }

    private final class OverViewLabelProvider
    extends GeneralLabelProvider {
        private OverViewLabelProvider() {
        }

        public String getText(Object element) {
            StringHelper sh = StringHelper.getInstance();
            if (element instanceof ToolkitDescriptor) {
                ToolkitDescriptor parentDescriptor;
                ToolkitDescriptor toolkitDescriptor = (ToolkitDescriptor)element;
                StringBuilder sb = new StringBuilder(toolkitDescriptor.getName());
                String parent = toolkitDescriptor.getIncludes();
                if (!StringUtils.isBlank((String)parent) && (parentDescriptor = COMP_SYSTEM.getToolkitDescriptor(parent)) != null) {
                    sb.append(" --> ");
                    sb.append(parentDescriptor.getName());
                }
                return sb.toString();
            }
            if (element instanceof Component) {
                ConcreteComponent concreteComponent;
                String componentClass;
                Component component = (Component)element;
                StringBuilder sb = new StringBuilder(sh.get(component.getType(), true));
                if (component instanceof ConcreteComponent && !StringUtils.isBlank((String)(componentClass = (concreteComponent = (ConcreteComponent)component).getComponentClass().getName()))) {
                    sb.append(" - ");
                    sb.append(componentClass);
                }
                return sb.toString();
            }
            if (element instanceof Action) {
                Action action = (Action)element;
                return sh.get(action.getName(), true);
            }
            if (element instanceof Param) {
                Param param = (Param)element;
                StringBuilder sb = new StringBuilder();
                sb.append(CompSystemI18n.getString((String)param.getType()));
                sb.append(" : ");
                sb.append(sh.get(param.getName(), true));
                if (param.hasValueSet()) {
                    sb.append(" [");
                    ParamValueSet valueSet = param.getValueSet();
                    Iterator iterator = valueSet.iterator();
                    while (iterator.hasNext()) {
                        sb.append(CompSystemI18n.getString((String)((ValueSetElement)iterator.next()).getValue(), (boolean)true));
                        if (!iterator.hasNext()) continue;
                        sb.append(", ");
                    }
                    sb.append("]");
                }
                return sb.toString();
            }
            return super.getText(element);
        }

        public Image getImage(Object element) {
            if (element instanceof ToolkitDescriptor) {
                return IconConstants.CATEGORY_IMAGE;
            }
            if (element instanceof Component) {
                ConcreteComponent concreteComponent;
                String componentClass;
                if (element instanceof ConcreteComponent && !StringUtils.isBlank((String)(componentClass = (concreteComponent = (ConcreteComponent)element).getComponentClass().getName()))) {
                    return IconConstants.TECHNICAL_NAME_IMAGE;
                }
                return IconConstants.LOGICAL_NAME_IMAGE;
            }
            if (element instanceof Action) {
                return IconConstants.CAP_IMAGE;
            }
            if (element instanceof Param) {
                return IconConstants.UP_ARROW_DIS_IMAGE;
            }
            return null;
        }
    }
}

