/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.client.ui.rcp.controllers.propertysources;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.commons.lang.Validate;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jubula.client.core.businessprocess.CapBP;
import org.eclipse.jubula.client.core.businessprocess.ComponentNamesBP;
import org.eclipse.jubula.client.core.businessprocess.IComponentNameMapper;
import org.eclipse.jubula.client.core.businessprocess.IParamNameMapper;
import org.eclipse.jubula.client.core.businessprocess.IWritableComponentNameMapper;
import org.eclipse.jubula.client.core.businessprocess.ParamNameBP;
import org.eclipse.jubula.client.core.events.DataEventDispatcher;
import org.eclipse.jubula.client.core.model.ICapPO;
import org.eclipse.jubula.client.core.model.INodePO;
import org.eclipse.jubula.client.core.model.IParamDescriptionPO;
import org.eclipse.jubula.client.core.model.IParamNodePO;
import org.eclipse.jubula.client.core.model.IParameterInterfacePO;
import org.eclipse.jubula.client.core.model.ISpecTestCasePO;
import org.eclipse.jubula.client.core.persistence.GeneralStorage;
import org.eclipse.jubula.client.core.persistence.IncompatibleTypeException;
import org.eclipse.jubula.client.core.persistence.NodePM;
import org.eclipse.jubula.client.core.persistence.PMException;
import org.eclipse.jubula.client.core.utils.GuiParamValueConverter;
import org.eclipse.jubula.client.core.utils.IParamValueValidator;
import org.eclipse.jubula.client.core.utils.NullValidator;
import org.eclipse.jubula.client.core.utils.StringHelper;
import org.eclipse.jubula.client.ui.i18n.Messages;
import org.eclipse.jubula.client.ui.rcp.Plugin;
import org.eclipse.jubula.client.ui.rcp.businessprocess.WorkingLanguageBP;
import org.eclipse.jubula.client.ui.rcp.controllers.PMExceptionHandler;
import org.eclipse.jubula.client.ui.rcp.controllers.propertydescriptors.PopupCompNameTextPropertyDescriptor;
import org.eclipse.jubula.client.ui.rcp.controllers.propertysources.AbstractNodePropertySource;
import org.eclipse.jubula.client.ui.rcp.controllers.propertysources.AbstractPropertySource;
import org.eclipse.jubula.client.ui.rcp.editors.IJBEditor;
import org.eclipse.jubula.client.ui.rcp.factory.TestDataControlFactory;
import org.eclipse.jubula.client.ui.rcp.provider.labelprovider.ParameterValueLabelProvider;
import org.eclipse.jubula.client.ui.utils.ErrorHandlingUtil;
import org.eclipse.jubula.toolkit.common.xml.businessprocess.ComponentBuilder;
import org.eclipse.jubula.tools.internal.exception.Assert;
import org.eclipse.jubula.tools.internal.exception.JBException;
import org.eclipse.jubula.tools.internal.xml.businessmodell.Action;
import org.eclipse.jubula.tools.internal.xml.businessmodell.CompSystem;
import org.eclipse.jubula.tools.internal.xml.businessmodell.Component;
import org.eclipse.jubula.tools.internal.xml.businessmodell.ConcreteComponent;
import org.eclipse.jubula.tools.internal.xml.businessmodell.Param;
import org.eclipse.jubula.tools.internal.xml.businessmodell.ValueSetElement;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.views.properties.ComboBoxPropertyDescriptor;
import org.eclipse.ui.views.properties.IPropertyDescriptor;
import org.eclipse.ui.views.properties.PropertyDescriptor;
import org.eclipse.ui.views.properties.TextPropertyDescriptor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CapGUIPropertySource
extends AbstractNodePropertySource {
    public static final String P_ELEMENT_DISPLAY_COMPNAME = Messages.CapGUIPropertySourceComponentName;
    public static final String P_ELEMENT_DISPLAY_COMPTYPE = Messages.CapGUIPropertySourceCompType;
    public static final String P_ELEMENT_DISPLAY_STEPNAME = Messages.CapGUIPropertySourceStepName;
    public static final String P_ELEMENT_PARAMS = "Parameters";
    public static final String P_ELEMENT_DISPLAY_PARAMS = Messages.CapGUIPropertySourceParams;
    public static final String P_ELEMENT_DISPLAY_ACTIONTYPE = Messages.CapGUIPropertySourceActionType;
    public static final String P_ELEMENT_DISPLAY_PARAMETERNAME = Messages.CapGUIPropertySourceParamName;
    public static final String P_ELEMENT_DISPLAY_PARAMETERTYPE = Messages.CapGUIPropertySourceParamType;
    public static final String P_ELEMENT_DISPLAY_PARAMETERVALUE = Messages.CapGUIPropertySourceParamValue;
    public static final String P_COMPONENT_CAT = Messages.CapGUIPropertySourceComponent;
    public static final String P_ACTION_CAT = Messages.CapGUIPropertySourceAction;
    public static final String P_PARAMETER_CAT = Messages.CapGUIPropertySourceParameter;
    static final Logger LOG = LoggerFactory.getLogger(CapGUIPropertySource.class);
    private static String[] componentTypes;
    private static String[] componentTypesSubList;
    private String[] m_parameterNames;
    private String[] m_parameterTypes;
    private String[] m_actionTypes;
    private String[] m_actionTypesSubList;
    private final ActionTypeController m_actionTypeController = new ActionTypeController();
    private List<ParameterNameController> m_paramNameControllerList = new ArrayList<ParameterNameController>();
    private List<ParameterTypeController> m_paramTypeControllerList = new ArrayList<ParameterTypeController>();
    private List<ParameterValueController> m_paramValueControllerList = new ArrayList<ParameterValueController>();
    private IPropertyDescriptor m_namePropDesc = null;
    private IPropertyDescriptor m_compTypePropDesc = null;
    private IPropertyDescriptor m_compNamePropDesc = null;
    private IPropertyDescriptor m_actionPropDesc = null;
    private List<IPropertyDescriptor> m_initializedParamDescriptors = new ArrayList<IPropertyDescriptor>();

    public CapGUIPropertySource(ICapPO cap) {
        super((INodePO)cap);
        this.initCompTypes();
        this.initActionTypes();
        this.initParameters();
        this.initPropDescriptor();
    }

    private void initParameters() {
        Map map = StringHelper.getInstance().getMap();
        ArrayList<String> paramNameList = new ArrayList<String>();
        ArrayList<String> paramTypeList = new ArrayList<String>();
        ArrayList<String> paramTypeSubList = new ArrayList<String>();
        ICapPO cap = (ICapPO)this.getPoNode();
        Action action = CapBP.getAction((ICapPO)cap);
        String[] stringArray = action.getParamNames();
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String paramName = stringArray[n2];
            paramNameList.add((String)map.get(paramName));
            Param parameter = action.findParam(paramName);
            String paramType = parameter.getType();
            paramTypeList.add((String)map.get(paramType));
            paramTypeSubList.add(paramType);
            ++n2;
        }
        this.m_parameterNames = paramNameList.toArray(new String[paramNameList.size()]);
        this.m_parameterTypes = paramTypeList.toArray(new String[paramTypeList.size()]);
    }

    private void initCompTypes() {
        String[] toolkitComponents;
        ArrayList<String> tmpList = new ArrayList<String>();
        ArrayList<String> tmpSubList = new ArrayList<String>();
        Map map = StringHelper.getInstance().getMap();
        HashMap<String, String> helpMap = new HashMap<String, String>();
        CompSystem compSystem = ComponentBuilder.getInstance().getCompSystem();
        String[] stringArray = toolkitComponents = compSystem.getComponentTypes(GeneralStorage.getInstance().getProject().getToolkit());
        int n = toolkitComponents.length;
        int n2 = 0;
        while (n2 < n) {
            String currComponent = stringArray[n2];
            String compType = (String)map.get(currComponent);
            if (compSystem.findComponent(currComponent).isVisible()) {
                tmpList.add(compType);
                helpMap.put(compType, currComponent);
            }
            ++n2;
        }
        componentTypes = tmpList.toArray(new String[tmpList.size()]);
        Arrays.sort(componentTypes);
        stringArray = componentTypes;
        n = componentTypes.length;
        n2 = 0;
        while (n2 < n) {
            String compType = stringArray[n2];
            tmpSubList.add((String)helpMap.get(compType));
            ++n2;
        }
        componentTypesSubList = tmpSubList.toArray(new String[tmpSubList.size()]);
    }

    private void initActionTypes() {
        ArrayList<String> tmpList = new ArrayList<String>();
        ArrayList<String> tmpSubList = new ArrayList<String>();
        Map map = StringHelper.getInstance().getMap();
        HashMap<String, String> helpMap = new HashMap<String, String>();
        CompSystem compSystem = ComponentBuilder.getInstance().getCompSystem();
        String compType = ((ICapPO)this.getPoNode()).getComponentType();
        Component component = compSystem.findComponent(compType);
        List actions = component.getActions();
        for (Object action : actions) {
            String actionName = String.valueOf(map.get(action.getName()));
            tmpList.add(actionName);
            helpMap.put(actionName, action.getName());
        }
        this.m_actionTypes = tmpList.toArray(new String[tmpList.size()]);
        Arrays.sort(this.m_actionTypes);
        String[] stringArray = this.m_actionTypes;
        int n = this.m_actionTypes.length;
        int n2 = 0;
        while (n2 < n) {
            Object action;
            action = stringArray[n2];
            tmpSubList.add((String)helpMap.get(action));
            ++n2;
        }
        this.m_actionTypesSubList = tmpSubList.toArray(new String[tmpSubList.size()]);
    }

    private IPropertyDescriptor getActionPropDesc() {
        if (this.m_actionPropDesc == null) {
            ComboBoxPropertyDescriptor cbpd = new ComboBoxPropertyDescriptor((Object)this.m_actionTypeController, P_ELEMENT_DISPLAY_ACTIONTYPE, this.m_actionTypes);
            cbpd.setLabelProvider((ILabelProvider)new LabelProvider(){

                public String getText(Object element) {
                    if (element instanceof Integer) {
                        return CapGUIPropertySource.this.m_actionTypes[(Integer)element];
                    }
                    Assert.notReached((String)(String.valueOf(Messages.WrongElementType) + "."));
                    return String.valueOf(element);
                }
            });
            cbpd.setCategory(P_ACTION_CAT);
            this.m_actionPropDesc = cbpd;
        }
        return this.m_actionPropDesc;
    }

    private IPropertyDescriptor getCompNamePropDesc() {
        if (this.m_compNamePropDesc == null) {
            ConcreteComponent concrete;
            PopupCompNameTextPropertyDescriptor pd = null;
            ICapPO capPO = (ICapPO)this.getPoNode();
            Component comp = ComponentBuilder.getInstance().getCompSystem().findComponent(capPO.getComponentType());
            if (comp.isConcrete() && (concrete = (ConcreteComponent)comp).hasDefaultMapping()) {
                return null;
            }
            if (pd == null) {
                pd = new PopupCompNameTextPropertyDescriptor(new ComponentNameController(), P_ELEMENT_DISPLAY_COMPNAME, capPO.getComponentType());
            }
            pd.setCategory(P_COMPONENT_CAT);
            this.m_compNamePropDesc = pd;
        }
        return this.m_compNamePropDesc;
    }

    private IPropertyDescriptor getCompTypePropDesc() {
        if (this.m_compTypePropDesc == null) {
            ComboBoxPropertyDescriptor cbpd = new ComboBoxPropertyDescriptor((Object)new ComponentTypeController(), P_ELEMENT_DISPLAY_COMPTYPE, componentTypes);
            cbpd.setLabelProvider((ILabelProvider)new LabelProvider(){

                public String getText(Object element) {
                    if (element instanceof Integer) {
                        Integer index = (Integer)element;
                        return index < componentTypes.length ? componentTypes[index] : "";
                    }
                    Assert.notReached((String)(String.valueOf(Messages.WrongElementType) + "."));
                    return String.valueOf(element);
                }
            });
            cbpd.setCategory(P_COMPONENT_CAT);
            this.m_compTypePropDesc = cbpd;
        }
        return this.m_compTypePropDesc;
    }

    private IPropertyDescriptor getStepNamePropDesc() {
        if (this.m_namePropDesc == null) {
            this.m_namePropDesc = new TextPropertyDescriptor((Object)new AbstractNodePropertySource.ElementNameController(this), P_ELEMENT_DISPLAY_STEPNAME);
        }
        return this.m_namePropDesc;
    }

    @Override
    protected void initPropDescriptor() {
        Map map = StringHelper.getInstance().getMap();
        this.clearPropertyDescriptors();
        this.addPropertyDescriptor(this.getStepNamePropDesc());
        super.initPropDescriptor();
        this.addPropertyDescriptor(this.getCompTypePropDesc());
        IPropertyDescriptor propdesc = this.getCompNamePropDesc();
        if (propdesc != null) {
            this.addPropertyDescriptor(this.getCompNamePropDesc());
        }
        this.addPropertyDescriptor(this.getActionPropDesc());
        if (this.m_initializedParamDescriptors.isEmpty()) {
            this.clearControllerLists();
            IParamNameMapper activeParamNameMapper = this.getActiveParamNameMapper();
            IParamNodePO paramNode = this.getParamNode();
            for (IParamDescriptionPO desc : paramNode.getParameterList()) {
                ParameterValueController paramCtrl = new ParameterValueController((AbstractNodePropertySource)this, desc, activeParamNameMapper);
                this.m_paramValueControllerList.add(paramCtrl);
                Action action = CapBP.getAction((ICapPO)((ICapPO)this.getPoNode()));
                ArrayList<String> values = new ArrayList<String>();
                Param param = action.findParam(desc.getUniqueId());
                Iterator iter = param.valueSetIterator();
                while (iter.hasNext()) {
                    values.add((String)map.get(((ValueSetElement)iter.next()).getValue()));
                }
                String[] valArray = values.toArray(new String[values.size()]);
                PropertyDescriptor descr = TestDataControlFactory.createValuePropertyDescriptor(paramCtrl, this.getParameterNameDescr(desc), valArray, param.getValueSet().isCombinable());
                descr.setLabelProvider((ILabelProvider)new ParameterValueLabelProvider(INCOMPL_DATA_IMAGE));
                descr.setCategory(P_PARAMETER_CAT);
                this.m_initializedParamDescriptors.add((IPropertyDescriptor)descr);
            }
        }
        this.addPropertyDescriptor(this.m_initializedParamDescriptors);
    }

    private void clearControllerLists() {
        this.m_paramNameControllerList.clear();
        this.m_paramTypeControllerList.clear();
    }

    void updateModel() {
        this.m_compNamePropDesc = null;
        this.m_actionPropDesc = null;
        this.initActionTypes();
        this.m_actionTypeController.setProperty(0);
        this.updateParameters();
    }

    void updateParameters() {
        this.m_initializedParamDescriptors.clear();
        this.initParameters();
        int paramNameControllerListSize = this.m_paramNameControllerList.size();
        int i = 0;
        while (i < paramNameControllerListSize) {
            ParameterNameController paramNameController = this.m_paramNameControllerList.get(i);
            if (this.m_parameterNames == null || this.m_parameterNames.length == 0) {
                paramNameController.setProperty("");
            } else {
                paramNameController.setProperty(this.m_parameterNames[0]);
            }
            ParameterTypeController paramTypeController = this.m_paramTypeControllerList.get(i);
            if (this.m_parameterTypes == null || this.m_parameterTypes.length == 0) {
                paramTypeController.setProperty("");
            } else {
                paramTypeController.setProperty(this.m_parameterTypes[0]);
            }
            ++i;
        }
        if (this.getParamNode().getDataManager().getDataSets().size() > 1) {
            this.getParamNode().getDataManager().removeDataSet(0);
        }
    }

    IParamNodePO getParamNode() {
        return (IParamNodePO)this.getPoNode();
    }

    public ActionTypeController getActionTypeController() {
        return this.m_actionTypeController;
    }

    public class ActionTypeController
    extends AbstractPropertySource.AbstractPropertyController {
        public boolean setProperty(Object value) {
            ICapPO cap = (ICapPO)CapGUIPropertySource.this.getPoNode();
            cap.clearTestData();
            cap.setActionName(CapGUIPropertySource.this.m_actionTypesSubList[(Integer)value]);
            this.setDefaultValues(cap);
            DataEventDispatcher.getInstance().firePropertyChanged(false);
            CapGUIPropertySource.this.updateParameters();
            return true;
        }

        public Object getProperty() {
            Map map = StringHelper.getInstance().getMap();
            ICapPO cap = (ICapPO)CapGUIPropertySource.this.getPoNode();
            String action = String.valueOf(map.get(cap.getActionName()));
            int actionTypesLength = CapGUIPropertySource.this.m_actionTypes.length;
            int i = 0;
            while (i < actionTypesLength) {
                if (CapGUIPropertySource.this.m_actionTypes[i].equals(action)) {
                    return i;
                }
                ++i;
            }
            return 0;
        }

        @Override
        public Image getImage() {
            ICapPO capPO = (ICapPO)CapGUIPropertySource.this.getPoNode();
            if (capPO.getMetaAction().isDeprecated()) {
                return DEPRECATED_IMAGE;
            }
            return DEFAULT_IMAGE;
        }

        private void setDefaultValues(ICapPO cap) {
            for (Object o : cap.getMetaAction().getParams()) {
                Param param = (Param)o;
                if (param.getDefaultValue() == null) continue;
                IParamDescriptionPO desc = cap.getParameterForUniqueId(param.getName());
                Locale locale = WorkingLanguageBP.getInstance().getWorkingLanguage();
                GuiParamValueConverter conv = new GuiParamValueConverter(param.getDefaultValue(), (IParameterInterfacePO)cap, locale, desc, (IParamValueValidator)new NullValidator());
                CapGUIPropertySource.this.getTestCaseParamBP().startParameterUpdate(conv, locale, 0, (IParamNameMapper)ParamNameBP.getInstance());
            }
        }
    }

    public class ComponentNameController
    extends AbstractPropertySource.AbstractPropertyController {
        public boolean setProperty(Object value) {
            boolean isCompNameChangedAndSpecTCReused = false;
            IWritableComponentNameMapper compMapper = CapGUIPropertySource.this.getActiveComponentNameMapper();
            Validate.notNull((Object)compMapper);
            ICapPO cap = (ICapPO)CapGUIPropertySource.this.getPoNode();
            try {
                ComponentNamesBP.getInstance().setCompName(cap, String.valueOf(value), ComponentNamesBP.CompNameCreationContext.STEP, compMapper);
                ISpecTestCasePO specTc = (ISpecTestCasePO)CapGUIPropertySource.this.getPoNode().getParentNode();
                if (!NodePM.getInternalExecTestCases((String)specTc.getGuid(), (long)specTc.getParentProjectId()).isEmpty()) {
                    isCompNameChangedAndSpecTCReused = true;
                }
                DataEventDispatcher.getInstance().firePropertyChanged(isCompNameChangedAndSpecTCReused);
                return true;
            }
            catch (IncompatibleTypeException ite) {
                ErrorHandlingUtil.createMessageDialog((JBException)((Object)ite), (Object[])ite.getErrorMessageParams(), null);
            }
            catch (PMException e) {
                IEditorPart activeEditor = Plugin.getActiveEditor();
                if (activeEditor instanceof IJBEditor) {
                    PMExceptionHandler.handlePMExceptionForEditor(e, (IJBEditor)activeEditor);
                }
                PMExceptionHandler.handlePMExceptionForMasterSession(e);
            }
            return false;
        }

        public Object getProperty() {
            ICapPO cap = (ICapPO)CapGUIPropertySource.this.getPoNode();
            IComponentNameMapper compMapper = Plugin.getActiveCompMapper();
            String componentNameGuid = cap.getComponentName();
            if (componentNameGuid != null) {
                if (compMapper != null) {
                    return compMapper.getCompNameCache().getName(componentNameGuid);
                }
                return ComponentNamesBP.getInstance().getName(componentNameGuid);
            }
            return "";
        }
    }

    public class ComponentTypeController
    extends AbstractPropertySource.AbstractPropertyController {
        public boolean setProperty(Object value) {
            if (value == null) {
                return false;
            }
            int index = (Integer)value;
            if (index >= componentTypesSubList.length) {
                return false;
            }
            ICapPO capNode = (ICapPO)CapGUIPropertySource.this.getPoNode();
            capNode.clearTestData();
            String typeName = componentTypesSubList[index];
            capNode.setComponentType(typeName);
            capNode.setComponentName("");
            CapGUIPropertySource.this.updateModel();
            return true;
        }

        public Object getProperty() {
            return this.getIndexOfType();
        }

        @Override
        public Image getImage() {
            ICapPO capPO = (ICapPO)CapGUIPropertySource.this.getPoNode();
            if (capPO.getMetaComponentType().isDeprecated()) {
                return DEPRECATED_IMAGE;
            }
            return DEFAULT_IMAGE;
        }

        private Integer getIndexOfType() {
            ICapPO cap;
            Map map = StringHelper.getInstance().getMap();
            if (map.containsKey((cap = (ICapPO)CapGUIPropertySource.this.getPoNode()).getComponentType())) {
                String type = (String)map.get(cap.getComponentType());
                int componentTypesLength = componentTypes.length;
                int i = 0;
                while (i < componentTypesLength) {
                    if (componentTypes[i].equals(type)) {
                        return i;
                    }
                    ++i;
                }
            }
            return 0;
        }
    }

    public class ParameterNameController
    extends AbstractPropertySource.AbstractPropertyController {
        private final int m_id;
        private String m_name;

        public ParameterNameController(int id, String name) {
            this.m_id = id;
            this.m_name = name;
        }

        public boolean setProperty(Object value) {
            return true;
        }

        public Object getProperty() {
            List paramList = CapGUIPropertySource.this.getParamNode().getParameterList();
            if (paramList.size() > this.m_id) {
                return ((IParamDescriptionPO)paramList.get(this.m_id)).getName();
            }
            return "";
        }

        @Override
        public Image getImage() {
            return DEFAULT_IMAGE;
        }

        public String getName() {
            return this.m_name;
        }
    }

    public class ParameterTypeController
    extends AbstractPropertySource.AbstractPropertyController {
        private final int m_id;
        private String m_name;

        public ParameterTypeController(int id, String name) {
            this.m_id = id;
            this.m_name = name;
        }

        public String getName() {
            return this.m_name;
        }

        public boolean setProperty(Object value) {
            return true;
        }

        public Object getProperty() {
            Map map = StringHelper.getInstance().getMap();
            List paramList = CapGUIPropertySource.this.getParamNode().getParameterList();
            if (paramList != null && !paramList.isEmpty() && !"".equals(((IParamDescriptionPO)paramList.get(this.m_id)).getType())) {
                return map.get(((IParamDescriptionPO)paramList.get(this.m_id)).getType());
            }
            return "";
        }

        @Override
        public Image getImage() {
            return DEFAULT_IMAGE;
        }
    }

    public class ParameterValueController
    extends AbstractNodePropertySource.AbstractParamValueController {
        public ParameterValueController(AbstractNodePropertySource s, IParamDescriptionPO desc, IParamNameMapper paramNameMapper) {
            super(CapGUIPropertySource.this, s, desc, paramNameMapper);
        }
    }
}

