/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.client.ui.rcp.dialogs;

import org.apache.commons.lang.StringUtils;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jubula.client.core.model.ProjectVersion;
import org.eclipse.jubula.client.ui.rcp.i18n.Messages;
import org.eclipse.jubula.client.ui.rcp.widgets.CheckedIntText;
import org.eclipse.jubula.client.ui.rcp.widgets.CheckedProjectNameText;
import org.eclipse.jubula.client.ui.utils.LayoutUtil;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.graphics.FontMetrics;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public abstract class VersionComposite
extends Composite {
    private Text m_projectNameField;
    private Text m_versionQualifierField;
    private Text m_majorVersionField;
    private Text m_minorVersionField;
    private Text m_microVersionField;
    private boolean m_okAllowed = false;
    private int m_length = 255;

    public VersionComposite(Composite parent, int style, ProjectVersion version) {
        this(parent, style, version, false);
    }

    public VersionComposite(Composite parent, int style, ProjectVersion version, boolean withNameField) {
        super(parent, style);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 4;
        this.setLayout((Layout)gridLayout);
        GridData gridData = new GridData();
        gridData.grabExcessHorizontalSpace = false;
        gridData.grabExcessVerticalSpace = true;
        gridData.horizontalAlignment = 4;
        gridData.verticalAlignment = 1;
        this.setLayoutData(gridData);
        this.createNameField(this, withNameField);
        this.createVersionFields(this, version);
        this.checkIfVersionsAreCorrect();
        this.checkAndModifyEnablementOfFields();
    }

    private void createNameField(Composite composite, boolean withName) {
        if (!withName) {
            return;
        }
        GridData gridData = this.newGridData();
        new Label(composite, 0).setText(Messages.SaveProjectAsActionLabel);
        this.m_projectNameField = new CheckedProjectNameText(composite, 2052);
        gridData = this.newGridData();
        LayoutUtil.addToolTipAndMaxWidth((GridData)gridData, (Control)this.m_projectNameField);
        gridData.widthHint = 0;
        gridData.horizontalSpan = 3;
        gridData.horizontalAlignment = 4;
        this.m_projectNameField.setLayoutData((Object)gridData);
        this.m_projectNameField.setText(StringUtils.defaultString(null));
        this.m_projectNameField.setData("TEST_COMP_NAME", (Object)"VersionComposite.ProjectNameField");
        LayoutUtil.setMaxChar((Text)this.m_projectNameField, (int)this.m_length);
        this.m_projectNameField.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                VersionComposite.this.modifyVersionFieldAction();
            }
        });
    }

    private void createVersionFields(Composite area, ProjectVersion version) {
        new Label(area, 0).setText(Messages.CreateNewProjectVersionActionVersionNumbers);
        this.m_majorVersionField = new CheckedIntText(area, 2052, true, 0, Integer.MAX_VALUE);
        GridData gridData = this.newGridData();
        LayoutUtil.addToolTipAndMaxWidth((GridData)gridData, (Control)this.m_majorVersionField);
        gridData.widthHint = Dialog.convertWidthInCharsToPixels((FontMetrics)LayoutUtil.getFontMetrics((Control)this.m_majorVersionField), (int)6);
        this.m_majorVersionField.setLayoutData((Object)gridData);
        this.m_majorVersionField.setText(version.getMajorNumber() != null ? String.valueOf(version.getMajorNumber()) : "");
        LayoutUtil.setMaxChar((Text)this.m_majorVersionField, (int)this.m_length);
        this.m_majorVersionField.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                VersionComposite.this.modifyVersionFieldAction();
            }
        });
        this.m_majorVersionField.setData("TEST_COMP_NAME", (Object)"VersionComposite.MajorVersionField");
        this.m_minorVersionField = new CheckedIntText(area, 2052, true, 0, Integer.MAX_VALUE);
        gridData = this.newGridData();
        LayoutUtil.addToolTipAndMaxWidth((GridData)gridData, (Control)this.m_minorVersionField);
        gridData.widthHint = Dialog.convertWidthInCharsToPixels((FontMetrics)LayoutUtil.getFontMetrics((Control)this.m_minorVersionField), (int)6);
        this.m_minorVersionField.setLayoutData((Object)gridData);
        this.m_minorVersionField.setText(version.getMinorNumber() != null ? String.valueOf(version.getMinorNumber()) : "");
        LayoutUtil.setMaxChar((Text)this.m_minorVersionField, (int)this.m_length);
        this.m_minorVersionField.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                VersionComposite.this.modifyVersionFieldAction();
            }
        });
        this.m_minorVersionField.setData("TEST_COMP_NAME", (Object)"VersionComposite.MinorVersionField");
        this.m_microVersionField = new CheckedIntText(area, 2052, true, 0, Integer.MAX_VALUE);
        gridData = this.newGridData();
        LayoutUtil.addToolTipAndMaxWidth((GridData)gridData, (Control)this.m_microVersionField);
        gridData.widthHint = Dialog.convertWidthInCharsToPixels((FontMetrics)LayoutUtil.getFontMetrics((Control)this.m_microVersionField), (int)11);
        this.m_microVersionField.setLayoutData((Object)gridData);
        this.m_microVersionField.setText(version.getMicroNumber() != null ? String.valueOf(version.getMicroNumber()) : "");
        LayoutUtil.setMaxChar((Text)this.m_microVersionField, (int)this.m_length);
        this.m_microVersionField.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                VersionComposite.this.modifyVersionFieldAction();
            }
        });
        this.m_microVersionField.setData("TEST_COMP_NAME", (Object)"VersionComposite.MicroVersionField");
        new Label(area, 0).setText(Messages.CreateNewProjectVersionActionQualifierLabel);
        this.m_versionQualifierField = new Text(area, 2052);
        gridData = this.newGridData();
        LayoutUtil.addToolTipAndMaxWidth((GridData)gridData, (Control)this.m_versionQualifierField);
        gridData.widthHint = 0;
        gridData.horizontalSpan = 3;
        gridData.horizontalAlignment = 4;
        this.m_versionQualifierField.setLayoutData((Object)gridData);
        this.m_versionQualifierField.setText(StringUtils.defaultIfBlank((String)version.getVersionQualifier(), (String)""));
        LayoutUtil.setMaxChar((Text)this.m_versionQualifierField, (int)this.m_length);
        this.m_versionQualifierField.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                VersionComposite.this.modifyVersionFieldAction();
            }
        });
        this.m_versionQualifierField.setData("TEST_COMP_NAME", (Object)"VersionComposite.VersionQualifierField");
    }

    private GridData newGridData() {
        GridData gridData = new GridData();
        gridData.grabExcessHorizontalSpace = false;
        gridData.horizontalAlignment = 1;
        gridData.horizontalSpan = 1;
        return gridData;
    }

    public abstract Boolean isChangeAllowed();

    public abstract void setMessage(String var1);

    public abstract void modifiedAction();

    public boolean modifyVersionFieldAction() {
        boolean isCorrect = this.checkIfVersionsAreCorrect();
        this.checkAndModifyEnablementOfFields();
        if (isCorrect) {
            this.m_okAllowed = true;
            if (!this.isChangeAllowed().booleanValue()) {
                this.m_okAllowed = false;
                isCorrect = false;
            }
        } else {
            this.m_okAllowed = false;
        }
        this.modifiedAction();
        return isCorrect;
    }

    private void checkAndModifyEnablementOfFields() {
        if (StringUtils.isBlank((String)this.m_majorVersionField.getText())) {
            this.m_minorVersionField.setEnabled(false);
            this.m_microVersionField.setEnabled(false);
        } else {
            this.m_minorVersionField.setEnabled(true);
        }
        if (StringUtils.isBlank((String)this.m_minorVersionField.getText()) || !this.m_minorVersionField.isEnabled()) {
            this.m_microVersionField.setEnabled(false);
        } else {
            this.m_microVersionField.setEnabled(true);
        }
    }

    private boolean checkIfVersionsAreCorrect() {
        boolean isCorrect = false;
        try {
            boolean bl = isCorrect = StringUtils.isNotBlank((String)this.m_majorVersionField.getText()) || StringUtils.isNotBlank((String)this.m_versionQualifierField.getText());
            if (isCorrect && StringUtils.isNotBlank((String)this.m_minorVersionField.getText())) {
                isCorrect = StringUtils.isNotBlank((String)this.m_majorVersionField.getText());
            }
            if (isCorrect && StringUtils.isNotBlank((String)this.m_microVersionField.getText())) {
                isCorrect = StringUtils.isNotBlank((String)this.m_minorVersionField.getText()) && StringUtils.isNotBlank((String)this.m_majorVersionField.getText());
            }
        }
        catch (NumberFormatException numberFormatException) {}
        if (!isCorrect) {
            this.setMessage(Messages.CreateNewProjectVersionActionInvalidVersion);
        }
        return isCorrect;
    }

    public Integer getMajorFieldValue() {
        Integer value = null;
        try {
            value = Integer.parseInt(this.m_majorVersionField.getText());
        }
        catch (NumberFormatException numberFormatException) {}
        return value;
    }

    public Integer getMinorFieldValue() {
        Integer value = null;
        try {
            if (this.m_minorVersionField.isEnabled()) {
                value = Integer.parseInt(this.m_minorVersionField.getText());
            }
        }
        catch (NumberFormatException numberFormatException) {}
        return value;
    }

    public Integer getMicroFieldValue() {
        Integer value = null;
        try {
            if (this.m_microVersionField.isEnabled()) {
                value = Integer.parseInt(this.m_microVersionField.getText());
            }
        }
        catch (NumberFormatException numberFormatException) {}
        return value;
    }

    public String getQualifierFieldValue() {
        if (StringUtils.isBlank((String)this.m_versionQualifierField.getText())) {
            return null;
        }
        return StringUtils.trim((String)this.m_versionQualifierField.getText());
    }

    public String getProjectNameFieldValue() {
        if (this.m_projectNameField != null) {
            return this.m_projectNameField.getText();
        }
        return "";
    }

    public boolean isOKAllowed() {
        return this.m_okAllowed;
    }

    public ProjectVersion getVersion() {
        return new ProjectVersion(this.getMajorFieldValue(), this.getMinorFieldValue(), this.getMicroFieldValue(), this.getQualifierFieldValue());
    }
}

