/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.client.ui.rcp.handlers;

import java.util.HashSet;
import java.util.Set;
import javax.persistence.EntityManager;
import javax.persistence.EntityTransaction;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.jubula.client.core.model.IComponentNamePO;
import org.eclipse.jubula.client.core.persistence.GeneralStorage;
import org.eclipse.jubula.client.core.persistence.PMException;
import org.eclipse.jubula.client.core.persistence.Persistor;
import org.eclipse.jubula.client.ui.rcp.controllers.PMExceptionHandler;
import org.eclipse.jubula.client.ui.rcp.handlers.AbstractMergeComponentNameHandler;
import org.eclipse.jubula.tools.internal.exception.ProjectDeletedException;

public class MergeComponentNameInViewHandler
extends AbstractMergeComponentNameHandler {
    public Object executeImpl(ExecutionEvent event) {
        Set<IComponentNamePO> compNames = this.getComponentNames(this.getSelection());
        IComponentNamePO selectedCompNamePo = this.openDialog(compNames);
        if (selectedCompNamePo == null) {
            return null;
        }
        EntityManager masterSession = GeneralStorage.getInstance().getMasterSession();
        EntityTransaction tx = Persistor.instance().getTransaction(masterSession);
        HashSet<IComponentNamePO> inSessionCompNames = new HashSet<IComponentNamePO>();
        for (IComponentNamePO cn : compNames) {
            inSessionCompNames.add((IComponentNamePO)masterSession.find(cn.getClass(), (Object)cn.getId()));
        }
        this.performOperation(inSessionCompNames, selectedCompNamePo);
        try {
            Persistor.instance().commitTransaction(masterSession, tx);
            this.fireChangeEvents(inSessionCompNames);
        }
        catch (PMException e) {
            PMExceptionHandler.handlePMExceptionForMasterSession(e);
        }
        catch (ProjectDeletedException projectDeletedException) {
            PMExceptionHandler.handleProjectDeletedException();
        }
        return null;
    }
}

