/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.client.wiki.ui.utils;

import org.apache.commons.lang.StringUtils;
import org.eclipse.jubula.client.core.model.IProjectPO;
import org.eclipse.jubula.client.core.persistence.GeneralStorage;
import org.eclipse.mylyn.wikitext.core.WikiText;
import org.eclipse.mylyn.wikitext.core.parser.markup.MarkupLanguage;

public class ProjectMarkupUtil {
    private ProjectMarkupUtil() {
    }

    public static MarkupLanguage getProjectMarkupLanguage() {
        IProjectPO project = GeneralStorage.getInstance().getProject();
        if (project == null) {
            return ProjectMarkupUtil.getDefaultMarkupLanguage();
        }
        return ProjectMarkupUtil.getMarkupForFileName(project.getMarkupLanguage());
    }

    public static MarkupLanguage getMarkupForFileName(String markupLanguage) {
        if (StringUtils.isBlank((String)markupLanguage)) {
            return ProjectMarkupUtil.getDefaultMarkupLanguage();
        }
        return WikiText.getMarkupLanguageForFilename((String)markupLanguage);
    }

    public static MarkupLanguage getDefaultMarkupLanguage() {
        return WikiText.getMarkupLanguageForFilename((String)"mediawiki");
    }
}

