/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.communication.internal.message;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.jubula.communication.internal.message.CAPTestMessage;
import org.eclipse.jubula.communication.internal.message.MessageCap;
import org.eclipse.jubula.communication.internal.message.UnknownMessageException;
import org.eclipse.jubula.tools.internal.messagehandling.MessageIDs;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CAPTestMessageFactory {
    private static final Logger LOG = LoggerFactory.getLogger(CAPTestMessageFactory.class);
    private static Map<String, String> toolkitToTestMessageClassName = new HashMap<String, String>();

    static {
        toolkitToTestMessageClassName.put("com.bredexsw.guidancer.SwtToolkitPlugin", "org.eclipse.jubula.communication.internal.message.swt.CAPSwtTestMessage");
        toolkitToTestMessageClassName.put("com.bredexsw.guidancer.RcpToolkitPlugin", toolkitToTestMessageClassName.get("com.bredexsw.guidancer.SwtToolkitPlugin"));
        toolkitToTestMessageClassName.put("com.bredexsw.guidancer.SwingToolkitPlugin", "org.eclipse.jubula.communication.internal.message.swing.CAPSwingTestMessage");
        toolkitToTestMessageClassName.put("com.bredexsw.guidancer.HtmlToolkitPlugin", "org.eclipse.jubula.communication.internal.message.html.CAPHtmlTestMessage");
        toolkitToTestMessageClassName.put("ui.toolkit.WinToolkitPlugin", "org.eclipse.jubula.communication.internal.message.win.CAPWinTestMessage");
        toolkitToTestMessageClassName.put("ui.toolkit.WinAppsToolkitPlugin", "org.eclipse.jubula.communication.internal.message.win.CAPWinTestMessage");
        toolkitToTestMessageClassName.put("ui.toolkit.mobile.IOSToolkitPlugin", "org.eclipse.jubula.communication.internal.message.ios.IOSCAPTestMessage");
        toolkitToTestMessageClassName.put("org.eclipse.jubula.JavaFXToolkitPlugin", "org.eclipse.jubula.communication.internal.message.javafx.CAPJavaFXTestMessage");
    }

    private CAPTestMessageFactory() {
    }

    public static CAPTestMessage getCAPTestMessage(MessageCap messageCap, String autToolKit) throws UnknownMessageException {
        String messageClassName = "null";
        try {
            messageClassName = toolkitToTestMessageClassName.get(autToolKit);
            if (messageClassName != null) {
                Class<?> messageClass = Class.forName(messageClassName, false, CAPTestMessage.class.getClassLoader());
                if (!CAPTestMessage.class.isAssignableFrom(messageClass)) {
                    throw new UnknownMessageException(String.valueOf(messageClass.getName()) + "is not assignable to " + CAPTestMessage.class.getName(), MessageIDs.E_MESSAGE_NOT_ASSIGNABLE);
                }
                CAPTestMessage result = (CAPTestMessage)messageClass.newInstance();
                result.setMessageCap(messageCap);
                return result;
            }
            throw new UnknownMessageException("Creating a shared message instance for " + messageClassName + "failed: " + autToolKit, MessageIDs.E_MESSAGE_NOT_CREATED);
        }
        catch (ExceptionInInitializerError eiie) {
            CAPTestMessageFactory.throwUnknownMessageException(messageClassName, eiie);
        }
        catch (LinkageError le) {
            CAPTestMessageFactory.throwUnknownMessageException(messageClassName, le);
        }
        catch (ClassNotFoundException cnfe) {
            CAPTestMessageFactory.throwUnknownMessageException(messageClassName, cnfe);
        }
        catch (InstantiationException ie) {
            CAPTestMessageFactory.throwUnknownMessageException(messageClassName, ie);
        }
        catch (IllegalAccessException iae) {
            CAPTestMessageFactory.throwUnknownMessageException(messageClassName, iae);
        }
        return null;
    }

    private static void throwUnknownMessageException(String messageClassName, Throwable nestedException) throws UnknownMessageException {
        LOG.error(nestedException.getLocalizedMessage(), nestedException);
        throw new UnknownMessageException("Creating a shared message instance for " + messageClassName + "failed: " + nestedException.getMessage(), MessageIDs.E_MESSAGE_NOT_CREATED);
    }
}

