/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.rc.swing.tester.util;

import java.awt.Component;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JTree;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.apache.commons.lang.ObjectUtils;
import org.apache.commons.lang.Validate;
import org.eclipse.jubula.rc.common.driver.ClickOptions;
import org.eclipse.jubula.rc.common.driver.IEventThreadQueuer;
import org.eclipse.jubula.rc.common.driver.IRobot;
import org.eclipse.jubula.rc.common.driver.IRunnable;
import org.eclipse.jubula.rc.common.exception.StepExecutionException;
import org.eclipse.jubula.rc.common.implclasses.tree.AbstractTreeOperationContext;
import org.eclipse.jubula.rc.common.logger.AutServerLogger;
import org.eclipse.jubula.rc.common.util.SelectionUtil;
import org.eclipse.jubula.rc.swing.driver.EventThreadQueuerAwtImpl;
import org.eclipse.jubula.rc.swing.tester.util.TesterUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TreeOperationContext
extends AbstractTreeOperationContext {
    private static AutServerLogger log = new AutServerLogger(TreeOperationContext.class);
    private TreeModel m_model;

    public TreeOperationContext(IEventThreadQueuer queuer, IRobot robot, JTree tree) {
        super(queuer, robot, (Object)tree);
        Validate.notNull((Object)tree.getModel());
        this.m_model = tree.getModel();
    }

    public Object[] getChildren(Object parent) {
        if (parent == null) {
            return this.getRootNodes();
        }
        int childCount = this.m_model.getChildCount(parent);
        ArrayList<Object> childList = new ArrayList<Object>();
        int i = 0;
        while (i < childCount) {
            childList.add(this.m_model.getChild(parent, i));
            ++i;
        }
        return childList.toArray();
    }

    public Collection<String> getNodeTextList(Object node) {
        String rendText;
        ArrayList<String> res = new ArrayList<String>();
        int row = this.getRowForTreeNode(node);
        String valText = this.convertValueToText(node, row);
        if (valText != null) {
            res.add(valText);
        }
        if ((rendText = this.getRenderedText(node)) != null) {
            res.add(rendText);
        }
        return res;
    }

    public int getNumberOfChildren(Object parent) {
        if (parent == null) {
            return this.getRootNodes().length;
        }
        return this.m_model.getChildCount(parent);
    }

    protected String convertValueToText(final Object node, final int row) throws StepExecutionException {
        return (String)this.getQueuer().invokeAndWait("convertValueToText", new IRunnable(){

            public Object run() {
                return ((JTree)TreeOperationContext.this.getTree()).convertValueToText(node, false, ((JTree)TreeOperationContext.this.getTree()).isExpanded(row), TreeOperationContext.this.m_model.isLeaf(node), row, false);
            }
        });
    }

    public String getRenderedText(final Object node) {
        return (String)this.getQueuer().invokeAndWait("getRenderedText", new IRunnable(){

            public Object run() {
                int row = TreeOperationContext.this.getRowForTreeNode(node);
                JTree tree = (JTree)TreeOperationContext.this.getTree();
                Component cellRendererComponent = tree.getCellRenderer().getTreeCellRendererComponent(tree, node, false, tree.isExpanded(row), TreeOperationContext.this.m_model.isLeaf(node), row, false);
                try {
                    return TesterUtil.getRenderedText(cellRendererComponent);
                }
                catch (StepExecutionException e) {
                    log.warn((Object)("Renderer not supported: " + cellRendererComponent.getClass()), (Throwable)e);
                    return null;
                }
            }
        });
    }

    protected String[] convertTreePathToText(Object treePath) {
        TreePath tp = (TreePath)treePath;
        Object[] path = tp.getPath();
        String[] values = new String[path.length];
        int i = 0;
        while (i < path.length) {
            values[i] = this.convertValueToText(path[i], this.getRowForTreeNode(path[i]));
            ++i;
        }
        return values;
    }

    protected int getRowForTreeNode(final Object node) throws StepExecutionException {
        Integer row = (Integer)this.getQueuer().invokeAndWait("getRowForTreeNode", new IRunnable(){

            public Object run() {
                TreePath pathToRoot = new TreePath(TreeOperationContext.this.getPathToRoot(node));
                return new Integer(((JTree)TreeOperationContext.this.getTree()).getRowForPath(pathToRoot));
            }
        });
        return row;
    }

    private Object[] getPathToRoot(Object node) {
        Object rootNode = this.m_model.getRoot();
        List<Object> path = this.getPathToRootImpl(node, rootNode);
        return path.toArray();
    }

    public Rectangle getNodeBounds(Object node) throws StepExecutionException {
        final int row = this.getRowForTreeNode(node);
        return (Rectangle)this.getQueuer().invokeAndWait("getRowBounds", new IRunnable(){

            public Object run() {
                return ((JTree)TreeOperationContext.this.getTree()).getRowBounds(row);
            }
        });
    }

    protected Object[] getSelectionPaths() {
        return (TreePath[])this.getQueuer().invokeAndWait("getSelectionPath", new IRunnable(){

            public Object run() {
                return ((JTree)TreeOperationContext.this.getTree()).getSelectionPaths();
            }
        });
    }

    public boolean isVisible(final Object node) {
        Boolean visible = (Boolean)this.getQueuer().invokeAndWait("isVisible", new IRunnable(){

            public Object run() {
                Object[] path = TreeOperationContext.this.getPathToRoot(node);
                return ((JTree)TreeOperationContext.this.getTree()).isVisible(new TreePath(path)) ? Boolean.TRUE : Boolean.FALSE;
            }
        });
        return visible;
    }

    protected TreeModel getModel() {
        return this.m_model;
    }

    public Rectangle getVisibleRowBounds(Rectangle rowBounds) {
        Rectangle visibleTreeBounds = ((JComponent)this.getTree()).getVisibleRect();
        Rectangle visibleRowBounds = visibleTreeBounds.intersection(rowBounds);
        return visibleRowBounds;
    }

    public void collapseNode(Object node) {
        final JTree tree = (JTree)this.getTree();
        ClassLoader oldCl = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(tree.getClass().getClassLoader());
            final int row = this.getRowForTreeNode(node);
            Rectangle nodeBounds = this.getNodeBounds(node);
            boolean collapsed = tree.isCollapsed(row);
            boolean doAction = this.isExpanded(node);
            EventThreadQueuerAwtImpl queuer = new EventThreadQueuerAwtImpl();
            queuer.invokeAndWait("scrollRowToVisible", new IRunnable(){

                public Object run() {
                    tree.scrollRowToVisible(row);
                    return null;
                }
            });
            Rectangle visibleNodeBounds = this.getVisibleRowBounds(nodeBounds);
            this.getRobot().move((Object)tree, (Object)visibleNodeBounds);
            if (doAction) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)(String.valueOf(collapsed ? "Expanding" : "Collapsing") + " node: " + node));
                    log.debug((Object)("Row           : " + row));
                    log.debug((Object)("Node bounds   : " + visibleNodeBounds));
                }
                queuer.invokeAndWait("collapseRow", new IRunnable(){

                    public Object run() {
                        tree.collapseRow(row);
                        return null;
                    }
                });
            }
        }
        finally {
            Thread.currentThread().setContextClassLoader(oldCl);
        }
    }

    public void expandNode(Object node) {
        final JTree tree = (JTree)this.getTree();
        ClassLoader oldCl = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(tree.getClass().getClassLoader());
            final int row = this.getRowForTreeNode(node);
            Rectangle nodeBounds = this.getNodeBounds(node);
            boolean collapsed = tree.isCollapsed(row);
            boolean doAction = !this.isExpanded(node);
            EventThreadQueuerAwtImpl queuer = new EventThreadQueuerAwtImpl();
            queuer.invokeAndWait("scrollRowToVisible", new IRunnable(){

                public Object run() {
                    tree.scrollRowToVisible(row);
                    return null;
                }
            });
            Rectangle visibleNodeBounds = this.getVisibleRowBounds(nodeBounds);
            this.getRobot().move((Object)tree, (Object)visibleNodeBounds);
            if (doAction) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)(String.valueOf(collapsed ? "Expanding" : "Collapsing") + " node: " + node));
                    log.debug((Object)("Row           : " + row));
                    log.debug((Object)("Node bounds   : " + visibleNodeBounds));
                }
                queuer.invokeAndWait("expandRow", new IRunnable(){

                    public Object run() {
                        tree.expandRow(row);
                        return null;
                    }
                });
            }
        }
        finally {
            Thread.currentThread().setContextClassLoader(oldCl);
        }
    }

    public Object[] getRootNodes() {
        JTree tree = (JTree)this.getTree();
        if (tree.isRootVisible()) {
            return new Object[]{tree.getModel().getRoot()};
        }
        return this.getChildren(tree.getModel().getRoot());
    }

    public void scrollNodeToVisible(Object node) {
        ((JTree)this.getTree()).scrollRowToVisible(this.getRowForTreeNode(node));
    }

    public Object getChild(Object parent, int index) {
        try {
            if (parent == null) {
                Object[] rootNodes = this.getRootNodes();
                return rootNodes[index];
            }
            return this.m_model.getChild(parent, index);
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            return null;
        }
    }

    public Object getParent(Object child) {
        Object parent = null;
        if (child instanceof TreeNode) {
            parent = ((TreeNode)child).getParent();
        } else {
            Object[] pathToRoot = this.getPathToRoot(child);
            if (pathToRoot.length > 1) {
                parent = pathToRoot[pathToRoot.length - 2];
            }
        }
        if (parent != null && parent.equals(this.m_model.getRoot()) && !((JTree)this.getTree()).isRootVisible()) {
            parent = null;
        }
        return parent;
    }

    private List<Object> getPathToRootImpl(Object node, Object currentNode) {
        if (ObjectUtils.equals((Object)currentNode, (Object)node)) {
            ArrayList<Object> retList = new ArrayList<Object>();
            retList.add(currentNode);
            return retList;
        }
        int childCount = this.m_model.getChildCount(currentNode);
        int i = 0;
        while (i < childCount) {
            List<Object> path = this.getPathToRootImpl(node, this.m_model.getChild(currentNode, i));
            if (path != null) {
                path.add(0, currentNode);
                return path;
            }
            ++i;
        }
        return null;
    }

    public boolean isExpanded(Object node) {
        return ((JTree)this.getTree()).isExpanded(this.getRowForTreeNode(node));
    }

    public void clickNode(Object node, ClickOptions clickOps) {
        this.scrollNodeToVisible(node);
        Rectangle rowBounds = this.getNodeBounds(node);
        Rectangle visibleRowBounds = this.getVisibleRowBounds(rowBounds);
        this.getRobot().click(this.getTree(), (Object)visibleRowBounds, clickOps);
    }

    public Object getSelectedNode() {
        Object[] paths = this.getCheckedSelectedPaths();
        SelectionUtil.validateSelection((Object[])paths);
        return ((TreePath)paths[0]).getLastPathComponent();
    }

    private TreePath[] getCheckedSelectedPaths() {
        Object[] paths = (TreePath[])this.getSelectionPaths();
        SelectionUtil.validateSelection((Object[])paths);
        return paths;
    }

    public int getIndexOfChild(Object parent, Object child) {
        if (parent != null) {
            return ((JTree)this.getTree()).getModel().getIndexOfChild(parent, child);
        }
        Object[] rootNodes = this.getRootNodes();
        int i = 0;
        while (i < rootNodes.length) {
            if (ObjectUtils.equals((Object)rootNodes[i], (Object)child)) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public boolean isLeaf(Object node) {
        return this.m_model.isLeaf(node);
    }

    public Object[] getSelectedNodes() {
        Object[] paths = this.getCheckedSelectedPaths();
        Object[] nodes = new Object[paths.length];
        int i = 0;
        while (i < paths.length) {
            nodes[i] = ((TreePath)paths[i]).getLastPathComponent();
            ++i;
        }
        SelectionUtil.validateSelection((Object[])paths);
        return nodes;
    }
}

