/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.rc.swt.utils;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.eclipse.jubula.rc.common.AUTServer;
import org.eclipse.jubula.rc.common.driver.IRunnable;
import org.eclipse.jubula.rc.common.exception.StepExecutionException;
import org.eclipse.jubula.rc.swt.SwtAUTServer;
import org.eclipse.jubula.rc.swt.driver.EventThreadQueuerSwtImpl;
import org.eclipse.jubula.rc.swt.driver.KeyCodeConverter;
import org.eclipse.jubula.toolkit.enums.ValueSets;
import org.eclipse.jubula.tools.internal.utils.EnvironmentUtils;
import org.eclipse.swt.SWT;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.dnd.DragSource;
import org.eclipse.swt.dnd.DropTarget;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Caret;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.CoolBar;
import org.eclipse.swt.widgets.CoolItem;
import org.eclipse.swt.widgets.Decorations;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Item;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.ScrollBar;
import org.eclipse.swt.widgets.Scrollable;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;
import org.eclipse.swt.widgets.Tracker;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeColumn;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.swt.widgets.Widget;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SwtUtils {
    private static final String WIN32 = "win32";
    private static final String GTK = "gtk";
    private static final String METHOD_NAME_GET_BOUNDS = "getBounds";
    private static Logger log = LoggerFactory.getLogger(SwtUtils.class);

    private SwtUtils() {
    }

    public static Widget getWidgetAtCursorLocation() {
        Display display = ((SwtAUTServer)AUTServer.getInstance()).getAutDisplay();
        if (display == null || display.isDisposed()) {
            return null;
        }
        Control control = display.getCursorControl();
        if (control == null) {
            return null;
        }
        control = SwtUtils.checkControlParent(control);
        Widget widget = SwtUtils.checkControlChildrenAtCursorLocation(control);
        return widget;
    }

    public static Widget invokeGetWidgetAtCursorLocation() {
        EventThreadQueuerSwtImpl evThreadQueuer = new EventThreadQueuerSwtImpl();
        Widget widget = (Widget)evThreadQueuer.invokeAndWait("getWidgetAtCursorLocation", new IRunnable(){

            public Object run() throws StepExecutionException {
                return SwtUtils.getWidgetAtCursorLocation();
            }
        });
        return widget;
    }

    public static Control getCursorControl() {
        EventThreadQueuerSwtImpl evThreadQueuer = new EventThreadQueuerSwtImpl();
        return (Control)evThreadQueuer.invokeAndWait("getCursorControl", new IRunnable(){

            public Object run() {
                Display disp = Display.getCurrent();
                if (disp == null || disp.isDisposed()) {
                    return null;
                }
                return disp.getCursorControl();
            }
        });
    }

    public static void waitForDisplayIdle(final Display display) {
        display.syncExec(new Runnable(){

            public void run() {
                while (!display.isDisposed() && display.readAndDispatch()) {
                    display.readAndDispatch();
                }
                display.update();
            }
        });
    }

    public static Item[] getMappableItems(Widget widget) {
        try {
            if (widget instanceof ToolBar) {
                return ((ToolBar)widget).getItems();
            }
            if (widget instanceof CoolBar) {
                return ((CoolBar)widget).getItems();
            }
        }
        catch (NullPointerException nullPointerException) {}
        return new Item[0];
    }

    public static Shell getShell(Widget widget) {
        Widget wdgt = widget;
        while (!(wdgt instanceof Control) && wdgt != null) {
            wdgt = SwtUtils.getWidgetParent(wdgt);
        }
        if (wdgt != null) {
            return ((Control)wdgt).getShell();
        }
        return null;
    }

    private static Widget checkControlChildrenAtCursorLocation(Control control) {
        Item[] items = SwtUtils.getMappableItems((Widget)control);
        if (items == null) {
            return control;
        }
        Point absMousePos = control.getDisplay().getCursorLocation();
        int i = 0;
        while (i < items.length) {
            Item item = items[i];
            Rectangle itemBounds = SwtUtils.getWidgetBounds((Widget)item);
            if (itemBounds.contains(absMousePos)) {
                return item;
            }
            ++i;
        }
        if (control instanceof Composite) {
            Composite composite = (Composite)control;
            Control[] children = composite.getChildren();
            int i2 = 0;
            while (i2 < children.length) {
                Control ctrl = children[i2];
                if (SwtUtils.getWidgetBounds((Widget)ctrl).contains(absMousePos)) {
                    return SwtUtils.checkControlChildrenAtCursorLocation(ctrl);
                }
                ++i2;
            }
        }
        return control;
    }

    public static Control checkControlParent(final Control control) {
        EventThreadQueuerSwtImpl evThreadQueuer = new EventThreadQueuerSwtImpl();
        return (Control)evThreadQueuer.invokeAndWait("checkControlParent", new IRunnable(){

            public Object run() throws StepExecutionException {
                Composite parent;
                if (control != null && !control.isDisposed() && ((parent = control.getParent()) instanceof CCombo || parent instanceof Table)) {
                    return parent;
                }
                return control;
            }
        });
    }

    public static Widget getWidgetParent(final Widget widget) {
        EventThreadQueuerSwtImpl evThreadQueuer = new EventThreadQueuerSwtImpl();
        Widget parent = (Widget)evThreadQueuer.invokeAndWait("getWidgetParent", new IRunnable(){

            public Object run() throws StepExecutionException {
                if (widget == null || widget.isDisposed()) {
                    return null;
                }
                return SwtUtils.getWidgetParentImpl(widget);
            }
        });
        return parent;
    }

    private static Widget getWidgetParentImpl(Widget widget) {
        Composite parent = null;
        if (widget == null) {
            log.error("Cannot get parent for null widget.");
        }
        if (widget instanceof Control) {
            parent = ((Control)widget).getParent();
        } else if (widget instanceof Caret) {
            parent = ((Caret)widget).getParent();
        } else if (widget instanceof Menu) {
            parent = ((Menu)widget).getParent();
        } else if (widget instanceof ScrollBar) {
            parent = ((ScrollBar)widget).getParent();
        } else if (widget instanceof CoolItem) {
            parent = ((CoolItem)widget).getParent();
        } else if (widget instanceof MenuItem) {
            parent = ((MenuItem)widget).getParent();
        } else if (widget instanceof TabItem) {
            parent = ((TabItem)widget).getParent();
        } else if (widget instanceof TableColumn) {
            parent = ((TableColumn)widget).getParent();
        } else if (widget instanceof TableItem) {
            parent = ((TableItem)widget).getParent();
        } else if (widget instanceof ToolItem) {
            parent = ((ToolItem)widget).getParent();
        } else if (widget instanceof TreeItem) {
            parent = ((TreeItem)widget).getParent();
        } else if (widget instanceof DragSource) {
            parent = ((DragSource)widget).getControl().getParent();
        } else if (widget instanceof DropTarget) {
            parent = ((DropTarget)widget).getControl().getParent();
        } else if (widget instanceof Tracker) {
            log.error("requested the parent of a Tracker- UNFINDABLE");
        }
        return parent;
    }

    public static Point getWidgetLocation(Widget widget) {
        Rectangle bounds = SwtUtils.getWidgetBounds(widget);
        return new Point(bounds.x, bounds.y);
    }

    public static Rectangle getRelativeWidgetBounds(Widget widget, Control relativeTo) {
        Rectangle absoluteBounds = SwtUtils.getWidgetBounds(widget);
        if (absoluteBounds == null || relativeTo == null) {
            return absoluteBounds;
        }
        return relativeTo.getDisplay().map(null, relativeTo, absoluteBounds);
    }

    public static Rectangle getWidgetBounds(Widget widget) {
        Rectangle bounds = null;
        if (widget == null) {
            log.debug("Trying to find bounds for null Widget. Null bounds returned");
            return null;
        }
        if (widget instanceof Shell) {
            bounds = SwtUtils.getBounds((Shell)widget);
        } else if (widget instanceof Control) {
            bounds = SwtUtils.getBounds((Control)widget);
        } else if (widget instanceof Caret) {
            bounds = SwtUtils.getBounds((Caret)widget);
        } else if (widget instanceof Menu) {
            bounds = SwtUtils.getBounds((Menu)widget);
        } else if (widget instanceof ScrollBar) {
            bounds = SwtUtils.getBounds((ScrollBar)widget);
        } else if (widget instanceof CoolItem) {
            bounds = SwtUtils.getBounds((CoolItem)widget);
        } else if (widget instanceof MenuItem) {
            bounds = SwtUtils.getBounds((MenuItem)widget);
        } else if (widget instanceof TabItem) {
            bounds = SwtUtils.getBounds((TabItem)widget);
        } else if (widget instanceof CTabItem) {
            bounds = SwtUtils.getBounds((CTabItem)widget);
        } else if (widget instanceof TableColumn) {
            bounds = SwtUtils.getBounds((TableColumn)widget);
        } else if (widget instanceof TableItem) {
            bounds = SwtUtils.getBounds((TableItem)widget);
        } else if (widget instanceof ToolItem) {
            bounds = SwtUtils.getBounds((ToolItem)widget);
        } else if (widget instanceof TreeItem) {
            bounds = SwtUtils.getBounds((TreeItem)widget);
        } else if (log.isDebugEnabled()) {
            log.debug("Tried to find bounds for unknown component type: " + widget.getClass().getName() + ". Returning null bounds.");
        }
        return bounds;
    }

    public static Widget[] getWidgetChildren(final Widget widget, final boolean recurse) {
        EventThreadQueuerSwtImpl evThreadQueuer = new EventThreadQueuerSwtImpl();
        Widget[] widgets = (Widget[])evThreadQueuer.invokeAndWait("getWidgetChildren", new IRunnable(){

            public Object run() throws StepExecutionException {
                if (widget == null || widget.isDisposed()) {
                    return new Widget[0];
                }
                return SwtUtils.getWidgetChildrenImpl(widget, recurse);
            }
        });
        return widgets;
    }

    private static Widget[] getWidgetChildrenImpl(Widget widget, boolean recurse) {
        Control[] widgets;
        LinkedList<Object> objT = new LinkedList<Object>();
        if (widget == null || widget.isDisposed()) {
            return new Widget[0];
        }
        if (widget instanceof Control && ((Control)widget).getMenu() != null) {
            objT.add(((Control)widget).getMenu());
        }
        if (widget instanceof Scrollable) {
            if (((Scrollable)widget).getVerticalBar() != null) {
                objT.add(((Scrollable)widget).getVerticalBar());
            }
            if (((Scrollable)widget).getHorizontalBar() != null) {
                objT.add(((Scrollable)widget).getHorizontalBar());
            }
        }
        if (widget instanceof Decorations && ((Decorations)widget).getMenuBar() != null) {
            objT.add(((Decorations)widget).getMenuBar());
        }
        if (widget instanceof Composite && (widgets = ((Composite)widget).getChildren()).length != 0) {
            objT.addAll(Arrays.asList(widgets));
        }
        if (widget instanceof CoolBar && (widgets = ((CoolBar)widget).getItems()).length != 0) {
            objT.addAll(Arrays.asList(widgets));
        }
        if (widget instanceof TabFolder && (widgets = ((TabFolder)widget).getItems()).length != 0) {
            objT.addAll(Arrays.asList(widgets));
        }
        if (widget instanceof Table) {
            widgets = ((Table)widget).getItems();
            if (widgets.length != 0) {
                objT.addAll(Arrays.asList(widgets));
            }
            if ((widgets = ((Table)widget).getColumns()).length != 0) {
                objT.addAll(Arrays.asList(widgets));
            }
        }
        if (widget instanceof ToolBar && (widgets = ((ToolBar)widget).getItems()).length != 0) {
            objT.addAll(Arrays.asList(widgets));
        }
        if (widget instanceof Tree && (widgets = ((Tree)widget).getItems()).length != 0) {
            objT.addAll(Arrays.asList(widgets));
        }
        SwtUtils.addNonControlChildren(widget, objT);
        if (recurse && objT.size() > 0) {
            LinkedList<Widget> extendedFamily = new LinkedList<Widget>();
            int i = 0;
            while (i < objT.size()) {
                Widget w = (Widget)objT.get(i);
                extendedFamily.addAll(Arrays.asList(SwtUtils.getWidgetChildrenImpl(w, recurse)));
                ++i;
            }
            objT.addAll(extendedFamily);
        }
        return objT.toArray(new Widget[objT.size()]);
    }

    private static void addNonControlChildren(Widget widget, List objT) {
        Menu childMenu;
        TreeItem[] widgets;
        if (widget instanceof TreeItem && (widgets = ((TreeItem)widget).getItems()).length != 0) {
            ((LinkedList)objT).addAll(Arrays.asList(widgets));
        }
        if (widget instanceof Menu && (widgets = ((Menu)widget).getItems()).length != 0) {
            ((LinkedList)objT).addAll(Arrays.asList(widgets));
        }
        if (widget instanceof MenuItem && (childMenu = ((MenuItem)widget).getMenu()) != null) {
            ((LinkedList)objT).add(childMenu);
        }
    }

    public static Shell getWidgetShell(Widget widget) {
        Widget parent = widget;
        while (!(parent instanceof Shell) && SwtUtils.getWidgetParent(parent) != null) {
            parent = SwtUtils.getWidgetParent(parent);
        }
        return (Shell)parent;
    }

    public static Rectangle getBounds(Control control) {
        Rectangle bounds = control.getDisplay().map((Control)control.getParent(), null, control.getBounds());
        bounds = SwtUtils.getActiveArea(control, bounds);
        return bounds;
    }

    private static Rectangle getActiveArea(Control control, Rectangle bounds) {
        int borderWidth = control.getBorderWidth();
        if (borderWidth > 0) {
            bounds.x += borderWidth;
            bounds.y += borderWidth;
            int dimAdjustment = 2 * borderWidth;
            bounds.height -= dimAdjustment;
            bounds.width -= dimAdjustment;
        }
        return bounds;
    }

    public static Rectangle getBounds(Caret caret) {
        return caret.getDisplay().map((Control)caret.getParent(), null, caret.getBounds());
    }

    public static Rectangle getBounds(Shell shell) {
        Rectangle clientArea = shell.getClientArea();
        Rectangle bounds = shell.getBounds();
        int titleBarHeight = bounds.height - clientArea.height;
        int widthDiff = bounds.width - clientArea.width;
        clientArea.x = bounds.x + widthDiff / 2;
        int borderWidth = shell.getBorderWidth();
        clientArea.y = bounds.y + titleBarHeight - borderWidth * 2;
        clientArea.height -= borderWidth;
        return clientArea;
    }

    private static Rectangle getBounds(Object object) {
        Rectangle result = new Rectangle(0, 0, 0, 0);
        String methodName = METHOD_NAME_GET_BOUNDS;
        try {
            Method method = object.getClass().getDeclaredMethod(methodName, null);
            method.setAccessible(true);
            result = (Rectangle)method.invoke(object, null);
        }
        catch (Exception e) {
            return SwtUtils.handleBoundsError(e);
        }
        return result;
    }

    public static Rectangle getBounds(MenuItem menuItem) {
        Rectangle itemRect = SwtUtils.getBounds((Object)menuItem);
        Rectangle menuRect = SwtUtils.getBounds(menuItem.getParent());
        itemRect.x = (menuItem.getParent().getStyle() & 0x4000000) != 0 ? menuRect.x + menuRect.width - itemRect.width - itemRect.x : (itemRect.x += menuRect.x);
        itemRect.y += menuRect.y;
        return itemRect;
    }

    public static Rectangle getBounds(Menu menu) {
        return SwtUtils.getBounds((Object)menu);
    }

    public static Rectangle getBounds(ScrollBar scrollBar) {
        Point size = scrollBar.getSize();
        Rectangle bounds = scrollBar.getParent().getBounds();
        if ((scrollBar.getParent().getStyle() & 0x4000000) != 0) {
            bounds.x = 0;
            bounds.width = size.x;
        } else {
            bounds.x = bounds.width - size.x;
        }
        bounds.y = bounds.height - size.y;
        return scrollBar.getDisplay().map((Control)scrollBar.getParent(), null, bounds);
    }

    static int sendMessage(int hWnd, int msg, int wParam, int[] lParam) throws Exception {
        int result = 0;
        String methodName = "SendMessage";
        String className = "org.eclipse.swt.internal.win32.OS";
        Class<?> clazz = Class.forName(className);
        Class[] params = new Class[]{Integer.TYPE, Integer.TYPE, Integer.TYPE, lParam.getClass()};
        Method method = clazz.getMethod(methodName, params);
        Object[] args = new Object[]{new Integer(hWnd), new Integer(msg), new Integer(wParam), lParam};
        result = (Integer)method.invoke(clazz, args);
        return result;
    }

    static Rectangle win32getBounds(TabItem tabItem) {
        TabFolder parent = tabItem.getParent();
        int index = parent.indexOf(tabItem);
        if (index == -1) {
            return new Rectangle(0, 0, 0, 0);
        }
        int[] rect = new int[4];
        try {
            SwtUtils.sendMessage(parent.handle, 4874, index, rect);
            int width = rect[2] - rect[0];
            int height = rect[3] - rect[1];
            Rectangle bounds = new Rectangle(rect[0], rect[1], width, height);
            return tabItem.getDisplay().map((Control)tabItem.getParent(), null, bounds);
        }
        catch (Exception e) {
            return SwtUtils.handleBoundsError(e);
        }
    }

    static Rectangle win32getBounds(TableColumn tableColumn) {
        Table parent = tableColumn.getParent();
        int index = parent.indexOf(tableColumn);
        if (index == -1) {
            return new Rectangle(0, 0, 0, 0);
        }
        int hwndHeader = SwtUtils.sendMessage(parent.handle, 4127, 0, new int[0]);
        int[] rect = new int[4];
        SwtUtils.sendMessage(hwndHeader, 4615, index, rect);
        int width = rect[2] - rect[0];
        int height = rect[3] - rect[1];
        Rectangle bounds = new Rectangle(rect[0], rect[1], width, height);
        int hwndTable = parent.handle;
        try {
            parent.handle = hwndHeader;
            Rectangle rectangle = tableColumn.getDisplay().map((Control)parent, null, bounds);
            parent.handle = hwndTable;
            return rectangle;
        }
        catch (Throwable throwable) {
            try {
                parent.handle = hwndTable;
                throw throwable;
            }
            catch (Exception e) {
                return SwtUtils.handleBoundsError(e);
            }
        }
    }

    static Rectangle win32getBounds(TreeColumn treeColumn) {
        Tree parent = treeColumn.getParent();
        int index = parent.indexOf(treeColumn);
        if (index == -1) {
            return new Rectangle(0, 0, 0, 0);
        }
        int hwndHeader = 0;
        try {
            Class<?> clazz = parent.getClass();
            Field f = clazz.getDeclaredField("hwndHeader");
            f.setAccessible(true);
            hwndHeader = f.getInt(parent);
            int[] rect = new int[4];
            SwtUtils.sendMessage(hwndHeader, 4615, index, rect);
            int width = rect[2] - rect[0];
            int height = rect[3] - rect[1];
            Rectangle bounds = new Rectangle(rect[0], rect[1], width, height);
            bounds.y -= treeColumn.getParent().getHeaderHeight();
            return treeColumn.getDisplay().map((Control)parent, null, bounds);
        }
        catch (Exception e) {
            return SwtUtils.handleBoundsError(e);
        }
    }

    static void gtkgetBounds(int handle, Rectangle bounds) throws Exception {
        Class<?> clazz = Class.forName("org.eclipse.swt.internal.gtk.OS");
        Class[] params = new Class[]{Integer.TYPE};
        Object[] args = new Object[]{new Integer(handle)};
        try {
            Method method = clazz.getMethod("gtkWIDGET_X", params);
            bounds.x = (Integer)method.invoke(clazz, args);
            method = clazz.getMethod("gtkWIDGET_Y", params);
            bounds.y = (Integer)method.invoke(clazz, args);
            method = clazz.getMethod("gtkWIDGET_WIDTH", params);
            bounds.width = (Integer)method.invoke(clazz, args);
            method = clazz.getMethod("gtkWIDGET_HEIGHT", params);
            bounds.height = (Integer)method.invoke(clazz, args);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            Method method = clazz.getMethod("GTK_WIDGET_X", params);
            bounds.x = (Integer)method.invoke(clazz, args);
            method = clazz.getMethod("GTK_WIDGET_Y", params);
            bounds.y = (Integer)method.invoke(clazz, args);
            method = clazz.getMethod("GTK_WIDGET_WIDTH", params);
            bounds.width = (Integer)method.invoke(clazz, args);
            method = clazz.getMethod("GTK_WIDGET_HEIGHT", params);
            bounds.height = (Integer)method.invoke(clazz, args);
        }
    }

    static Rectangle gtkgetBounds(TableColumn tableColumn) {
        Rectangle bounds = new Rectangle(0, 0, 0, 0);
        try {
            Class<?> clazz = tableColumn.getClass();
            Field f = clazz.getDeclaredField("buttonHandle");
            f.setAccessible(true);
            int handle = f.getInt(tableColumn);
            SwtUtils.gtkgetBounds(handle, bounds);
            bounds.y -= tableColumn.getParent().getHeaderHeight();
            return tableColumn.getDisplay().map((Control)tableColumn.getParent(), null, bounds);
        }
        catch (Exception e) {
            return SwtUtils.handleBoundsError(e);
        }
    }

    static Rectangle gtkgetBounds(TreeColumn treeColumn) {
        Rectangle bounds = new Rectangle(0, 0, 0, 0);
        try {
            Class<?> clazz = treeColumn.getClass();
            Field f = clazz.getDeclaredField("buttonHandle");
            f.setAccessible(true);
            int handle = f.getInt(treeColumn);
            SwtUtils.gtkgetBounds(handle, bounds);
            bounds.y -= treeColumn.getParent().getHeaderHeight();
            return treeColumn.getDisplay().map((Control)treeColumn.getParent(), null, bounds);
        }
        catch (Exception e) {
            return SwtUtils.handleBoundsError(e);
        }
    }

    static Rectangle gtkgetBounds(TabItem tabItem) {
        Rectangle bounds = new Rectangle(0, 0, 0, 0);
        try {
            Class<?> clazz = Class.forName("org.eclipse.swt.widgets.Widget");
            Field f = clazz.getDeclaredField("handle");
            f.setAccessible(true);
            int handle = f.getInt(tabItem);
            SwtUtils.gtkgetBounds(handle, bounds);
            return tabItem.getDisplay().map((Control)tabItem.getParent(), null, bounds);
        }
        catch (Exception e) {
            return SwtUtils.handleBoundsError(e);
        }
    }

    public static Rectangle getBounds(TabItem tabItem) {
        try {
            Method getBoundsMethod = tabItem.getClass().getMethod(METHOD_NAME_GET_BOUNDS, null);
            Object result = getBoundsMethod.invoke((Object)tabItem, null);
            if (result instanceof Rectangle) {
                Rectangle bounds = (Rectangle)result;
                TabFolder parent = tabItem.getParent();
                bounds.y = (parent.getStyle() & 0x400) == 1024 ? parent.getBounds().y - bounds.height : 0;
                return tabItem.getDisplay().map((Control)tabItem.getParent(), null, bounds);
            }
            String className = result != null ? result.getClass().getName() : "null";
            log.error("Expected getBounds() to return an object of type 'Rectangle', but received object of type '" + className + "'.");
        }
        catch (Exception e) {
            log.warn("Could not invoke getBounds() on TabItem. This is expected when using an SWT version lower than 3.4", (Throwable)e);
        }
        if (SWT.getPlatform().equals(WIN32)) {
            return SwtUtils.win32getBounds(tabItem);
        }
        if (SWT.getPlatform().equals(GTK)) {
            return SwtUtils.gtkgetBounds(tabItem);
        }
        return null;
    }

    public static Rectangle getBounds(TableColumn tableColumn) {
        if (SWT.getPlatform().equals(WIN32)) {
            return SwtUtils.win32getBounds(tableColumn);
        }
        if (SWT.getPlatform().equals(GTK)) {
            return SwtUtils.gtkgetBounds(tableColumn);
        }
        return null;
    }

    public static Rectangle getBounds(TreeColumn treeColumn) {
        if (SWT.getPlatform().equals(WIN32)) {
            return SwtUtils.win32getBounds(treeColumn);
        }
        if (SWT.getPlatform().equals(GTK)) {
            return SwtUtils.gtkgetBounds(treeColumn);
        }
        return null;
    }

    public static Rectangle getBounds(TableItem item) {
        Rectangle bounds = item.getDisplay().map((Control)item.getParent(), null, item.getBounds(0));
        return bounds;
    }

    public static Rectangle getBounds(TreeItem item) {
        Rectangle bounds = item.getBounds();
        if (item.getParent().getColumnCount() > 0) {
            bounds.width = item.getParent().getBounds().width;
        }
        return item.getDisplay().map((Control)item.getParent(), null, bounds);
    }

    public static Rectangle getBounds(TreeItem item, int column) {
        Rectangle bounds = item.getBounds(column);
        return item.getDisplay().map((Control)item.getParent(), null, bounds);
    }

    public static Rectangle getRelativeBounds(TreeItem item, int column) {
        Rectangle absoluteBounds = SwtUtils.getBounds(item, column);
        return item.getDisplay().map(null, (Control)item.getParent(), absoluteBounds);
    }

    public static Rectangle getBounds(CTabItem item) {
        return item.getDisplay().map((Control)item.getParent(), null, item.getBounds());
    }

    public static Rectangle getBounds(ToolItem item) {
        return item.getDisplay().map((Control)item.getParent(), null, item.getBounds());
    }

    public static Rectangle getBounds(CoolItem item) {
        return item.getDisplay().map((Control)item.getParent(), null, item.getBounds());
    }

    private static Rectangle handleBoundsError(Exception e) {
        Rectangle defaultResult = new Rectangle(0, 0, 0, 0);
        String message = "getBounds() failed. Returning default bounds result: " + defaultResult + ".";
        if (EnvironmentUtils.isMacOS()) {
            log.debug(message, (Throwable)e);
        } else {
            log.error(message, (Throwable)e);
        }
        return defaultResult;
    }

    public static String toString(final Widget widget) {
        EventThreadQueuerSwtImpl evThreadQueuer = new EventThreadQueuerSwtImpl();
        String widgetToStr = (String)evThreadQueuer.invokeAndWait("toString", new IRunnable(){

            public Object run() throws StepExecutionException {
                return String.valueOf(widget);
            }
        });
        return widgetToStr;
    }

    public static Point convertToSwtPoint(java.awt.Point awtPoint) {
        return new Point(awtPoint.x, awtPoint.y);
    }

    public static boolean isMouseCursorInWidget(final Widget widget) {
        EventThreadQueuerSwtImpl evThreadQueuer = new EventThreadQueuerSwtImpl();
        boolean isInComponent = (Boolean)evThreadQueuer.invokeAndWait("isInComponent", new IRunnable(){

            public Object run() throws StepExecutionException {
                return SwtUtils.getWidgetBounds(widget).contains(widget.getDisplay().getCursorLocation()) ? Boolean.TRUE : Boolean.FALSE;
            }
        });
        return isInComponent;
    }

    public static boolean isInBounds(final Widget boundsWidget, final Widget eventWidget) {
        EventThreadQueuerSwtImpl evThreadQueuer = new EventThreadQueuerSwtImpl();
        return (Boolean)evThreadQueuer.invokeAndWait("getWidgetChildren", new IRunnable(){

            public Object run() throws StepExecutionException {
                if (boundsWidget == null || boundsWidget.isDisposed() || eventWidget == null || eventWidget.isDisposed()) {
                    return Boolean.FALSE;
                }
                Rectangle widgetBounds = SwtUtils.getWidgetBounds(boundsWidget);
                boolean isInBounds = widgetBounds.equals((Object)widgetBounds.union(SwtUtils.getWidgetBounds(eventWidget)));
                return isInBounds ? Boolean.TRUE : Boolean.FALSE;
            }
        });
    }

    public static boolean containsInclusive(Rectangle rect, Point point) {
        boolean y2;
        Point treeLocUpperLeft = new Point(rect.x, rect.y);
        Point treeLocLowerRight = new Point(rect.width + treeLocUpperLeft.x, rect.height + treeLocUpperLeft.y);
        boolean x1 = point.x >= treeLocUpperLeft.x;
        boolean x2 = point.x < treeLocLowerRight.x;
        boolean y1 = point.y >= treeLocUpperLeft.y;
        boolean bl = y2 = point.y < treeLocLowerRight.y;
        return x1 && x2 && y1 && y2;
    }

    public static final String removeMnemonics(String text) {
        if (text == null) {
            return null;
        }
        int index = text.indexOf(38);
        if (index == -1) {
            return text;
        }
        int len = text.length();
        StringBuffer sb = new StringBuffer(len);
        int lastIndex = 0;
        while (index != -1) {
            if (index == len - 1) break;
            if (text.charAt(index + 1) == '&') {
                ++index;
            }
            if (index > 0 && text.charAt(index - 1) == '(' && text.length() >= index + 3 && text.charAt(index + 2) == ')') {
                sb.append(text.substring(lastIndex, index - 1));
                index += 3;
            } else {
                sb.append(text.substring(lastIndex, index));
            }
            lastIndex = ++index;
            index = text.indexOf(38, index);
        }
        if (lastIndex < len) {
            sb.append(text.substring(lastIndex, len));
        }
        return sb.toString();
    }

    public static int getSystemDefaultModifier() {
        if (EnvironmentUtils.isMacOS()) {
            return KeyCodeConverter.getKeyCode(ValueSets.Modifier.cmd.rcValue());
        }
        return KeyCodeConverter.getKeyCode(ValueSets.Modifier.control.rcValue());
    }

    public static int getSystemModifier2() {
        return KeyCodeConverter.getKeyCode(ValueSets.Modifier.shift.rcValue());
    }

    public static int getSystemModifier3() {
        return KeyCodeConverter.getKeyCode(ValueSets.Modifier.alt.rcValue());
    }

    public static int getSystemModifier4() {
        return KeyCodeConverter.getKeyCode(ValueSets.Modifier.control.rcValue());
    }

    public static boolean isDropdownListShell(Shell shell) {
        return shell != null && !shell.isDisposed() && StringUtils.isBlank((String)shell.getText()) && (shell.getStyle() & 0x4000) != 0 && shell.getChildren() != null && shell.getChildren().length == 1 && shell.getChildren()[0] instanceof org.eclipse.swt.widgets.List;
    }
}

