/*******************************************************************************
 * Copyright (c) 2014 BREDEX GmbH.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     BREDEX GmbH - initial API and implementation and/or initial documentation
 *******************************************************************************/
package org.eclipse.jubula.toolkit.base.components;

import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jubula.communication.CAP;

/**
 * Interface representing the GraphicsComponent component from the base toolkit. 
 * @noextend This interface is not intended to be extended by clients.
 * @noimplement This interface is not intended to be implemented by clients.
 */
public interface GraphicsComponent
	
	 {
	
	
	
	
	
	
		/**
		 * @throws IllegalArgumentException Throws an IllegalArgumentException if one of the parameters is null.
		 */
		
		@NonNull public CAP showText(
		
			@NonNull java.lang.String text,
		
			@NonNull java.lang.Integer textSizeInPoints,
		
			@NonNull java.lang.Integer timePerWordInMilliseconds,
		
			@NonNull java.lang.Integer windowWidthInPixels
		
		) throws IllegalArgumentException;
	
		/**
		 * @throws IllegalArgumentException Throws an IllegalArgumentException if one of the parameters is null.
		 */
		
		@NonNull public CAP checkExistence(
		
			@NonNull java.lang.Boolean exists
		
		) throws IllegalArgumentException;
	
		/**
		 * @throws IllegalArgumentException Throws an IllegalArgumentException if one of the parameters is null.
		 */
		
		@NonNull public CAP checkEnablement(
		
			@NonNull java.lang.Boolean enabled
		
		) throws IllegalArgumentException;
	
		/**
		 * @throws IllegalArgumentException Throws an IllegalArgumentException if one of the parameters is null.
		 */
		
		@NonNull public CAP checkProperty(
		
			@NonNull java.lang.String propertyName,
		
			@NonNull java.lang.String propertyValue,
		
			@NonNull org.eclipse.jubula.toolkit.enums.ValueSets.Operator operator
		
		) throws IllegalArgumentException;
	
		/**
		 * @throws IllegalArgumentException Throws an IllegalArgumentException if one of the parameters is null.
		 */
		
		@NonNull public CAP checkFocus(
		
			@NonNull java.lang.Boolean hasFocus
		
		) throws IllegalArgumentException;
	
		/**
		 * @throws IllegalArgumentException Throws an IllegalArgumentException if one of the parameters is null.
		 */
		
		@NonNull public CAP waitForComponent(
		
			@NonNull java.lang.Integer timeoutInMs,
		
			@NonNull java.lang.Integer delayAfterVisibility
		
		) throws IllegalArgumentException;
	
		/**
		 * @throws IllegalArgumentException Throws an IllegalArgumentException if one of the parameters is null.
		 */
		
		@NonNull public CAP click(
		
			@NonNull java.lang.Integer numberOfClicks,
		
			@NonNull org.eclipse.jubula.toolkit.enums.ValueSets.InteractionMode mouseButton
		
		) throws IllegalArgumentException;
	
		/**
		 * @throws IllegalArgumentException Throws an IllegalArgumentException if one of the parameters is null.
		 */
		
		@NonNull public CAP clickInComponent(
		
			@NonNull java.lang.Integer numberOfClicks,
		
			@NonNull org.eclipse.jubula.toolkit.enums.ValueSets.InteractionMode mouseButton,
		
			@NonNull java.lang.Integer xPosition,
		
			@NonNull org.eclipse.jubula.toolkit.enums.ValueSets.Unit xUnits,
		
			@NonNull java.lang.Integer yPosition,
		
			@NonNull org.eclipse.jubula.toolkit.enums.ValueSets.Unit yUnits
		
		) throws IllegalArgumentException;
	
		/**
		 * @throws IllegalArgumentException Throws an IllegalArgumentException if one of the parameters is null.
		 */
		
		@NonNull public CAP selectContextMenuEntryByTextpathSpecifyPosition(
		
			@NonNull java.lang.Integer xPosition,
		
			@NonNull org.eclipse.jubula.toolkit.enums.ValueSets.Unit xUnits,
		
			@NonNull java.lang.Integer yPosition,
		
			@NonNull org.eclipse.jubula.toolkit.enums.ValueSets.Unit yUnits,
		
			@NonNull java.lang.String menupath,
		
			@NonNull org.eclipse.jubula.toolkit.enums.ValueSets.Operator operator,
		
			@NonNull org.eclipse.jubula.toolkit.enums.ValueSets.InteractionMode mouseButton
		
		) throws IllegalArgumentException;
	
		/**
		 * @throws IllegalArgumentException Throws an IllegalArgumentException if one of the parameters is null.
		 */
		
		@NonNull public CAP selectContextMenuEntryByIndexpath(
		
			@NonNull java.lang.String indexpath,
		
			@NonNull org.eclipse.jubula.toolkit.enums.ValueSets.InteractionMode mouseButton
		
		) throws IllegalArgumentException;
	
		/**
		 * @throws IllegalArgumentException Throws an IllegalArgumentException if one of the parameters is null.
		 */
		
		@NonNull public CAP selectContextMenuEntryByTextpath(
		
			@NonNull java.lang.String textpath,
		
			@NonNull org.eclipse.jubula.toolkit.enums.ValueSets.Operator operator,
		
			@NonNull org.eclipse.jubula.toolkit.enums.ValueSets.InteractionMode mouseButton
		
		) throws IllegalArgumentException;
	
		/**
		 * @throws IllegalArgumentException Throws an IllegalArgumentException if one of the parameters is null.
		 */
		
		@NonNull public CAP selectContextMenuEntryByIndexpathSpecifyPosition(
		
			@NonNull java.lang.Integer xPosition,
		
			@NonNull org.eclipse.jubula.toolkit.enums.ValueSets.Unit xUnits,
		
			@NonNull java.lang.Integer yPosition,
		
			@NonNull org.eclipse.jubula.toolkit.enums.ValueSets.Unit yUnits,
		
			@NonNull java.lang.String indexpath,
		
			@NonNull org.eclipse.jubula.toolkit.enums.ValueSets.InteractionMode mouseButton
		
		) throws IllegalArgumentException;
	
		/**
		 * @throws IllegalArgumentException Throws an IllegalArgumentException if one of the parameters is null.
		 */
		
		@NonNull public CAP checkEnablementOfContextMenuEntryByIndexpath(
		
			@NonNull java.lang.String indexpath,
		
			@NonNull java.lang.Boolean enabled,
		
			@NonNull org.eclipse.jubula.toolkit.enums.ValueSets.InteractionMode mouseButton
		
		) throws IllegalArgumentException;
	
		/**
		 * @throws IllegalArgumentException Throws an IllegalArgumentException if one of the parameters is null.
		 */
		
		@NonNull public CAP checkEnablementOfContextMenuEntryByIndexpathSpecifyPosition(
		
			@NonNull java.lang.Integer xPosition,
		
			@NonNull org.eclipse.jubula.toolkit.enums.ValueSets.Unit xUnits,
		
			@NonNull java.lang.Integer yPosition,
		
			@NonNull org.eclipse.jubula.toolkit.enums.ValueSets.Unit yUnits,
		
			@NonNull java.lang.String indexpath,
		
			@NonNull java.lang.Boolean enabled,
		
			@NonNull org.eclipse.jubula.toolkit.enums.ValueSets.InteractionMode mouseButton
		
		) throws IllegalArgumentException;
	
		/**
		 * @throws IllegalArgumentException Throws an IllegalArgumentException if one of the parameters is null.
		 */
		
		@NonNull public CAP checkEnablementOfContextMenuEntryByTextpath(
		
			@NonNull java.lang.String textpath,
		
			@NonNull org.eclipse.jubula.toolkit.enums.ValueSets.Operator operator,
		
			@NonNull java.lang.Boolean enabled,
		
			@NonNull org.eclipse.jubula.toolkit.enums.ValueSets.InteractionMode mouseButton
		
		) throws IllegalArgumentException;
	
		/**
		 * @throws IllegalArgumentException Throws an IllegalArgumentException if one of the parameters is null.
		 */
		
		@NonNull public CAP checkEnablementOfContextMenuEntryByTextpathSpecifyPosition(
		
			@NonNull java.lang.Integer xPosition,
		
			@NonNull org.eclipse.jubula.toolkit.enums.ValueSets.Unit xUnits,
		
			@NonNull java.lang.Integer yPosition,
		
			@NonNull org.eclipse.jubula.toolkit.enums.ValueSets.Unit yUnits,
		
			@NonNull java.lang.String textpath,
		
			@NonNull org.eclipse.jubula.toolkit.enums.ValueSets.Operator operator,
		
			@NonNull java.lang.Boolean enabled,
		
			@NonNull org.eclipse.jubula.toolkit.enums.ValueSets.InteractionMode mouseButton
		
		) throws IllegalArgumentException;
	
		/**
		 * @throws IllegalArgumentException Throws an IllegalArgumentException if one of the parameters is null.
		 */
		
		@NonNull public CAP checkExistenceOfContextMenuEntryByIndexpath(
		
			@NonNull java.lang.String indexpath,
		
			@NonNull java.lang.Boolean exists,
		
			@NonNull org.eclipse.jubula.toolkit.enums.ValueSets.InteractionMode mouseButton
		
		) throws IllegalArgumentException;
	
		/**
		 * @throws IllegalArgumentException Throws an IllegalArgumentException if one of the parameters is null.
		 */
		
		@NonNull public CAP checkExistenceOfContextMenuEntryByIndexpathSpecifyPosition(
		
			@NonNull java.lang.Integer xPosition,
		
			@NonNull org.eclipse.jubula.toolkit.enums.ValueSets.Unit xUnits,
		
			@NonNull java.lang.Integer yPosition,
		
			@NonNull org.eclipse.jubula.toolkit.enums.ValueSets.Unit yUnits,
		
			@NonNull java.lang.String indexpath,
		
			@NonNull java.lang.Boolean exists,
		
			@NonNull org.eclipse.jubula.toolkit.enums.ValueSets.InteractionMode mouseButton
		
		) throws IllegalArgumentException;
	
		/**
		 * @throws IllegalArgumentException Throws an IllegalArgumentException if one of the parameters is null.
		 */
		
		@NonNull public CAP checkExistenceOfContextMenuEntryByTextpath(
		
			@NonNull java.lang.String textpath,
		
			@NonNull org.eclipse.jubula.toolkit.enums.ValueSets.Operator operator,
		
			@NonNull java.lang.Boolean exists,
		
			@NonNull org.eclipse.jubula.toolkit.enums.ValueSets.InteractionMode mouseButton
		
		) throws IllegalArgumentException;
	
		/**
		 * @throws IllegalArgumentException Throws an IllegalArgumentException if one of the parameters is null.
		 */
		
		@NonNull public CAP checkExistenceOfContextMenuEntryByTextpathSpecifyPosition(
		
			@NonNull java.lang.Integer xPosition,
		
			@NonNull org.eclipse.jubula.toolkit.enums.ValueSets.Unit xUnits,
		
			@NonNull java.lang.Integer yPosition,
		
			@NonNull org.eclipse.jubula.toolkit.enums.ValueSets.Unit yUnits,
		
			@NonNull java.lang.String textpath,
		
			@NonNull org.eclipse.jubula.toolkit.enums.ValueSets.Operator operator,
		
			@NonNull java.lang.Boolean exists,
		
			@NonNull org.eclipse.jubula.toolkit.enums.ValueSets.InteractionMode mouseButton
		
		) throws IllegalArgumentException;
	
		/**
		 * @throws IllegalArgumentException Throws an IllegalArgumentException if one of the parameters is null.
		 */
		
		@NonNull public CAP checkSelectionOfContextMenuEntryByIndexpath(
		
			@NonNull java.lang.String indexpath,
		
			@NonNull java.lang.Boolean selected,
		
			@NonNull org.eclipse.jubula.toolkit.enums.ValueSets.InteractionMode mouseButton
		
		) throws IllegalArgumentException;
	
		/**
		 * @throws IllegalArgumentException Throws an IllegalArgumentException if one of the parameters is null.
		 */
		
		@NonNull public CAP checkSelectionOfContextMenuEntryByIndexpathSpecifyPosition(
		
			@NonNull java.lang.Integer xPosition,
		
			@NonNull org.eclipse.jubula.toolkit.enums.ValueSets.Unit xUnits,
		
			@NonNull java.lang.Integer yPosition,
		
			@NonNull org.eclipse.jubula.toolkit.enums.ValueSets.Unit yUnits,
		
			@NonNull java.lang.String indexpath,
		
			@NonNull java.lang.Boolean selected,
		
			@NonNull org.eclipse.jubula.toolkit.enums.ValueSets.InteractionMode mouseButton
		
		) throws IllegalArgumentException;
	
		/**
		 * @throws IllegalArgumentException Throws an IllegalArgumentException if one of the parameters is null.
		 */
		
		@NonNull public CAP checkSelectionOfContextMenuEntryByTextpath(
		
			@NonNull java.lang.String textpath,
		
			@NonNull org.eclipse.jubula.toolkit.enums.ValueSets.Operator operator,
		
			@NonNull java.lang.Boolean selected,
		
			@NonNull org.eclipse.jubula.toolkit.enums.ValueSets.InteractionMode mouseButton
		
		) throws IllegalArgumentException;
	
		/**
		 * @throws IllegalArgumentException Throws an IllegalArgumentException if one of the parameters is null.
		 */
		
		@NonNull public CAP checkSelectionOfContextMenuEntryByTextpathSpecifyPosition(
		
			@NonNull java.lang.Integer xPosition,
		
			@NonNull org.eclipse.jubula.toolkit.enums.ValueSets.Unit xUnits,
		
			@NonNull java.lang.Integer yPosition,
		
			@NonNull org.eclipse.jubula.toolkit.enums.ValueSets.Unit yUnits,
		
			@NonNull java.lang.String textpath,
		
			@NonNull org.eclipse.jubula.toolkit.enums.ValueSets.Operator operator,
		
			@NonNull java.lang.Boolean selected,
		
			@NonNull org.eclipse.jubula.toolkit.enums.ValueSets.InteractionMode mouseButton
		
		) throws IllegalArgumentException;
	
		/**
		 * @throws IllegalArgumentException Throws an IllegalArgumentException if one of the parameters is null.
		 */
		
		@NonNull public CAP drag(
		
			@NonNull org.eclipse.jubula.toolkit.enums.ValueSets.InteractionMode mouseButton,
		
			@NonNull org.eclipse.jubula.toolkit.enums.ValueSets.Modifier modifierKeys,
		
			@NonNull java.lang.Integer xPosition,
		
			@NonNull org.eclipse.jubula.toolkit.enums.ValueSets.Unit xUnits,
		
			@NonNull java.lang.Integer yPosition,
		
			@NonNull org.eclipse.jubula.toolkit.enums.ValueSets.Unit yUnits
		
		) throws IllegalArgumentException;
	
		/**
		 * @throws IllegalArgumentException Throws an IllegalArgumentException if one of the parameters is null.
		 */
		
		@NonNull public CAP drop(
		
			@NonNull java.lang.Integer xPosition,
		
			@NonNull org.eclipse.jubula.toolkit.enums.ValueSets.Unit xUnits,
		
			@NonNull java.lang.Integer yPosition,
		
			@NonNull org.eclipse.jubula.toolkit.enums.ValueSets.Unit yUnits,
		
			@NonNull java.lang.Integer delayBeforeDropMilliseconds
		
		) throws IllegalArgumentException;
	
} 