/*******************************************************************************
 * Copyright (c) 2014 BREDEX GmbH.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     BREDEX GmbH - initial API and implementation and/or initial documentation
 *******************************************************************************/
package org.eclipse.jubula.toolkit.base.internal.impl;

import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jubula.communication.CAP;
import org.apache.commons.lang.Validate;
import org.eclipse.jubula.communication.internal.message.MessageCap;
import org.eclipse.jubula.communication.internal.message.MessageParam;
import org.eclipse.jubula.tools.ComponentIdentifier;
import org.eclipse.jubula.tools.internal.objects.IComponentIdentifier;
import org.eclipse.jubula.toolkit.internal.annotations.RealizedType;
import org.eclipse.jubula.toolkit.internal.annotations.TesterClass;

/**
 * Class representing the GraphicsComponent component from the base toolkit.
 */
public class GraphicsComponent
	
	implements org.eclipse.jubula.toolkit.base.components.GraphicsComponent {
	
	
		
		
			
			@NonNull protected IComponentIdentifier m_componentIdentifier;
			public GraphicsComponent(@NonNull ComponentIdentifier componentIdentifier) {
				super();
				Validate.isTrue(componentIdentifier instanceof IComponentIdentifier);
				m_componentIdentifier = (IComponentIdentifier) componentIdentifier;
			}
		
	
	
	
	
	
		/**
		 * @throws IllegalArgumentException Throws an IllegalArgumentException if one of the parameters is null.
		 */
		
		@NonNull public CAP showText(
		
			@NonNull java.lang.String text,
		
			@NonNull java.lang.Integer textSizeInPoints,
		
			@NonNull java.lang.Integer timePerWordInMilliseconds,
		
			@NonNull java.lang.Integer windowWidthInPixels
		
		) throws IllegalArgumentException {
			MessageCap messageCap = new MessageCap();
			messageCap.setMethod("rcShowText"); //$NON-NLS-1$
			messageCap.sethasDefaultMapping(false);
			
			messageCap.setCi(m_componentIdentifier);
			
			
			
			Validate.notNull(text, "Argument 'text' must not be null"); //$NON-NLS-1$
				
				
				
			messageCap.addMessageParam(new MessageParam(text.toString(), "java.lang.String")); //$NON-NLS-1$
				
			
			
			Validate.notNull(textSizeInPoints, "Argument 'textSizeInPoints' must not be null"); //$NON-NLS-1$
				
				
				
			messageCap.addMessageParam(new MessageParam(textSizeInPoints.toString(), "java.lang.Integer")); //$NON-NLS-1$
				
			
			
			Validate.notNull(timePerWordInMilliseconds, "Argument 'timePerWordInMilliseconds' must not be null"); //$NON-NLS-1$
				
				
				
			messageCap.addMessageParam(new MessageParam(timePerWordInMilliseconds.toString(), "java.lang.Integer")); //$NON-NLS-1$
				
			
			
			Validate.notNull(windowWidthInPixels, "Argument 'windowWidthInPixels' must not be null"); //$NON-NLS-1$
				
				
				
			messageCap.addMessageParam(new MessageParam(windowWidthInPixels.toString(), "java.lang.Integer")); //$NON-NLS-1$
				
			
			return messageCap;
		}
	
		/**
		 * @throws IllegalArgumentException Throws an IllegalArgumentException if one of the parameters is null.
		 */
		
		@NonNull public CAP checkExistence(
		
			@NonNull java.lang.Boolean exists
		
		) throws IllegalArgumentException {
			MessageCap messageCap = new MessageCap();
			messageCap.setMethod("rcVerifyExists"); //$NON-NLS-1$
			messageCap.sethasDefaultMapping(false);
			
			messageCap.setCi(m_componentIdentifier);
			
			
			
			Validate.notNull(exists, "Argument 'exists' must not be null"); //$NON-NLS-1$
				
				
				
			messageCap.addMessageParam(new MessageParam(exists.toString(), "java.lang.Boolean")); //$NON-NLS-1$
				
			
			return messageCap;
		}
	
		/**
		 * @throws IllegalArgumentException Throws an IllegalArgumentException if one of the parameters is null.
		 */
		
		@NonNull public CAP checkEnablement(
		
			@NonNull java.lang.Boolean enabled
		
		) throws IllegalArgumentException {
			MessageCap messageCap = new MessageCap();
			messageCap.setMethod("rcVerifyEnabled"); //$NON-NLS-1$
			messageCap.sethasDefaultMapping(false);
			
			messageCap.setCi(m_componentIdentifier);
			
			
			
			Validate.notNull(enabled, "Argument 'enabled' must not be null"); //$NON-NLS-1$
				
				
				
			messageCap.addMessageParam(new MessageParam(enabled.toString(), "java.lang.Boolean")); //$NON-NLS-1$
				
			
			return messageCap;
		}
	
		/**
		 * @throws IllegalArgumentException Throws an IllegalArgumentException if one of the parameters is null.
		 */
		
		@NonNull public CAP checkProperty(
		
			@NonNull java.lang.String propertyName,
		
			@NonNull java.lang.String propertyValue,
		
			@NonNull org.eclipse.jubula.toolkit.enums.ValueSets.Operator operator
		
		) throws IllegalArgumentException {
			MessageCap messageCap = new MessageCap();
			messageCap.setMethod("rcVerifyProperty"); //$NON-NLS-1$
			messageCap.sethasDefaultMapping(false);
			
			messageCap.setCi(m_componentIdentifier);
			
			
			
			Validate.notNull(propertyName, "Argument 'propertyName' must not be null"); //$NON-NLS-1$
				
				
				
			messageCap.addMessageParam(new MessageParam(propertyName.toString(), "java.lang.String")); //$NON-NLS-1$
				
			
			
			Validate.notNull(propertyValue, "Argument 'propertyValue' must not be null"); //$NON-NLS-1$
				
				
				
			messageCap.addMessageParam(new MessageParam(propertyValue.toString(), "java.lang.String")); //$NON-NLS-1$
				
			
			
			Validate.notNull(operator, "Argument 'operator' must not be null"); //$NON-NLS-1$
				
				
				
			messageCap.addMessageParam(new MessageParam(operator.rcValue(), "java.lang.String")); //$NON-NLS-1$
				
			
			return messageCap;
		}
	
		/**
		 * @throws IllegalArgumentException Throws an IllegalArgumentException if one of the parameters is null.
		 */
		
		@NonNull public CAP checkFocus(
		
			@NonNull java.lang.Boolean hasFocus
		
		) throws IllegalArgumentException {
			MessageCap messageCap = new MessageCap();
			messageCap.setMethod("rcVerifyFocus"); //$NON-NLS-1$
			messageCap.sethasDefaultMapping(false);
			
			messageCap.setCi(m_componentIdentifier);
			
			
			
			Validate.notNull(hasFocus, "Argument 'hasFocus' must not be null"); //$NON-NLS-1$
				
				
				
			messageCap.addMessageParam(new MessageParam(hasFocus.toString(), "java.lang.Boolean")); //$NON-NLS-1$
				
			
			return messageCap;
		}
	
		/**
		 * @throws IllegalArgumentException Throws an IllegalArgumentException if one of the parameters is null.
		 */
		
		@NonNull public CAP waitForComponent(
		
			@NonNull java.lang.Integer timeoutInMs,
		
			@NonNull java.lang.Integer delayAfterVisibility
		
		) throws IllegalArgumentException {
			MessageCap messageCap = new MessageCap();
			messageCap.setMethod("rcWaitForComponent"); //$NON-NLS-1$
			messageCap.sethasDefaultMapping(false);
			
			messageCap.setCi(m_componentIdentifier);
			
			
			
			Validate.notNull(timeoutInMs, "Argument 'timeoutInMs' must not be null"); //$NON-NLS-1$
				
				
				
			messageCap.addMessageParam(new MessageParam(timeoutInMs.toString(), "java.lang.Integer")); //$NON-NLS-1$
				
			
			
			Validate.notNull(delayAfterVisibility, "Argument 'delayAfterVisibility' must not be null"); //$NON-NLS-1$
				
				
				
			messageCap.addMessageParam(new MessageParam(delayAfterVisibility.toString(), "java.lang.Integer")); //$NON-NLS-1$
				
			
			return messageCap;
		}
	
		/**
		 * @throws IllegalArgumentException Throws an IllegalArgumentException if one of the parameters is null.
		 */
		
		@NonNull public CAP click(
		
			@NonNull java.lang.Integer numberOfClicks,
		
			@NonNull org.eclipse.jubula.toolkit.enums.ValueSets.InteractionMode mouseButton
		
		) throws IllegalArgumentException {
			MessageCap messageCap = new MessageCap();
			messageCap.setMethod("rcClick"); //$NON-NLS-1$
			messageCap.sethasDefaultMapping(false);
			
			messageCap.setCi(m_componentIdentifier);
			
			
			
			Validate.notNull(numberOfClicks, "Argument 'numberOfClicks' must not be null"); //$NON-NLS-1$
				
				
				
			messageCap.addMessageParam(new MessageParam(numberOfClicks.toString(), "java.lang.Integer")); //$NON-NLS-1$
				
			
			
			Validate.notNull(mouseButton, "Argument 'mouseButton' must not be null"); //$NON-NLS-1$
				
				
				
			messageCap.addMessageParam(new MessageParam(mouseButton.rcValue(), "java.lang.Integer")); //$NON-NLS-1$
				
			
			return messageCap;
		}
	
		/**
		 * @throws IllegalArgumentException Throws an IllegalArgumentException if one of the parameters is null.
		 */
		
		@NonNull public CAP clickInComponent(
		
			@NonNull java.lang.Integer numberOfClicks,
		
			@NonNull org.eclipse.jubula.toolkit.enums.ValueSets.InteractionMode mouseButton,
		
			@NonNull java.lang.Integer xPosition,
		
			@NonNull org.eclipse.jubula.toolkit.enums.ValueSets.Unit xUnits,
		
			@NonNull java.lang.Integer yPosition,
		
			@NonNull org.eclipse.jubula.toolkit.enums.ValueSets.Unit yUnits
		
		) throws IllegalArgumentException {
			MessageCap messageCap = new MessageCap();
			messageCap.setMethod("rcClickDirect"); //$NON-NLS-1$
			messageCap.sethasDefaultMapping(false);
			
			messageCap.setCi(m_componentIdentifier);
			
			
			
			Validate.notNull(numberOfClicks, "Argument 'numberOfClicks' must not be null"); //$NON-NLS-1$
				
				
				
			messageCap.addMessageParam(new MessageParam(numberOfClicks.toString(), "java.lang.Integer")); //$NON-NLS-1$
				
			
			
			Validate.notNull(mouseButton, "Argument 'mouseButton' must not be null"); //$NON-NLS-1$
				
				
				
			messageCap.addMessageParam(new MessageParam(mouseButton.rcValue(), "java.lang.Integer")); //$NON-NLS-1$
				
			
			
			Validate.notNull(xPosition, "Argument 'xPosition' must not be null"); //$NON-NLS-1$
				
				
				
			messageCap.addMessageParam(new MessageParam(xPosition.toString(), "java.lang.Integer")); //$NON-NLS-1$
				
			
			
			Validate.notNull(xUnits, "Argument 'xUnits' must not be null"); //$NON-NLS-1$
				
				
				
			messageCap.addMessageParam(new MessageParam(xUnits.rcValue(), "java.lang.String")); //$NON-NLS-1$
				
			
			
			Validate.notNull(yPosition, "Argument 'yPosition' must not be null"); //$NON-NLS-1$
				
				
				
			messageCap.addMessageParam(new MessageParam(yPosition.toString(), "java.lang.Integer")); //$NON-NLS-1$
				
			
			
			Validate.notNull(yUnits, "Argument 'yUnits' must not be null"); //$NON-NLS-1$
				
				
				
			messageCap.addMessageParam(new MessageParam(yUnits.rcValue(), "java.lang.String")); //$NON-NLS-1$
				
			
			return messageCap;
		}
	
		/**
		 * @throws IllegalArgumentException Throws an IllegalArgumentException if one of the parameters is null.
		 */
		
		@NonNull public CAP selectContextMenuEntryByTextpathSpecifyPosition(
		
			@NonNull java.lang.Integer xPosition,
		
			@NonNull org.eclipse.jubula.toolkit.enums.ValueSets.Unit xUnits,
		
			@NonNull java.lang.Integer yPosition,
		
			@NonNull org.eclipse.jubula.toolkit.enums.ValueSets.Unit yUnits,
		
			@NonNull java.lang.String menupath,
		
			@NonNull org.eclipse.jubula.toolkit.enums.ValueSets.Operator operator,
		
			@NonNull org.eclipse.jubula.toolkit.enums.ValueSets.InteractionMode mouseButton
		
		) throws IllegalArgumentException {
			MessageCap messageCap = new MessageCap();
			messageCap.setMethod("rcPopupSelectByTextPath"); //$NON-NLS-1$
			messageCap.sethasDefaultMapping(false);
			
			messageCap.setCi(m_componentIdentifier);
			
			
			
			Validate.notNull(xPosition, "Argument 'xPosition' must not be null"); //$NON-NLS-1$
				
				
				
			messageCap.addMessageParam(new MessageParam(xPosition.toString(), "java.lang.Integer")); //$NON-NLS-1$
				
			
			
			Validate.notNull(xUnits, "Argument 'xUnits' must not be null"); //$NON-NLS-1$
				
				
				
			messageCap.addMessageParam(new MessageParam(xUnits.rcValue(), "java.lang.String")); //$NON-NLS-1$
				
			
			
			Validate.notNull(yPosition, "Argument 'yPosition' must not be null"); //$NON-NLS-1$
				
				
				
			messageCap.addMessageParam(new MessageParam(yPosition.toString(), "java.lang.Integer")); //$NON-NLS-1$
				
			
			
			Validate.notNull(yUnits, "Argument 'yUnits' must not be null"); //$NON-NLS-1$
				
				
				
			messageCap.addMessageParam(new MessageParam(yUnits.rcValue(), "java.lang.String")); //$NON-NLS-1$
				
			
			
			Validate.notNull(menupath, "Argument 'menupath' must not be null"); //$NON-NLS-1$
				
				
				
			messageCap.addMessageParam(new MessageParam(menupath.toString(), "java.lang.String")); //$NON-NLS-1$
				
			
			
			Validate.notNull(operator, "Argument 'operator' must not be null"); //$NON-NLS-1$
				
				
				
			messageCap.addMessageParam(new MessageParam(operator.rcValue(), "java.lang.String")); //$NON-NLS-1$
				
			
			
			Validate.notNull(mouseButton, "Argument 'mouseButton' must not be null"); //$NON-NLS-1$
				
				
				
			messageCap.addMessageParam(new MessageParam(mouseButton.rcValue(), "java.lang.Integer")); //$NON-NLS-1$
				
			
			return messageCap;
		}
	
		/**
		 * @throws IllegalArgumentException Throws an IllegalArgumentException if one of the parameters is null.
		 */
		
		@NonNull public CAP selectContextMenuEntryByIndexpath(
		
			@NonNull java.lang.String indexpath,
		
			@NonNull org.eclipse.jubula.toolkit.enums.ValueSets.InteractionMode mouseButton
		
		) throws IllegalArgumentException {
			MessageCap messageCap = new MessageCap();
			messageCap.setMethod("rcPopupSelectByIndexPath"); //$NON-NLS-1$
			messageCap.sethasDefaultMapping(false);
			
			messageCap.setCi(m_componentIdentifier);
			
			
			
			Validate.notNull(indexpath, "Argument 'indexpath' must not be null"); //$NON-NLS-1$
				
				
				
			messageCap.addMessageParam(new MessageParam(indexpath.toString(), "java.lang.String")); //$NON-NLS-1$
				
			
			
			Validate.notNull(mouseButton, "Argument 'mouseButton' must not be null"); //$NON-NLS-1$
				
				
				
			messageCap.addMessageParam(new MessageParam(mouseButton.rcValue(), "java.lang.Integer")); //$NON-NLS-1$
				
			
			return messageCap;
		}
	
		/**
		 * @throws IllegalArgumentException Throws an IllegalArgumentException if one of the parameters is null.
		 */
		
		@NonNull public CAP selectContextMenuEntryByTextpath(
		
			@NonNull java.lang.String textpath,
		
			@NonNull org.eclipse.jubula.toolkit.enums.ValueSets.Operator operator,
		
			@NonNull org.eclipse.jubula.toolkit.enums.ValueSets.InteractionMode mouseButton
		
		) throws IllegalArgumentException {
			MessageCap messageCap = new MessageCap();
			messageCap.setMethod("rcPopupSelectByTextPath"); //$NON-NLS-1$
			messageCap.sethasDefaultMapping(false);
			
			messageCap.setCi(m_componentIdentifier);
			
			
			
			Validate.notNull(textpath, "Argument 'textpath' must not be null"); //$NON-NLS-1$
				
				
				
			messageCap.addMessageParam(new MessageParam(textpath.toString(), "java.lang.String")); //$NON-NLS-1$
				
			
			
			Validate.notNull(operator, "Argument 'operator' must not be null"); //$NON-NLS-1$
				
				
				
			messageCap.addMessageParam(new MessageParam(operator.rcValue(), "java.lang.String")); //$NON-NLS-1$
				
			
			
			Validate.notNull(mouseButton, "Argument 'mouseButton' must not be null"); //$NON-NLS-1$
				
				
				
			messageCap.addMessageParam(new MessageParam(mouseButton.rcValue(), "java.lang.Integer")); //$NON-NLS-1$
				
			
			return messageCap;
		}
	
		/**
		 * @throws IllegalArgumentException Throws an IllegalArgumentException if one of the parameters is null.
		 */
		
		@NonNull public CAP selectContextMenuEntryByIndexpathSpecifyPosition(
		
			@NonNull java.lang.Integer xPosition,
		
			@NonNull org.eclipse.jubula.toolkit.enums.ValueSets.Unit xUnits,
		
			@NonNull java.lang.Integer yPosition,
		
			@NonNull org.eclipse.jubula.toolkit.enums.ValueSets.Unit yUnits,
		
			@NonNull java.lang.String indexpath,
		
			@NonNull org.eclipse.jubula.toolkit.enums.ValueSets.InteractionMode mouseButton
		
		) throws IllegalArgumentException {
			MessageCap messageCap = new MessageCap();
			messageCap.setMethod("rcPopupSelectByIndexPath"); //$NON-NLS-1$
			messageCap.sethasDefaultMapping(false);
			
			messageCap.setCi(m_componentIdentifier);
			
			
			
			Validate.notNull(xPosition, "Argument 'xPosition' must not be null"); //$NON-NLS-1$
				
				
				
			messageCap.addMessageParam(new MessageParam(xPosition.toString(), "java.lang.Integer")); //$NON-NLS-1$
				
			
			
			Validate.notNull(xUnits, "Argument 'xUnits' must not be null"); //$NON-NLS-1$
				
				
				
			messageCap.addMessageParam(new MessageParam(xUnits.rcValue(), "java.lang.String")); //$NON-NLS-1$
				
			
			
			Validate.notNull(yPosition, "Argument 'yPosition' must not be null"); //$NON-NLS-1$
				
				
				
			messageCap.addMessageParam(new MessageParam(yPosition.toString(), "java.lang.Integer")); //$NON-NLS-1$
				
			
			
			Validate.notNull(yUnits, "Argument 'yUnits' must not be null"); //$NON-NLS-1$
				
				
				
			messageCap.addMessageParam(new MessageParam(yUnits.rcValue(), "java.lang.String")); //$NON-NLS-1$
				
			
			
			Validate.notNull(indexpath, "Argument 'indexpath' must not be null"); //$NON-NLS-1$
				
				
				
			messageCap.addMessageParam(new MessageParam(indexpath.toString(), "java.lang.String")); //$NON-NLS-1$
				
			
			
			Validate.notNull(mouseButton, "Argument 'mouseButton' must not be null"); //$NON-NLS-1$
				
				
				
			messageCap.addMessageParam(new MessageParam(mouseButton.rcValue(), "java.lang.Integer")); //$NON-NLS-1$
				
			
			return messageCap;
		}
	
		/**
		 * @throws IllegalArgumentException Throws an IllegalArgumentException if one of the parameters is null.
		 */
		
		@NonNull public CAP checkEnablementOfContextMenuEntryByIndexpath(
		
			@NonNull java.lang.String indexpath,
		
			@NonNull java.lang.Boolean enabled,
		
			@NonNull org.eclipse.jubula.toolkit.enums.ValueSets.InteractionMode mouseButton
		
		) throws IllegalArgumentException {
			MessageCap messageCap = new MessageCap();
			messageCap.setMethod("rcPopupVerifyEnabledByIndexPath"); //$NON-NLS-1$
			messageCap.sethasDefaultMapping(false);
			
			messageCap.setCi(m_componentIdentifier);
			
			
			
			Validate.notNull(indexpath, "Argument 'indexpath' must not be null"); //$NON-NLS-1$
				
				
				
			messageCap.addMessageParam(new MessageParam(indexpath.toString(), "java.lang.String")); //$NON-NLS-1$
				
			
			
			Validate.notNull(enabled, "Argument 'enabled' must not be null"); //$NON-NLS-1$
				
				
				
			messageCap.addMessageParam(new MessageParam(enabled.toString(), "java.lang.Boolean")); //$NON-NLS-1$
				
			
			
			Validate.notNull(mouseButton, "Argument 'mouseButton' must not be null"); //$NON-NLS-1$
				
				
				
			messageCap.addMessageParam(new MessageParam(mouseButton.rcValue(), "java.lang.Integer")); //$NON-NLS-1$
				
			
			return messageCap;
		}
	
		/**
		 * @throws IllegalArgumentException Throws an IllegalArgumentException if one of the parameters is null.
		 */
		
		@NonNull public CAP checkEnablementOfContextMenuEntryByIndexpathSpecifyPosition(
		
			@NonNull java.lang.Integer xPosition,
		
			@NonNull org.eclipse.jubula.toolkit.enums.ValueSets.Unit xUnits,
		
			@NonNull java.lang.Integer yPosition,
		
			@NonNull org.eclipse.jubula.toolkit.enums.ValueSets.Unit yUnits,
		
			@NonNull java.lang.String indexpath,
		
			@NonNull java.lang.Boolean enabled,
		
			@NonNull org.eclipse.jubula.toolkit.enums.ValueSets.InteractionMode mouseButton
		
		) throws IllegalArgumentException {
			MessageCap messageCap = new MessageCap();
			messageCap.setMethod("rcPopupVerifyEnabledByIndexPath"); //$NON-NLS-1$
			messageCap.sethasDefaultMapping(false);
			
			messageCap.setCi(m_componentIdentifier);
			
			
			
			Validate.notNull(xPosition, "Argument 'xPosition' must not be null"); //$NON-NLS-1$
				
				
				
			messageCap.addMessageParam(new MessageParam(xPosition.toString(), "java.lang.Integer")); //$NON-NLS-1$
				
			
			
			Validate.notNull(xUnits, "Argument 'xUnits' must not be null"); //$NON-NLS-1$
				
				
				
			messageCap.addMessageParam(new MessageParam(xUnits.rcValue(), "java.lang.String")); //$NON-NLS-1$
				
			
			
			Validate.notNull(yPosition, "Argument 'yPosition' must not be null"); //$NON-NLS-1$
				
				
				
			messageCap.addMessageParam(new MessageParam(yPosition.toString(), "java.lang.Integer")); //$NON-NLS-1$
				
			
			
			Validate.notNull(yUnits, "Argument 'yUnits' must not be null"); //$NON-NLS-1$
				
				
				
			messageCap.addMessageParam(new MessageParam(yUnits.rcValue(), "java.lang.String")); //$NON-NLS-1$
				
			
			
			Validate.notNull(indexpath, "Argument 'indexpath' must not be null"); //$NON-NLS-1$
				
				
				
			messageCap.addMessageParam(new MessageParam(indexpath.toString(), "java.lang.String")); //$NON-NLS-1$
				
			
			
			Validate.notNull(enabled, "Argument 'enabled' must not be null"); //$NON-NLS-1$
				
				
				
			messageCap.addMessageParam(new MessageParam(enabled.toString(), "java.lang.Boolean")); //$NON-NLS-1$
				
			
			
			Validate.notNull(mouseButton, "Argument 'mouseButton' must not be null"); //$NON-NLS-1$
				
				
				
			messageCap.addMessageParam(new MessageParam(mouseButton.rcValue(), "java.lang.Integer")); //$NON-NLS-1$
				
			
			return messageCap;
		}
	
		/**
		 * @throws IllegalArgumentException Throws an IllegalArgumentException if one of the parameters is null.
		 */
		
		@NonNull public CAP checkEnablementOfContextMenuEntryByTextpath(
		
			@NonNull java.lang.String textpath,
		
			@NonNull org.eclipse.jubula.toolkit.enums.ValueSets.Operator operator,
		
			@NonNull java.lang.Boolean enabled,
		
			@NonNull org.eclipse.jubula.toolkit.enums.ValueSets.InteractionMode mouseButton
		
		) throws IllegalArgumentException {
			MessageCap messageCap = new MessageCap();
			messageCap.setMethod("rcPopupVerifyEnabledByTextPath"); //$NON-NLS-1$
			messageCap.sethasDefaultMapping(false);
			
			messageCap.setCi(m_componentIdentifier);
			
			
			
			Validate.notNull(textpath, "Argument 'textpath' must not be null"); //$NON-NLS-1$
				
				
				
			messageCap.addMessageParam(new MessageParam(textpath.toString(), "java.lang.String")); //$NON-NLS-1$
				
			
			
			Validate.notNull(operator, "Argument 'operator' must not be null"); //$NON-NLS-1$
				
				
				
			messageCap.addMessageParam(new MessageParam(operator.rcValue(), "java.lang.String")); //$NON-NLS-1$
				
			
			
			Validate.notNull(enabled, "Argument 'enabled' must not be null"); //$NON-NLS-1$
				
				
				
			messageCap.addMessageParam(new MessageParam(enabled.toString(), "java.lang.Boolean")); //$NON-NLS-1$
				
			
			
			Validate.notNull(mouseButton, "Argument 'mouseButton' must not be null"); //$NON-NLS-1$
				
				
				
			messageCap.addMessageParam(new MessageParam(mouseButton.rcValue(), "java.lang.Integer")); //$NON-NLS-1$
				
			
			return messageCap;
		}
	
		/**
		 * @throws IllegalArgumentException Throws an IllegalArgumentException if one of the parameters is null.
		 */
		
		@NonNull public CAP checkEnablementOfContextMenuEntryByTextpathSpecifyPosition(
		
			@NonNull java.lang.Integer xPosition,
		
			@NonNull org.eclipse.jubula.toolkit.enums.ValueSets.Unit xUnits,
		
			@NonNull java.lang.Integer yPosition,
		
			@NonNull org.eclipse.jubula.toolkit.enums.ValueSets.Unit yUnits,
		
			@NonNull java.lang.String textpath,
		
			@NonNull org.eclipse.jubula.toolkit.enums.ValueSets.Operator operator,
		
			@NonNull java.lang.Boolean enabled,
		
			@NonNull org.eclipse.jubula.toolkit.enums.ValueSets.InteractionMode mouseButton
		
		) throws IllegalArgumentException {
			MessageCap messageCap = new MessageCap();
			messageCap.setMethod("rcPopupVerifyEnabledByTextPath"); //$NON-NLS-1$
			messageCap.sethasDefaultMapping(false);
			
			messageCap.setCi(m_componentIdentifier);
			
			
			
			Validate.notNull(xPosition, "Argument 'xPosition' must not be null"); //$NON-NLS-1$
				
				
				
			messageCap.addMessageParam(new MessageParam(xPosition.toString(), "java.lang.Integer")); //$NON-NLS-1$
				
			
			
			Validate.notNull(xUnits, "Argument 'xUnits' must not be null"); //$NON-NLS-1$
				
				
				
			messageCap.addMessageParam(new MessageParam(xUnits.rcValue(), "java.lang.String")); //$NON-NLS-1$
				
			
			
			Validate.notNull(yPosition, "Argument 'yPosition' must not be null"); //$NON-NLS-1$
				
				
				
			messageCap.addMessageParam(new MessageParam(yPosition.toString(), "java.lang.Integer")); //$NON-NLS-1$
				
			
			
			Validate.notNull(yUnits, "Argument 'yUnits' must not be null"); //$NON-NLS-1$
				
				
				
			messageCap.addMessageParam(new MessageParam(yUnits.rcValue(), "java.lang.String")); //$NON-NLS-1$
				
			
			
			Validate.notNull(textpath, "Argument 'textpath' must not be null"); //$NON-NLS-1$
				
				
				
			messageCap.addMessageParam(new MessageParam(textpath.toString(), "java.lang.String")); //$NON-NLS-1$
				
			
			
			Validate.notNull(operator, "Argument 'operator' must not be null"); //$NON-NLS-1$
				
				
				
			messageCap.addMessageParam(new MessageParam(operator.rcValue(), "java.lang.String")); //$NON-NLS-1$
				
			
			
			Validate.notNull(enabled, "Argument 'enabled' must not be null"); //$NON-NLS-1$
				
				
				
			messageCap.addMessageParam(new MessageParam(enabled.toString(), "java.lang.Boolean")); //$NON-NLS-1$
				
			
			
			Validate.notNull(mouseButton, "Argument 'mouseButton' must not be null"); //$NON-NLS-1$
				
				
				
			messageCap.addMessageParam(new MessageParam(mouseButton.rcValue(), "java.lang.Integer")); //$NON-NLS-1$
				
			
			return messageCap;
		}
	
		/**
		 * @throws IllegalArgumentException Throws an IllegalArgumentException if one of the parameters is null.
		 */
		
		@NonNull public CAP checkExistenceOfContextMenuEntryByIndexpath(
		
			@NonNull java.lang.String indexpath,
		
			@NonNull java.lang.Boolean exists,
		
			@NonNull org.eclipse.jubula.toolkit.enums.ValueSets.InteractionMode mouseButton
		
		) throws IllegalArgumentException {
			MessageCap messageCap = new MessageCap();
			messageCap.setMethod("rcPopupVerifyExistsByIndexPath"); //$NON-NLS-1$
			messageCap.sethasDefaultMapping(false);
			
			messageCap.setCi(m_componentIdentifier);
			
			
			
			Validate.notNull(indexpath, "Argument 'indexpath' must not be null"); //$NON-NLS-1$
				
				
				
			messageCap.addMessageParam(new MessageParam(indexpath.toString(), "java.lang.String")); //$NON-NLS-1$
				
			
			
			Validate.notNull(exists, "Argument 'exists' must not be null"); //$NON-NLS-1$
				
				
				
			messageCap.addMessageParam(new MessageParam(exists.toString(), "java.lang.Boolean")); //$NON-NLS-1$
				
			
			
			Validate.notNull(mouseButton, "Argument 'mouseButton' must not be null"); //$NON-NLS-1$
				
				
				
			messageCap.addMessageParam(new MessageParam(mouseButton.rcValue(), "java.lang.Integer")); //$NON-NLS-1$
				
			
			return messageCap;
		}
	
		/**
		 * @throws IllegalArgumentException Throws an IllegalArgumentException if one of the parameters is null.
		 */
		
		@NonNull public CAP checkExistenceOfContextMenuEntryByIndexpathSpecifyPosition(
		
			@NonNull java.lang.Integer xPosition,
		
			@NonNull org.eclipse.jubula.toolkit.enums.ValueSets.Unit xUnits,
		
			@NonNull java.lang.Integer yPosition,
		
			@NonNull org.eclipse.jubula.toolkit.enums.ValueSets.Unit yUnits,
		
			@NonNull java.lang.String indexpath,
		
			@NonNull java.lang.Boolean exists,
		
			@NonNull org.eclipse.jubula.toolkit.enums.ValueSets.InteractionMode mouseButton
		
		) throws IllegalArgumentException {
			MessageCap messageCap = new MessageCap();
			messageCap.setMethod("rcPopupVerifyExistsByIndexPath"); //$NON-NLS-1$
			messageCap.sethasDefaultMapping(false);
			
			messageCap.setCi(m_componentIdentifier);
			
			
			
			Validate.notNull(xPosition, "Argument 'xPosition' must not be null"); //$NON-NLS-1$
				
				
				
			messageCap.addMessageParam(new MessageParam(xPosition.toString(), "java.lang.Integer")); //$NON-NLS-1$
				
			
			
			Validate.notNull(xUnits, "Argument 'xUnits' must not be null"); //$NON-NLS-1$
				
				
				
			messageCap.addMessageParam(new MessageParam(xUnits.rcValue(), "java.lang.String")); //$NON-NLS-1$
				
			
			
			Validate.notNull(yPosition, "Argument 'yPosition' must not be null"); //$NON-NLS-1$
				
				
				
			messageCap.addMessageParam(new MessageParam(yPosition.toString(), "java.lang.Integer")); //$NON-NLS-1$
				
			
			
			Validate.notNull(yUnits, "Argument 'yUnits' must not be null"); //$NON-NLS-1$
				
				
				
			messageCap.addMessageParam(new MessageParam(yUnits.rcValue(), "java.lang.String")); //$NON-NLS-1$
				
			
			
			Validate.notNull(indexpath, "Argument 'indexpath' must not be null"); //$NON-NLS-1$
				
				
				
			messageCap.addMessageParam(new MessageParam(indexpath.toString(), "java.lang.String")); //$NON-NLS-1$
				
			
			
			Validate.notNull(exists, "Argument 'exists' must not be null"); //$NON-NLS-1$
				
				
				
			messageCap.addMessageParam(new MessageParam(exists.toString(), "java.lang.Boolean")); //$NON-NLS-1$
				
			
			
			Validate.notNull(mouseButton, "Argument 'mouseButton' must not be null"); //$NON-NLS-1$
				
				
				
			messageCap.addMessageParam(new MessageParam(mouseButton.rcValue(), "java.lang.Integer")); //$NON-NLS-1$
				
			
			return messageCap;
		}
	
		/**
		 * @throws IllegalArgumentException Throws an IllegalArgumentException if one of the parameters is null.
		 */
		
		@NonNull public CAP checkExistenceOfContextMenuEntryByTextpath(
		
			@NonNull java.lang.String textpath,
		
			@NonNull org.eclipse.jubula.toolkit.enums.ValueSets.Operator operator,
		
			@NonNull java.lang.Boolean exists,
		
			@NonNull org.eclipse.jubula.toolkit.enums.ValueSets.InteractionMode mouseButton
		
		) throws IllegalArgumentException {
			MessageCap messageCap = new MessageCap();
			messageCap.setMethod("rcPopupVerifyExistsByTextPath"); //$NON-NLS-1$
			messageCap.sethasDefaultMapping(false);
			
			messageCap.setCi(m_componentIdentifier);
			
			
			
			Validate.notNull(textpath, "Argument 'textpath' must not be null"); //$NON-NLS-1$
				
				
				
			messageCap.addMessageParam(new MessageParam(textpath.toString(), "java.lang.String")); //$NON-NLS-1$
				
			
			
			Validate.notNull(operator, "Argument 'operator' must not be null"); //$NON-NLS-1$
				
				
				
			messageCap.addMessageParam(new MessageParam(operator.rcValue(), "java.lang.String")); //$NON-NLS-1$
				
			
			
			Validate.notNull(exists, "Argument 'exists' must not be null"); //$NON-NLS-1$
				
				
				
			messageCap.addMessageParam(new MessageParam(exists.toString(), "java.lang.Boolean")); //$NON-NLS-1$
				
			
			
			Validate.notNull(mouseButton, "Argument 'mouseButton' must not be null"); //$NON-NLS-1$
				
				
				
			messageCap.addMessageParam(new MessageParam(mouseButton.rcValue(), "java.lang.Integer")); //$NON-NLS-1$
				
			
			return messageCap;
		}
	
		/**
		 * @throws IllegalArgumentException Throws an IllegalArgumentException if one of the parameters is null.
		 */
		
		@NonNull public CAP checkExistenceOfContextMenuEntryByTextpathSpecifyPosition(
		
			@NonNull java.lang.Integer xPosition,
		
			@NonNull org.eclipse.jubula.toolkit.enums.ValueSets.Unit xUnits,
		
			@NonNull java.lang.Integer yPosition,
		
			@NonNull org.eclipse.jubula.toolkit.enums.ValueSets.Unit yUnits,
		
			@NonNull java.lang.String textpath,
		
			@NonNull org.eclipse.jubula.toolkit.enums.ValueSets.Operator operator,
		
			@NonNull java.lang.Boolean exists,
		
			@NonNull org.eclipse.jubula.toolkit.enums.ValueSets.InteractionMode mouseButton
		
		) throws IllegalArgumentException {
			MessageCap messageCap = new MessageCap();
			messageCap.setMethod("rcPopupVerifyExistsByTextPath"); //$NON-NLS-1$
			messageCap.sethasDefaultMapping(false);
			
			messageCap.setCi(m_componentIdentifier);
			
			
			
			Validate.notNull(xPosition, "Argument 'xPosition' must not be null"); //$NON-NLS-1$
				
				
				
			messageCap.addMessageParam(new MessageParam(xPosition.toString(), "java.lang.Integer")); //$NON-NLS-1$
				
			
			
			Validate.notNull(xUnits, "Argument 'xUnits' must not be null"); //$NON-NLS-1$
				
				
				
			messageCap.addMessageParam(new MessageParam(xUnits.rcValue(), "java.lang.String")); //$NON-NLS-1$
				
			
			
			Validate.notNull(yPosition, "Argument 'yPosition' must not be null"); //$NON-NLS-1$
				
				
				
			messageCap.addMessageParam(new MessageParam(yPosition.toString(), "java.lang.Integer")); //$NON-NLS-1$
				
			
			
			Validate.notNull(yUnits, "Argument 'yUnits' must not be null"); //$NON-NLS-1$
				
				
				
			messageCap.addMessageParam(new MessageParam(yUnits.rcValue(), "java.lang.String")); //$NON-NLS-1$
				
			
			
			Validate.notNull(textpath, "Argument 'textpath' must not be null"); //$NON-NLS-1$
				
				
				
			messageCap.addMessageParam(new MessageParam(textpath.toString(), "java.lang.String")); //$NON-NLS-1$
				
			
			
			Validate.notNull(operator, "Argument 'operator' must not be null"); //$NON-NLS-1$
				
				
				
			messageCap.addMessageParam(new MessageParam(operator.rcValue(), "java.lang.String")); //$NON-NLS-1$
				
			
			
			Validate.notNull(exists, "Argument 'exists' must not be null"); //$NON-NLS-1$
				
				
				
			messageCap.addMessageParam(new MessageParam(exists.toString(), "java.lang.Boolean")); //$NON-NLS-1$
				
			
			
			Validate.notNull(mouseButton, "Argument 'mouseButton' must not be null"); //$NON-NLS-1$
				
				
				
			messageCap.addMessageParam(new MessageParam(mouseButton.rcValue(), "java.lang.Integer")); //$NON-NLS-1$
				
			
			return messageCap;
		}
	
		/**
		 * @throws IllegalArgumentException Throws an IllegalArgumentException if one of the parameters is null.
		 */
		
		@NonNull public CAP checkSelectionOfContextMenuEntryByIndexpath(
		
			@NonNull java.lang.String indexpath,
		
			@NonNull java.lang.Boolean selected,
		
			@NonNull org.eclipse.jubula.toolkit.enums.ValueSets.InteractionMode mouseButton
		
		) throws IllegalArgumentException {
			MessageCap messageCap = new MessageCap();
			messageCap.setMethod("rcPopupVerifySelectedByIndexPath"); //$NON-NLS-1$
			messageCap.sethasDefaultMapping(false);
			
			messageCap.setCi(m_componentIdentifier);
			
			
			
			Validate.notNull(indexpath, "Argument 'indexpath' must not be null"); //$NON-NLS-1$
				
				
				
			messageCap.addMessageParam(new MessageParam(indexpath.toString(), "java.lang.String")); //$NON-NLS-1$
				
			
			
			Validate.notNull(selected, "Argument 'selected' must not be null"); //$NON-NLS-1$
				
				
				
			messageCap.addMessageParam(new MessageParam(selected.toString(), "java.lang.Boolean")); //$NON-NLS-1$
				
			
			
			Validate.notNull(mouseButton, "Argument 'mouseButton' must not be null"); //$NON-NLS-1$
				
				
				
			messageCap.addMessageParam(new MessageParam(mouseButton.rcValue(), "java.lang.Integer")); //$NON-NLS-1$
				
			
			return messageCap;
		}
	
		/**
		 * @throws IllegalArgumentException Throws an IllegalArgumentException if one of the parameters is null.
		 */
		
		@NonNull public CAP checkSelectionOfContextMenuEntryByIndexpathSpecifyPosition(
		
			@NonNull java.lang.Integer xPosition,
		
			@NonNull org.eclipse.jubula.toolkit.enums.ValueSets.Unit xUnits,
		
			@NonNull java.lang.Integer yPosition,
		
			@NonNull org.eclipse.jubula.toolkit.enums.ValueSets.Unit yUnits,
		
			@NonNull java.lang.String indexpath,
		
			@NonNull java.lang.Boolean selected,
		
			@NonNull org.eclipse.jubula.toolkit.enums.ValueSets.InteractionMode mouseButton
		
		) throws IllegalArgumentException {
			MessageCap messageCap = new MessageCap();
			messageCap.setMethod("rcPopupVerifySelectedByIndexPath"); //$NON-NLS-1$
			messageCap.sethasDefaultMapping(false);
			
			messageCap.setCi(m_componentIdentifier);
			
			
			
			Validate.notNull(xPosition, "Argument 'xPosition' must not be null"); //$NON-NLS-1$
				
				
				
			messageCap.addMessageParam(new MessageParam(xPosition.toString(), "java.lang.Integer")); //$NON-NLS-1$
				
			
			
			Validate.notNull(xUnits, "Argument 'xUnits' must not be null"); //$NON-NLS-1$
				
				
				
			messageCap.addMessageParam(new MessageParam(xUnits.rcValue(), "java.lang.String")); //$NON-NLS-1$
				
			
			
			Validate.notNull(yPosition, "Argument 'yPosition' must not be null"); //$NON-NLS-1$
				
				
				
			messageCap.addMessageParam(new MessageParam(yPosition.toString(), "java.lang.Integer")); //$NON-NLS-1$
				
			
			
			Validate.notNull(yUnits, "Argument 'yUnits' must not be null"); //$NON-NLS-1$
				
				
				
			messageCap.addMessageParam(new MessageParam(yUnits.rcValue(), "java.lang.String")); //$NON-NLS-1$
				
			
			
			Validate.notNull(indexpath, "Argument 'indexpath' must not be null"); //$NON-NLS-1$
				
				
				
			messageCap.addMessageParam(new MessageParam(indexpath.toString(), "java.lang.String")); //$NON-NLS-1$
				
			
			
			Validate.notNull(selected, "Argument 'selected' must not be null"); //$NON-NLS-1$
				
				
				
			messageCap.addMessageParam(new MessageParam(selected.toString(), "java.lang.Boolean")); //$NON-NLS-1$
				
			
			
			Validate.notNull(mouseButton, "Argument 'mouseButton' must not be null"); //$NON-NLS-1$
				
				
				
			messageCap.addMessageParam(new MessageParam(mouseButton.rcValue(), "java.lang.Integer")); //$NON-NLS-1$
				
			
			return messageCap;
		}
	
		/**
		 * @throws IllegalArgumentException Throws an IllegalArgumentException if one of the parameters is null.
		 */
		
		@NonNull public CAP checkSelectionOfContextMenuEntryByTextpath(
		
			@NonNull java.lang.String textpath,
		
			@NonNull org.eclipse.jubula.toolkit.enums.ValueSets.Operator operator,
		
			@NonNull java.lang.Boolean selected,
		
			@NonNull org.eclipse.jubula.toolkit.enums.ValueSets.InteractionMode mouseButton
		
		) throws IllegalArgumentException {
			MessageCap messageCap = new MessageCap();
			messageCap.setMethod("rcPopupVerifySelectedByTextPath"); //$NON-NLS-1$
			messageCap.sethasDefaultMapping(false);
			
			messageCap.setCi(m_componentIdentifier);
			
			
			
			Validate.notNull(textpath, "Argument 'textpath' must not be null"); //$NON-NLS-1$
				
				
				
			messageCap.addMessageParam(new MessageParam(textpath.toString(), "java.lang.String")); //$NON-NLS-1$
				
			
			
			Validate.notNull(operator, "Argument 'operator' must not be null"); //$NON-NLS-1$
				
				
				
			messageCap.addMessageParam(new MessageParam(operator.rcValue(), "java.lang.String")); //$NON-NLS-1$
				
			
			
			Validate.notNull(selected, "Argument 'selected' must not be null"); //$NON-NLS-1$
				
				
				
			messageCap.addMessageParam(new MessageParam(selected.toString(), "java.lang.Boolean")); //$NON-NLS-1$
				
			
			
			Validate.notNull(mouseButton, "Argument 'mouseButton' must not be null"); //$NON-NLS-1$
				
				
				
			messageCap.addMessageParam(new MessageParam(mouseButton.rcValue(), "java.lang.Integer")); //$NON-NLS-1$
				
			
			return messageCap;
		}
	
		/**
		 * @throws IllegalArgumentException Throws an IllegalArgumentException if one of the parameters is null.
		 */
		
		@NonNull public CAP checkSelectionOfContextMenuEntryByTextpathSpecifyPosition(
		
			@NonNull java.lang.Integer xPosition,
		
			@NonNull org.eclipse.jubula.toolkit.enums.ValueSets.Unit xUnits,
		
			@NonNull java.lang.Integer yPosition,
		
			@NonNull org.eclipse.jubula.toolkit.enums.ValueSets.Unit yUnits,
		
			@NonNull java.lang.String textpath,
		
			@NonNull org.eclipse.jubula.toolkit.enums.ValueSets.Operator operator,
		
			@NonNull java.lang.Boolean selected,
		
			@NonNull org.eclipse.jubula.toolkit.enums.ValueSets.InteractionMode mouseButton
		
		) throws IllegalArgumentException {
			MessageCap messageCap = new MessageCap();
			messageCap.setMethod("rcPopupVerifySelectedByTextPath"); //$NON-NLS-1$
			messageCap.sethasDefaultMapping(false);
			
			messageCap.setCi(m_componentIdentifier);
			
			
			
			Validate.notNull(xPosition, "Argument 'xPosition' must not be null"); //$NON-NLS-1$
				
				
				
			messageCap.addMessageParam(new MessageParam(xPosition.toString(), "java.lang.Integer")); //$NON-NLS-1$
				
			
			
			Validate.notNull(xUnits, "Argument 'xUnits' must not be null"); //$NON-NLS-1$
				
				
				
			messageCap.addMessageParam(new MessageParam(xUnits.rcValue(), "java.lang.String")); //$NON-NLS-1$
				
			
			
			Validate.notNull(yPosition, "Argument 'yPosition' must not be null"); //$NON-NLS-1$
				
				
				
			messageCap.addMessageParam(new MessageParam(yPosition.toString(), "java.lang.Integer")); //$NON-NLS-1$
				
			
			
			Validate.notNull(yUnits, "Argument 'yUnits' must not be null"); //$NON-NLS-1$
				
				
				
			messageCap.addMessageParam(new MessageParam(yUnits.rcValue(), "java.lang.String")); //$NON-NLS-1$
				
			
			
			Validate.notNull(textpath, "Argument 'textpath' must not be null"); //$NON-NLS-1$
				
				
				
			messageCap.addMessageParam(new MessageParam(textpath.toString(), "java.lang.String")); //$NON-NLS-1$
				
			
			
			Validate.notNull(operator, "Argument 'operator' must not be null"); //$NON-NLS-1$
				
				
				
			messageCap.addMessageParam(new MessageParam(operator.rcValue(), "java.lang.String")); //$NON-NLS-1$
				
			
			
			Validate.notNull(selected, "Argument 'selected' must not be null"); //$NON-NLS-1$
				
				
				
			messageCap.addMessageParam(new MessageParam(selected.toString(), "java.lang.Boolean")); //$NON-NLS-1$
				
			
			
			Validate.notNull(mouseButton, "Argument 'mouseButton' must not be null"); //$NON-NLS-1$
				
				
				
			messageCap.addMessageParam(new MessageParam(mouseButton.rcValue(), "java.lang.Integer")); //$NON-NLS-1$
				
			
			return messageCap;
		}
	
		/**
		 * @throws IllegalArgumentException Throws an IllegalArgumentException if one of the parameters is null.
		 */
		
		@NonNull public CAP drag(
		
			@NonNull org.eclipse.jubula.toolkit.enums.ValueSets.InteractionMode mouseButton,
		
			@NonNull org.eclipse.jubula.toolkit.enums.ValueSets.Modifier modifierKeys,
		
			@NonNull java.lang.Integer xPosition,
		
			@NonNull org.eclipse.jubula.toolkit.enums.ValueSets.Unit xUnits,
		
			@NonNull java.lang.Integer yPosition,
		
			@NonNull org.eclipse.jubula.toolkit.enums.ValueSets.Unit yUnits
		
		) throws IllegalArgumentException {
			MessageCap messageCap = new MessageCap();
			messageCap.setMethod("rcDrag"); //$NON-NLS-1$
			messageCap.sethasDefaultMapping(false);
			
			messageCap.setCi(m_componentIdentifier);
			
			
			
			Validate.notNull(mouseButton, "Argument 'mouseButton' must not be null"); //$NON-NLS-1$
				
				
				
			messageCap.addMessageParam(new MessageParam(mouseButton.rcValue(), "java.lang.Integer")); //$NON-NLS-1$
				
			
			
			Validate.notNull(modifierKeys, "Argument 'modifierKeys' must not be null"); //$NON-NLS-1$
				
				
				
			messageCap.addMessageParam(new MessageParam(modifierKeys.rcValue(), "java.lang.String")); //$NON-NLS-1$
				
			
			
			Validate.notNull(xPosition, "Argument 'xPosition' must not be null"); //$NON-NLS-1$
				
				
				
			messageCap.addMessageParam(new MessageParam(xPosition.toString(), "java.lang.Integer")); //$NON-NLS-1$
				
			
			
			Validate.notNull(xUnits, "Argument 'xUnits' must not be null"); //$NON-NLS-1$
				
				
				
			messageCap.addMessageParam(new MessageParam(xUnits.rcValue(), "java.lang.String")); //$NON-NLS-1$
				
			
			
			Validate.notNull(yPosition, "Argument 'yPosition' must not be null"); //$NON-NLS-1$
				
				
				
			messageCap.addMessageParam(new MessageParam(yPosition.toString(), "java.lang.Integer")); //$NON-NLS-1$
				
			
			
			Validate.notNull(yUnits, "Argument 'yUnits' must not be null"); //$NON-NLS-1$
				
				
				
			messageCap.addMessageParam(new MessageParam(yUnits.rcValue(), "java.lang.String")); //$NON-NLS-1$
				
			
			return messageCap;
		}
	
		/**
		 * @throws IllegalArgumentException Throws an IllegalArgumentException if one of the parameters is null.
		 */
		
		@NonNull public CAP drop(
		
			@NonNull java.lang.Integer xPosition,
		
			@NonNull org.eclipse.jubula.toolkit.enums.ValueSets.Unit xUnits,
		
			@NonNull java.lang.Integer yPosition,
		
			@NonNull org.eclipse.jubula.toolkit.enums.ValueSets.Unit yUnits,
		
			@NonNull java.lang.Integer delayBeforeDropMilliseconds
		
		) throws IllegalArgumentException {
			MessageCap messageCap = new MessageCap();
			messageCap.setMethod("rcDrop"); //$NON-NLS-1$
			messageCap.sethasDefaultMapping(false);
			
			messageCap.setCi(m_componentIdentifier);
			
			
			
			Validate.notNull(xPosition, "Argument 'xPosition' must not be null"); //$NON-NLS-1$
				
				
				
			messageCap.addMessageParam(new MessageParam(xPosition.toString(), "java.lang.Integer")); //$NON-NLS-1$
				
			
			
			Validate.notNull(xUnits, "Argument 'xUnits' must not be null"); //$NON-NLS-1$
				
				
				
			messageCap.addMessageParam(new MessageParam(xUnits.rcValue(), "java.lang.String")); //$NON-NLS-1$
				
			
			
			Validate.notNull(yPosition, "Argument 'yPosition' must not be null"); //$NON-NLS-1$
				
				
				
			messageCap.addMessageParam(new MessageParam(yPosition.toString(), "java.lang.Integer")); //$NON-NLS-1$
				
			
			
			Validate.notNull(yUnits, "Argument 'yUnits' must not be null"); //$NON-NLS-1$
				
				
				
			messageCap.addMessageParam(new MessageParam(yUnits.rcValue(), "java.lang.String")); //$NON-NLS-1$
				
			
			
			Validate.notNull(delayBeforeDropMilliseconds, "Argument 'delayBeforeDropMilliseconds' must not be null"); //$NON-NLS-1$
				
				
				
			messageCap.addMessageParam(new MessageParam(delayBeforeDropMilliseconds.toString(), "java.lang.Integer")); //$NON-NLS-1$
				
			
			return messageCap;
		}
	
} 