/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.toolkit.common.xml.businessprocess;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.ResourceBundle;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.InvalidRegistryObjectException;
import org.eclipse.jubula.toolkit.common.IToolKitProvider;
import org.eclipse.jubula.toolkit.common.PluginStarter;
import org.eclipse.jubula.toolkit.common.businessprocess.ToolkitSupportBP;
import org.eclipse.jubula.toolkit.common.exception.ToolkitPluginException;
import org.eclipse.jubula.toolkit.common.i18n.Messages;
import org.eclipse.jubula.tools.internal.exception.ConfigXmlException;
import org.eclipse.jubula.tools.internal.i18n.CompSystemI18n;
import org.eclipse.jubula.tools.internal.messagehandling.MessageIDs;
import org.eclipse.jubula.tools.internal.utils.generator.AbstractComponentBuilder;
import org.eclipse.jubula.tools.internal.xml.businessmodell.CompSystem;
import org.eclipse.jubula.tools.internal.xml.businessmodell.ToolkitDescriptor;
import org.eclipse.jubula.tools.internal.xml.businessprocess.ConfigVersion;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ComponentBuilder
extends AbstractComponentBuilder {
    private static ComponentBuilder instance;
    private static Logger log;

    static {
        log = LoggerFactory.getLogger(ComponentBuilder.class);
    }

    private ComponentBuilder() {
    }

    private void initCompSystem() throws ToolkitPluginException {
        IExtension[] plugins;
        IExtension[] iExtensionArray = plugins = PluginStarter.getDefault().findToolkitPlugins();
        int n = plugins.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement[] elements;
            IExtension extension = iExtensionArray[n2];
            IConfigurationElement[] iConfigurationElementArray = elements = extension.getConfigurationElements();
            int n3 = elements.length;
            int n4 = 0;
            while (n4 < n3) {
                String msg;
                IConfigurationElement element = iConfigurationElementArray[n4];
                try {
                    IToolKitProvider provider = (IToolKitProvider)element.createExecutableExtension("IToolkitProvider");
                    URL componentConfigurationURL = provider.getComponentConfigurationFileURL();
                    InputStream inputStream = this.getInputStream(componentConfigurationURL);
                    CompSystem compSystem = this.createCompSystem(inputStream);
                    ToolkitDescriptor descr = this.createToolkitDescriptor(element, compSystem);
                    ResourceBundle resourceBundle = provider.getI18nResourceBundle();
                    if (resourceBundle == null) {
                        log.error(String.valueOf(Messages.NoI18n) + "-" + Messages.ResourceBundleAvailable + ":" + " " + String.valueOf(descr.getName()));
                    }
                    CompSystemI18n.addResourceBundle((ResourceBundle)resourceBundle);
                    this.setToolkitDescriptorToComponents(compSystem, descr);
                    this.addToolkitToCompSystem(compSystem);
                    ToolkitSupportBP.addToolkitProvider(descr, provider);
                }
                catch (IOException fileNotFoundEx) {
                    msg = String.valueOf(Messages.ComponenConfigurationNotFound) + "!";
                    log.error(msg, (Throwable)fileNotFoundEx);
                }
                catch (CoreException coreEx) {
                    msg = String.valueOf(Messages.CouldNotCreateToolkitProvider) + "!";
                    log.error(msg, (Throwable)coreEx);
                }
                ++n4;
            }
            ++n2;
        }
        this.postProcess();
    }

    private ToolkitDescriptor createToolkitDescriptor(IConfigurationElement element, CompSystem compSystem) throws ToolkitPluginException {
        String toolkitId = element.getAttribute("toolkitID");
        try {
            if (compSystem.getToolkitDescriptor(toolkitId) == null) {
                String name = element.getAttribute("name");
                String level = element.getAttribute("level");
                boolean isUserToolkit = Boolean.parseBoolean(element.getAttribute("isUserToolkit"));
                String includes = String.valueOf(element.getAttribute("includes"));
                String depends = String.valueOf(element.getAttribute("depends"));
                int order = Integer.parseInt(element.getAttribute("order"));
                ConfigVersion configVersion = compSystem.getConfigVersion();
                int majorVersion = configVersion.getMajorVersion();
                int minorVersion = configVersion.getMinorVersion();
                ToolkitDescriptor descr = new ToolkitDescriptor(toolkitId, name, includes, depends, level, order, isUserToolkit, majorVersion, minorVersion);
                compSystem.addToolkitPluginDescriptor(toolkitId, descr);
                return descr;
            }
        }
        catch (NumberFormatException e) {
            log.error(e.getLocalizedMessage(), (Throwable)e);
            throw new ToolkitPluginException(String.valueOf(Messages.ErrorWhileReadingAttributes) + ":" + " " + String.valueOf(toolkitId), e);
        }
        catch (InvalidRegistryObjectException e) {
            log.error(e.getLocalizedMessage(), (Throwable)e);
            throw new ToolkitPluginException(String.valueOf(Messages.ErrorWhileReadingAttributes) + ":" + " " + String.valueOf(toolkitId), e);
        }
        return null;
    }

    public static ComponentBuilder getInstance() {
        if (instance == null) {
            instance = new ComponentBuilder();
        }
        return instance;
    }

    public CompSystem getCompSystem() {
        if (super.getCompSystem() == null) {
            try {
                this.initCompSystem();
            }
            catch (RuntimeException e) {
                log.error(e.getMessage());
                throw new ConfigXmlException(e.getMessage(), MessageIDs.E_GENERAL_COMPONENT_ERROR);
            }
            catch (ToolkitPluginException tke) {
                throw new ConfigXmlException(tke.getMessage(), MessageIDs.E_GENERAL_COMPONENT_ERROR);
            }
        }
        return super.getCompSystem();
    }

    public List<String> getLevelToolkitIds() {
        List toolkitDescriptors = super.getCompSystem().getIndependentToolkitDescriptors(true);
        ArrayList<String> toolkitIds = new ArrayList<String>();
        for (ToolkitDescriptor desc : toolkitDescriptors) {
            toolkitIds.add(desc.getToolkitID());
        }
        return toolkitIds;
    }
}

