/*******************************************************************************
 * Copyright (c) 2014 BREDEX GmbH.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     BREDEX GmbH - initial API and implementation and/or initial documentation
 *******************************************************************************/
package org.eclipse.jubula.toolkit.concrete.components;

import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jubula.communication.CAP;

/**
 * Interface representing the TableComponent component from the concrete toolkit. 
 * @noextend This interface is not intended to be extended by clients.
 * @noimplement This interface is not intended to be implemented by clients.
 */
public interface TableComponent
	extends org.eclipse.jubula.toolkit.base.components.TextInputComponent
	 {
	
	
	
	
	
	
		/**
		 * @throws IllegalArgumentException Throws an IllegalArgumentException if one of the parameters is null.
		 */
		
		@NonNull public CAP inputTextSpecifyCell(
		
			@NonNull java.lang.String text,
		
			@NonNull java.lang.String row,
		
			@NonNull java.lang.String rowOperator,
		
			@NonNull java.lang.String column,
		
			@NonNull java.lang.String columnOperator
		
		) throws IllegalArgumentException;
	
		/**
		 * @throws IllegalArgumentException Throws an IllegalArgumentException if one of the parameters is null.
		 */
		
		@NonNull public CAP replaceTextSpecifyCell(
		
			@NonNull java.lang.String text,
		
			@NonNull java.lang.String row,
		
			@NonNull java.lang.String rowOperator,
		
			@NonNull java.lang.String column,
		
			@NonNull java.lang.String columnOperator
		
		) throws IllegalArgumentException;
	
		/**
		 * @throws IllegalArgumentException Throws an IllegalArgumentException if one of the parameters is null.
		 */
		
		@NonNull public CAP selectCell(
		
			@NonNull java.lang.String row,
		
			@NonNull java.lang.String rowOperator,
		
			@NonNull java.lang.String column,
		
			@NonNull java.lang.String columnOperator,
		
			@NonNull java.lang.Integer numberOfClicks,
		
			@NonNull java.lang.Integer xPosition,
		
			@NonNull org.eclipse.jubula.toolkit.enums.ValueSets.Unit xUnits,
		
			@NonNull java.lang.Integer yPosition,
		
			@NonNull org.eclipse.jubula.toolkit.enums.ValueSets.Unit yUnits,
		
			@NonNull org.eclipse.jubula.toolkit.enums.ValueSets.BinaryChoice extendSelection,
		
			@NonNull org.eclipse.jubula.toolkit.enums.ValueSets.InteractionMode mouseButton
		
		) throws IllegalArgumentException;
	
		/**
		 * @throws IllegalArgumentException Throws an IllegalArgumentException if one of the parameters is null.
		 */
		
		@NonNull public CAP move(
		
			@NonNull org.eclipse.jubula.toolkit.enums.ValueSets.Direction direction,
		
			@NonNull java.lang.Integer numberOfCells,
		
			@NonNull java.lang.Integer numberOfClicks,
		
			@NonNull java.lang.Integer xPosition,
		
			@NonNull org.eclipse.jubula.toolkit.enums.ValueSets.Unit xUnits,
		
			@NonNull java.lang.Integer yPosition,
		
			@NonNull org.eclipse.jubula.toolkit.enums.ValueSets.Unit yUnits,
		
			@NonNull org.eclipse.jubula.toolkit.enums.ValueSets.BinaryChoice extendSelection
		
		) throws IllegalArgumentException;
	
		/**
		 * @throws IllegalArgumentException Throws an IllegalArgumentException if one of the parameters is null.
		 */
		
		@NonNull public CAP checkEditabilitySpecifyCell(
		
			@NonNull java.lang.Boolean editable,
		
			@NonNull java.lang.String row,
		
			@NonNull java.lang.String rowOperator,
		
			@NonNull java.lang.String column,
		
			@NonNull java.lang.String columnOperator
		
		) throws IllegalArgumentException;
	
		/**
		 * @throws IllegalArgumentException Throws an IllegalArgumentException if one of the parameters is null.
		 */
		
		@NonNull public CAP checkEditabilityOfSelectedCell(
		
			@NonNull java.lang.Boolean editable
		
		) throws IllegalArgumentException;
	
		/**
		 * @throws IllegalArgumentException Throws an IllegalArgumentException if one of the parameters is null.
		 */
		
		@NonNull public CAP checkEditabilityOfCellMousePosition(
		
			@NonNull java.lang.Boolean editable
		
		) throws IllegalArgumentException;
	
		/**
		 * @throws IllegalArgumentException Throws an IllegalArgumentException if one of the parameters is null.
		 */
		
		@NonNull public CAP checkTextSpecifyCell(
		
			@NonNull java.lang.String text,
		
			@NonNull java.lang.String textOperator,
		
			@NonNull java.lang.String row,
		
			@NonNull java.lang.String rowOperator,
		
			@NonNull java.lang.String column,
		
			@NonNull java.lang.String columnOperator
		
		) throws IllegalArgumentException;
	
		/**
		 * @throws IllegalArgumentException Throws an IllegalArgumentException if one of the parameters is null.
		 */
		
		@NonNull public CAP checkTextMousePosition(
		
			@NonNull java.lang.String text,
		
			@NonNull org.eclipse.jubula.toolkit.enums.ValueSets.Operator operator
		
		) throws IllegalArgumentException;
	
		/**
		 * @throws IllegalArgumentException Throws an IllegalArgumentException if one of the parameters is null.
		 */
		
		@NonNull public CAP checkExistenceOfValueInRow(
		
			@NonNull java.lang.String row,
		
			@NonNull java.lang.String rowOperator,
		
			@NonNull java.lang.String value,
		
			@NonNull java.lang.String valueOperator,
		
			@NonNull org.eclipse.jubula.toolkit.enums.ValueSets.SearchType searchType,
		
			@NonNull java.lang.Boolean exists
		
		) throws IllegalArgumentException;
	
		/**
		 * @throws IllegalArgumentException Throws an IllegalArgumentException if one of the parameters is null.
		 */
		
		@NonNull public CAP checkExistenceOfValueInColumn(
		
			@NonNull java.lang.String column,
		
			@NonNull java.lang.String columnOperator,
		
			@NonNull java.lang.String value,
		
			@NonNull java.lang.String valueOperator,
		
			@NonNull org.eclipse.jubula.toolkit.enums.ValueSets.SearchType searchType,
		
			@NonNull java.lang.Boolean exists
		
		) throws IllegalArgumentException;
	
		/**
		 * @throws IllegalArgumentException Throws an IllegalArgumentException if one of the parameters is null.
		 */
		
		@NonNull public CAP selectValueFromColumn(
		
			@NonNull java.lang.String column,
		
			@NonNull java.lang.String columnOperator,
		
			@NonNull java.lang.String value,
		
			@NonNull java.lang.String valueOperator,
		
			@NonNull java.lang.Integer numberOfClicks,
		
			@NonNull org.eclipse.jubula.toolkit.enums.ValueSets.BinaryChoice extendSelection,
		
			@NonNull org.eclipse.jubula.toolkit.enums.ValueSets.SearchType searchType,
		
			@NonNull org.eclipse.jubula.toolkit.enums.ValueSets.InteractionMode mouseButton
		
		) throws IllegalArgumentException;
	
		/**
		 * @throws IllegalArgumentException Throws an IllegalArgumentException if one of the parameters is null.
		 */
		
		@NonNull public CAP selectValueFromRow(
		
			@NonNull java.lang.String row,
		
			@NonNull java.lang.String rowOperator,
		
			@NonNull java.lang.String value,
		
			@NonNull java.lang.String valueOperator,
		
			@NonNull java.lang.Integer numberOfClicks,
		
			@NonNull org.eclipse.jubula.toolkit.enums.ValueSets.BinaryChoice extendSelection,
		
			@NonNull org.eclipse.jubula.toolkit.enums.ValueSets.SearchType searchType,
		
			@NonNull org.eclipse.jubula.toolkit.enums.ValueSets.InteractionMode mouseButton
		
		) throws IllegalArgumentException;
	
		/**
		 * @throws IllegalArgumentException Throws an IllegalArgumentException if one of the parameters is null.
		 */
		
		@NonNull public CAP dragCell(
		
			@NonNull org.eclipse.jubula.toolkit.enums.ValueSets.InteractionMode mouseButton,
		
			@NonNull org.eclipse.jubula.toolkit.enums.ValueSets.Modifier modifierKeys,
		
			@NonNull java.lang.String row,
		
			@NonNull java.lang.String rowOperator,
		
			@NonNull java.lang.String column,
		
			@NonNull java.lang.String columnOperator,
		
			@NonNull java.lang.Integer xPosition,
		
			@NonNull org.eclipse.jubula.toolkit.enums.ValueSets.Unit xUnits,
		
			@NonNull java.lang.Integer yPosition,
		
			@NonNull org.eclipse.jubula.toolkit.enums.ValueSets.Unit yUnits
		
		) throws IllegalArgumentException;
	
		/**
		 * @throws IllegalArgumentException Throws an IllegalArgumentException if one of the parameters is null.
		 */
		
		@NonNull public CAP dropOnCell(
		
			@NonNull java.lang.String row,
		
			@NonNull java.lang.String rowOperator,
		
			@NonNull java.lang.String column,
		
			@NonNull java.lang.String columnOperator,
		
			@NonNull java.lang.Integer xPosition,
		
			@NonNull org.eclipse.jubula.toolkit.enums.ValueSets.Unit xUnits,
		
			@NonNull java.lang.Integer yPosition,
		
			@NonNull org.eclipse.jubula.toolkit.enums.ValueSets.Unit yUnits,
		
			@NonNull java.lang.Integer delayBeforeDropMilliseconds
		
		) throws IllegalArgumentException;
	
		/**
		 * @throws IllegalArgumentException Throws an IllegalArgumentException if one of the parameters is null.
		 */
		
		@NonNull public CAP dragCellFromColumn(
		
			@NonNull org.eclipse.jubula.toolkit.enums.ValueSets.InteractionMode mouseButton,
		
			@NonNull org.eclipse.jubula.toolkit.enums.ValueSets.Modifier modifierKeys,
		
			@NonNull java.lang.String column,
		
			@NonNull java.lang.String columnOperator,
		
			@NonNull java.lang.String value,
		
			@NonNull java.lang.String valueOperator,
		
			@NonNull org.eclipse.jubula.toolkit.enums.ValueSets.SearchType searchType
		
		) throws IllegalArgumentException;
	
		/**
		 * @throws IllegalArgumentException Throws an IllegalArgumentException if one of the parameters is null.
		 */
		
		@NonNull public CAP dropOnCellFromColumn(
		
			@NonNull java.lang.String column,
		
			@NonNull java.lang.String columnOperator,
		
			@NonNull java.lang.String value,
		
			@NonNull java.lang.String valueOperator,
		
			@NonNull org.eclipse.jubula.toolkit.enums.ValueSets.SearchType searchType,
		
			@NonNull java.lang.Integer delayBeforeDropMilliseconds
		
		) throws IllegalArgumentException;
	
		/**
		 * @throws IllegalArgumentException Throws an IllegalArgumentException if one of the parameters is null.
		 */
		
		@NonNull public CAP dragCellFromRow(
		
			@NonNull org.eclipse.jubula.toolkit.enums.ValueSets.InteractionMode mouseButton,
		
			@NonNull org.eclipse.jubula.toolkit.enums.ValueSets.Modifier modifierKeys,
		
			@NonNull java.lang.String row,
		
			@NonNull java.lang.String rowOperator,
		
			@NonNull java.lang.String value,
		
			@NonNull java.lang.String valueOperator,
		
			@NonNull org.eclipse.jubula.toolkit.enums.ValueSets.SearchType searchType
		
		) throws IllegalArgumentException;
	
		/**
		 * @throws IllegalArgumentException Throws an IllegalArgumentException if one of the parameters is null.
		 */
		
		@NonNull public CAP dropOnCellFromRow(
		
			@NonNull java.lang.String row,
		
			@NonNull java.lang.String rowOperator,
		
			@NonNull java.lang.String value,
		
			@NonNull java.lang.String valueOperator,
		
			@NonNull org.eclipse.jubula.toolkit.enums.ValueSets.SearchType searchType,
		
			@NonNull java.lang.Integer delayBeforeDropMilliseconds
		
		) throws IllegalArgumentException;
	
		/**
		 * @throws IllegalArgumentException Throws an IllegalArgumentException if one of the parameters is null.
		 */
		
		@NonNull public CAP checkSelectionOfCheckboxInSelectedRow(
		
			@NonNull java.lang.Boolean checked
		
		) throws IllegalArgumentException;
	
		/**
		 * @throws IllegalArgumentException Throws an IllegalArgumentException if one of the parameters is null.
		 */
		
		@NonNull public CAP checkSelectionOfCheckboxAtMousePosition(
		
			@NonNull java.lang.Boolean checked
		
		) throws IllegalArgumentException;
	
		
		@NonNull public CAP toggleCheckboxInSelectedRow(
		
		) ;
	
		
		@NonNull public CAP toggleCheckboxAtMousePosition(
		
		) ;
	
} 