/*******************************************************************************
 * Copyright (c) 2014 BREDEX GmbH.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     BREDEX GmbH - initial API and implementation and/or initial documentation
 *******************************************************************************/
package org.eclipse.jubula.toolkit.concrete.components;

import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jubula.communication.CAP;

/**
 * Interface representing the TreeComponent component from the concrete toolkit. 
 * @noextend This interface is not intended to be extended by clients.
 * @noimplement This interface is not intended to be implemented by clients.
 */
public interface TreeComponent
	extends org.eclipse.jubula.toolkit.base.components.GraphicsComponent
	 {
	
	
	
	
	
	
		/**
		 * @throws IllegalArgumentException Throws an IllegalArgumentException if one of the parameters is null.
		 */
		
		@NonNull public CAP collapseNodeByTextpath(
		
			@NonNull org.eclipse.jubula.toolkit.enums.ValueSets.SearchType pathType,
		
			@NonNull java.lang.Integer preAscend,
		
			@NonNull java.lang.String textpath,
		
			@NonNull org.eclipse.jubula.toolkit.enums.ValueSets.Operator operator
		
		) throws IllegalArgumentException;
	
		/**
		 * @throws IllegalArgumentException Throws an IllegalArgumentException if one of the parameters is null.
		 */
		
		@NonNull public CAP collapseNodeByIndexpath(
		
			@NonNull org.eclipse.jubula.toolkit.enums.ValueSets.SearchType pathType,
		
			@NonNull java.lang.Integer preAscend,
		
			@NonNull java.lang.String indexpath
		
		) throws IllegalArgumentException;
	
		/**
		 * @throws IllegalArgumentException Throws an IllegalArgumentException if one of the parameters is null.
		 */
		
		@NonNull public CAP expandNodeByTextpath(
		
			@NonNull org.eclipse.jubula.toolkit.enums.ValueSets.SearchType pathType,
		
			@NonNull java.lang.Integer preAscend,
		
			@NonNull java.lang.String textpath,
		
			@NonNull org.eclipse.jubula.toolkit.enums.ValueSets.Operator operator
		
		) throws IllegalArgumentException;
	
		/**
		 * @throws IllegalArgumentException Throws an IllegalArgumentException if one of the parameters is null.
		 */
		
		@NonNull public CAP expandNodeByIndexpath(
		
			@NonNull org.eclipse.jubula.toolkit.enums.ValueSets.SearchType pathType,
		
			@NonNull java.lang.Integer preAscend,
		
			@NonNull java.lang.String indexpath
		
		) throws IllegalArgumentException;
	
		/**
		 * @throws IllegalArgumentException Throws an IllegalArgumentException if one of the parameters is null.
		 */
		
		@NonNull public CAP selectNodeByTextpath(
		
			@NonNull org.eclipse.jubula.toolkit.enums.ValueSets.SearchType pathType,
		
			@NonNull java.lang.Integer preAscend,
		
			@NonNull java.lang.String textpath,
		
			@NonNull org.eclipse.jubula.toolkit.enums.ValueSets.Operator operator,
		
			@NonNull java.lang.Integer numberOfClicks,
		
			@NonNull org.eclipse.jubula.toolkit.enums.ValueSets.InteractionMode mouseButton,
		
			@NonNull org.eclipse.jubula.toolkit.enums.ValueSets.BinaryChoice extendSelection
		
		) throws IllegalArgumentException;
	
		/**
		 * @throws IllegalArgumentException Throws an IllegalArgumentException if one of the parameters is null.
		 */
		
		@NonNull public CAP selectNodeByIndexpath(
		
			@NonNull org.eclipse.jubula.toolkit.enums.ValueSets.SearchType pathType,
		
			@NonNull java.lang.Integer preAscend,
		
			@NonNull java.lang.String indexpath,
		
			@NonNull java.lang.Integer numberOfClicks,
		
			@NonNull org.eclipse.jubula.toolkit.enums.ValueSets.InteractionMode mouseButton,
		
			@NonNull org.eclipse.jubula.toolkit.enums.ValueSets.BinaryChoice extendSelection
		
		) throws IllegalArgumentException;
	
		/**
		 * @throws IllegalArgumentException Throws an IllegalArgumentException if one of the parameters is null.
		 */
		
		@NonNull public CAP move(
		
			@NonNull org.eclipse.jubula.toolkit.enums.ValueSets.TreeDirection direction,
		
			@NonNull java.lang.Integer numberOfNodes,
		
			@NonNull java.lang.Integer numberOfClicks
		
		) throws IllegalArgumentException;
	
		/**
		 * @throws IllegalArgumentException Throws an IllegalArgumentException if one of the parameters is null.
		 */
		
		@NonNull public CAP checkExistenceOfNodeByTextpath(
		
			@NonNull org.eclipse.jubula.toolkit.enums.ValueSets.SearchType pathType,
		
			@NonNull java.lang.Integer preAscend,
		
			@NonNull java.lang.String textpath,
		
			@NonNull org.eclipse.jubula.toolkit.enums.ValueSets.Operator operator,
		
			@NonNull java.lang.Boolean exists
		
		) throws IllegalArgumentException;
	
		/**
		 * @throws IllegalArgumentException Throws an IllegalArgumentException if one of the parameters is null.
		 */
		
		@NonNull public CAP checkExistenceOfNodeByIndexpath(
		
			@NonNull org.eclipse.jubula.toolkit.enums.ValueSets.SearchType pathType,
		
			@NonNull java.lang.Integer preAscend,
		
			@NonNull java.lang.String indexpath,
		
			@NonNull java.lang.Boolean exists
		
		) throws IllegalArgumentException;
	
		/**
		 * @throws IllegalArgumentException Throws an IllegalArgumentException if one of the parameters is null.
		 */
		
		@NonNull public CAP checkTextOfSelectedNodeS(
		
			@NonNull java.lang.String text,
		
			@NonNull org.eclipse.jubula.toolkit.enums.ValueSets.Operator operator
		
		) throws IllegalArgumentException;
	
		/**
		 * @throws IllegalArgumentException Throws an IllegalArgumentException if one of the parameters is null.
		 */
		
		@NonNull public CAP checkTextMousePosition(
		
			@NonNull java.lang.String text,
		
			@NonNull org.eclipse.jubula.toolkit.enums.ValueSets.Operator operator
		
		) throws IllegalArgumentException;
	
		/**
		 * @throws IllegalArgumentException Throws an IllegalArgumentException if one of the parameters is null.
		 */
		
		@NonNull public CAP dragNodeByTextpath(
		
			@NonNull org.eclipse.jubula.toolkit.enums.ValueSets.InteractionMode mouseButton,
		
			@NonNull org.eclipse.jubula.toolkit.enums.ValueSets.Modifier modifierKeys,
		
			@NonNull org.eclipse.jubula.toolkit.enums.ValueSets.SearchType pathType,
		
			@NonNull java.lang.Integer preAscend,
		
			@NonNull java.lang.String treeTextpath,
		
			@NonNull org.eclipse.jubula.toolkit.enums.ValueSets.Operator operator
		
		) throws IllegalArgumentException;
	
		/**
		 * @throws IllegalArgumentException Throws an IllegalArgumentException if one of the parameters is null.
		 */
		
		@NonNull public CAP dropOnNodeByTextpath(
		
			@NonNull org.eclipse.jubula.toolkit.enums.ValueSets.SearchType pathType,
		
			@NonNull java.lang.Integer preAscend,
		
			@NonNull java.lang.String treeTextpath,
		
			@NonNull org.eclipse.jubula.toolkit.enums.ValueSets.Operator operator,
		
			@NonNull java.lang.Integer delayBeforeDropMilliseconds
		
		) throws IllegalArgumentException;
	
		/**
		 * @throws IllegalArgumentException Throws an IllegalArgumentException if one of the parameters is null.
		 */
		
		@NonNull public CAP dragNodeByIndexpath(
		
			@NonNull org.eclipse.jubula.toolkit.enums.ValueSets.InteractionMode mouseButton,
		
			@NonNull org.eclipse.jubula.toolkit.enums.ValueSets.Modifier modifierKeys,
		
			@NonNull org.eclipse.jubula.toolkit.enums.ValueSets.SearchType pathType,
		
			@NonNull java.lang.Integer preAscend,
		
			@NonNull java.lang.String treeIndexpath
		
		) throws IllegalArgumentException;
	
		/**
		 * @throws IllegalArgumentException Throws an IllegalArgumentException if one of the parameters is null.
		 */
		
		@NonNull public CAP dropOnNodeByIndexpath(
		
			@NonNull org.eclipse.jubula.toolkit.enums.ValueSets.SearchType pathType,
		
			@NonNull java.lang.Integer preAscend,
		
			@NonNull java.lang.String treeIndexpath,
		
			@NonNull java.lang.Integer delayBeforeDropMilliseconds
		
		) throws IllegalArgumentException;
	
} 