/*******************************************************************************
 * Copyright (c) 2014 BREDEX GmbH.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     BREDEX GmbH - initial API and implementation and/or initial documentation
 *******************************************************************************/
package org.eclipse.jubula.toolkit.concrete.internal.impl;

import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jubula.communication.CAP;
import org.apache.commons.lang.Validate;
import org.eclipse.jubula.communication.internal.message.MessageCap;
import org.eclipse.jubula.communication.internal.message.MessageParam;
import org.eclipse.jubula.tools.ComponentIdentifier;
import org.eclipse.jubula.tools.internal.objects.IComponentIdentifier;
import org.eclipse.jubula.toolkit.internal.annotations.RealizedType;
import org.eclipse.jubula.toolkit.internal.annotations.TesterClass;

/**
 * Class representing the Application component from the concrete toolkit.
 */
public class Application
	
	implements org.eclipse.jubula.toolkit.concrete.components.Application {
	
	
		
		
			
			public Application() {
				super();
			}
		
	
	
	
	protected IComponentIdentifier getPseudoComponentIdentifier() {
		
		return null;
		
	}
	
	
		/**
		 * @throws IllegalArgumentException Throws an IllegalArgumentException if one of the parameters is null.
		 */
		
		@NonNull public CAP clickInActiveWindow(
		
			@NonNull java.lang.Integer numberOfClicks,
		
			@NonNull org.eclipse.jubula.toolkit.enums.ValueSets.InteractionMode mouseButton,
		
			@NonNull java.lang.Integer xPosition,
		
			@NonNull org.eclipse.jubula.toolkit.enums.ValueSets.Unit xUnits,
		
			@NonNull java.lang.Integer yPosition,
		
			@NonNull org.eclipse.jubula.toolkit.enums.ValueSets.Unit yUnits
		
		) throws IllegalArgumentException {
			MessageCap messageCap = new MessageCap();
			messageCap.setMethod("rcClickDirect"); //$NON-NLS-1$
			messageCap.sethasDefaultMapping(true);
			
			messageCap.setCi(getPseudoComponentIdentifier());
			
			
			Validate.notNull(numberOfClicks, "Argument 'numberOfClicks' must not be null"); //$NON-NLS-1$
				
				
				
			messageCap.addMessageParam(new MessageParam(numberOfClicks.toString(), "java.lang.Integer")); //$NON-NLS-1$
				
			
			
			Validate.notNull(mouseButton, "Argument 'mouseButton' must not be null"); //$NON-NLS-1$
				
				
				
			messageCap.addMessageParam(new MessageParam(mouseButton.rcValue(), "java.lang.Integer")); //$NON-NLS-1$
				
			
			
			Validate.notNull(xPosition, "Argument 'xPosition' must not be null"); //$NON-NLS-1$
				
				
				
			messageCap.addMessageParam(new MessageParam(xPosition.toString(), "java.lang.Integer")); //$NON-NLS-1$
				
			
			
			Validate.notNull(xUnits, "Argument 'xUnits' must not be null"); //$NON-NLS-1$
				
				
				
			messageCap.addMessageParam(new MessageParam(xUnits.rcValue(), "java.lang.String")); //$NON-NLS-1$
				
			
			
			Validate.notNull(yPosition, "Argument 'yPosition' must not be null"); //$NON-NLS-1$
				
				
				
			messageCap.addMessageParam(new MessageParam(yPosition.toString(), "java.lang.Integer")); //$NON-NLS-1$
				
			
			
			Validate.notNull(yUnits, "Argument 'yUnits' must not be null"); //$NON-NLS-1$
				
				
				
			messageCap.addMessageParam(new MessageParam(yUnits.rcValue(), "java.lang.String")); //$NON-NLS-1$
				
			
			return messageCap;
		}
	
		/**
		 * @throws IllegalArgumentException Throws an IllegalArgumentException if one of the parameters is null.
		 */
		
		@NonNull public CAP activate(
		
			@NonNull org.eclipse.jubula.toolkit.enums.ValueSets.AUTActivationMethod activationMethod
		
		) throws IllegalArgumentException {
			MessageCap messageCap = new MessageCap();
			messageCap.setMethod("rcActivate"); //$NON-NLS-1$
			messageCap.sethasDefaultMapping(true);
			
			messageCap.setCi(getPseudoComponentIdentifier());
			
			
			Validate.notNull(activationMethod, "Argument 'activationMethod' must not be null"); //$NON-NLS-1$
				
				
				
			messageCap.addMessageParam(new MessageParam(activationMethod.rcValue(), "java.lang.String")); //$NON-NLS-1$
				
			
			return messageCap;
		}
	
		/**
		 * @throws IllegalArgumentException Throws an IllegalArgumentException if one of the parameters is null.
		 */
		
		@NonNull public CAP inputText(
		
			@NonNull java.lang.String text
		
		) throws IllegalArgumentException {
			MessageCap messageCap = new MessageCap();
			messageCap.setMethod("rcInputText"); //$NON-NLS-1$
			messageCap.sethasDefaultMapping(true);
			
			messageCap.setCi(getPseudoComponentIdentifier());
			
			
			Validate.notNull(text, "Argument 'text' must not be null"); //$NON-NLS-1$
				
				
				
			messageCap.addMessageParam(new MessageParam(text.toString(), "java.lang.String")); //$NON-NLS-1$
				
			
			return messageCap;
		}
	
		/**
		 * @throws IllegalArgumentException Throws an IllegalArgumentException if one of the parameters is null.
		 */
		
		@NonNull public CAP keyCombination(
		
			@NonNull org.eclipse.jubula.toolkit.enums.ValueSets.Modifier modifierKeys,
		
			@NonNull java.lang.String baseKey
		
		) throws IllegalArgumentException {
			MessageCap messageCap = new MessageCap();
			messageCap.setMethod("rcKeyStroke"); //$NON-NLS-1$
			messageCap.sethasDefaultMapping(true);
			
			messageCap.setCi(getPseudoComponentIdentifier());
			
			
			Validate.notNull(modifierKeys, "Argument 'modifierKeys' must not be null"); //$NON-NLS-1$
				
				
				
			messageCap.addMessageParam(new MessageParam(modifierKeys.rcValue(), "java.lang.String")); //$NON-NLS-1$
				
			
			
			Validate.notNull(baseKey, "Argument 'baseKey' must not be null"); //$NON-NLS-1$
				
				
				
			messageCap.addMessageParam(new MessageParam(baseKey.toString(), "java.lang.String")); //$NON-NLS-1$
				
			
			return messageCap;
		}
	
		/**
		 * @throws IllegalArgumentException Throws an IllegalArgumentException if one of the parameters is null.
		 */
		
		@NonNull public CAP setToggleKey(
		
			@NonNull java.lang.Integer key,
		
			@NonNull java.lang.Boolean activateKey
		
		) throws IllegalArgumentException {
			MessageCap messageCap = new MessageCap();
			messageCap.setMethod("rcToggle"); //$NON-NLS-1$
			messageCap.sethasDefaultMapping(true);
			
			messageCap.setCi(getPseudoComponentIdentifier());
			
			
			Validate.notNull(key, "Argument 'key' must not be null"); //$NON-NLS-1$
				
				
				
			messageCap.addMessageParam(new MessageParam(key.toString(), "java.lang.Integer")); //$NON-NLS-1$
				
			
			
			Validate.notNull(activateKey, "Argument 'activateKey' must not be null"); //$NON-NLS-1$
				
				
				
			messageCap.addMessageParam(new MessageParam(activateKey.toString(), "java.lang.Boolean")); //$NON-NLS-1$
				
			
			return messageCap;
		}
	
		/**
		 * @throws IllegalArgumentException Throws an IllegalArgumentException if one of the parameters is null.
		 */
		
		@NonNull public CAP wait(
		
			@NonNull java.lang.Integer millisecs
		
		) throws IllegalArgumentException {
			MessageCap messageCap = new MessageCap();
			messageCap.setMethod("rcWait"); //$NON-NLS-1$
			messageCap.sethasDefaultMapping(true);
			
			messageCap.setCi(getPseudoComponentIdentifier());
			
			
			Validate.notNull(millisecs, "Argument 'millisecs' must not be null"); //$NON-NLS-1$
				
				
				
			messageCap.addMessageParam(new MessageParam(millisecs.toString(), "java.lang.Integer")); //$NON-NLS-1$
				
			
			return messageCap;
		}
	
		
		@NonNull public CAP pauseTestExecution(
		
		)  {
			MessageCap messageCap = new MessageCap();
			messageCap.setMethod("rcPause"); //$NON-NLS-1$
			messageCap.sethasDefaultMapping(true);
			
			messageCap.setCi(getPseudoComponentIdentifier());
			
			return messageCap;
		}
	
		/**
		 * @throws IllegalArgumentException Throws an IllegalArgumentException if one of the parameters is null.
		 */
		
		@NonNull public CAP waitForWindow(
		
			@NonNull java.lang.String title,
		
			@NonNull org.eclipse.jubula.toolkit.enums.ValueSets.Operator operator,
		
			@NonNull java.lang.Integer timeoutInMs,
		
			@NonNull java.lang.Integer delayAfterVisibility
		
		) throws IllegalArgumentException {
			MessageCap messageCap = new MessageCap();
			messageCap.setMethod("rcWaitForWindow"); //$NON-NLS-1$
			messageCap.sethasDefaultMapping(true);
			
			messageCap.setCi(getPseudoComponentIdentifier());
			
			
			Validate.notNull(title, "Argument 'title' must not be null"); //$NON-NLS-1$
				
				
				
			messageCap.addMessageParam(new MessageParam(title.toString(), "java.lang.String")); //$NON-NLS-1$
				
			
			
			Validate.notNull(operator, "Argument 'operator' must not be null"); //$NON-NLS-1$
				
				
				
			messageCap.addMessageParam(new MessageParam(operator.rcValue(), "java.lang.String")); //$NON-NLS-1$
				
			
			
			Validate.notNull(timeoutInMs, "Argument 'timeoutInMs' must not be null"); //$NON-NLS-1$
				
				
				
			messageCap.addMessageParam(new MessageParam(timeoutInMs.toString(), "java.lang.Integer")); //$NON-NLS-1$
				
			
			
			Validate.notNull(delayAfterVisibility, "Argument 'delayAfterVisibility' must not be null"); //$NON-NLS-1$
				
				
				
			messageCap.addMessageParam(new MessageParam(delayAfterVisibility.toString(), "java.lang.Integer")); //$NON-NLS-1$
				
			
			return messageCap;
		}
	
		/**
		 * @throws IllegalArgumentException Throws an IllegalArgumentException if one of the parameters is null.
		 */
		
		@NonNull public CAP waitForWindowActivation(
		
			@NonNull java.lang.String title,
		
			@NonNull org.eclipse.jubula.toolkit.enums.ValueSets.Operator operator,
		
			@NonNull java.lang.Integer timeoutInMs,
		
			@NonNull java.lang.Integer delayAfterVisibility
		
		) throws IllegalArgumentException {
			MessageCap messageCap = new MessageCap();
			messageCap.setMethod("rcWaitForWindowActivation"); //$NON-NLS-1$
			messageCap.sethasDefaultMapping(true);
			
			messageCap.setCi(getPseudoComponentIdentifier());
			
			
			Validate.notNull(title, "Argument 'title' must not be null"); //$NON-NLS-1$
				
				
				
			messageCap.addMessageParam(new MessageParam(title.toString(), "java.lang.String")); //$NON-NLS-1$
				
			
			
			Validate.notNull(operator, "Argument 'operator' must not be null"); //$NON-NLS-1$
				
				
				
			messageCap.addMessageParam(new MessageParam(operator.rcValue(), "java.lang.String")); //$NON-NLS-1$
				
			
			
			Validate.notNull(timeoutInMs, "Argument 'timeoutInMs' must not be null"); //$NON-NLS-1$
				
				
				
			messageCap.addMessageParam(new MessageParam(timeoutInMs.toString(), "java.lang.Integer")); //$NON-NLS-1$
				
			
			
			Validate.notNull(delayAfterVisibility, "Argument 'delayAfterVisibility' must not be null"); //$NON-NLS-1$
				
				
				
			messageCap.addMessageParam(new MessageParam(delayAfterVisibility.toString(), "java.lang.Integer")); //$NON-NLS-1$
				
			
			return messageCap;
		}
	
		/**
		 * @throws IllegalArgumentException Throws an IllegalArgumentException if one of the parameters is null.
		 */
		
		@NonNull public CAP waitForWindowToClose(
		
			@NonNull java.lang.String title,
		
			@NonNull org.eclipse.jubula.toolkit.enums.ValueSets.Operator operator,
		
			@NonNull java.lang.Integer timeoutInMs,
		
			@NonNull java.lang.Integer delayAfterClosure
		
		) throws IllegalArgumentException {
			MessageCap messageCap = new MessageCap();
			messageCap.setMethod("rcWaitForWindowToClose"); //$NON-NLS-1$
			messageCap.sethasDefaultMapping(true);
			
			messageCap.setCi(getPseudoComponentIdentifier());
			
			
			Validate.notNull(title, "Argument 'title' must not be null"); //$NON-NLS-1$
				
				
				
			messageCap.addMessageParam(new MessageParam(title.toString(), "java.lang.String")); //$NON-NLS-1$
				
			
			
			Validate.notNull(operator, "Argument 'operator' must not be null"); //$NON-NLS-1$
				
				
				
			messageCap.addMessageParam(new MessageParam(operator.rcValue(), "java.lang.String")); //$NON-NLS-1$
				
			
			
			Validate.notNull(timeoutInMs, "Argument 'timeoutInMs' must not be null"); //$NON-NLS-1$
				
				
				
			messageCap.addMessageParam(new MessageParam(timeoutInMs.toString(), "java.lang.Integer")); //$NON-NLS-1$
				
			
			
			Validate.notNull(delayAfterClosure, "Argument 'delayAfterClosure' must not be null"); //$NON-NLS-1$
				
				
				
			messageCap.addMessageParam(new MessageParam(delayAfterClosure.toString(), "java.lang.Integer")); //$NON-NLS-1$
				
			
			return messageCap;
		}
	
		/**
		 * @throws IllegalArgumentException Throws an IllegalArgumentException if one of the parameters is null.
		 */
		
		@NonNull public CAP takeScreenshot(
		
			@NonNull java.lang.String destination,
		
			@NonNull java.lang.Integer delay,
		
			@NonNull java.lang.String fileAccess,
		
			@NonNull java.lang.Integer scalingFactor,
		
			@NonNull java.lang.Boolean createDirectories
		
		) throws IllegalArgumentException {
			MessageCap messageCap = new MessageCap();
			messageCap.setMethod("rcTakeScreenshot"); //$NON-NLS-1$
			messageCap.sethasDefaultMapping(true);
			
			messageCap.setCi(getPseudoComponentIdentifier());
			
			
			Validate.notNull(destination, "Argument 'destination' must not be null"); //$NON-NLS-1$
				
				
				
			messageCap.addMessageParam(new MessageParam(destination.toString(), "java.lang.String")); //$NON-NLS-1$
				
			
			
			Validate.notNull(delay, "Argument 'delay' must not be null"); //$NON-NLS-1$
				
				
				
			messageCap.addMessageParam(new MessageParam(delay.toString(), "java.lang.Integer")); //$NON-NLS-1$
				
			
			
			Validate.notNull(fileAccess, "Argument 'fileAccess' must not be null"); //$NON-NLS-1$
				
				
				
			messageCap.addMessageParam(new MessageParam(fileAccess.toString(), "java.lang.String")); //$NON-NLS-1$
				
			
			
			Validate.notNull(scalingFactor, "Argument 'scalingFactor' must not be null"); //$NON-NLS-1$
				
				
				
			messageCap.addMessageParam(new MessageParam(scalingFactor.toString(), "java.lang.Integer")); //$NON-NLS-1$
				
			
			
			Validate.notNull(createDirectories, "Argument 'createDirectories' must not be null"); //$NON-NLS-1$
				
				
				
			messageCap.addMessageParam(new MessageParam(createDirectories.toString(), "java.lang.Boolean")); //$NON-NLS-1$
				
			
			return messageCap;
		}
	
		/**
		 * @throws IllegalArgumentException Throws an IllegalArgumentException if one of the parameters is null.
		 */
		
		@NonNull public CAP externalKeyCombination(
		
			@NonNull org.eclipse.jubula.toolkit.enums.ValueSets.Modifier modifierKeys,
		
			@NonNull java.lang.String baseKey
		
		) throws IllegalArgumentException {
			MessageCap messageCap = new MessageCap();
			messageCap.setMethod("rcNativeKeyStroke"); //$NON-NLS-1$
			messageCap.sethasDefaultMapping(true);
			
			messageCap.setCi(getPseudoComponentIdentifier());
			
			
			Validate.notNull(modifierKeys, "Argument 'modifierKeys' must not be null"); //$NON-NLS-1$
				
				
				
			messageCap.addMessageParam(new MessageParam(modifierKeys.rcValue(), "java.lang.String")); //$NON-NLS-1$
				
			
			
			Validate.notNull(baseKey, "Argument 'baseKey' must not be null"); //$NON-NLS-1$
				
				
				
			messageCap.addMessageParam(new MessageParam(baseKey.toString(), "java.lang.String")); //$NON-NLS-1$
				
			
			return messageCap;
		}
	
		/**
		 * @throws IllegalArgumentException Throws an IllegalArgumentException if one of the parameters is null.
		 */
		
		@NonNull public CAP externalInputText(
		
			@NonNull java.lang.String text
		
		) throws IllegalArgumentException {
			MessageCap messageCap = new MessageCap();
			messageCap.setMethod("rcNativeInputText"); //$NON-NLS-1$
			messageCap.sethasDefaultMapping(true);
			
			messageCap.setCi(getPseudoComponentIdentifier());
			
			
			Validate.notNull(text, "Argument 'text' must not be null"); //$NON-NLS-1$
				
				
				
			messageCap.addMessageParam(new MessageParam(text.toString(), "java.lang.String")); //$NON-NLS-1$
				
			
			return messageCap;
		}
	
		/**
		 * @throws IllegalArgumentException Throws an IllegalArgumentException if one of the parameters is null.
		 */
		
		@NonNull public CAP copyTextToClipboard(
		
			@NonNull java.lang.String text
		
		) throws IllegalArgumentException {
			MessageCap messageCap = new MessageCap();
			messageCap.setMethod("rcCopyToClipboard"); //$NON-NLS-1$
			messageCap.sethasDefaultMapping(true);
			
			messageCap.setCi(getPseudoComponentIdentifier());
			
			
			Validate.notNull(text, "Argument 'text' must not be null"); //$NON-NLS-1$
				
				
				
			messageCap.addMessageParam(new MessageParam(text.toString(), "java.lang.String")); //$NON-NLS-1$
				
			
			return messageCap;
		}
	
		/**
		 * @throws IllegalArgumentException Throws an IllegalArgumentException if one of the parameters is null.
		 */
		
		@NonNull public CAP checkNumericValues(
		
			@NonNull java.lang.String value1,
		
			@NonNull java.lang.String comparisonMethod,
		
			@NonNull java.lang.String value2
		
		) throws IllegalArgumentException {
			MessageCap messageCap = new MessageCap();
			messageCap.setMethod("rcCheckValues"); //$NON-NLS-1$
			messageCap.sethasDefaultMapping(true);
			
			messageCap.setCi(getPseudoComponentIdentifier());
			
			
			Validate.notNull(value1, "Argument 'value1' must not be null"); //$NON-NLS-1$
				
				
				
			messageCap.addMessageParam(new MessageParam(value1.toString(), "java.lang.String")); //$NON-NLS-1$
				
			
			
			Validate.notNull(comparisonMethod, "Argument 'comparisonMethod' must not be null"); //$NON-NLS-1$
				
				
				
			messageCap.addMessageParam(new MessageParam(comparisonMethod.toString(), "java.lang.String")); //$NON-NLS-1$
				
			
			
			Validate.notNull(value2, "Argument 'value2' must not be null"); //$NON-NLS-1$
				
				
				
			messageCap.addMessageParam(new MessageParam(value2.toString(), "java.lang.String")); //$NON-NLS-1$
				
			
			return messageCap;
		}
	
		/**
		 * @throws IllegalArgumentException Throws an IllegalArgumentException if one of the parameters is null.
		 */
		
		@NonNull public CAP takeScreenshotOfActiveWindow(
		
			@NonNull java.lang.String destination,
		
			@NonNull java.lang.Integer delay,
		
			@NonNull java.lang.String fileAccess,
		
			@NonNull java.lang.Integer scalingFactor,
		
			@NonNull java.lang.Boolean createDirectories,
		
			@NonNull java.lang.Integer marginTop,
		
			@NonNull java.lang.Integer marginRight,
		
			@NonNull java.lang.Integer marginBottom,
		
			@NonNull java.lang.Integer marginLeft
		
		) throws IllegalArgumentException {
			MessageCap messageCap = new MessageCap();
			messageCap.setMethod("rcTakeScreenshotOfActiveWindow"); //$NON-NLS-1$
			messageCap.sethasDefaultMapping(true);
			
			messageCap.setCi(getPseudoComponentIdentifier());
			
			
			Validate.notNull(destination, "Argument 'destination' must not be null"); //$NON-NLS-1$
				
				
				
			messageCap.addMessageParam(new MessageParam(destination.toString(), "java.lang.String")); //$NON-NLS-1$
				
			
			
			Validate.notNull(delay, "Argument 'delay' must not be null"); //$NON-NLS-1$
				
				
				
			messageCap.addMessageParam(new MessageParam(delay.toString(), "java.lang.Integer")); //$NON-NLS-1$
				
			
			
			Validate.notNull(fileAccess, "Argument 'fileAccess' must not be null"); //$NON-NLS-1$
				
				
				
			messageCap.addMessageParam(new MessageParam(fileAccess.toString(), "java.lang.String")); //$NON-NLS-1$
				
			
			
			Validate.notNull(scalingFactor, "Argument 'scalingFactor' must not be null"); //$NON-NLS-1$
				
				
				
			messageCap.addMessageParam(new MessageParam(scalingFactor.toString(), "java.lang.Integer")); //$NON-NLS-1$
				
			
			
			Validate.notNull(createDirectories, "Argument 'createDirectories' must not be null"); //$NON-NLS-1$
				
				
				
			messageCap.addMessageParam(new MessageParam(createDirectories.toString(), "java.lang.Boolean")); //$NON-NLS-1$
				
			
			
			Validate.notNull(marginTop, "Argument 'marginTop' must not be null"); //$NON-NLS-1$
				
				
				
			messageCap.addMessageParam(new MessageParam(marginTop.toString(), "java.lang.Integer")); //$NON-NLS-1$
				
			
			
			Validate.notNull(marginRight, "Argument 'marginRight' must not be null"); //$NON-NLS-1$
				
				
				
			messageCap.addMessageParam(new MessageParam(marginRight.toString(), "java.lang.Integer")); //$NON-NLS-1$
				
			
			
			Validate.notNull(marginBottom, "Argument 'marginBottom' must not be null"); //$NON-NLS-1$
				
				
				
			messageCap.addMessageParam(new MessageParam(marginBottom.toString(), "java.lang.Integer")); //$NON-NLS-1$
				
			
			
			Validate.notNull(marginLeft, "Argument 'marginLeft' must not be null"); //$NON-NLS-1$
				
				
				
			messageCap.addMessageParam(new MessageParam(marginLeft.toString(), "java.lang.Integer")); //$NON-NLS-1$
				
			
			return messageCap;
		}
	
		/**
		 * @throws IllegalArgumentException Throws an IllegalArgumentException if one of the parameters is null.
		 */
		
		@NonNull public CAP checkStringValues(
		
			@NonNull java.lang.String value1,
		
			@NonNull java.lang.String value2Operator,
		
			@NonNull java.lang.String value2
		
		) throws IllegalArgumentException {
			MessageCap messageCap = new MessageCap();
			messageCap.setMethod("rcCheckStringValues"); //$NON-NLS-1$
			messageCap.sethasDefaultMapping(true);
			
			messageCap.setCi(getPseudoComponentIdentifier());
			
			
			Validate.notNull(value1, "Argument 'value1' must not be null"); //$NON-NLS-1$
				
				
				
			messageCap.addMessageParam(new MessageParam(value1.toString(), "java.lang.String")); //$NON-NLS-1$
				
			
			
			Validate.notNull(value2Operator, "Argument 'value2Operator' must not be null"); //$NON-NLS-1$
				
				
				
			messageCap.addMessageParam(new MessageParam(value2Operator.toString(), "java.lang.String")); //$NON-NLS-1$
				
			
			
			Validate.notNull(value2, "Argument 'value2' must not be null"); //$NON-NLS-1$
				
				
				
			messageCap.addMessageParam(new MessageParam(value2.toString(), "java.lang.String")); //$NON-NLS-1$
				
			
			return messageCap;
		}
	
		/**
		 * @throws IllegalArgumentException Throws an IllegalArgumentException if one of the parameters is null.
		 */
		
		@NonNull public CAP checkExistenceOfWindow(
		
			@NonNull java.lang.String title,
		
			@NonNull org.eclipse.jubula.toolkit.enums.ValueSets.Operator operator,
		
			@NonNull java.lang.Boolean exists
		
		) throws IllegalArgumentException {
			MessageCap messageCap = new MessageCap();
			messageCap.setMethod("rcCheckExistenceOfWindow"); //$NON-NLS-1$
			messageCap.sethasDefaultMapping(true);
			
			messageCap.setCi(getPseudoComponentIdentifier());
			
			
			Validate.notNull(title, "Argument 'title' must not be null"); //$NON-NLS-1$
				
				
				
			messageCap.addMessageParam(new MessageParam(title.toString(), "java.lang.String")); //$NON-NLS-1$
				
			
			
			Validate.notNull(operator, "Argument 'operator' must not be null"); //$NON-NLS-1$
				
				
				
			messageCap.addMessageParam(new MessageParam(operator.rcValue(), "java.lang.String")); //$NON-NLS-1$
				
			
			
			Validate.notNull(exists, "Argument 'exists' must not be null"); //$NON-NLS-1$
				
				
				
			messageCap.addMessageParam(new MessageParam(exists.toString(), "java.lang.Boolean")); //$NON-NLS-1$
				
			
			return messageCap;
		}
	
} 