/*******************************************************************************
 * Copyright (c) 2014 BREDEX GmbH.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     BREDEX GmbH - initial API and implementation and/or initial documentation
 *******************************************************************************/
package org.eclipse.jubula.toolkit.concrete.internal.impl;

import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jubula.communication.CAP;
import org.apache.commons.lang.Validate;
import org.eclipse.jubula.communication.internal.message.MessageCap;
import org.eclipse.jubula.communication.internal.message.MessageParam;
import org.eclipse.jubula.tools.ComponentIdentifier;
import org.eclipse.jubula.tools.internal.objects.IComponentIdentifier;
import org.eclipse.jubula.toolkit.internal.annotations.RealizedType;
import org.eclipse.jubula.toolkit.internal.annotations.TesterClass;

/**
 * Class representing the ListComponent component from the concrete toolkit.
 */
@RealizedType(realizedType="guidancer.abstract.TextVerifiable")
public class ListComponent
	extends org.eclipse.jubula.toolkit.base.internal.impl.TextComponent
	implements org.eclipse.jubula.toolkit.concrete.components.ListComponent {
	
	
		
		
			
			public ListComponent(@NonNull ComponentIdentifier componentIdentifier) {
				super(componentIdentifier);
			}
		
	
	
	
	
	
		/**
		 * @throws IllegalArgumentException Throws an IllegalArgumentException if one of the parameters is null.
		 */
		
		@NonNull public CAP checkSelectionOfEntryByValue(
		
			@NonNull java.lang.String text,
		
			@NonNull org.eclipse.jubula.toolkit.enums.ValueSets.Operator operator,
		
			@NonNull java.lang.Boolean selected
		
		) throws IllegalArgumentException {
			MessageCap messageCap = new MessageCap();
			messageCap.setMethod("rcVerifySelectedValue"); //$NON-NLS-1$
			messageCap.sethasDefaultMapping(false);
			
			messageCap.setCi(m_componentIdentifier);
			
			
			
			Validate.notNull(text, "Argument 'text' must not be null"); //$NON-NLS-1$
				
				
				
			messageCap.addMessageParam(new MessageParam(text.toString(), "java.lang.String")); //$NON-NLS-1$
				
			
			
			Validate.notNull(operator, "Argument 'operator' must not be null"); //$NON-NLS-1$
				
				
				
			messageCap.addMessageParam(new MessageParam(operator.rcValue(), "java.lang.String")); //$NON-NLS-1$
				
			
			
			Validate.notNull(selected, "Argument 'selected' must not be null"); //$NON-NLS-1$
				
				
				
			messageCap.addMessageParam(new MessageParam(selected.toString(), "java.lang.Boolean")); //$NON-NLS-1$
				
			
			return messageCap;
		}
	
		/**
		 * @throws IllegalArgumentException Throws an IllegalArgumentException if one of the parameters is null.
		 */
		
		@NonNull public CAP checkExistenceOfEntryByValue(
		
			@NonNull java.lang.String text,
		
			@NonNull org.eclipse.jubula.toolkit.enums.ValueSets.Operator operator,
		
			@NonNull java.lang.Boolean exists
		
		) throws IllegalArgumentException {
			MessageCap messageCap = new MessageCap();
			messageCap.setMethod("rcVerifyContainsValue"); //$NON-NLS-1$
			messageCap.sethasDefaultMapping(false);
			
			messageCap.setCi(m_componentIdentifier);
			
			
			
			Validate.notNull(text, "Argument 'text' must not be null"); //$NON-NLS-1$
				
				
				
			messageCap.addMessageParam(new MessageParam(text.toString(), "java.lang.String")); //$NON-NLS-1$
				
			
			
			Validate.notNull(operator, "Argument 'operator' must not be null"); //$NON-NLS-1$
				
				
				
			messageCap.addMessageParam(new MessageParam(operator.rcValue(), "java.lang.String")); //$NON-NLS-1$
				
			
			
			Validate.notNull(exists, "Argument 'exists' must not be null"); //$NON-NLS-1$
				
				
				
			messageCap.addMessageParam(new MessageParam(exists.toString(), "java.lang.Boolean")); //$NON-NLS-1$
				
			
			return messageCap;
		}
	
		/**
		 * @throws IllegalArgumentException Throws an IllegalArgumentException if one of the parameters is null.
		 */
		
		@NonNull public CAP checkSelectionOfEntryByIndex(
		
			@NonNull java.lang.String index,
		
			@NonNull java.lang.Boolean selected
		
		) throws IllegalArgumentException {
			MessageCap messageCap = new MessageCap();
			messageCap.setMethod("rcVerifySelectedIndex"); //$NON-NLS-1$
			messageCap.sethasDefaultMapping(false);
			
			messageCap.setCi(m_componentIdentifier);
			
			
			
			Validate.notNull(index, "Argument 'index' must not be null"); //$NON-NLS-1$
				
				
				
			messageCap.addMessageParam(new MessageParam(index.toString(), "java.lang.String")); //$NON-NLS-1$
				
			
			
			Validate.notNull(selected, "Argument 'selected' must not be null"); //$NON-NLS-1$
				
				
				
			messageCap.addMessageParam(new MessageParam(selected.toString(), "java.lang.Boolean")); //$NON-NLS-1$
				
			
			return messageCap;
		}
	
		/**
		 * @throws IllegalArgumentException Throws an IllegalArgumentException if one of the parameters is null.
		 */
		
		@NonNull public CAP selectEntryByIndexIndices(
		
			@NonNull java.lang.String index,
		
			@NonNull org.eclipse.jubula.toolkit.enums.ValueSets.BinaryChoice extendSelection,
		
			@NonNull org.eclipse.jubula.toolkit.enums.ValueSets.InteractionMode mouseButton,
		
			@NonNull java.lang.Integer numberOfClicks
		
		) throws IllegalArgumentException {
			MessageCap messageCap = new MessageCap();
			messageCap.setMethod("rcSelectIndex"); //$NON-NLS-1$
			messageCap.sethasDefaultMapping(false);
			
			messageCap.setCi(m_componentIdentifier);
			
			
			
			Validate.notNull(index, "Argument 'index' must not be null"); //$NON-NLS-1$
				
				
				
			messageCap.addMessageParam(new MessageParam(index.toString(), "java.lang.String")); //$NON-NLS-1$
				
			
			
			Validate.notNull(extendSelection, "Argument 'extendSelection' must not be null"); //$NON-NLS-1$
				
				
				
			messageCap.addMessageParam(new MessageParam(extendSelection.rcValue(), "java.lang.String")); //$NON-NLS-1$
				
			
			
			Validate.notNull(mouseButton, "Argument 'mouseButton' must not be null"); //$NON-NLS-1$
				
				
				
			messageCap.addMessageParam(new MessageParam(mouseButton.rcValue(), "java.lang.Integer")); //$NON-NLS-1$
				
			
			
			Validate.notNull(numberOfClicks, "Argument 'numberOfClicks' must not be null"); //$NON-NLS-1$
				
				
				
			messageCap.addMessageParam(new MessageParam(numberOfClicks.toString(), "java.lang.Integer")); //$NON-NLS-1$
				
			
			return messageCap;
		}
	
		/**
		 * @throws IllegalArgumentException Throws an IllegalArgumentException if one of the parameters is null.
		 */
		
		@NonNull public CAP selectEntryByValueS(
		
			@NonNull java.lang.String text,
		
			@NonNull org.eclipse.jubula.toolkit.enums.ValueSets.Operator operator,
		
			@NonNull org.eclipse.jubula.toolkit.enums.ValueSets.SearchType searchType,
		
			@NonNull org.eclipse.jubula.toolkit.enums.ValueSets.BinaryChoice extendSelection,
		
			@NonNull org.eclipse.jubula.toolkit.enums.ValueSets.InteractionMode mouseButton,
		
			@NonNull java.lang.Integer numberOfClicks
		
		) throws IllegalArgumentException {
			MessageCap messageCap = new MessageCap();
			messageCap.setMethod("rcSelectValue"); //$NON-NLS-1$
			messageCap.sethasDefaultMapping(false);
			
			messageCap.setCi(m_componentIdentifier);
			
			
			
			Validate.notNull(text, "Argument 'text' must not be null"); //$NON-NLS-1$
				
				
				
			messageCap.addMessageParam(new MessageParam(text.toString(), "java.lang.String")); //$NON-NLS-1$
				
			
			
			Validate.notNull(operator, "Argument 'operator' must not be null"); //$NON-NLS-1$
				
				
				
			messageCap.addMessageParam(new MessageParam(operator.rcValue(), "java.lang.String")); //$NON-NLS-1$
				
			
			
			Validate.notNull(searchType, "Argument 'searchType' must not be null"); //$NON-NLS-1$
				
				
				
			messageCap.addMessageParam(new MessageParam(searchType.rcValue(), "java.lang.String")); //$NON-NLS-1$
				
			
			
			Validate.notNull(extendSelection, "Argument 'extendSelection' must not be null"); //$NON-NLS-1$
				
				
				
			messageCap.addMessageParam(new MessageParam(extendSelection.rcValue(), "java.lang.String")); //$NON-NLS-1$
				
			
			
			Validate.notNull(mouseButton, "Argument 'mouseButton' must not be null"); //$NON-NLS-1$
				
				
				
			messageCap.addMessageParam(new MessageParam(mouseButton.rcValue(), "java.lang.Integer")); //$NON-NLS-1$
				
			
			
			Validate.notNull(numberOfClicks, "Argument 'numberOfClicks' must not be null"); //$NON-NLS-1$
				
				
				
			messageCap.addMessageParam(new MessageParam(numberOfClicks.toString(), "java.lang.Integer")); //$NON-NLS-1$
				
			
			return messageCap;
		}
	
		/**
		 * @throws IllegalArgumentException Throws an IllegalArgumentException if one of the parameters is null.
		 */
		
		@NonNull public CAP dragEntryByValue(
		
			@NonNull org.eclipse.jubula.toolkit.enums.ValueSets.InteractionMode mouseButton,
		
			@NonNull org.eclipse.jubula.toolkit.enums.ValueSets.Modifier modifierKeys,
		
			@NonNull java.lang.String text,
		
			@NonNull org.eclipse.jubula.toolkit.enums.ValueSets.Operator operator,
		
			@NonNull org.eclipse.jubula.toolkit.enums.ValueSets.SearchType searchType
		
		) throws IllegalArgumentException {
			MessageCap messageCap = new MessageCap();
			messageCap.setMethod("rcDragValue"); //$NON-NLS-1$
			messageCap.sethasDefaultMapping(false);
			
			messageCap.setCi(m_componentIdentifier);
			
			
			
			Validate.notNull(mouseButton, "Argument 'mouseButton' must not be null"); //$NON-NLS-1$
				
				
				
			messageCap.addMessageParam(new MessageParam(mouseButton.rcValue(), "java.lang.Integer")); //$NON-NLS-1$
				
			
			
			Validate.notNull(modifierKeys, "Argument 'modifierKeys' must not be null"); //$NON-NLS-1$
				
				
				
			messageCap.addMessageParam(new MessageParam(modifierKeys.rcValue(), "java.lang.String")); //$NON-NLS-1$
				
			
			
			Validate.notNull(text, "Argument 'text' must not be null"); //$NON-NLS-1$
				
				
				
			messageCap.addMessageParam(new MessageParam(text.toString(), "java.lang.String")); //$NON-NLS-1$
				
			
			
			Validate.notNull(operator, "Argument 'operator' must not be null"); //$NON-NLS-1$
				
				
				
			messageCap.addMessageParam(new MessageParam(operator.rcValue(), "java.lang.String")); //$NON-NLS-1$
				
			
			
			Validate.notNull(searchType, "Argument 'searchType' must not be null"); //$NON-NLS-1$
				
				
				
			messageCap.addMessageParam(new MessageParam(searchType.rcValue(), "java.lang.String")); //$NON-NLS-1$
				
			
			return messageCap;
		}
	
		/**
		 * @throws IllegalArgumentException Throws an IllegalArgumentException if one of the parameters is null.
		 */
		
		@NonNull public CAP dragEntryByIndex(
		
			@NonNull org.eclipse.jubula.toolkit.enums.ValueSets.InteractionMode mouseButton,
		
			@NonNull org.eclipse.jubula.toolkit.enums.ValueSets.Modifier modifierKeys,
		
			@NonNull java.lang.Integer index
		
		) throws IllegalArgumentException {
			MessageCap messageCap = new MessageCap();
			messageCap.setMethod("rcDragIndex"); //$NON-NLS-1$
			messageCap.sethasDefaultMapping(false);
			
			messageCap.setCi(m_componentIdentifier);
			
			
			
			Validate.notNull(mouseButton, "Argument 'mouseButton' must not be null"); //$NON-NLS-1$
				
				
				
			messageCap.addMessageParam(new MessageParam(mouseButton.rcValue(), "java.lang.Integer")); //$NON-NLS-1$
				
			
			
			Validate.notNull(modifierKeys, "Argument 'modifierKeys' must not be null"); //$NON-NLS-1$
				
				
				
			messageCap.addMessageParam(new MessageParam(modifierKeys.rcValue(), "java.lang.String")); //$NON-NLS-1$
				
			
			
			Validate.notNull(index, "Argument 'index' must not be null"); //$NON-NLS-1$
				
				
				
			messageCap.addMessageParam(new MessageParam(index.toString(), "java.lang.Integer")); //$NON-NLS-1$
				
			
			return messageCap;
		}
	
		/**
		 * @throws IllegalArgumentException Throws an IllegalArgumentException if one of the parameters is null.
		 */
		
		@NonNull public CAP dropOnEntryByValue(
		
			@NonNull java.lang.String text,
		
			@NonNull org.eclipse.jubula.toolkit.enums.ValueSets.Operator operator,
		
			@NonNull org.eclipse.jubula.toolkit.enums.ValueSets.SearchType searchType,
		
			@NonNull java.lang.Integer delayBeforeDropMilliseconds
		
		) throws IllegalArgumentException {
			MessageCap messageCap = new MessageCap();
			messageCap.setMethod("rcDropValue"); //$NON-NLS-1$
			messageCap.sethasDefaultMapping(false);
			
			messageCap.setCi(m_componentIdentifier);
			
			
			
			Validate.notNull(text, "Argument 'text' must not be null"); //$NON-NLS-1$
				
				
				
			messageCap.addMessageParam(new MessageParam(text.toString(), "java.lang.String")); //$NON-NLS-1$
				
			
			
			Validate.notNull(operator, "Argument 'operator' must not be null"); //$NON-NLS-1$
				
				
				
			messageCap.addMessageParam(new MessageParam(operator.rcValue(), "java.lang.String")); //$NON-NLS-1$
				
			
			
			Validate.notNull(searchType, "Argument 'searchType' must not be null"); //$NON-NLS-1$
				
				
				
			messageCap.addMessageParam(new MessageParam(searchType.rcValue(), "java.lang.String")); //$NON-NLS-1$
				
			
			
			Validate.notNull(delayBeforeDropMilliseconds, "Argument 'delayBeforeDropMilliseconds' must not be null"); //$NON-NLS-1$
				
				
				
			messageCap.addMessageParam(new MessageParam(delayBeforeDropMilliseconds.toString(), "java.lang.Integer")); //$NON-NLS-1$
				
			
			return messageCap;
		}
	
		/**
		 * @throws IllegalArgumentException Throws an IllegalArgumentException if one of the parameters is null.
		 */
		
		@NonNull public CAP dropOnEntryByIndex(
		
			@NonNull java.lang.Integer index,
		
			@NonNull java.lang.Integer delayBeforeDropMilliseconds
		
		) throws IllegalArgumentException {
			MessageCap messageCap = new MessageCap();
			messageCap.setMethod("rcDropIndex"); //$NON-NLS-1$
			messageCap.sethasDefaultMapping(false);
			
			messageCap.setCi(m_componentIdentifier);
			
			
			
			Validate.notNull(index, "Argument 'index' must not be null"); //$NON-NLS-1$
				
				
				
			messageCap.addMessageParam(new MessageParam(index.toString(), "java.lang.Integer")); //$NON-NLS-1$
				
			
			
			Validate.notNull(delayBeforeDropMilliseconds, "Argument 'delayBeforeDropMilliseconds' must not be null"); //$NON-NLS-1$
				
				
				
			messageCap.addMessageParam(new MessageParam(delayBeforeDropMilliseconds.toString(), "java.lang.Integer")); //$NON-NLS-1$
				
			
			return messageCap;
		}
	
} 