/*******************************************************************************
 * Copyright (c) 2014 BREDEX GmbH.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     BREDEX GmbH - initial API and implementation and/or initial documentation
 *******************************************************************************/
package org.eclipse.jubula.toolkit.concrete.internal.impl;

import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jubula.communication.CAP;
import org.apache.commons.lang.Validate;
import org.eclipse.jubula.communication.internal.message.MessageCap;
import org.eclipse.jubula.communication.internal.message.MessageParam;
import org.eclipse.jubula.tools.ComponentIdentifier;
import org.eclipse.jubula.tools.internal.objects.IComponentIdentifier;
import org.eclipse.jubula.toolkit.internal.annotations.RealizedType;
import org.eclipse.jubula.toolkit.internal.annotations.TesterClass;

/**
 * Class representing the TableComponent component from the concrete toolkit.
 */
@RealizedType(realizedType="guidancer.abstract.TextInputSupport")
public class TableComponent
	extends org.eclipse.jubula.toolkit.base.internal.impl.TextInputComponent
	implements org.eclipse.jubula.toolkit.concrete.components.TableComponent {
	
	
		
		
			
			public TableComponent(@NonNull ComponentIdentifier componentIdentifier) {
				super(componentIdentifier);
			}
		
	
	
	
	
	
		/**
		 * @throws IllegalArgumentException Throws an IllegalArgumentException if one of the parameters is null.
		 */
		
		@NonNull public CAP inputTextSpecifyCell(
		
			@NonNull java.lang.String text,
		
			@NonNull java.lang.String row,
		
			@NonNull java.lang.String rowOperator,
		
			@NonNull java.lang.String column,
		
			@NonNull java.lang.String columnOperator
		
		) throws IllegalArgumentException {
			MessageCap messageCap = new MessageCap();
			messageCap.setMethod("rcInputText"); //$NON-NLS-1$
			messageCap.sethasDefaultMapping(false);
			
			messageCap.setCi(m_componentIdentifier);
			
			
			
			Validate.notNull(text, "Argument 'text' must not be null"); //$NON-NLS-1$
				
				
				
			messageCap.addMessageParam(new MessageParam(text.toString(), "java.lang.String")); //$NON-NLS-1$
				
			
			
			Validate.notNull(row, "Argument 'row' must not be null"); //$NON-NLS-1$
				
				
				
			messageCap.addMessageParam(new MessageParam(row.toString(), "java.lang.String")); //$NON-NLS-1$
				
			
			
			Validate.notNull(rowOperator, "Argument 'rowOperator' must not be null"); //$NON-NLS-1$
				
				
				
			messageCap.addMessageParam(new MessageParam(rowOperator.toString(), "java.lang.String")); //$NON-NLS-1$
				
			
			
			Validate.notNull(column, "Argument 'column' must not be null"); //$NON-NLS-1$
				
				
				
			messageCap.addMessageParam(new MessageParam(column.toString(), "java.lang.String")); //$NON-NLS-1$
				
			
			
			Validate.notNull(columnOperator, "Argument 'columnOperator' must not be null"); //$NON-NLS-1$
				
				
				
			messageCap.addMessageParam(new MessageParam(columnOperator.toString(), "java.lang.String")); //$NON-NLS-1$
				
			
			return messageCap;
		}
	
		/**
		 * @throws IllegalArgumentException Throws an IllegalArgumentException if one of the parameters is null.
		 */
		
		@NonNull public CAP replaceTextSpecifyCell(
		
			@NonNull java.lang.String text,
		
			@NonNull java.lang.String row,
		
			@NonNull java.lang.String rowOperator,
		
			@NonNull java.lang.String column,
		
			@NonNull java.lang.String columnOperator
		
		) throws IllegalArgumentException {
			MessageCap messageCap = new MessageCap();
			messageCap.setMethod("rcReplaceText"); //$NON-NLS-1$
			messageCap.sethasDefaultMapping(false);
			
			messageCap.setCi(m_componentIdentifier);
			
			
			
			Validate.notNull(text, "Argument 'text' must not be null"); //$NON-NLS-1$
				
				
				
			messageCap.addMessageParam(new MessageParam(text.toString(), "java.lang.String")); //$NON-NLS-1$
				
			
			
			Validate.notNull(row, "Argument 'row' must not be null"); //$NON-NLS-1$
				
				
				
			messageCap.addMessageParam(new MessageParam(row.toString(), "java.lang.String")); //$NON-NLS-1$
				
			
			
			Validate.notNull(rowOperator, "Argument 'rowOperator' must not be null"); //$NON-NLS-1$
				
				
				
			messageCap.addMessageParam(new MessageParam(rowOperator.toString(), "java.lang.String")); //$NON-NLS-1$
				
			
			
			Validate.notNull(column, "Argument 'column' must not be null"); //$NON-NLS-1$
				
				
				
			messageCap.addMessageParam(new MessageParam(column.toString(), "java.lang.String")); //$NON-NLS-1$
				
			
			
			Validate.notNull(columnOperator, "Argument 'columnOperator' must not be null"); //$NON-NLS-1$
				
				
				
			messageCap.addMessageParam(new MessageParam(columnOperator.toString(), "java.lang.String")); //$NON-NLS-1$
				
			
			return messageCap;
		}
	
		/**
		 * @throws IllegalArgumentException Throws an IllegalArgumentException if one of the parameters is null.
		 */
		
		@NonNull public CAP selectCell(
		
			@NonNull java.lang.String row,
		
			@NonNull java.lang.String rowOperator,
		
			@NonNull java.lang.String column,
		
			@NonNull java.lang.String columnOperator,
		
			@NonNull java.lang.Integer numberOfClicks,
		
			@NonNull java.lang.Integer xPosition,
		
			@NonNull org.eclipse.jubula.toolkit.enums.ValueSets.Unit xUnits,
		
			@NonNull java.lang.Integer yPosition,
		
			@NonNull org.eclipse.jubula.toolkit.enums.ValueSets.Unit yUnits,
		
			@NonNull org.eclipse.jubula.toolkit.enums.ValueSets.BinaryChoice extendSelection,
		
			@NonNull org.eclipse.jubula.toolkit.enums.ValueSets.InteractionMode mouseButton
		
		) throws IllegalArgumentException {
			MessageCap messageCap = new MessageCap();
			messageCap.setMethod("rcSelectCell"); //$NON-NLS-1$
			messageCap.sethasDefaultMapping(false);
			
			messageCap.setCi(m_componentIdentifier);
			
			
			
			Validate.notNull(row, "Argument 'row' must not be null"); //$NON-NLS-1$
				
				
				
			messageCap.addMessageParam(new MessageParam(row.toString(), "java.lang.String")); //$NON-NLS-1$
				
			
			
			Validate.notNull(rowOperator, "Argument 'rowOperator' must not be null"); //$NON-NLS-1$
				
				
				
			messageCap.addMessageParam(new MessageParam(rowOperator.toString(), "java.lang.String")); //$NON-NLS-1$
				
			
			
			Validate.notNull(column, "Argument 'column' must not be null"); //$NON-NLS-1$
				
				
				
			messageCap.addMessageParam(new MessageParam(column.toString(), "java.lang.String")); //$NON-NLS-1$
				
			
			
			Validate.notNull(columnOperator, "Argument 'columnOperator' must not be null"); //$NON-NLS-1$
				
				
				
			messageCap.addMessageParam(new MessageParam(columnOperator.toString(), "java.lang.String")); //$NON-NLS-1$
				
			
			
			Validate.notNull(numberOfClicks, "Argument 'numberOfClicks' must not be null"); //$NON-NLS-1$
				
				
				
			messageCap.addMessageParam(new MessageParam(numberOfClicks.toString(), "java.lang.Integer")); //$NON-NLS-1$
				
			
			
			Validate.notNull(xPosition, "Argument 'xPosition' must not be null"); //$NON-NLS-1$
				
				
				
			messageCap.addMessageParam(new MessageParam(xPosition.toString(), "java.lang.Integer")); //$NON-NLS-1$
				
			
			
			Validate.notNull(xUnits, "Argument 'xUnits' must not be null"); //$NON-NLS-1$
				
				
				
			messageCap.addMessageParam(new MessageParam(xUnits.rcValue(), "java.lang.String")); //$NON-NLS-1$
				
			
			
			Validate.notNull(yPosition, "Argument 'yPosition' must not be null"); //$NON-NLS-1$
				
				
				
			messageCap.addMessageParam(new MessageParam(yPosition.toString(), "java.lang.Integer")); //$NON-NLS-1$
				
			
			
			Validate.notNull(yUnits, "Argument 'yUnits' must not be null"); //$NON-NLS-1$
				
				
				
			messageCap.addMessageParam(new MessageParam(yUnits.rcValue(), "java.lang.String")); //$NON-NLS-1$
				
			
			
			Validate.notNull(extendSelection, "Argument 'extendSelection' must not be null"); //$NON-NLS-1$
				
				
				
			messageCap.addMessageParam(new MessageParam(extendSelection.rcValue(), "java.lang.String")); //$NON-NLS-1$
				
			
			
			Validate.notNull(mouseButton, "Argument 'mouseButton' must not be null"); //$NON-NLS-1$
				
				
				
			messageCap.addMessageParam(new MessageParam(mouseButton.rcValue(), "java.lang.Integer")); //$NON-NLS-1$
				
			
			return messageCap;
		}
	
		/**
		 * @throws IllegalArgumentException Throws an IllegalArgumentException if one of the parameters is null.
		 */
		
		@NonNull public CAP move(
		
			@NonNull org.eclipse.jubula.toolkit.enums.ValueSets.Direction direction,
		
			@NonNull java.lang.Integer numberOfCells,
		
			@NonNull java.lang.Integer numberOfClicks,
		
			@NonNull java.lang.Integer xPosition,
		
			@NonNull org.eclipse.jubula.toolkit.enums.ValueSets.Unit xUnits,
		
			@NonNull java.lang.Integer yPosition,
		
			@NonNull org.eclipse.jubula.toolkit.enums.ValueSets.Unit yUnits,
		
			@NonNull org.eclipse.jubula.toolkit.enums.ValueSets.BinaryChoice extendSelection
		
		) throws IllegalArgumentException {
			MessageCap messageCap = new MessageCap();
			messageCap.setMethod("rcMove"); //$NON-NLS-1$
			messageCap.sethasDefaultMapping(false);
			
			messageCap.setCi(m_componentIdentifier);
			
			
			
			Validate.notNull(direction, "Argument 'direction' must not be null"); //$NON-NLS-1$
				
				
				
			messageCap.addMessageParam(new MessageParam(direction.rcValue(), "java.lang.String")); //$NON-NLS-1$
				
			
			
			Validate.notNull(numberOfCells, "Argument 'numberOfCells' must not be null"); //$NON-NLS-1$
				
				
				
			messageCap.addMessageParam(new MessageParam(numberOfCells.toString(), "java.lang.Integer")); //$NON-NLS-1$
				
			
			
			Validate.notNull(numberOfClicks, "Argument 'numberOfClicks' must not be null"); //$NON-NLS-1$
				
				
				
			messageCap.addMessageParam(new MessageParam(numberOfClicks.toString(), "java.lang.Integer")); //$NON-NLS-1$
				
			
			
			Validate.notNull(xPosition, "Argument 'xPosition' must not be null"); //$NON-NLS-1$
				
				
				
			messageCap.addMessageParam(new MessageParam(xPosition.toString(), "java.lang.Integer")); //$NON-NLS-1$
				
			
			
			Validate.notNull(xUnits, "Argument 'xUnits' must not be null"); //$NON-NLS-1$
				
				
				
			messageCap.addMessageParam(new MessageParam(xUnits.rcValue(), "java.lang.String")); //$NON-NLS-1$
				
			
			
			Validate.notNull(yPosition, "Argument 'yPosition' must not be null"); //$NON-NLS-1$
				
				
				
			messageCap.addMessageParam(new MessageParam(yPosition.toString(), "java.lang.Integer")); //$NON-NLS-1$
				
			
			
			Validate.notNull(yUnits, "Argument 'yUnits' must not be null"); //$NON-NLS-1$
				
				
				
			messageCap.addMessageParam(new MessageParam(yUnits.rcValue(), "java.lang.String")); //$NON-NLS-1$
				
			
			
			Validate.notNull(extendSelection, "Argument 'extendSelection' must not be null"); //$NON-NLS-1$
				
				
				
			messageCap.addMessageParam(new MessageParam(extendSelection.rcValue(), "java.lang.String")); //$NON-NLS-1$
				
			
			return messageCap;
		}
	
		/**
		 * @throws IllegalArgumentException Throws an IllegalArgumentException if one of the parameters is null.
		 */
		
		@NonNull public CAP checkEditabilitySpecifyCell(
		
			@NonNull java.lang.Boolean editable,
		
			@NonNull java.lang.String row,
		
			@NonNull java.lang.String rowOperator,
		
			@NonNull java.lang.String column,
		
			@NonNull java.lang.String columnOperator
		
		) throws IllegalArgumentException {
			MessageCap messageCap = new MessageCap();
			messageCap.setMethod("rcVerifyEditable"); //$NON-NLS-1$
			messageCap.sethasDefaultMapping(false);
			
			messageCap.setCi(m_componentIdentifier);
			
			
			
			Validate.notNull(editable, "Argument 'editable' must not be null"); //$NON-NLS-1$
				
				
				
			messageCap.addMessageParam(new MessageParam(editable.toString(), "java.lang.Boolean")); //$NON-NLS-1$
				
			
			
			Validate.notNull(row, "Argument 'row' must not be null"); //$NON-NLS-1$
				
				
				
			messageCap.addMessageParam(new MessageParam(row.toString(), "java.lang.String")); //$NON-NLS-1$
				
			
			
			Validate.notNull(rowOperator, "Argument 'rowOperator' must not be null"); //$NON-NLS-1$
				
				
				
			messageCap.addMessageParam(new MessageParam(rowOperator.toString(), "java.lang.String")); //$NON-NLS-1$
				
			
			
			Validate.notNull(column, "Argument 'column' must not be null"); //$NON-NLS-1$
				
				
				
			messageCap.addMessageParam(new MessageParam(column.toString(), "java.lang.String")); //$NON-NLS-1$
				
			
			
			Validate.notNull(columnOperator, "Argument 'columnOperator' must not be null"); //$NON-NLS-1$
				
				
				
			messageCap.addMessageParam(new MessageParam(columnOperator.toString(), "java.lang.String")); //$NON-NLS-1$
				
			
			return messageCap;
		}
	
		/**
		 * @throws IllegalArgumentException Throws an IllegalArgumentException if one of the parameters is null.
		 */
		
		@NonNull public CAP checkEditabilityOfSelectedCell(
		
			@NonNull java.lang.Boolean editable
		
		) throws IllegalArgumentException {
			MessageCap messageCap = new MessageCap();
			messageCap.setMethod("rcVerifyEditableSelected"); //$NON-NLS-1$
			messageCap.sethasDefaultMapping(false);
			
			messageCap.setCi(m_componentIdentifier);
			
			
			
			Validate.notNull(editable, "Argument 'editable' must not be null"); //$NON-NLS-1$
				
				
				
			messageCap.addMessageParam(new MessageParam(editable.toString(), "java.lang.Boolean")); //$NON-NLS-1$
				
			
			return messageCap;
		}
	
		/**
		 * @throws IllegalArgumentException Throws an IllegalArgumentException if one of the parameters is null.
		 */
		
		@NonNull public CAP checkEditabilityOfCellMousePosition(
		
			@NonNull java.lang.Boolean editable
		
		) throws IllegalArgumentException {
			MessageCap messageCap = new MessageCap();
			messageCap.setMethod("rcVerifyEditableMousePosition"); //$NON-NLS-1$
			messageCap.sethasDefaultMapping(false);
			
			messageCap.setCi(m_componentIdentifier);
			
			
			
			Validate.notNull(editable, "Argument 'editable' must not be null"); //$NON-NLS-1$
				
				
				
			messageCap.addMessageParam(new MessageParam(editable.toString(), "java.lang.Boolean")); //$NON-NLS-1$
				
			
			return messageCap;
		}
	
		/**
		 * @throws IllegalArgumentException Throws an IllegalArgumentException if one of the parameters is null.
		 */
		
		@NonNull public CAP checkTextSpecifyCell(
		
			@NonNull java.lang.String text,
		
			@NonNull java.lang.String textOperator,
		
			@NonNull java.lang.String row,
		
			@NonNull java.lang.String rowOperator,
		
			@NonNull java.lang.String column,
		
			@NonNull java.lang.String columnOperator
		
		) throws IllegalArgumentException {
			MessageCap messageCap = new MessageCap();
			messageCap.setMethod("rcVerifyText"); //$NON-NLS-1$
			messageCap.sethasDefaultMapping(false);
			
			messageCap.setCi(m_componentIdentifier);
			
			
			
			Validate.notNull(text, "Argument 'text' must not be null"); //$NON-NLS-1$
				
				
				
			messageCap.addMessageParam(new MessageParam(text.toString(), "java.lang.String")); //$NON-NLS-1$
				
			
			
			Validate.notNull(textOperator, "Argument 'textOperator' must not be null"); //$NON-NLS-1$
				
				
				
			messageCap.addMessageParam(new MessageParam(textOperator.toString(), "java.lang.String")); //$NON-NLS-1$
				
			
			
			Validate.notNull(row, "Argument 'row' must not be null"); //$NON-NLS-1$
				
				
				
			messageCap.addMessageParam(new MessageParam(row.toString(), "java.lang.String")); //$NON-NLS-1$
				
			
			
			Validate.notNull(rowOperator, "Argument 'rowOperator' must not be null"); //$NON-NLS-1$
				
				
				
			messageCap.addMessageParam(new MessageParam(rowOperator.toString(), "java.lang.String")); //$NON-NLS-1$
				
			
			
			Validate.notNull(column, "Argument 'column' must not be null"); //$NON-NLS-1$
				
				
				
			messageCap.addMessageParam(new MessageParam(column.toString(), "java.lang.String")); //$NON-NLS-1$
				
			
			
			Validate.notNull(columnOperator, "Argument 'columnOperator' must not be null"); //$NON-NLS-1$
				
				
				
			messageCap.addMessageParam(new MessageParam(columnOperator.toString(), "java.lang.String")); //$NON-NLS-1$
				
			
			return messageCap;
		}
	
		/**
		 * @throws IllegalArgumentException Throws an IllegalArgumentException if one of the parameters is null.
		 */
		
		@NonNull public CAP checkTextMousePosition(
		
			@NonNull java.lang.String text,
		
			@NonNull org.eclipse.jubula.toolkit.enums.ValueSets.Operator operator
		
		) throws IllegalArgumentException {
			MessageCap messageCap = new MessageCap();
			messageCap.setMethod("rcVerifyTextAtMousePosition"); //$NON-NLS-1$
			messageCap.sethasDefaultMapping(false);
			
			messageCap.setCi(m_componentIdentifier);
			
			
			
			Validate.notNull(text, "Argument 'text' must not be null"); //$NON-NLS-1$
				
				
				
			messageCap.addMessageParam(new MessageParam(text.toString(), "java.lang.String")); //$NON-NLS-1$
				
			
			
			Validate.notNull(operator, "Argument 'operator' must not be null"); //$NON-NLS-1$
				
				
				
			messageCap.addMessageParam(new MessageParam(operator.rcValue(), "java.lang.String")); //$NON-NLS-1$
				
			
			return messageCap;
		}
	
		/**
		 * @throws IllegalArgumentException Throws an IllegalArgumentException if one of the parameters is null.
		 */
		
		@NonNull public CAP checkExistenceOfValueInRow(
		
			@NonNull java.lang.String row,
		
			@NonNull java.lang.String rowOperator,
		
			@NonNull java.lang.String value,
		
			@NonNull java.lang.String valueOperator,
		
			@NonNull org.eclipse.jubula.toolkit.enums.ValueSets.SearchType searchType,
		
			@NonNull java.lang.Boolean exists
		
		) throws IllegalArgumentException {
			MessageCap messageCap = new MessageCap();
			messageCap.setMethod("rcVerifyValueInRow"); //$NON-NLS-1$
			messageCap.sethasDefaultMapping(false);
			
			messageCap.setCi(m_componentIdentifier);
			
			
			
			Validate.notNull(row, "Argument 'row' must not be null"); //$NON-NLS-1$
				
				
				
			messageCap.addMessageParam(new MessageParam(row.toString(), "java.lang.String")); //$NON-NLS-1$
				
			
			
			Validate.notNull(rowOperator, "Argument 'rowOperator' must not be null"); //$NON-NLS-1$
				
				
				
			messageCap.addMessageParam(new MessageParam(rowOperator.toString(), "java.lang.String")); //$NON-NLS-1$
				
			
			
			Validate.notNull(value, "Argument 'value' must not be null"); //$NON-NLS-1$
				
				
				
			messageCap.addMessageParam(new MessageParam(value.toString(), "java.lang.String")); //$NON-NLS-1$
				
			
			
			Validate.notNull(valueOperator, "Argument 'valueOperator' must not be null"); //$NON-NLS-1$
				
				
				
			messageCap.addMessageParam(new MessageParam(valueOperator.toString(), "java.lang.String")); //$NON-NLS-1$
				
			
			
			Validate.notNull(searchType, "Argument 'searchType' must not be null"); //$NON-NLS-1$
				
				
				
			messageCap.addMessageParam(new MessageParam(searchType.rcValue(), "java.lang.String")); //$NON-NLS-1$
				
			
			
			Validate.notNull(exists, "Argument 'exists' must not be null"); //$NON-NLS-1$
				
				
				
			messageCap.addMessageParam(new MessageParam(exists.toString(), "java.lang.Boolean")); //$NON-NLS-1$
				
			
			return messageCap;
		}
	
		/**
		 * @throws IllegalArgumentException Throws an IllegalArgumentException if one of the parameters is null.
		 */
		
		@NonNull public CAP checkExistenceOfValueInColumn(
		
			@NonNull java.lang.String column,
		
			@NonNull java.lang.String columnOperator,
		
			@NonNull java.lang.String value,
		
			@NonNull java.lang.String valueOperator,
		
			@NonNull org.eclipse.jubula.toolkit.enums.ValueSets.SearchType searchType,
		
			@NonNull java.lang.Boolean exists
		
		) throws IllegalArgumentException {
			MessageCap messageCap = new MessageCap();
			messageCap.setMethod("rcVerifyValueInColumn"); //$NON-NLS-1$
			messageCap.sethasDefaultMapping(false);
			
			messageCap.setCi(m_componentIdentifier);
			
			
			
			Validate.notNull(column, "Argument 'column' must not be null"); //$NON-NLS-1$
				
				
				
			messageCap.addMessageParam(new MessageParam(column.toString(), "java.lang.String")); //$NON-NLS-1$
				
			
			
			Validate.notNull(columnOperator, "Argument 'columnOperator' must not be null"); //$NON-NLS-1$
				
				
				
			messageCap.addMessageParam(new MessageParam(columnOperator.toString(), "java.lang.String")); //$NON-NLS-1$
				
			
			
			Validate.notNull(value, "Argument 'value' must not be null"); //$NON-NLS-1$
				
				
				
			messageCap.addMessageParam(new MessageParam(value.toString(), "java.lang.String")); //$NON-NLS-1$
				
			
			
			Validate.notNull(valueOperator, "Argument 'valueOperator' must not be null"); //$NON-NLS-1$
				
				
				
			messageCap.addMessageParam(new MessageParam(valueOperator.toString(), "java.lang.String")); //$NON-NLS-1$
				
			
			
			Validate.notNull(searchType, "Argument 'searchType' must not be null"); //$NON-NLS-1$
				
				
				
			messageCap.addMessageParam(new MessageParam(searchType.rcValue(), "java.lang.String")); //$NON-NLS-1$
				
			
			
			Validate.notNull(exists, "Argument 'exists' must not be null"); //$NON-NLS-1$
				
				
				
			messageCap.addMessageParam(new MessageParam(exists.toString(), "java.lang.Boolean")); //$NON-NLS-1$
				
			
			return messageCap;
		}
	
		/**
		 * @throws IllegalArgumentException Throws an IllegalArgumentException if one of the parameters is null.
		 */
		
		@NonNull public CAP selectValueFromColumn(
		
			@NonNull java.lang.String column,
		
			@NonNull java.lang.String columnOperator,
		
			@NonNull java.lang.String value,
		
			@NonNull java.lang.String valueOperator,
		
			@NonNull java.lang.Integer numberOfClicks,
		
			@NonNull org.eclipse.jubula.toolkit.enums.ValueSets.BinaryChoice extendSelection,
		
			@NonNull org.eclipse.jubula.toolkit.enums.ValueSets.SearchType searchType,
		
			@NonNull org.eclipse.jubula.toolkit.enums.ValueSets.InteractionMode mouseButton
		
		) throws IllegalArgumentException {
			MessageCap messageCap = new MessageCap();
			messageCap.setMethod("rcSelectRowByValue"); //$NON-NLS-1$
			messageCap.sethasDefaultMapping(false);
			
			messageCap.setCi(m_componentIdentifier);
			
			
			
			Validate.notNull(column, "Argument 'column' must not be null"); //$NON-NLS-1$
				
				
				
			messageCap.addMessageParam(new MessageParam(column.toString(), "java.lang.String")); //$NON-NLS-1$
				
			
			
			Validate.notNull(columnOperator, "Argument 'columnOperator' must not be null"); //$NON-NLS-1$
				
				
				
			messageCap.addMessageParam(new MessageParam(columnOperator.toString(), "java.lang.String")); //$NON-NLS-1$
				
			
			
			Validate.notNull(value, "Argument 'value' must not be null"); //$NON-NLS-1$
				
				
				
			messageCap.addMessageParam(new MessageParam(value.toString(), "java.lang.String")); //$NON-NLS-1$
				
			
			
			Validate.notNull(valueOperator, "Argument 'valueOperator' must not be null"); //$NON-NLS-1$
				
				
				
			messageCap.addMessageParam(new MessageParam(valueOperator.toString(), "java.lang.String")); //$NON-NLS-1$
				
			
			
			Validate.notNull(numberOfClicks, "Argument 'numberOfClicks' must not be null"); //$NON-NLS-1$
				
				
				
			messageCap.addMessageParam(new MessageParam(numberOfClicks.toString(), "java.lang.Integer")); //$NON-NLS-1$
				
			
			
			Validate.notNull(extendSelection, "Argument 'extendSelection' must not be null"); //$NON-NLS-1$
				
				
				
			messageCap.addMessageParam(new MessageParam(extendSelection.rcValue(), "java.lang.String")); //$NON-NLS-1$
				
			
			
			Validate.notNull(searchType, "Argument 'searchType' must not be null"); //$NON-NLS-1$
				
				
				
			messageCap.addMessageParam(new MessageParam(searchType.rcValue(), "java.lang.String")); //$NON-NLS-1$
				
			
			
			Validate.notNull(mouseButton, "Argument 'mouseButton' must not be null"); //$NON-NLS-1$
				
				
				
			messageCap.addMessageParam(new MessageParam(mouseButton.rcValue(), "java.lang.Integer")); //$NON-NLS-1$
				
			
			return messageCap;
		}
	
		/**
		 * @throws IllegalArgumentException Throws an IllegalArgumentException if one of the parameters is null.
		 */
		
		@NonNull public CAP selectValueFromRow(
		
			@NonNull java.lang.String row,
		
			@NonNull java.lang.String rowOperator,
		
			@NonNull java.lang.String value,
		
			@NonNull java.lang.String valueOperator,
		
			@NonNull java.lang.Integer numberOfClicks,
		
			@NonNull org.eclipse.jubula.toolkit.enums.ValueSets.BinaryChoice extendSelection,
		
			@NonNull org.eclipse.jubula.toolkit.enums.ValueSets.SearchType searchType,
		
			@NonNull org.eclipse.jubula.toolkit.enums.ValueSets.InteractionMode mouseButton
		
		) throws IllegalArgumentException {
			MessageCap messageCap = new MessageCap();
			messageCap.setMethod("rcSelectCellByColValue"); //$NON-NLS-1$
			messageCap.sethasDefaultMapping(false);
			
			messageCap.setCi(m_componentIdentifier);
			
			
			
			Validate.notNull(row, "Argument 'row' must not be null"); //$NON-NLS-1$
				
				
				
			messageCap.addMessageParam(new MessageParam(row.toString(), "java.lang.String")); //$NON-NLS-1$
				
			
			
			Validate.notNull(rowOperator, "Argument 'rowOperator' must not be null"); //$NON-NLS-1$
				
				
				
			messageCap.addMessageParam(new MessageParam(rowOperator.toString(), "java.lang.String")); //$NON-NLS-1$
				
			
			
			Validate.notNull(value, "Argument 'value' must not be null"); //$NON-NLS-1$
				
				
				
			messageCap.addMessageParam(new MessageParam(value.toString(), "java.lang.String")); //$NON-NLS-1$
				
			
			
			Validate.notNull(valueOperator, "Argument 'valueOperator' must not be null"); //$NON-NLS-1$
				
				
				
			messageCap.addMessageParam(new MessageParam(valueOperator.toString(), "java.lang.String")); //$NON-NLS-1$
				
			
			
			Validate.notNull(numberOfClicks, "Argument 'numberOfClicks' must not be null"); //$NON-NLS-1$
				
				
				
			messageCap.addMessageParam(new MessageParam(numberOfClicks.toString(), "java.lang.Integer")); //$NON-NLS-1$
				
			
			
			Validate.notNull(extendSelection, "Argument 'extendSelection' must not be null"); //$NON-NLS-1$
				
				
				
			messageCap.addMessageParam(new MessageParam(extendSelection.rcValue(), "java.lang.String")); //$NON-NLS-1$
				
			
			
			Validate.notNull(searchType, "Argument 'searchType' must not be null"); //$NON-NLS-1$
				
				
				
			messageCap.addMessageParam(new MessageParam(searchType.rcValue(), "java.lang.String")); //$NON-NLS-1$
				
			
			
			Validate.notNull(mouseButton, "Argument 'mouseButton' must not be null"); //$NON-NLS-1$
				
				
				
			messageCap.addMessageParam(new MessageParam(mouseButton.rcValue(), "java.lang.Integer")); //$NON-NLS-1$
				
			
			return messageCap;
		}
	
		/**
		 * @throws IllegalArgumentException Throws an IllegalArgumentException if one of the parameters is null.
		 */
		
		@NonNull public CAP dragCell(
		
			@NonNull org.eclipse.jubula.toolkit.enums.ValueSets.InteractionMode mouseButton,
		
			@NonNull org.eclipse.jubula.toolkit.enums.ValueSets.Modifier modifierKeys,
		
			@NonNull java.lang.String row,
		
			@NonNull java.lang.String rowOperator,
		
			@NonNull java.lang.String column,
		
			@NonNull java.lang.String columnOperator,
		
			@NonNull java.lang.Integer xPosition,
		
			@NonNull org.eclipse.jubula.toolkit.enums.ValueSets.Unit xUnits,
		
			@NonNull java.lang.Integer yPosition,
		
			@NonNull org.eclipse.jubula.toolkit.enums.ValueSets.Unit yUnits
		
		) throws IllegalArgumentException {
			MessageCap messageCap = new MessageCap();
			messageCap.setMethod("rcDragCell"); //$NON-NLS-1$
			messageCap.sethasDefaultMapping(false);
			
			messageCap.setCi(m_componentIdentifier);
			
			
			
			Validate.notNull(mouseButton, "Argument 'mouseButton' must not be null"); //$NON-NLS-1$
				
				
				
			messageCap.addMessageParam(new MessageParam(mouseButton.rcValue(), "java.lang.Integer")); //$NON-NLS-1$
				
			
			
			Validate.notNull(modifierKeys, "Argument 'modifierKeys' must not be null"); //$NON-NLS-1$
				
				
				
			messageCap.addMessageParam(new MessageParam(modifierKeys.rcValue(), "java.lang.String")); //$NON-NLS-1$
				
			
			
			Validate.notNull(row, "Argument 'row' must not be null"); //$NON-NLS-1$
				
				
				
			messageCap.addMessageParam(new MessageParam(row.toString(), "java.lang.String")); //$NON-NLS-1$
				
			
			
			Validate.notNull(rowOperator, "Argument 'rowOperator' must not be null"); //$NON-NLS-1$
				
				
				
			messageCap.addMessageParam(new MessageParam(rowOperator.toString(), "java.lang.String")); //$NON-NLS-1$
				
			
			
			Validate.notNull(column, "Argument 'column' must not be null"); //$NON-NLS-1$
				
				
				
			messageCap.addMessageParam(new MessageParam(column.toString(), "java.lang.String")); //$NON-NLS-1$
				
			
			
			Validate.notNull(columnOperator, "Argument 'columnOperator' must not be null"); //$NON-NLS-1$
				
				
				
			messageCap.addMessageParam(new MessageParam(columnOperator.toString(), "java.lang.String")); //$NON-NLS-1$
				
			
			
			Validate.notNull(xPosition, "Argument 'xPosition' must not be null"); //$NON-NLS-1$
				
				
				
			messageCap.addMessageParam(new MessageParam(xPosition.toString(), "java.lang.Integer")); //$NON-NLS-1$
				
			
			
			Validate.notNull(xUnits, "Argument 'xUnits' must not be null"); //$NON-NLS-1$
				
				
				
			messageCap.addMessageParam(new MessageParam(xUnits.rcValue(), "java.lang.String")); //$NON-NLS-1$
				
			
			
			Validate.notNull(yPosition, "Argument 'yPosition' must not be null"); //$NON-NLS-1$
				
				
				
			messageCap.addMessageParam(new MessageParam(yPosition.toString(), "java.lang.Integer")); //$NON-NLS-1$
				
			
			
			Validate.notNull(yUnits, "Argument 'yUnits' must not be null"); //$NON-NLS-1$
				
				
				
			messageCap.addMessageParam(new MessageParam(yUnits.rcValue(), "java.lang.String")); //$NON-NLS-1$
				
			
			return messageCap;
		}
	
		/**
		 * @throws IllegalArgumentException Throws an IllegalArgumentException if one of the parameters is null.
		 */
		
		@NonNull public CAP dropOnCell(
		
			@NonNull java.lang.String row,
		
			@NonNull java.lang.String rowOperator,
		
			@NonNull java.lang.String column,
		
			@NonNull java.lang.String columnOperator,
		
			@NonNull java.lang.Integer xPosition,
		
			@NonNull org.eclipse.jubula.toolkit.enums.ValueSets.Unit xUnits,
		
			@NonNull java.lang.Integer yPosition,
		
			@NonNull org.eclipse.jubula.toolkit.enums.ValueSets.Unit yUnits,
		
			@NonNull java.lang.Integer delayBeforeDropMilliseconds
		
		) throws IllegalArgumentException {
			MessageCap messageCap = new MessageCap();
			messageCap.setMethod("rcDropCell"); //$NON-NLS-1$
			messageCap.sethasDefaultMapping(false);
			
			messageCap.setCi(m_componentIdentifier);
			
			
			
			Validate.notNull(row, "Argument 'row' must not be null"); //$NON-NLS-1$
				
				
				
			messageCap.addMessageParam(new MessageParam(row.toString(), "java.lang.String")); //$NON-NLS-1$
				
			
			
			Validate.notNull(rowOperator, "Argument 'rowOperator' must not be null"); //$NON-NLS-1$
				
				
				
			messageCap.addMessageParam(new MessageParam(rowOperator.toString(), "java.lang.String")); //$NON-NLS-1$
				
			
			
			Validate.notNull(column, "Argument 'column' must not be null"); //$NON-NLS-1$
				
				
				
			messageCap.addMessageParam(new MessageParam(column.toString(), "java.lang.String")); //$NON-NLS-1$
				
			
			
			Validate.notNull(columnOperator, "Argument 'columnOperator' must not be null"); //$NON-NLS-1$
				
				
				
			messageCap.addMessageParam(new MessageParam(columnOperator.toString(), "java.lang.String")); //$NON-NLS-1$
				
			
			
			Validate.notNull(xPosition, "Argument 'xPosition' must not be null"); //$NON-NLS-1$
				
				
				
			messageCap.addMessageParam(new MessageParam(xPosition.toString(), "java.lang.Integer")); //$NON-NLS-1$
				
			
			
			Validate.notNull(xUnits, "Argument 'xUnits' must not be null"); //$NON-NLS-1$
				
				
				
			messageCap.addMessageParam(new MessageParam(xUnits.rcValue(), "java.lang.String")); //$NON-NLS-1$
				
			
			
			Validate.notNull(yPosition, "Argument 'yPosition' must not be null"); //$NON-NLS-1$
				
				
				
			messageCap.addMessageParam(new MessageParam(yPosition.toString(), "java.lang.Integer")); //$NON-NLS-1$
				
			
			
			Validate.notNull(yUnits, "Argument 'yUnits' must not be null"); //$NON-NLS-1$
				
				
				
			messageCap.addMessageParam(new MessageParam(yUnits.rcValue(), "java.lang.String")); //$NON-NLS-1$
				
			
			
			Validate.notNull(delayBeforeDropMilliseconds, "Argument 'delayBeforeDropMilliseconds' must not be null"); //$NON-NLS-1$
				
				
				
			messageCap.addMessageParam(new MessageParam(delayBeforeDropMilliseconds.toString(), "java.lang.Integer")); //$NON-NLS-1$
				
			
			return messageCap;
		}
	
		/**
		 * @throws IllegalArgumentException Throws an IllegalArgumentException if one of the parameters is null.
		 */
		
		@NonNull public CAP dragCellFromColumn(
		
			@NonNull org.eclipse.jubula.toolkit.enums.ValueSets.InteractionMode mouseButton,
		
			@NonNull org.eclipse.jubula.toolkit.enums.ValueSets.Modifier modifierKeys,
		
			@NonNull java.lang.String column,
		
			@NonNull java.lang.String columnOperator,
		
			@NonNull java.lang.String value,
		
			@NonNull java.lang.String valueOperator,
		
			@NonNull org.eclipse.jubula.toolkit.enums.ValueSets.SearchType searchType
		
		) throws IllegalArgumentException {
			MessageCap messageCap = new MessageCap();
			messageCap.setMethod("rcDragRowByValue"); //$NON-NLS-1$
			messageCap.sethasDefaultMapping(false);
			
			messageCap.setCi(m_componentIdentifier);
			
			
			
			Validate.notNull(mouseButton, "Argument 'mouseButton' must not be null"); //$NON-NLS-1$
				
				
				
			messageCap.addMessageParam(new MessageParam(mouseButton.rcValue(), "java.lang.Integer")); //$NON-NLS-1$
				
			
			
			Validate.notNull(modifierKeys, "Argument 'modifierKeys' must not be null"); //$NON-NLS-1$
				
				
				
			messageCap.addMessageParam(new MessageParam(modifierKeys.rcValue(), "java.lang.String")); //$NON-NLS-1$
				
			
			
			Validate.notNull(column, "Argument 'column' must not be null"); //$NON-NLS-1$
				
				
				
			messageCap.addMessageParam(new MessageParam(column.toString(), "java.lang.String")); //$NON-NLS-1$
				
			
			
			Validate.notNull(columnOperator, "Argument 'columnOperator' must not be null"); //$NON-NLS-1$
				
				
				
			messageCap.addMessageParam(new MessageParam(columnOperator.toString(), "java.lang.String")); //$NON-NLS-1$
				
			
			
			Validate.notNull(value, "Argument 'value' must not be null"); //$NON-NLS-1$
				
				
				
			messageCap.addMessageParam(new MessageParam(value.toString(), "java.lang.String")); //$NON-NLS-1$
				
			
			
			Validate.notNull(valueOperator, "Argument 'valueOperator' must not be null"); //$NON-NLS-1$
				
				
				
			messageCap.addMessageParam(new MessageParam(valueOperator.toString(), "java.lang.String")); //$NON-NLS-1$
				
			
			
			Validate.notNull(searchType, "Argument 'searchType' must not be null"); //$NON-NLS-1$
				
				
				
			messageCap.addMessageParam(new MessageParam(searchType.rcValue(), "java.lang.String")); //$NON-NLS-1$
				
			
			return messageCap;
		}
	
		/**
		 * @throws IllegalArgumentException Throws an IllegalArgumentException if one of the parameters is null.
		 */
		
		@NonNull public CAP dropOnCellFromColumn(
		
			@NonNull java.lang.String column,
		
			@NonNull java.lang.String columnOperator,
		
			@NonNull java.lang.String value,
		
			@NonNull java.lang.String valueOperator,
		
			@NonNull org.eclipse.jubula.toolkit.enums.ValueSets.SearchType searchType,
		
			@NonNull java.lang.Integer delayBeforeDropMilliseconds
		
		) throws IllegalArgumentException {
			MessageCap messageCap = new MessageCap();
			messageCap.setMethod("rcDropRowByValue"); //$NON-NLS-1$
			messageCap.sethasDefaultMapping(false);
			
			messageCap.setCi(m_componentIdentifier);
			
			
			
			Validate.notNull(column, "Argument 'column' must not be null"); //$NON-NLS-1$
				
				
				
			messageCap.addMessageParam(new MessageParam(column.toString(), "java.lang.String")); //$NON-NLS-1$
				
			
			
			Validate.notNull(columnOperator, "Argument 'columnOperator' must not be null"); //$NON-NLS-1$
				
				
				
			messageCap.addMessageParam(new MessageParam(columnOperator.toString(), "java.lang.String")); //$NON-NLS-1$
				
			
			
			Validate.notNull(value, "Argument 'value' must not be null"); //$NON-NLS-1$
				
				
				
			messageCap.addMessageParam(new MessageParam(value.toString(), "java.lang.String")); //$NON-NLS-1$
				
			
			
			Validate.notNull(valueOperator, "Argument 'valueOperator' must not be null"); //$NON-NLS-1$
				
				
				
			messageCap.addMessageParam(new MessageParam(valueOperator.toString(), "java.lang.String")); //$NON-NLS-1$
				
			
			
			Validate.notNull(searchType, "Argument 'searchType' must not be null"); //$NON-NLS-1$
				
				
				
			messageCap.addMessageParam(new MessageParam(searchType.rcValue(), "java.lang.String")); //$NON-NLS-1$
				
			
			
			Validate.notNull(delayBeforeDropMilliseconds, "Argument 'delayBeforeDropMilliseconds' must not be null"); //$NON-NLS-1$
				
				
				
			messageCap.addMessageParam(new MessageParam(delayBeforeDropMilliseconds.toString(), "java.lang.Integer")); //$NON-NLS-1$
				
			
			return messageCap;
		}
	
		/**
		 * @throws IllegalArgumentException Throws an IllegalArgumentException if one of the parameters is null.
		 */
		
		@NonNull public CAP dragCellFromRow(
		
			@NonNull org.eclipse.jubula.toolkit.enums.ValueSets.InteractionMode mouseButton,
		
			@NonNull org.eclipse.jubula.toolkit.enums.ValueSets.Modifier modifierKeys,
		
			@NonNull java.lang.String row,
		
			@NonNull java.lang.String rowOperator,
		
			@NonNull java.lang.String value,
		
			@NonNull java.lang.String valueOperator,
		
			@NonNull org.eclipse.jubula.toolkit.enums.ValueSets.SearchType searchType
		
		) throws IllegalArgumentException {
			MessageCap messageCap = new MessageCap();
			messageCap.setMethod("rcDragCellByColValue"); //$NON-NLS-1$
			messageCap.sethasDefaultMapping(false);
			
			messageCap.setCi(m_componentIdentifier);
			
			
			
			Validate.notNull(mouseButton, "Argument 'mouseButton' must not be null"); //$NON-NLS-1$
				
				
				
			messageCap.addMessageParam(new MessageParam(mouseButton.rcValue(), "java.lang.Integer")); //$NON-NLS-1$
				
			
			
			Validate.notNull(modifierKeys, "Argument 'modifierKeys' must not be null"); //$NON-NLS-1$
				
				
				
			messageCap.addMessageParam(new MessageParam(modifierKeys.rcValue(), "java.lang.String")); //$NON-NLS-1$
				
			
			
			Validate.notNull(row, "Argument 'row' must not be null"); //$NON-NLS-1$
				
				
				
			messageCap.addMessageParam(new MessageParam(row.toString(), "java.lang.String")); //$NON-NLS-1$
				
			
			
			Validate.notNull(rowOperator, "Argument 'rowOperator' must not be null"); //$NON-NLS-1$
				
				
				
			messageCap.addMessageParam(new MessageParam(rowOperator.toString(), "java.lang.String")); //$NON-NLS-1$
				
			
			
			Validate.notNull(value, "Argument 'value' must not be null"); //$NON-NLS-1$
				
				
				
			messageCap.addMessageParam(new MessageParam(value.toString(), "java.lang.String")); //$NON-NLS-1$
				
			
			
			Validate.notNull(valueOperator, "Argument 'valueOperator' must not be null"); //$NON-NLS-1$
				
				
				
			messageCap.addMessageParam(new MessageParam(valueOperator.toString(), "java.lang.String")); //$NON-NLS-1$
				
			
			
			Validate.notNull(searchType, "Argument 'searchType' must not be null"); //$NON-NLS-1$
				
				
				
			messageCap.addMessageParam(new MessageParam(searchType.rcValue(), "java.lang.String")); //$NON-NLS-1$
				
			
			return messageCap;
		}
	
		/**
		 * @throws IllegalArgumentException Throws an IllegalArgumentException if one of the parameters is null.
		 */
		
		@NonNull public CAP dropOnCellFromRow(
		
			@NonNull java.lang.String row,
		
			@NonNull java.lang.String rowOperator,
		
			@NonNull java.lang.String value,
		
			@NonNull java.lang.String valueOperator,
		
			@NonNull org.eclipse.jubula.toolkit.enums.ValueSets.SearchType searchType,
		
			@NonNull java.lang.Integer delayBeforeDropMilliseconds
		
		) throws IllegalArgumentException {
			MessageCap messageCap = new MessageCap();
			messageCap.setMethod("rcDropCellByColValue"); //$NON-NLS-1$
			messageCap.sethasDefaultMapping(false);
			
			messageCap.setCi(m_componentIdentifier);
			
			
			
			Validate.notNull(row, "Argument 'row' must not be null"); //$NON-NLS-1$
				
				
				
			messageCap.addMessageParam(new MessageParam(row.toString(), "java.lang.String")); //$NON-NLS-1$
				
			
			
			Validate.notNull(rowOperator, "Argument 'rowOperator' must not be null"); //$NON-NLS-1$
				
				
				
			messageCap.addMessageParam(new MessageParam(rowOperator.toString(), "java.lang.String")); //$NON-NLS-1$
				
			
			
			Validate.notNull(value, "Argument 'value' must not be null"); //$NON-NLS-1$
				
				
				
			messageCap.addMessageParam(new MessageParam(value.toString(), "java.lang.String")); //$NON-NLS-1$
				
			
			
			Validate.notNull(valueOperator, "Argument 'valueOperator' must not be null"); //$NON-NLS-1$
				
				
				
			messageCap.addMessageParam(new MessageParam(valueOperator.toString(), "java.lang.String")); //$NON-NLS-1$
				
			
			
			Validate.notNull(searchType, "Argument 'searchType' must not be null"); //$NON-NLS-1$
				
				
				
			messageCap.addMessageParam(new MessageParam(searchType.rcValue(), "java.lang.String")); //$NON-NLS-1$
				
			
			
			Validate.notNull(delayBeforeDropMilliseconds, "Argument 'delayBeforeDropMilliseconds' must not be null"); //$NON-NLS-1$
				
				
				
			messageCap.addMessageParam(new MessageParam(delayBeforeDropMilliseconds.toString(), "java.lang.Integer")); //$NON-NLS-1$
				
			
			return messageCap;
		}
	
		/**
		 * @throws IllegalArgumentException Throws an IllegalArgumentException if one of the parameters is null.
		 */
		
		@NonNull public CAP checkSelectionOfCheckboxInSelectedRow(
		
			@NonNull java.lang.Boolean checked
		
		) throws IllegalArgumentException {
			MessageCap messageCap = new MessageCap();
			messageCap.setMethod("rcVerifyCheckboxInSelectedRow"); //$NON-NLS-1$
			messageCap.sethasDefaultMapping(false);
			
			messageCap.setCi(m_componentIdentifier);
			
			
			
			Validate.notNull(checked, "Argument 'checked' must not be null"); //$NON-NLS-1$
				
				
				
			messageCap.addMessageParam(new MessageParam(checked.toString(), "java.lang.Boolean")); //$NON-NLS-1$
				
			
			return messageCap;
		}
	
		/**
		 * @throws IllegalArgumentException Throws an IllegalArgumentException if one of the parameters is null.
		 */
		
		@NonNull public CAP checkSelectionOfCheckboxAtMousePosition(
		
			@NonNull java.lang.Boolean checked
		
		) throws IllegalArgumentException {
			MessageCap messageCap = new MessageCap();
			messageCap.setMethod("rcVerifyCheckboxInRowAtMousePosition"); //$NON-NLS-1$
			messageCap.sethasDefaultMapping(false);
			
			messageCap.setCi(m_componentIdentifier);
			
			
			
			Validate.notNull(checked, "Argument 'checked' must not be null"); //$NON-NLS-1$
				
				
				
			messageCap.addMessageParam(new MessageParam(checked.toString(), "java.lang.Boolean")); //$NON-NLS-1$
				
			
			return messageCap;
		}
	
		
		@NonNull public CAP toggleCheckboxInSelectedRow(
		
		)  {
			MessageCap messageCap = new MessageCap();
			messageCap.setMethod("rcToggleCheckboxInSelectedRow"); //$NON-NLS-1$
			messageCap.sethasDefaultMapping(false);
			
			messageCap.setCi(m_componentIdentifier);
			
			
			return messageCap;
		}
	
		
		@NonNull public CAP toggleCheckboxAtMousePosition(
		
		)  {
			MessageCap messageCap = new MessageCap();
			messageCap.setMethod("rcToggleCheckboxInRowAtMousePosition"); //$NON-NLS-1$
			messageCap.sethasDefaultMapping(false);
			
			messageCap.setCi(m_componentIdentifier);
			
			
			return messageCap;
		}
	
} 