/*******************************************************************************
 * Copyright (c) 2014 BREDEX GmbH.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     BREDEX GmbH - initial API and implementation and/or initial documentation
 *******************************************************************************/
package org.eclipse.jubula.toolkit.concrete.internal.impl;

import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jubula.communication.CAP;
import org.apache.commons.lang.Validate;
import org.eclipse.jubula.communication.internal.message.MessageCap;
import org.eclipse.jubula.communication.internal.message.MessageParam;
import org.eclipse.jubula.tools.ComponentIdentifier;
import org.eclipse.jubula.tools.internal.objects.IComponentIdentifier;
import org.eclipse.jubula.toolkit.internal.annotations.RealizedType;
import org.eclipse.jubula.toolkit.internal.annotations.TesterClass;

/**
 * Class representing the TreeComponent component from the concrete toolkit.
 */
@RealizedType(realizedType="guidancer.abstract.Widget")
public class TreeComponent
	extends org.eclipse.jubula.toolkit.base.internal.impl.GraphicsComponent
	implements org.eclipse.jubula.toolkit.concrete.components.TreeComponent {
	
	
		
		
			
			public TreeComponent(@NonNull ComponentIdentifier componentIdentifier) {
				super(componentIdentifier);
			}
		
	
	
	
	
	
		/**
		 * @throws IllegalArgumentException Throws an IllegalArgumentException if one of the parameters is null.
		 */
		
		@NonNull public CAP collapseNodeByTextpath(
		
			@NonNull org.eclipse.jubula.toolkit.enums.ValueSets.SearchType pathType,
		
			@NonNull java.lang.Integer preAscend,
		
			@NonNull java.lang.String textpath,
		
			@NonNull org.eclipse.jubula.toolkit.enums.ValueSets.Operator operator
		
		) throws IllegalArgumentException {
			MessageCap messageCap = new MessageCap();
			messageCap.setMethod("rcCollapse"); //$NON-NLS-1$
			messageCap.sethasDefaultMapping(false);
			
			messageCap.setCi(m_componentIdentifier);
			
			
			
			Validate.notNull(pathType, "Argument 'pathType' must not be null"); //$NON-NLS-1$
				
				
				
			messageCap.addMessageParam(new MessageParam(pathType.rcValue(), "java.lang.String")); //$NON-NLS-1$
				
			
			
			Validate.notNull(preAscend, "Argument 'preAscend' must not be null"); //$NON-NLS-1$
				
				
				
			messageCap.addMessageParam(new MessageParam(preAscend.toString(), "java.lang.Integer")); //$NON-NLS-1$
				
			
			
			Validate.notNull(textpath, "Argument 'textpath' must not be null"); //$NON-NLS-1$
				
				
				
			messageCap.addMessageParam(new MessageParam(textpath.toString(), "java.lang.String")); //$NON-NLS-1$
				
			
			
			Validate.notNull(operator, "Argument 'operator' must not be null"); //$NON-NLS-1$
				
				
				
			messageCap.addMessageParam(new MessageParam(operator.rcValue(), "java.lang.String")); //$NON-NLS-1$
				
			
			return messageCap;
		}
	
		/**
		 * @throws IllegalArgumentException Throws an IllegalArgumentException if one of the parameters is null.
		 */
		
		@NonNull public CAP collapseNodeByIndexpath(
		
			@NonNull org.eclipse.jubula.toolkit.enums.ValueSets.SearchType pathType,
		
			@NonNull java.lang.Integer preAscend,
		
			@NonNull java.lang.String indexpath
		
		) throws IllegalArgumentException {
			MessageCap messageCap = new MessageCap();
			messageCap.setMethod("rcCollapseByIndices"); //$NON-NLS-1$
			messageCap.sethasDefaultMapping(false);
			
			messageCap.setCi(m_componentIdentifier);
			
			
			
			Validate.notNull(pathType, "Argument 'pathType' must not be null"); //$NON-NLS-1$
				
				
				
			messageCap.addMessageParam(new MessageParam(pathType.rcValue(), "java.lang.String")); //$NON-NLS-1$
				
			
			
			Validate.notNull(preAscend, "Argument 'preAscend' must not be null"); //$NON-NLS-1$
				
				
				
			messageCap.addMessageParam(new MessageParam(preAscend.toString(), "java.lang.Integer")); //$NON-NLS-1$
				
			
			
			Validate.notNull(indexpath, "Argument 'indexpath' must not be null"); //$NON-NLS-1$
				
				
				
			messageCap.addMessageParam(new MessageParam(indexpath.toString(), "java.lang.String")); //$NON-NLS-1$
				
			
			return messageCap;
		}
	
		/**
		 * @throws IllegalArgumentException Throws an IllegalArgumentException if one of the parameters is null.
		 */
		
		@NonNull public CAP expandNodeByTextpath(
		
			@NonNull org.eclipse.jubula.toolkit.enums.ValueSets.SearchType pathType,
		
			@NonNull java.lang.Integer preAscend,
		
			@NonNull java.lang.String textpath,
		
			@NonNull org.eclipse.jubula.toolkit.enums.ValueSets.Operator operator
		
		) throws IllegalArgumentException {
			MessageCap messageCap = new MessageCap();
			messageCap.setMethod("rcExpand"); //$NON-NLS-1$
			messageCap.sethasDefaultMapping(false);
			
			messageCap.setCi(m_componentIdentifier);
			
			
			
			Validate.notNull(pathType, "Argument 'pathType' must not be null"); //$NON-NLS-1$
				
				
				
			messageCap.addMessageParam(new MessageParam(pathType.rcValue(), "java.lang.String")); //$NON-NLS-1$
				
			
			
			Validate.notNull(preAscend, "Argument 'preAscend' must not be null"); //$NON-NLS-1$
				
				
				
			messageCap.addMessageParam(new MessageParam(preAscend.toString(), "java.lang.Integer")); //$NON-NLS-1$
				
			
			
			Validate.notNull(textpath, "Argument 'textpath' must not be null"); //$NON-NLS-1$
				
				
				
			messageCap.addMessageParam(new MessageParam(textpath.toString(), "java.lang.String")); //$NON-NLS-1$
				
			
			
			Validate.notNull(operator, "Argument 'operator' must not be null"); //$NON-NLS-1$
				
				
				
			messageCap.addMessageParam(new MessageParam(operator.rcValue(), "java.lang.String")); //$NON-NLS-1$
				
			
			return messageCap;
		}
	
		/**
		 * @throws IllegalArgumentException Throws an IllegalArgumentException if one of the parameters is null.
		 */
		
		@NonNull public CAP expandNodeByIndexpath(
		
			@NonNull org.eclipse.jubula.toolkit.enums.ValueSets.SearchType pathType,
		
			@NonNull java.lang.Integer preAscend,
		
			@NonNull java.lang.String indexpath
		
		) throws IllegalArgumentException {
			MessageCap messageCap = new MessageCap();
			messageCap.setMethod("rcExpandByIndices"); //$NON-NLS-1$
			messageCap.sethasDefaultMapping(false);
			
			messageCap.setCi(m_componentIdentifier);
			
			
			
			Validate.notNull(pathType, "Argument 'pathType' must not be null"); //$NON-NLS-1$
				
				
				
			messageCap.addMessageParam(new MessageParam(pathType.rcValue(), "java.lang.String")); //$NON-NLS-1$
				
			
			
			Validate.notNull(preAscend, "Argument 'preAscend' must not be null"); //$NON-NLS-1$
				
				
				
			messageCap.addMessageParam(new MessageParam(preAscend.toString(), "java.lang.Integer")); //$NON-NLS-1$
				
			
			
			Validate.notNull(indexpath, "Argument 'indexpath' must not be null"); //$NON-NLS-1$
				
				
				
			messageCap.addMessageParam(new MessageParam(indexpath.toString(), "java.lang.String")); //$NON-NLS-1$
				
			
			return messageCap;
		}
	
		/**
		 * @throws IllegalArgumentException Throws an IllegalArgumentException if one of the parameters is null.
		 */
		
		@NonNull public CAP selectNodeByTextpath(
		
			@NonNull org.eclipse.jubula.toolkit.enums.ValueSets.SearchType pathType,
		
			@NonNull java.lang.Integer preAscend,
		
			@NonNull java.lang.String textpath,
		
			@NonNull org.eclipse.jubula.toolkit.enums.ValueSets.Operator operator,
		
			@NonNull java.lang.Integer numberOfClicks,
		
			@NonNull org.eclipse.jubula.toolkit.enums.ValueSets.InteractionMode mouseButton,
		
			@NonNull org.eclipse.jubula.toolkit.enums.ValueSets.BinaryChoice extendSelection
		
		) throws IllegalArgumentException {
			MessageCap messageCap = new MessageCap();
			messageCap.setMethod("rcSelect"); //$NON-NLS-1$
			messageCap.sethasDefaultMapping(false);
			
			messageCap.setCi(m_componentIdentifier);
			
			
			
			Validate.notNull(pathType, "Argument 'pathType' must not be null"); //$NON-NLS-1$
				
				
				
			messageCap.addMessageParam(new MessageParam(pathType.rcValue(), "java.lang.String")); //$NON-NLS-1$
				
			
			
			Validate.notNull(preAscend, "Argument 'preAscend' must not be null"); //$NON-NLS-1$
				
				
				
			messageCap.addMessageParam(new MessageParam(preAscend.toString(), "java.lang.Integer")); //$NON-NLS-1$
				
			
			
			Validate.notNull(textpath, "Argument 'textpath' must not be null"); //$NON-NLS-1$
				
				
				
			messageCap.addMessageParam(new MessageParam(textpath.toString(), "java.lang.String")); //$NON-NLS-1$
				
			
			
			Validate.notNull(operator, "Argument 'operator' must not be null"); //$NON-NLS-1$
				
				
				
			messageCap.addMessageParam(new MessageParam(operator.rcValue(), "java.lang.String")); //$NON-NLS-1$
				
			
			
			Validate.notNull(numberOfClicks, "Argument 'numberOfClicks' must not be null"); //$NON-NLS-1$
				
				
				
			messageCap.addMessageParam(new MessageParam(numberOfClicks.toString(), "java.lang.Integer")); //$NON-NLS-1$
				
			
			
			Validate.notNull(mouseButton, "Argument 'mouseButton' must not be null"); //$NON-NLS-1$
				
				
				
			messageCap.addMessageParam(new MessageParam(mouseButton.rcValue(), "java.lang.Integer")); //$NON-NLS-1$
				
			
			
			Validate.notNull(extendSelection, "Argument 'extendSelection' must not be null"); //$NON-NLS-1$
				
				
				
			messageCap.addMessageParam(new MessageParam(extendSelection.rcValue(), "java.lang.String")); //$NON-NLS-1$
				
			
			return messageCap;
		}
	
		/**
		 * @throws IllegalArgumentException Throws an IllegalArgumentException if one of the parameters is null.
		 */
		
		@NonNull public CAP selectNodeByIndexpath(
		
			@NonNull org.eclipse.jubula.toolkit.enums.ValueSets.SearchType pathType,
		
			@NonNull java.lang.Integer preAscend,
		
			@NonNull java.lang.String indexpath,
		
			@NonNull java.lang.Integer numberOfClicks,
		
			@NonNull org.eclipse.jubula.toolkit.enums.ValueSets.InteractionMode mouseButton,
		
			@NonNull org.eclipse.jubula.toolkit.enums.ValueSets.BinaryChoice extendSelection
		
		) throws IllegalArgumentException {
			MessageCap messageCap = new MessageCap();
			messageCap.setMethod("rcSelectByIndices"); //$NON-NLS-1$
			messageCap.sethasDefaultMapping(false);
			
			messageCap.setCi(m_componentIdentifier);
			
			
			
			Validate.notNull(pathType, "Argument 'pathType' must not be null"); //$NON-NLS-1$
				
				
				
			messageCap.addMessageParam(new MessageParam(pathType.rcValue(), "java.lang.String")); //$NON-NLS-1$
				
			
			
			Validate.notNull(preAscend, "Argument 'preAscend' must not be null"); //$NON-NLS-1$
				
				
				
			messageCap.addMessageParam(new MessageParam(preAscend.toString(), "java.lang.Integer")); //$NON-NLS-1$
				
			
			
			Validate.notNull(indexpath, "Argument 'indexpath' must not be null"); //$NON-NLS-1$
				
				
				
			messageCap.addMessageParam(new MessageParam(indexpath.toString(), "java.lang.String")); //$NON-NLS-1$
				
			
			
			Validate.notNull(numberOfClicks, "Argument 'numberOfClicks' must not be null"); //$NON-NLS-1$
				
				
				
			messageCap.addMessageParam(new MessageParam(numberOfClicks.toString(), "java.lang.Integer")); //$NON-NLS-1$
				
			
			
			Validate.notNull(mouseButton, "Argument 'mouseButton' must not be null"); //$NON-NLS-1$
				
				
				
			messageCap.addMessageParam(new MessageParam(mouseButton.rcValue(), "java.lang.Integer")); //$NON-NLS-1$
				
			
			
			Validate.notNull(extendSelection, "Argument 'extendSelection' must not be null"); //$NON-NLS-1$
				
				
				
			messageCap.addMessageParam(new MessageParam(extendSelection.rcValue(), "java.lang.String")); //$NON-NLS-1$
				
			
			return messageCap;
		}
	
		/**
		 * @throws IllegalArgumentException Throws an IllegalArgumentException if one of the parameters is null.
		 */
		
		@NonNull public CAP move(
		
			@NonNull org.eclipse.jubula.toolkit.enums.ValueSets.TreeDirection direction,
		
			@NonNull java.lang.Integer numberOfNodes,
		
			@NonNull java.lang.Integer numberOfClicks
		
		) throws IllegalArgumentException {
			MessageCap messageCap = new MessageCap();
			messageCap.setMethod("rcMove"); //$NON-NLS-1$
			messageCap.sethasDefaultMapping(false);
			
			messageCap.setCi(m_componentIdentifier);
			
			
			
			Validate.notNull(direction, "Argument 'direction' must not be null"); //$NON-NLS-1$
				
				
				
			messageCap.addMessageParam(new MessageParam(direction.rcValue(), "java.lang.String")); //$NON-NLS-1$
				
			
			
			Validate.notNull(numberOfNodes, "Argument 'numberOfNodes' must not be null"); //$NON-NLS-1$
				
				
				
			messageCap.addMessageParam(new MessageParam(numberOfNodes.toString(), "java.lang.Integer")); //$NON-NLS-1$
				
			
			
			Validate.notNull(numberOfClicks, "Argument 'numberOfClicks' must not be null"); //$NON-NLS-1$
				
				
				
			messageCap.addMessageParam(new MessageParam(numberOfClicks.toString(), "java.lang.Integer")); //$NON-NLS-1$
				
			
			return messageCap;
		}
	
		/**
		 * @throws IllegalArgumentException Throws an IllegalArgumentException if one of the parameters is null.
		 */
		
		@NonNull public CAP checkExistenceOfNodeByTextpath(
		
			@NonNull org.eclipse.jubula.toolkit.enums.ValueSets.SearchType pathType,
		
			@NonNull java.lang.Integer preAscend,
		
			@NonNull java.lang.String textpath,
		
			@NonNull org.eclipse.jubula.toolkit.enums.ValueSets.Operator operator,
		
			@NonNull java.lang.Boolean exists
		
		) throws IllegalArgumentException {
			MessageCap messageCap = new MessageCap();
			messageCap.setMethod("rcVerifyPath"); //$NON-NLS-1$
			messageCap.sethasDefaultMapping(false);
			
			messageCap.setCi(m_componentIdentifier);
			
			
			
			Validate.notNull(pathType, "Argument 'pathType' must not be null"); //$NON-NLS-1$
				
				
				
			messageCap.addMessageParam(new MessageParam(pathType.rcValue(), "java.lang.String")); //$NON-NLS-1$
				
			
			
			Validate.notNull(preAscend, "Argument 'preAscend' must not be null"); //$NON-NLS-1$
				
				
				
			messageCap.addMessageParam(new MessageParam(preAscend.toString(), "java.lang.Integer")); //$NON-NLS-1$
				
			
			
			Validate.notNull(textpath, "Argument 'textpath' must not be null"); //$NON-NLS-1$
				
				
				
			messageCap.addMessageParam(new MessageParam(textpath.toString(), "java.lang.String")); //$NON-NLS-1$
				
			
			
			Validate.notNull(operator, "Argument 'operator' must not be null"); //$NON-NLS-1$
				
				
				
			messageCap.addMessageParam(new MessageParam(operator.rcValue(), "java.lang.String")); //$NON-NLS-1$
				
			
			
			Validate.notNull(exists, "Argument 'exists' must not be null"); //$NON-NLS-1$
				
				
				
			messageCap.addMessageParam(new MessageParam(exists.toString(), "java.lang.Boolean")); //$NON-NLS-1$
				
			
			return messageCap;
		}
	
		/**
		 * @throws IllegalArgumentException Throws an IllegalArgumentException if one of the parameters is null.
		 */
		
		@NonNull public CAP checkExistenceOfNodeByIndexpath(
		
			@NonNull org.eclipse.jubula.toolkit.enums.ValueSets.SearchType pathType,
		
			@NonNull java.lang.Integer preAscend,
		
			@NonNull java.lang.String indexpath,
		
			@NonNull java.lang.Boolean exists
		
		) throws IllegalArgumentException {
			MessageCap messageCap = new MessageCap();
			messageCap.setMethod("rcVerifyPathByIndices"); //$NON-NLS-1$
			messageCap.sethasDefaultMapping(false);
			
			messageCap.setCi(m_componentIdentifier);
			
			
			
			Validate.notNull(pathType, "Argument 'pathType' must not be null"); //$NON-NLS-1$
				
				
				
			messageCap.addMessageParam(new MessageParam(pathType.rcValue(), "java.lang.String")); //$NON-NLS-1$
				
			
			
			Validate.notNull(preAscend, "Argument 'preAscend' must not be null"); //$NON-NLS-1$
				
				
				
			messageCap.addMessageParam(new MessageParam(preAscend.toString(), "java.lang.Integer")); //$NON-NLS-1$
				
			
			
			Validate.notNull(indexpath, "Argument 'indexpath' must not be null"); //$NON-NLS-1$
				
				
				
			messageCap.addMessageParam(new MessageParam(indexpath.toString(), "java.lang.String")); //$NON-NLS-1$
				
			
			
			Validate.notNull(exists, "Argument 'exists' must not be null"); //$NON-NLS-1$
				
				
				
			messageCap.addMessageParam(new MessageParam(exists.toString(), "java.lang.Boolean")); //$NON-NLS-1$
				
			
			return messageCap;
		}
	
		/**
		 * @throws IllegalArgumentException Throws an IllegalArgumentException if one of the parameters is null.
		 */
		
		@NonNull public CAP checkTextOfSelectedNodeS(
		
			@NonNull java.lang.String text,
		
			@NonNull org.eclipse.jubula.toolkit.enums.ValueSets.Operator operator
		
		) throws IllegalArgumentException {
			MessageCap messageCap = new MessageCap();
			messageCap.setMethod("rcVerifySelectedValue"); //$NON-NLS-1$
			messageCap.sethasDefaultMapping(false);
			
			messageCap.setCi(m_componentIdentifier);
			
			
			
			Validate.notNull(text, "Argument 'text' must not be null"); //$NON-NLS-1$
				
				
				
			messageCap.addMessageParam(new MessageParam(text.toString(), "java.lang.String")); //$NON-NLS-1$
				
			
			
			Validate.notNull(operator, "Argument 'operator' must not be null"); //$NON-NLS-1$
				
				
				
			messageCap.addMessageParam(new MessageParam(operator.rcValue(), "java.lang.String")); //$NON-NLS-1$
				
			
			return messageCap;
		}
	
		/**
		 * @throws IllegalArgumentException Throws an IllegalArgumentException if one of the parameters is null.
		 */
		
		@NonNull public CAP checkTextMousePosition(
		
			@NonNull java.lang.String text,
		
			@NonNull org.eclipse.jubula.toolkit.enums.ValueSets.Operator operator
		
		) throws IllegalArgumentException {
			MessageCap messageCap = new MessageCap();
			messageCap.setMethod("rcVerifyTextAtMousePosition"); //$NON-NLS-1$
			messageCap.sethasDefaultMapping(false);
			
			messageCap.setCi(m_componentIdentifier);
			
			
			
			Validate.notNull(text, "Argument 'text' must not be null"); //$NON-NLS-1$
				
				
				
			messageCap.addMessageParam(new MessageParam(text.toString(), "java.lang.String")); //$NON-NLS-1$
				
			
			
			Validate.notNull(operator, "Argument 'operator' must not be null"); //$NON-NLS-1$
				
				
				
			messageCap.addMessageParam(new MessageParam(operator.rcValue(), "java.lang.String")); //$NON-NLS-1$
				
			
			return messageCap;
		}
	
		/**
		 * @throws IllegalArgumentException Throws an IllegalArgumentException if one of the parameters is null.
		 */
		
		@NonNull public CAP dragNodeByTextpath(
		
			@NonNull org.eclipse.jubula.toolkit.enums.ValueSets.InteractionMode mouseButton,
		
			@NonNull org.eclipse.jubula.toolkit.enums.ValueSets.Modifier modifierKeys,
		
			@NonNull org.eclipse.jubula.toolkit.enums.ValueSets.SearchType pathType,
		
			@NonNull java.lang.Integer preAscend,
		
			@NonNull java.lang.String treeTextpath,
		
			@NonNull org.eclipse.jubula.toolkit.enums.ValueSets.Operator operator
		
		) throws IllegalArgumentException {
			MessageCap messageCap = new MessageCap();
			messageCap.setMethod("rcDragByTextPath"); //$NON-NLS-1$
			messageCap.sethasDefaultMapping(false);
			
			messageCap.setCi(m_componentIdentifier);
			
			
			
			Validate.notNull(mouseButton, "Argument 'mouseButton' must not be null"); //$NON-NLS-1$
				
				
				
			messageCap.addMessageParam(new MessageParam(mouseButton.rcValue(), "java.lang.Integer")); //$NON-NLS-1$
				
			
			
			Validate.notNull(modifierKeys, "Argument 'modifierKeys' must not be null"); //$NON-NLS-1$
				
				
				
			messageCap.addMessageParam(new MessageParam(modifierKeys.rcValue(), "java.lang.String")); //$NON-NLS-1$
				
			
			
			Validate.notNull(pathType, "Argument 'pathType' must not be null"); //$NON-NLS-1$
				
				
				
			messageCap.addMessageParam(new MessageParam(pathType.rcValue(), "java.lang.String")); //$NON-NLS-1$
				
			
			
			Validate.notNull(preAscend, "Argument 'preAscend' must not be null"); //$NON-NLS-1$
				
				
				
			messageCap.addMessageParam(new MessageParam(preAscend.toString(), "java.lang.Integer")); //$NON-NLS-1$
				
			
			
			Validate.notNull(treeTextpath, "Argument 'treeTextpath' must not be null"); //$NON-NLS-1$
				
				
				
			messageCap.addMessageParam(new MessageParam(treeTextpath.toString(), "java.lang.String")); //$NON-NLS-1$
				
			
			
			Validate.notNull(operator, "Argument 'operator' must not be null"); //$NON-NLS-1$
				
				
				
			messageCap.addMessageParam(new MessageParam(operator.rcValue(), "java.lang.String")); //$NON-NLS-1$
				
			
			return messageCap;
		}
	
		/**
		 * @throws IllegalArgumentException Throws an IllegalArgumentException if one of the parameters is null.
		 */
		
		@NonNull public CAP dropOnNodeByTextpath(
		
			@NonNull org.eclipse.jubula.toolkit.enums.ValueSets.SearchType pathType,
		
			@NonNull java.lang.Integer preAscend,
		
			@NonNull java.lang.String treeTextpath,
		
			@NonNull org.eclipse.jubula.toolkit.enums.ValueSets.Operator operator,
		
			@NonNull java.lang.Integer delayBeforeDropMilliseconds
		
		) throws IllegalArgumentException {
			MessageCap messageCap = new MessageCap();
			messageCap.setMethod("rcDropByTextPath"); //$NON-NLS-1$
			messageCap.sethasDefaultMapping(false);
			
			messageCap.setCi(m_componentIdentifier);
			
			
			
			Validate.notNull(pathType, "Argument 'pathType' must not be null"); //$NON-NLS-1$
				
				
				
			messageCap.addMessageParam(new MessageParam(pathType.rcValue(), "java.lang.String")); //$NON-NLS-1$
				
			
			
			Validate.notNull(preAscend, "Argument 'preAscend' must not be null"); //$NON-NLS-1$
				
				
				
			messageCap.addMessageParam(new MessageParam(preAscend.toString(), "java.lang.Integer")); //$NON-NLS-1$
				
			
			
			Validate.notNull(treeTextpath, "Argument 'treeTextpath' must not be null"); //$NON-NLS-1$
				
				
				
			messageCap.addMessageParam(new MessageParam(treeTextpath.toString(), "java.lang.String")); //$NON-NLS-1$
				
			
			
			Validate.notNull(operator, "Argument 'operator' must not be null"); //$NON-NLS-1$
				
				
				
			messageCap.addMessageParam(new MessageParam(operator.rcValue(), "java.lang.String")); //$NON-NLS-1$
				
			
			
			Validate.notNull(delayBeforeDropMilliseconds, "Argument 'delayBeforeDropMilliseconds' must not be null"); //$NON-NLS-1$
				
				
				
			messageCap.addMessageParam(new MessageParam(delayBeforeDropMilliseconds.toString(), "java.lang.Integer")); //$NON-NLS-1$
				
			
			return messageCap;
		}
	
		/**
		 * @throws IllegalArgumentException Throws an IllegalArgumentException if one of the parameters is null.
		 */
		
		@NonNull public CAP dragNodeByIndexpath(
		
			@NonNull org.eclipse.jubula.toolkit.enums.ValueSets.InteractionMode mouseButton,
		
			@NonNull org.eclipse.jubula.toolkit.enums.ValueSets.Modifier modifierKeys,
		
			@NonNull org.eclipse.jubula.toolkit.enums.ValueSets.SearchType pathType,
		
			@NonNull java.lang.Integer preAscend,
		
			@NonNull java.lang.String treeIndexpath
		
		) throws IllegalArgumentException {
			MessageCap messageCap = new MessageCap();
			messageCap.setMethod("rcDragByIndexPath"); //$NON-NLS-1$
			messageCap.sethasDefaultMapping(false);
			
			messageCap.setCi(m_componentIdentifier);
			
			
			
			Validate.notNull(mouseButton, "Argument 'mouseButton' must not be null"); //$NON-NLS-1$
				
				
				
			messageCap.addMessageParam(new MessageParam(mouseButton.rcValue(), "java.lang.Integer")); //$NON-NLS-1$
				
			
			
			Validate.notNull(modifierKeys, "Argument 'modifierKeys' must not be null"); //$NON-NLS-1$
				
				
				
			messageCap.addMessageParam(new MessageParam(modifierKeys.rcValue(), "java.lang.String")); //$NON-NLS-1$
				
			
			
			Validate.notNull(pathType, "Argument 'pathType' must not be null"); //$NON-NLS-1$
				
				
				
			messageCap.addMessageParam(new MessageParam(pathType.rcValue(), "java.lang.String")); //$NON-NLS-1$
				
			
			
			Validate.notNull(preAscend, "Argument 'preAscend' must not be null"); //$NON-NLS-1$
				
				
				
			messageCap.addMessageParam(new MessageParam(preAscend.toString(), "java.lang.Integer")); //$NON-NLS-1$
				
			
			
			Validate.notNull(treeIndexpath, "Argument 'treeIndexpath' must not be null"); //$NON-NLS-1$
				
				
				
			messageCap.addMessageParam(new MessageParam(treeIndexpath.toString(), "java.lang.String")); //$NON-NLS-1$
				
			
			return messageCap;
		}
	
		/**
		 * @throws IllegalArgumentException Throws an IllegalArgumentException if one of the parameters is null.
		 */
		
		@NonNull public CAP dropOnNodeByIndexpath(
		
			@NonNull org.eclipse.jubula.toolkit.enums.ValueSets.SearchType pathType,
		
			@NonNull java.lang.Integer preAscend,
		
			@NonNull java.lang.String treeIndexpath,
		
			@NonNull java.lang.Integer delayBeforeDropMilliseconds
		
		) throws IllegalArgumentException {
			MessageCap messageCap = new MessageCap();
			messageCap.setMethod("rcDropByIndexPath"); //$NON-NLS-1$
			messageCap.sethasDefaultMapping(false);
			
			messageCap.setCi(m_componentIdentifier);
			
			
			
			Validate.notNull(pathType, "Argument 'pathType' must not be null"); //$NON-NLS-1$
				
				
				
			messageCap.addMessageParam(new MessageParam(pathType.rcValue(), "java.lang.String")); //$NON-NLS-1$
				
			
			
			Validate.notNull(preAscend, "Argument 'preAscend' must not be null"); //$NON-NLS-1$
				
				
				
			messageCap.addMessageParam(new MessageParam(preAscend.toString(), "java.lang.Integer")); //$NON-NLS-1$
				
			
			
			Validate.notNull(treeIndexpath, "Argument 'treeIndexpath' must not be null"); //$NON-NLS-1$
				
				
				
			messageCap.addMessageParam(new MessageParam(treeIndexpath.toString(), "java.lang.String")); //$NON-NLS-1$
				
			
			
			Validate.notNull(delayBeforeDropMilliseconds, "Argument 'delayBeforeDropMilliseconds' must not be null"); //$NON-NLS-1$
				
				
				
			messageCap.addMessageParam(new MessageParam(delayBeforeDropMilliseconds.toString(), "java.lang.Integer")); //$NON-NLS-1$
				
			
			return messageCap;
		}
	
} 