/*******************************************************************************
 * Copyright (c) 2014 BREDEX GmbH.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     BREDEX GmbH - initial API and implementation and/or initial documentation
 *******************************************************************************/
package org.eclipse.jubula.toolkit.html.internal.impl;

import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jubula.communication.CAP;
import org.apache.commons.lang.Validate;
import org.eclipse.jubula.communication.internal.message.MessageCap;
import org.eclipse.jubula.communication.internal.message.MessageParam;
import org.eclipse.jubula.tools.ComponentIdentifier;
import org.eclipse.jubula.tools.internal.objects.IComponentIdentifier;
import org.eclipse.jubula.toolkit.internal.annotations.RealizedType;
import org.eclipse.jubula.toolkit.internal.annotations.TesterClass;

/**
 * Class representing the Browser component from the html toolkit.
 */
@TesterClass(testerClass="com.bredexsw.jubula.rc.html.web.implclasses.HtmlApplicationImplClass")
public class Browser
	
	implements org.eclipse.jubula.toolkit.html.components.Browser {
	
	
		
		
			
			public Browser() {
				super();
			}
		
	
	
	
	protected IComponentIdentifier getPseudoComponentIdentifier() {
		
		org.eclipse.jubula.tools.internal.objects.ComponentIdentifier pseudoIdentifier =
			new org.eclipse.jubula.tools.internal.objects.ComponentIdentifier();
		pseudoIdentifier.setComponentClassName("com.bredexsw.guidancer.webautserver.web.implclasses.WebBrowser"); //$NON-NLS-1$
		return pseudoIdentifier;
		
	}
	
	
		/**
		 * @throws IllegalArgumentException Throws an IllegalArgumentException if one of the parameters is null.
		 */
		
		@NonNull public CAP openURL(
		
			@NonNull java.lang.String uRL
		
		) throws IllegalArgumentException {
			MessageCap messageCap = new MessageCap();
			messageCap.setMethod("rcGotoUrl"); //$NON-NLS-1$
			messageCap.sethasDefaultMapping(true);
			
			messageCap.setCi(getPseudoComponentIdentifier());
			
			
			Validate.notNull(uRL, "Argument 'uRL' must not be null"); //$NON-NLS-1$
				
				
				
			messageCap.addMessageParam(new MessageParam(uRL.toString(), "java.lang.String")); //$NON-NLS-1$
				
			
			return messageCap;
		}
	
		
		@NonNull public CAP goBack(
		
		)  {
			MessageCap messageCap = new MessageCap();
			messageCap.setMethod("rcBack"); //$NON-NLS-1$
			messageCap.sethasDefaultMapping(true);
			
			messageCap.setCi(getPseudoComponentIdentifier());
			
			return messageCap;
		}
	
		
		@NonNull public CAP reloadPage(
		
		)  {
			MessageCap messageCap = new MessageCap();
			messageCap.setMethod("rcReload"); //$NON-NLS-1$
			messageCap.sethasDefaultMapping(true);
			
			messageCap.setCi(getPseudoComponentIdentifier());
			
			return messageCap;
		}
	
		/**
		 * @throws IllegalArgumentException Throws an IllegalArgumentException if one of the parameters is null.
		 */
		
		@NonNull public CAP selectWindowWithIdentifier(
		
			@NonNull java.lang.String identifier,
		
			@NonNull java.lang.String identifierType
		
		) throws IllegalArgumentException {
			MessageCap messageCap = new MessageCap();
			messageCap.setMethod("rcSelectWindowByIdentifier"); //$NON-NLS-1$
			messageCap.sethasDefaultMapping(true);
			
			messageCap.setCi(getPseudoComponentIdentifier());
			
			
			Validate.notNull(identifier, "Argument 'identifier' must not be null"); //$NON-NLS-1$
				
				
				
			messageCap.addMessageParam(new MessageParam(identifier.toString(), "java.lang.String")); //$NON-NLS-1$
				
			
			
			Validate.notNull(identifierType, "Argument 'identifierType' must not be null"); //$NON-NLS-1$
				
				
				
			messageCap.addMessageParam(new MessageParam(identifierType.toString(), "java.lang.String")); //$NON-NLS-1$
				
			
			return messageCap;
		}
	
		/**
		 * @throws IllegalArgumentException Throws an IllegalArgumentException if one of the parameters is null.
		 */
		
		@NonNull public CAP selectWindowWithTitle(
		
			@NonNull java.lang.String windowTitle,
		
			@NonNull org.eclipse.jubula.toolkit.enums.ValueSets.Operator operator
		
		) throws IllegalArgumentException {
			MessageCap messageCap = new MessageCap();
			messageCap.setMethod("rcSelectWindow"); //$NON-NLS-1$
			messageCap.sethasDefaultMapping(true);
			
			messageCap.setCi(getPseudoComponentIdentifier());
			
			
			Validate.notNull(windowTitle, "Argument 'windowTitle' must not be null"); //$NON-NLS-1$
				
				
				
			messageCap.addMessageParam(new MessageParam(windowTitle.toString(), "java.lang.String")); //$NON-NLS-1$
				
			
			
			Validate.notNull(operator, "Argument 'operator' must not be null"); //$NON-NLS-1$
				
				
				
			messageCap.addMessageParam(new MessageParam(operator.rcValue(), "java.lang.String")); //$NON-NLS-1$
				
			
			return messageCap;
		}
	
} 