/*******************************************************************************
 * Copyright (c) 2014 BREDEX GmbH.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     BREDEX GmbH - initial API and implementation and/or initial documentation
 *******************************************************************************/
package org.eclipse.jubula.toolkit.ios.internal.impl;

import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jubula.communication.CAP;
import org.apache.commons.lang.Validate;
import org.eclipse.jubula.communication.internal.message.MessageCap;
import org.eclipse.jubula.communication.internal.message.MessageParam;
import org.eclipse.jubula.tools.ComponentIdentifier;
import org.eclipse.jubula.tools.internal.objects.IComponentIdentifier;
import org.eclipse.jubula.toolkit.internal.annotations.RealizedType;
import org.eclipse.jubula.toolkit.internal.annotations.TesterClass;

/**
 * Class representing the Picker component from the ios toolkit.
 */
@RealizedType(realizedType="guidancer.concrete.ComboBox")
public class Picker
	extends org.eclipse.jubula.toolkit.concrete.internal.impl.ComboComponent
	implements org.eclipse.jubula.toolkit.ios.components.Picker {
	
	
		
		
			
			public Picker(@NonNull ComponentIdentifier componentIdentifier) {
				super(componentIdentifier);
			}
		
	
	
	
	
	
		/**
		 * @throws IllegalArgumentException Throws an IllegalArgumentException if one of the parameters is null.
		 */
		
		@NonNull public CAP swipe(
		
			@NonNull org.eclipse.jubula.toolkit.enums.ValueSets.Direction direction
		
		) throws IllegalArgumentException {
			MessageCap messageCap = new MessageCap();
			messageCap.setMethod("rcSwipe"); //$NON-NLS-1$
			messageCap.sethasDefaultMapping(false);
			
			messageCap.setCi(m_componentIdentifier);
			
			
			
			Validate.notNull(direction, "Argument 'direction' must not be null"); //$NON-NLS-1$
				
				
				
			messageCap.addMessageParam(new MessageParam(direction.rcValue(), "java.lang.String")); //$NON-NLS-1$
				
			
			return messageCap;
		}
	
		/**
		 * @throws IllegalArgumentException Throws an IllegalArgumentException if one of the parameters is null.
		 */
		
		@NonNull public CAP checkExistenceOfEntryByValueInColumn(
		
			@NonNull java.lang.String text,
		
			@NonNull org.eclipse.jubula.toolkit.enums.ValueSets.Operator operator,
		
			@NonNull java.lang.Boolean exists,
		
			@NonNull java.lang.Integer column
		
		) throws IllegalArgumentException {
			MessageCap messageCap = new MessageCap();
			messageCap.setMethod("rcVerifyContainsValue"); //$NON-NLS-1$
			messageCap.sethasDefaultMapping(false);
			
			messageCap.setCi(m_componentIdentifier);
			
			
			
			Validate.notNull(text, "Argument 'text' must not be null"); //$NON-NLS-1$
				
				
				
			messageCap.addMessageParam(new MessageParam(text.toString(), "java.lang.String")); //$NON-NLS-1$
				
			
			
			Validate.notNull(operator, "Argument 'operator' must not be null"); //$NON-NLS-1$
				
				
				
			messageCap.addMessageParam(new MessageParam(operator.rcValue(), "java.lang.String")); //$NON-NLS-1$
				
			
			
			Validate.notNull(exists, "Argument 'exists' must not be null"); //$NON-NLS-1$
				
				
				
			messageCap.addMessageParam(new MessageParam(exists.toString(), "java.lang.Boolean")); //$NON-NLS-1$
				
			
			
			Validate.notNull(column, "Argument 'column' must not be null"); //$NON-NLS-1$
				
				
				
			messageCap.addMessageParam(new MessageParam(column.toString(), "java.lang.Integer")); //$NON-NLS-1$
				
			
			return messageCap;
		}
	
		/**
		 * @throws IllegalArgumentException Throws an IllegalArgumentException if one of the parameters is null.
		 */
		
		@NonNull public CAP checkSelectionOfEntryByIndexInColumn(
		
			@NonNull java.lang.String index,
		
			@NonNull java.lang.Boolean selected,
		
			@NonNull java.lang.Integer column
		
		) throws IllegalArgumentException {
			MessageCap messageCap = new MessageCap();
			messageCap.setMethod("rcVerifySelectedIndex"); //$NON-NLS-1$
			messageCap.sethasDefaultMapping(false);
			
			messageCap.setCi(m_componentIdentifier);
			
			
			
			Validate.notNull(index, "Argument 'index' must not be null"); //$NON-NLS-1$
				
				
				
			messageCap.addMessageParam(new MessageParam(index.toString(), "java.lang.String")); //$NON-NLS-1$
				
			
			
			Validate.notNull(selected, "Argument 'selected' must not be null"); //$NON-NLS-1$
				
				
				
			messageCap.addMessageParam(new MessageParam(selected.toString(), "java.lang.Boolean")); //$NON-NLS-1$
				
			
			
			Validate.notNull(column, "Argument 'column' must not be null"); //$NON-NLS-1$
				
				
				
			messageCap.addMessageParam(new MessageParam(column.toString(), "java.lang.Integer")); //$NON-NLS-1$
				
			
			return messageCap;
		}
	
		/**
		 * @throws IllegalArgumentException Throws an IllegalArgumentException if one of the parameters is null.
		 */
		
		@NonNull public CAP selectEntryByIndexInColumn(
		
			@NonNull java.lang.String index,
		
			@NonNull java.lang.Integer column
		
		) throws IllegalArgumentException {
			MessageCap messageCap = new MessageCap();
			messageCap.setMethod("rcSelectIndex"); //$NON-NLS-1$
			messageCap.sethasDefaultMapping(false);
			
			messageCap.setCi(m_componentIdentifier);
			
			
			
			Validate.notNull(index, "Argument 'index' must not be null"); //$NON-NLS-1$
				
				
				
			messageCap.addMessageParam(new MessageParam(index.toString(), "java.lang.String")); //$NON-NLS-1$
				
			
			
			Validate.notNull(column, "Argument 'column' must not be null"); //$NON-NLS-1$
				
				
				
			messageCap.addMessageParam(new MessageParam(column.toString(), "java.lang.Integer")); //$NON-NLS-1$
				
			
			return messageCap;
		}
	
		/**
		 * @throws IllegalArgumentException Throws an IllegalArgumentException if one of the parameters is null.
		 */
		
		@NonNull public CAP selectEntryByValueInColumn(
		
			@NonNull java.lang.String text,
		
			@NonNull org.eclipse.jubula.toolkit.enums.ValueSets.Operator operator,
		
			@NonNull org.eclipse.jubula.toolkit.enums.ValueSets.SearchType searchType,
		
			@NonNull java.lang.Integer column
		
		) throws IllegalArgumentException {
			MessageCap messageCap = new MessageCap();
			messageCap.setMethod("rcSelectValue"); //$NON-NLS-1$
			messageCap.sethasDefaultMapping(false);
			
			messageCap.setCi(m_componentIdentifier);
			
			
			
			Validate.notNull(text, "Argument 'text' must not be null"); //$NON-NLS-1$
				
				
				
			messageCap.addMessageParam(new MessageParam(text.toString(), "java.lang.String")); //$NON-NLS-1$
				
			
			
			Validate.notNull(operator, "Argument 'operator' must not be null"); //$NON-NLS-1$
				
				
				
			messageCap.addMessageParam(new MessageParam(operator.rcValue(), "java.lang.String")); //$NON-NLS-1$
				
			
			
			Validate.notNull(searchType, "Argument 'searchType' must not be null"); //$NON-NLS-1$
				
				
				
			messageCap.addMessageParam(new MessageParam(searchType.rcValue(), "java.lang.String")); //$NON-NLS-1$
				
			
			
			Validate.notNull(column, "Argument 'column' must not be null"); //$NON-NLS-1$
				
				
				
			messageCap.addMessageParam(new MessageParam(column.toString(), "java.lang.Integer")); //$NON-NLS-1$
				
			
			return messageCap;
		}
	
} 