/*******************************************************************************
 * Copyright (c) 2014 BREDEX GmbH.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     BREDEX GmbH - initial API and implementation and/or initial documentation
 *******************************************************************************/
package org.eclipse.jubula.toolkit.swt.components;

import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jubula.communication.CAP;

/**
 * Interface representing the {@link org.eclipse.swt.widgets.ToolItem} component from the swt toolkit. 
 * @noextend This interface is not intended to be extended by clients.
 * @noimplement This interface is not intended to be implemented by clients.
 */
public interface ToolItem
	extends org.eclipse.jubula.toolkit.swt.components.Item
	 {
	
	
	
	
	
	
		/**
		 * @throws IllegalArgumentException Throws an IllegalArgumentException if one of the parameters is null.
		 */
		
		@NonNull public CAP selectMenuEntryByTextpath(
		
			@NonNull java.lang.String menupath,
		
			@NonNull org.eclipse.jubula.toolkit.enums.ValueSets.Operator operator
		
		) throws IllegalArgumentException;
	
		/**
		 * @throws IllegalArgumentException Throws an IllegalArgumentException if one of the parameters is null.
		 */
		
		@NonNull public CAP selectMenuEntryByIndexpath(
		
			@NonNull java.lang.String indexpath
		
		) throws IllegalArgumentException;
	
		/**
		 * @throws IllegalArgumentException Throws an IllegalArgumentException if one of the parameters is null.
		 */
		
		@NonNull public CAP checkEnablementOfEntryByTextpath(
		
			@NonNull java.lang.String menupath,
		
			@NonNull org.eclipse.jubula.toolkit.enums.ValueSets.Operator operator,
		
			@NonNull java.lang.Boolean enabled
		
		) throws IllegalArgumentException;
	
		/**
		 * @throws IllegalArgumentException Throws an IllegalArgumentException if one of the parameters is null.
		 */
		
		@NonNull public CAP checkEnablementOfEntryByIndexpath(
		
			@NonNull java.lang.String indexpath,
		
			@NonNull java.lang.Boolean enabled
		
		) throws IllegalArgumentException;
	
		/**
		 * @throws IllegalArgumentException Throws an IllegalArgumentException if one of the parameters is null.
		 */
		
		@NonNull public CAP checkExistenceOfEntryByTextpath(
		
			@NonNull java.lang.String menupath,
		
			@NonNull org.eclipse.jubula.toolkit.enums.ValueSets.Operator operator,
		
			@NonNull java.lang.Boolean exists
		
		) throws IllegalArgumentException;
	
		/**
		 * @throws IllegalArgumentException Throws an IllegalArgumentException if one of the parameters is null.
		 */
		
		@NonNull public CAP checkExistenceOfEntryByIndexpath(
		
			@NonNull java.lang.String indexpath,
		
			@NonNull java.lang.Boolean exists
		
		) throws IllegalArgumentException;
	
		/**
		 * @throws IllegalArgumentException Throws an IllegalArgumentException if one of the parameters is null.
		 */
		
		@NonNull public CAP checkSelectionOfEntryByTextpath(
		
			@NonNull java.lang.String menupath,
		
			@NonNull org.eclipse.jubula.toolkit.enums.ValueSets.Operator operator,
		
			@NonNull java.lang.Boolean selected
		
		) throws IllegalArgumentException;
	
		/**
		 * @throws IllegalArgumentException Throws an IllegalArgumentException if one of the parameters is null.
		 */
		
		@NonNull public CAP checkSelectionOfEntryByIndexpath(
		
			@NonNull java.lang.String indexpath,
		
			@NonNull java.lang.Boolean selected
		
		) throws IllegalArgumentException;
	
} 