/*******************************************************************************
 * Copyright (c) 2014 BREDEX GmbH.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     BREDEX GmbH - initial API and implementation and/or initial documentation
 *******************************************************************************/
package org.eclipse.jubula.toolkit.swt.components;

import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jubula.communication.CAP;

/**
 * Interface representing the {@link org.eclipse.swt.widgets.Tree} component from the swt toolkit. 
 * @noextend This interface is not intended to be extended by clients.
 * @noimplement This interface is not intended to be implemented by clients.
 */
public interface Tree
	extends org.eclipse.jubula.toolkit.concrete.components.TreeComponent
	 {
	
	
	
	
	
	
		/**
		 * @throws IllegalArgumentException Throws an IllegalArgumentException if one of the parameters is null.
		 */
		
		@NonNull public CAP checkSelectionOfCheckboxOnSelectedNode(
		
			@NonNull java.lang.Boolean checked
		
		) throws IllegalArgumentException;
	
		/**
		 * @throws IllegalArgumentException Throws an IllegalArgumentException if one of the parameters is null.
		 */
		
		@NonNull public CAP toggleCheckboxOnNodeByTextpath(
		
			@NonNull org.eclipse.jubula.toolkit.enums.ValueSets.SearchType pathType,
		
			@NonNull java.lang.Integer preAscend,
		
			@NonNull java.lang.String textpath,
		
			@NonNull org.eclipse.jubula.toolkit.enums.ValueSets.Operator operator
		
		) throws IllegalArgumentException;
	
		/**
		 * @throws IllegalArgumentException Throws an IllegalArgumentException if one of the parameters is null.
		 */
		
		@NonNull public CAP toggleCheckboxOnNodeByIndexpath(
		
			@NonNull org.eclipse.jubula.toolkit.enums.ValueSets.SearchType pathType,
		
			@NonNull java.lang.Integer preAscend,
		
			@NonNull java.lang.String indexpath
		
		) throws IllegalArgumentException;
	
		/**
		 * @throws IllegalArgumentException Throws an IllegalArgumentException if one of the parameters is null.
		 */
		
		@NonNull public CAP checkSelectionOfCheckboxByTextpath(
		
			@NonNull org.eclipse.jubula.toolkit.enums.ValueSets.SearchType pathType,
		
			@NonNull java.lang.Integer preAscend,
		
			@NonNull java.lang.String textpath,
		
			@NonNull org.eclipse.jubula.toolkit.enums.ValueSets.Operator operator,
		
			@NonNull java.lang.Boolean checked
		
		) throws IllegalArgumentException;
	
		/**
		 * @throws IllegalArgumentException Throws an IllegalArgumentException if one of the parameters is null.
		 */
		
		@NonNull public CAP checkSelectionOfCheckboxByIndexpath(
		
			@NonNull org.eclipse.jubula.toolkit.enums.ValueSets.SearchType pathType,
		
			@NonNull java.lang.Integer preAscend,
		
			@NonNull java.lang.String indexpath,
		
			@NonNull java.lang.Boolean checked
		
		) throws IllegalArgumentException;
	
} 