/*******************************************************************************
 * Copyright (c) 2014 BREDEX GmbH.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     BREDEX GmbH - initial API and implementation and/or initial documentation
 *******************************************************************************/
package org.eclipse.jubula.toolkit.swt.components;

import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jubula.communication.CAP;

/**
 * Interface representing the {@link org.eclipse.swt.widgets.Tree} component from the swt toolkit. 
 * @noextend This interface is not intended to be extended by clients.
 * @noimplement This interface is not intended to be implemented by clients.
 */
public interface TreeTable
	extends org.eclipse.jubula.toolkit.swt.components.Tree
	 {
	
	
	
	
	
	
		/**
		 * @throws IllegalArgumentException Throws an IllegalArgumentException if one of the parameters is null.
		 */
		
		@NonNull public CAP selectEntryByTextpathSpecifyColumn(
		
			@NonNull org.eclipse.jubula.toolkit.enums.ValueSets.SearchType pathType,
		
			@NonNull java.lang.Integer preAscend,
		
			@NonNull java.lang.String textpath,
		
			@NonNull org.eclipse.jubula.toolkit.enums.ValueSets.Operator operator,
		
			@NonNull java.lang.Integer numberOfClicks,
		
			@NonNull java.lang.Integer column,
		
			@NonNull org.eclipse.jubula.toolkit.enums.ValueSets.InteractionMode mouseButton
		
		) throws IllegalArgumentException;
	
		/**
		 * @throws IllegalArgumentException Throws an IllegalArgumentException if one of the parameters is null.
		 */
		
		@NonNull public CAP selectEntryByIndexpathSpecifyColumn(
		
			@NonNull org.eclipse.jubula.toolkit.enums.ValueSets.SearchType pathType,
		
			@NonNull java.lang.Integer preAscend,
		
			@NonNull java.lang.String indexpath,
		
			@NonNull java.lang.Integer numberOfClicks,
		
			@NonNull java.lang.Integer column,
		
			@NonNull org.eclipse.jubula.toolkit.enums.ValueSets.InteractionMode mouseButton
		
		) throws IllegalArgumentException;
	
		/**
		 * @throws IllegalArgumentException Throws an IllegalArgumentException if one of the parameters is null.
		 */
		
		@NonNull public CAP checkSelectionByValueSSpecifyColumn(
		
			@NonNull java.lang.String text,
		
			@NonNull org.eclipse.jubula.toolkit.enums.ValueSets.Operator operator,
		
			@NonNull java.lang.Integer column
		
		) throws IllegalArgumentException;
	
} 