/*******************************************************************************
 * Copyright (c) 2014 BREDEX GmbH.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     BREDEX GmbH - initial API and implementation and/or initial documentation
 *******************************************************************************/
package org.eclipse.jubula.toolkit.win;

import org.apache.commons.lang.Validate;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jubula.tools.ComponentIdentifier;
import org.eclipse.jubula.toolkit.ToolkitInfo;
import org.eclipse.jubula.toolkit.win.internal.WinToolkitInfo;

/**
 * Factory for creating components from the win toolkit.
 * @noextend This class is not intended to be extended by clients.
 */
public final class WinComponents {
	
	
	@NonNull private final static ToolkitInfo m_toolkitInformation = new WinToolkitInfo();

	private WinComponents() {
		super();
	}
	
	
	@NonNull public static ToolkitInfo getToolkitInformation() {
		return m_toolkitInformation;
	}

	
	/** create a new representative for a Button UI component.*/
	@NonNull public static org.eclipse.jubula.toolkit.concrete.components.ButtonComponent createButton (@NonNull ComponentIdentifier componentIdentifier) {
		Validate.notNull(componentIdentifier);
		return new org.eclipse.jubula.toolkit.win.internal.impl.Button(componentIdentifier);
	}
	
	/** create a new representative for a {@link com.bredexsw.guidancer.rc.dotnet.components.controltype.ButtonWinForm} UI component.*/
	@NonNull public static org.eclipse.jubula.toolkit.concrete.components.ButtonComponent createWinFormButton (@NonNull ComponentIdentifier componentIdentifier) {
		Validate.notNull(componentIdentifier);
		return new org.eclipse.jubula.toolkit.win.internal.impl.WinFormButton(componentIdentifier);
	}
	
	/** create a new representative for a {@link com.bredexsw.guidancer.rc.dotnet.components.controltype.ButtonWPF} UI component.*/
	@NonNull public static org.eclipse.jubula.toolkit.concrete.components.ButtonComponent createWPFButton (@NonNull ComponentIdentifier componentIdentifier) {
		Validate.notNull(componentIdentifier);
		return new org.eclipse.jubula.toolkit.win.internal.impl.WPFButton(componentIdentifier);
	}
	
	/** create a new representative for a {@link com.bredexsw.guidancer.rc.dotnet.components.controltype.ButtonWin32} UI component.*/
	@NonNull public static org.eclipse.jubula.toolkit.concrete.components.ButtonComponent createButtonWin32 (@NonNull ComponentIdentifier componentIdentifier) {
		Validate.notNull(componentIdentifier);
		return new org.eclipse.jubula.toolkit.win.internal.impl.ButtonWin32(componentIdentifier);
	}
	
	/** create a new representative for a CheckBox UI component.*/
	@NonNull public static org.eclipse.jubula.toolkit.concrete.components.ButtonComponent createCheckBox (@NonNull ComponentIdentifier componentIdentifier) {
		Validate.notNull(componentIdentifier);
		return new org.eclipse.jubula.toolkit.win.internal.impl.CheckBox(componentIdentifier);
	}
	
	/** create a new representative for a {@link com.bredexsw.guidancer.rc.dotnet.components.controltype.CheckBoxWinForm} UI component.*/
	@NonNull public static org.eclipse.jubula.toolkit.concrete.components.ButtonComponent createWinFormCheckBox (@NonNull ComponentIdentifier componentIdentifier) {
		Validate.notNull(componentIdentifier);
		return new org.eclipse.jubula.toolkit.win.internal.impl.WinFormCheckBox(componentIdentifier);
	}
	
	/** create a new representative for a {@link com.bredexsw.guidancer.rc.dotnet.components.controltype.CheckBoxWPF} UI component.*/
	@NonNull public static org.eclipse.jubula.toolkit.concrete.components.ButtonComponent createWPFCheckBox (@NonNull ComponentIdentifier componentIdentifier) {
		Validate.notNull(componentIdentifier);
		return new org.eclipse.jubula.toolkit.win.internal.impl.WPFCheckBox(componentIdentifier);
	}
	
	/** create a new representative for a RadioButton UI component.*/
	@NonNull public static org.eclipse.jubula.toolkit.concrete.components.ButtonComponent createRadioButton (@NonNull ComponentIdentifier componentIdentifier) {
		Validate.notNull(componentIdentifier);
		return new org.eclipse.jubula.toolkit.win.internal.impl.RadioButton(componentIdentifier);
	}
	
	/** create a new representative for a {@link com.bredexsw.guidancer.rc.dotnet.components.controltype.RadioButtonWinForm} UI component.*/
	@NonNull public static org.eclipse.jubula.toolkit.concrete.components.ButtonComponent createWinFormRadioButton (@NonNull ComponentIdentifier componentIdentifier) {
		Validate.notNull(componentIdentifier);
		return new org.eclipse.jubula.toolkit.win.internal.impl.WinFormRadioButton(componentIdentifier);
	}
	
	/** create a new representative for a {@link com.bredexsw.guidancer.rc.dotnet.components.controltype.RadioButtonWPF} UI component.*/
	@NonNull public static org.eclipse.jubula.toolkit.concrete.components.ButtonComponent createWPFRadioButton (@NonNull ComponentIdentifier componentIdentifier) {
		Validate.notNull(componentIdentifier);
		return new org.eclipse.jubula.toolkit.win.internal.impl.WPFRadioButton(componentIdentifier);
	}
	
	/** create a new representative for a TextInputComponent UI component.*/
	@NonNull public static org.eclipse.jubula.toolkit.concrete.components.TextInputComponent createTextInputComponent (@NonNull ComponentIdentifier componentIdentifier) {
		Validate.notNull(componentIdentifier);
		return new org.eclipse.jubula.toolkit.win.internal.impl.TextInputComponent(componentIdentifier);
	}
	
	/** create a new representative for a {@link com.bredexsw.guidancer.rc.dotnet.components.controltype.EditWinForm} UI component.*/
	@NonNull public static org.eclipse.jubula.toolkit.concrete.components.TextInputComponent createWinFormTextField (@NonNull ComponentIdentifier componentIdentifier) {
		Validate.notNull(componentIdentifier);
		return new org.eclipse.jubula.toolkit.win.internal.impl.WinFormTextField(componentIdentifier);
	}
	
	/** create a new representative for a {@link com.bredexsw.guidancer.rc.dotnet.components.controltype.EditWPF} UI component.*/
	@NonNull public static org.eclipse.jubula.toolkit.concrete.components.TextInputComponent createWPFTextField (@NonNull ComponentIdentifier componentIdentifier) {
		Validate.notNull(componentIdentifier);
		return new org.eclipse.jubula.toolkit.win.internal.impl.WPFTextField(componentIdentifier);
	}
	
	/** create a new representative for a TextArea UI component.*/
	@NonNull public static org.eclipse.jubula.toolkit.concrete.components.TextInputComponent createTextArea (@NonNull ComponentIdentifier componentIdentifier) {
		Validate.notNull(componentIdentifier);
		return new org.eclipse.jubula.toolkit.win.internal.impl.TextArea(componentIdentifier);
	}
	
	/** create a new representative for a {@link com.bredexsw.guidancer.rc.dotnet.components.controltype.DocumentWinForm} UI component.*/
	@NonNull public static org.eclipse.jubula.toolkit.concrete.components.TextInputComponent createWinFormDocument (@NonNull ComponentIdentifier componentIdentifier) {
		Validate.notNull(componentIdentifier);
		return new org.eclipse.jubula.toolkit.win.internal.impl.WinFormDocument(componentIdentifier);
	}
	
	/** create a new representative for a {@link com.bredexsw.guidancer.rc.dotnet.components.controltype.DocumentWPF} UI component.*/
	@NonNull public static org.eclipse.jubula.toolkit.concrete.components.TextInputComponent createWPFDocument (@NonNull ComponentIdentifier componentIdentifier) {
		Validate.notNull(componentIdentifier);
		return new org.eclipse.jubula.toolkit.win.internal.impl.WPFDocument(componentIdentifier);
	}
	
	/** create a new representative for a TextComponent UI component.*/
	@NonNull public static org.eclipse.jubula.toolkit.concrete.components.TextComponent createTextComponent (@NonNull ComponentIdentifier componentIdentifier) {
		Validate.notNull(componentIdentifier);
		return new org.eclipse.jubula.toolkit.win.internal.impl.TextComponent(componentIdentifier);
	}
	
	/** create a new representative for a {@link com.bredexsw.guidancer.rc.dotnet.components.controltype.TextWinForm} UI component.*/
	@NonNull public static org.eclipse.jubula.toolkit.concrete.components.TextComponent createWinFormLabel (@NonNull ComponentIdentifier componentIdentifier) {
		Validate.notNull(componentIdentifier);
		return new org.eclipse.jubula.toolkit.win.internal.impl.WinFormLabel(componentIdentifier);
	}
	
	/** create a new representative for a {@link com.bredexsw.guidancer.rc.dotnet.components.controltype.TextWPF} UI component.*/
	@NonNull public static org.eclipse.jubula.toolkit.concrete.components.TextComponent createWPFLabel (@NonNull ComponentIdentifier componentIdentifier) {
		Validate.notNull(componentIdentifier);
		return new org.eclipse.jubula.toolkit.win.internal.impl.WPFLabel(componentIdentifier);
	}
	
	/** create a new representative for a Tree UI component.*/
	@NonNull public static org.eclipse.jubula.toolkit.concrete.components.TreeComponent createTree (@NonNull ComponentIdentifier componentIdentifier) {
		Validate.notNull(componentIdentifier);
		return new org.eclipse.jubula.toolkit.win.internal.impl.Tree(componentIdentifier);
	}
	
	/** create a new representative for a {@link com.bredexsw.guidancer.rc.dotnet.components.controltype.TreeWinForm} UI component.*/
	@NonNull public static org.eclipse.jubula.toolkit.concrete.components.TreeComponent createWinFormTree (@NonNull ComponentIdentifier componentIdentifier) {
		Validate.notNull(componentIdentifier);
		return new org.eclipse.jubula.toolkit.win.internal.impl.WinFormTree(componentIdentifier);
	}
	
	/** create a new representative for a {@link com.bredexsw.guidancer.rc.dotnet.components.controltype.TreeWPF} UI component.*/
	@NonNull public static org.eclipse.jubula.toolkit.concrete.components.TreeComponent createWPFTree (@NonNull ComponentIdentifier componentIdentifier) {
		Validate.notNull(componentIdentifier);
		return new org.eclipse.jubula.toolkit.win.internal.impl.WPFTree(componentIdentifier);
	}
	
	/** create a new representative for a TabComponent UI component.*/
	@NonNull public static org.eclipse.jubula.toolkit.concrete.components.TabComponent createTabComponent (@NonNull ComponentIdentifier componentIdentifier) {
		Validate.notNull(componentIdentifier);
		return new org.eclipse.jubula.toolkit.win.internal.impl.TabComponent(componentIdentifier);
	}
	
	/** create a new representative for a {@link com.bredexsw.guidancer.rc.dotnet.components.controltype.TabWinForm} UI component.*/
	@NonNull public static org.eclipse.jubula.toolkit.concrete.components.TabComponent createWinFormTab (@NonNull ComponentIdentifier componentIdentifier) {
		Validate.notNull(componentIdentifier);
		return new org.eclipse.jubula.toolkit.win.internal.impl.WinFormTab(componentIdentifier);
	}
	
	/** create a new representative for a {@link com.bredexsw.guidancer.rc.dotnet.components.controltype.TabWPF} UI component.*/
	@NonNull public static org.eclipse.jubula.toolkit.concrete.components.TabComponent createWPFTab (@NonNull ComponentIdentifier componentIdentifier) {
		Validate.notNull(componentIdentifier);
		return new org.eclipse.jubula.toolkit.win.internal.impl.WPFTab(componentIdentifier);
	}
	
	/** create a new representative for a List UI component.*/
	@NonNull public static org.eclipse.jubula.toolkit.concrete.components.ListComponent createList (@NonNull ComponentIdentifier componentIdentifier) {
		Validate.notNull(componentIdentifier);
		return new org.eclipse.jubula.toolkit.win.internal.impl.List(componentIdentifier);
	}
	
	/** create a new representative for a {@link com.bredexsw.guidancer.rc.dotnet.components.controltype.ListWinForm} UI component.*/
	@NonNull public static org.eclipse.jubula.toolkit.concrete.components.ListComponent createWinFormList (@NonNull ComponentIdentifier componentIdentifier) {
		Validate.notNull(componentIdentifier);
		return new org.eclipse.jubula.toolkit.win.internal.impl.WinFormList(componentIdentifier);
	}
	
	/** create a new representative for a {@link com.bredexsw.guidancer.rc.dotnet.components.controltype.ListWPF} UI component.*/
	@NonNull public static org.eclipse.jubula.toolkit.concrete.components.ListComponent createWPFList (@NonNull ComponentIdentifier componentIdentifier) {
		Validate.notNull(componentIdentifier);
		return new org.eclipse.jubula.toolkit.win.internal.impl.WPFList(componentIdentifier);
	}
	
	/** create a new representative for a Table UI component.*/
	@NonNull public static org.eclipse.jubula.toolkit.concrete.components.TableComponent createTable (@NonNull ComponentIdentifier componentIdentifier) {
		Validate.notNull(componentIdentifier);
		return new org.eclipse.jubula.toolkit.win.internal.impl.Table(componentIdentifier);
	}
	
	/** create a new representative for a {@link com.bredexsw.guidancer.rc.dotnet.components.controltype.TableWinForm} UI component.*/
	@NonNull public static org.eclipse.jubula.toolkit.concrete.components.TableComponent createWinFormTable (@NonNull ComponentIdentifier componentIdentifier) {
		Validate.notNull(componentIdentifier);
		return new org.eclipse.jubula.toolkit.win.internal.impl.WinFormTable(componentIdentifier);
	}
	
	/** create a new representative for a {@link com.bredexsw.guidancer.rc.dotnet.components.controltype.TableWPF} UI component.*/
	@NonNull public static org.eclipse.jubula.toolkit.concrete.components.TableComponent createWPFTable (@NonNull ComponentIdentifier componentIdentifier) {
		Validate.notNull(componentIdentifier);
		return new org.eclipse.jubula.toolkit.win.internal.impl.WPFTable(componentIdentifier);
	}
	
	/** create a new representative for a ComboComponent UI component.*/
	@NonNull public static org.eclipse.jubula.toolkit.concrete.components.ComboComponent createComboComponent (@NonNull ComponentIdentifier componentIdentifier) {
		Validate.notNull(componentIdentifier);
		return new org.eclipse.jubula.toolkit.win.internal.impl.ComboComponent(componentIdentifier);
	}
	
	/** create a new representative for a {@link com.bredexsw.guidancer.rc.dotnet.components.controltype.ComboBoxWinForm} UI component.*/
	@NonNull public static org.eclipse.jubula.toolkit.concrete.components.ComboComponent createWinFormComboBox (@NonNull ComponentIdentifier componentIdentifier) {
		Validate.notNull(componentIdentifier);
		return new org.eclipse.jubula.toolkit.win.internal.impl.WinFormComboBox(componentIdentifier);
	}
	
	/** create a new representative for a {@link com.bredexsw.guidancer.rc.dotnet.components.controltype.ComboBoxWPF} UI component.*/
	@NonNull public static org.eclipse.jubula.toolkit.concrete.components.ComboComponent createWPFComboBox (@NonNull ComponentIdentifier componentIdentifier) {
		Validate.notNull(componentIdentifier);
		return new org.eclipse.jubula.toolkit.win.internal.impl.WPFComboBox(componentIdentifier);
	}
	
	/** create a new representative for a {@link Application} component.*/
	@NonNull public static org.eclipse.jubula.toolkit.concrete.components.Application createApplication () {
		return new org.eclipse.jubula.toolkit.win.internal.impl.Application();
	}
	
	/** create a new representative for a {@link Menu} component.*/
	@NonNull public static org.eclipse.jubula.toolkit.concrete.components.MenuBarComponent createMenu () {
		return new org.eclipse.jubula.toolkit.win.internal.impl.Menu();
	}
}